-- MySQL dump 10.13  Distrib 8.3.0, for macos14.2 (arm64)
--
-- Host: 127.0.0.1    Database: shofy
-- ------------------------------------------------------
-- Server version	8.3.0

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'hPdMjr4dz5lXv4aNAqrTKOVZgWeI3iAJ',1,'2024-03-15 02:59:54','2024-03-15 02:59:54','2024-03-15 02:59:54');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
INSERT INTO `ads` VALUES (1,'Ads 1','2029-03-15 00:00:00','not_set','UROL9F9ZZVAA','main/banners/1.jpg','/products',0,1,'published','2024-03-15 03:00:31','2024-03-15 03:00:31',1,NULL,NULL),(2,'Ads 2','2029-03-15 00:00:00','not_set','B30VDBKO7SBF','main/banners/2.jpg','/products',0,2,'published','2024-03-15 03:00:31','2024-03-15 03:00:31',1,NULL,NULL),(3,'Ads 3','2029-03-15 00:00:00','not_set','BN3ZCHLIE95I','main/gadgets/gadget-banner-1.jpg','/products',0,3,'published','2024-03-15 03:00:31','2024-03-15 03:00:31',1,NULL,NULL),(4,'Ads 4','2029-03-15 00:00:00','not_set','QGPRRJ2MPZYA','main/gadgets/gadget-banner-2.jpg','/products',0,4,'published','2024-03-15 03:00:31','2024-03-15 03:00:31',1,NULL,NULL),(5,'Ads 5','2029-03-15 00:00:00','not_set','B5ZA76ZWMWAE','main/banners/slider-1.png','http://shofy.test/products/playstation-5-console',0,5,'published','2024-03-15 03:00:31','2024-03-15 03:00:31',1,NULL,NULL),(6,'Ads 6','2029-03-15 00:00:00','not_set','F1LTQS976YPY','main/banners/slider-2.png','http://shofy.test',0,6,'published','2024-03-15 03:00:32','2024-03-15 03:00:32',1,NULL,NULL),(7,'Ads 7','2029-03-15 00:00:00','not_set','IHPZ2WBSYJUK','main/banners/slider-3.png','http://shofy.test/products/sony-x900h-4k-ultra-hd-smart-led-tv',0,7,'published','2024-03-15 03:00:32','2024-03-15 03:00:32',1,NULL,NULL);
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','Enjoy free shipping on all orders over $99! Shop now and save on delivery costs.',0,NULL,NULL,0,1,'2024-03-15 10:00:07',NULL,1,'2024-03-15 03:00:07','2024-03-15 03:00:07'),(2,'Announcement 2','Need assistance? Our customer support is available 24/7 to help you with any questions or concerns.',0,NULL,NULL,0,1,'2024-03-15 10:00:07',NULL,1,'2024-03-15 03:00:07','2024-03-15 03:00:07'),(3,'Announcement 3','Shop with confidence! We offer a hassle-free 30 days return service for your peace of mind.',0,NULL,NULL,0,1,'2024-03-15 10:00:07',NULL,1,'2024-03-15 03:00:07','2024-03-15 03:00:07');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_user` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Crisp Bread &amp; Cake',0,'Nihil aliquam quos est quidem adipisci minima consequatur autem. Cumque natus voluptatem aut consequatur quisquam corporis sed. Aut sapiente voluptas qui itaque incidunt enim possimus.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2024-03-15 03:00:01','2024-03-15 03:00:01'),(2,'Fashion',0,'Ut ex qui exercitationem iste ut culpa molestiae molestiae. Explicabo facere molestias voluptates sapiente perspiciatis labore incidunt. In voluptates necessitatibus autem ut minima.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:00:01','2024-03-15 03:00:01'),(3,'Electronic',0,'Dicta magnam ea impedit suscipit. Eligendi autem sit ut et eum. Quam quidem molestias quia nihil repudiandae omnis reprehenderit ut.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:00:01','2024-03-15 03:00:01'),(4,'Commercial',0,'Distinctio exercitationem aut eligendi ut sint. Qui quam dolorum provident eveniet quia. Aliquam quidem earum quidem.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:00:01','2024-03-15 03:00:01'),(5,'Organic Fruits',0,'Consequatur ut dolor eos modi nostrum a. Et facere nihil veritatis et. Facilis qui in quia et mollitia. Sit et consequuntur quaerat qui quis dolorem excepturi.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:00:01','2024-03-15 03:00:01'),(6,'Ecological',0,'Facilis quod eveniet iste. Corrupti expedita qui cupiditate eos ratione repellat et. Facilis a explicabo esse magni. Nulla similique fugit sit autem atque ab animi.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:00:01','2024-03-15 03:00:01');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Paolo Ratke','hstiedemann@example.com','+1 (858) 490-6705','5852 Strosin Curve\nElyssaview, NY 72140-7593','Qui ut quidem eum sit.','Modi sit vitae nisi sequi perferendis eos facere. Et quo quo at soluta. Aperiam cumque aut optio ea velit deleniti. Ut autem harum qui. Sequi et delectus et sequi sequi quo deleniti. Quia enim nisi quia eos soluta ea. Et tempore nulla et et unde. Error eos eum quod ullam et. Corporis est aut est vel. Sed dolorem ab amet ab distinctio. Sed harum omnis reiciendis. Dolor in est debitis tempore in iste voluptas. Accusamus quisquam dolores dolores aut quo aut sint tenetur.','read','2024-03-15 03:00:00','2024-03-15 03:00:00'),(2,'Dejuan Pfeffer PhD','bbahringer@example.org','1-901-433-7252','6320 Harvey Forges\nSouth Bertaville, OR 56627-3003','Alias sit corporis libero quos totam accusamus.','Id labore ut reprehenderit accusantium excepturi expedita. Libero dolorum voluptatem praesentium dolores commodi. Exercitationem quam est omnis saepe natus. Harum est fugiat sunt qui et voluptatem. Praesentium facilis hic sed facilis. Quam error nesciunt et dolorem possimus consequatur. Eligendi qui nisi rerum quae saepe. Mollitia est est aut et molestiae. Rerum ab iste quia et illum quod. Sapiente a et et veritatis dignissimos est cumque.','read','2024-03-15 03:00:00','2024-03-15 03:00:00'),(3,'Preston Treutel III','lisette.rath@example.org','863.610.5731','36438 Liana Turnpike\nFunkberg, AZ 80071-5729','Rem omnis ipsam consequuntur laudantium pariatur.','Inventore quod quam fuga nostrum ab nostrum mollitia neque. Saepe necessitatibus aut quia veniam quod quaerat voluptas. Velit vero vel magni autem velit et vero. Dolores debitis consequatur sunt voluptas iure. Eum ratione nisi sunt reprehenderit aut impedit. Explicabo nisi qui recusandae nulla et. Minima rem aliquid ipsum et perferendis sequi. Ab omnis et totam aut temporibus ea sed.','read','2024-03-15 03:00:00','2024-03-15 03:00:00'),(4,'Ms. Ettie Reinger','yolanda77@example.net','804-482-6758','6701 Jaqueline Parks Suite 068\nKesslerbury, NM 61407-4147','Rem ea quae sit dolorem voluptas sint dolores.','Error nam quibusdam aliquid enim explicabo eum est. Vero quae et eos accusantium corrupti eaque autem aut. Modi harum error deserunt distinctio reprehenderit facilis. Voluptate omnis placeat et dolores doloremque debitis. Est omnis facilis est harum. Asperiores quis quia dolorum sit quas aspernatur et dolore. Amet rerum nemo magni quasi eligendi aut ut commodi.','read','2024-03-15 03:00:00','2024-03-15 03:00:00'),(5,'Devin Koss DVM','amayer@example.com','+17186085021','35009 Jeramie Terrace\nLaurelmouth, AZ 29552','Enim quis qui aut quia numquam iusto et sequi.','Facere quod quibusdam cum consequatur. Qui quasi nihil eveniet consequuntur itaque voluptatem. Blanditiis et maxime voluptas rerum et quo illum est. Occaecati unde iusto molestiae quos ipsa in commodi. Tenetur eaque aut quaerat aut consequuntur natus. Placeat minima temporibus qui reiciendis harum. Provident aliquid quas consequatur rem consectetur id qui.','read','2024-03-15 03:00:00','2024-03-15 03:00:00'),(6,'Ona Schmidt','andre47@example.org','941-635-1325','6911 Borer Lodge Suite 222\nHeaneyhaven, SD 31791','Nam fuga omnis omnis sequi.','Cumque ipsum temporibus aut fugit. Id voluptatibus accusantium nemo error sit necessitatibus. Sapiente dicta qui qui odit sequi quaerat quis. Fugit eius fuga iusto sit quae sit. Est eaque et qui et. Dicta reiciendis nihil nemo dolores. Culpa inventore eos esse voluptas nulla. Illum sit est ab ut molestiae nemo. A officiis illo ea. Rem aliquid neque fugiat nam perferendis quas. Qui ab et fugiat atque. Odio provident quidem cum ab autem esse. Dolorem et delectus explicabo quo et.','read','2024-03-15 03:00:00','2024-03-15 03:00:00'),(7,'Prof. Paige Miller Jr.','frederic90@example.org','+1-678-468-0544','483 Watsica Unions\nBoyerport, CT 66836-5247','Quia cumque dolor iste tempore.','Et dolores voluptates voluptas beatae. Veritatis quos quo non reprehenderit unde quaerat reiciendis. Placeat error laboriosam nemo aut. Numquam laborum corrupti itaque perferendis eaque incidunt nesciunt. Neque repellat expedita ut eos eum nisi. Facilis quod sit dolore impedit libero consequatur placeat. Consequatur id libero sint consequatur rerum qui asperiores.','unread','2024-03-15 03:00:00','2024-03-15 03:00:00'),(8,'Chaim Lind','bgibson@example.com','(512) 819-3197','4446 Halvorson Drive\nMurazikside, NH 13478','Aliquid magni quo possimus quos excepturi.','Impedit necessitatibus rem debitis alias id. Ratione mollitia voluptas et earum autem eaque sit. Veritatis dolore quidem accusantium reiciendis incidunt. Dolorem reiciendis eum sunt possimus aut. Sed eaque id magni aut. Qui harum neque consequatur. Ex a officia quaerat. Fugit sit omnis culpa. Necessitatibus doloribus quidem voluptas provident inventore consequatur laudantium provident.','unread','2024-03-15 03:00:00','2024-03-15 03:00:00'),(9,'Issac Shields','ebednar@example.net','+1-949-958-8091','35215 Everardo Mills\nWest Simfort, SD 30824-2123','Natus veritatis aut molestias iure sunt.','Sit in natus ex officia ipsum distinctio. Impedit tempora ipsam ut veritatis. Eius perspiciatis aut quia itaque. Sapiente dolor placeat et incidunt repellendus nulla minima. Ducimus cumque nostrum et distinctio. Enim natus est aperiam voluptatem ipsam. Voluptatibus aut quia possimus odio assumenda. A sint ab quia incidunt amet assumenda ut aut. Numquam occaecati saepe excepturi. Pariatur saepe tempora quisquam ut itaque. Est nihil iste nobis est facere.','read','2024-03-15 03:00:00','2024-03-15 03:00:00'),(10,'Prof. Moses Kuvalis I','ymarks@example.com','+1 (785) 721-1282','49402 Marquardt Greens\nNew Broderick, IL 87241-0299','Expedita autem voluptatem quis voluptatem aut.','Maxime eaque ducimus eius distinctio incidunt aut. Alias pariatur est nulla quo. Rem omnis consectetur occaecati ex sapiente. Possimus eum autem nobis autem ad similique. Incidunt et nisi est qui harum consequuntur. Dolorem est labore explicabo placeat qui velit laborum. Harum fuga exercitationem dolores culpa omnis dolore. Molestias recusandae dolor aut aut. Dolorem quisquam assumenda rerum expedita hic sed. Voluptatem porro dolore velit magnam sed voluptas odit.','read','2024-03-15 03:00:00','2024-03-15 03:00:00');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands`
--

DROP TABLE IF EXISTS `ec_brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands`
--

LOCK TABLES `ec_brands` WRITE;
/*!40000 ALTER TABLE `ec_brands` DISABLE KEYS */;
INSERT INTO `ec_brands` VALUES (1,'FoodPound','New Snacks Release',NULL,NULL,'published',0,1,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(2,'iTea JSC','Happy Tea 100% Organic. From $29.9',NULL,NULL,'published',1,1,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(3,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',2,1,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(4,'Shofy','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',3,1,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(5,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',4,1,'2024-03-15 02:59:56','2024-03-15 02:59:56');
/*!40000 ALTER TABLE `ec_brands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands_translations`
--

DROP TABLE IF EXISTS `ec_brands_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_brands_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_brands_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands_translations`
--

LOCK TABLES `ec_brands_translations` WRITE;
/*!40000 ALTER TABLE `ec_brands_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_brands_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_cart`
--

DROP TABLE IF EXISTS `ec_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_cart` (
  `identifier` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `instance` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`identifier`,`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_cart`
--

LOCK TABLES `ec_cart` WRITE;
/*!40000 ALTER TABLE `ec_cart` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_currencies`
--

DROP TABLE IF EXISTS `ec_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned DEFAULT '0',
  `order` int unsigned DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_currencies`
--

LOCK TABLES `ec_currencies` WRITE;
/*!40000 ALTER TABLE `ec_currencies` DISABLE KEYS */;
INSERT INTO `ec_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(2,'EUR','€',0,2,1,0,0.84,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(3,'VND','₫',0,0,2,0,23203,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(4,'NGN','₦',1,2,2,0,895.52,'2024-03-15 02:59:56','2024-03-15 02:59:56');
/*!40000 ALTER TABLE `ec_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_addresses`
--

DROP TABLE IF EXISTS `ec_customer_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_addresses`
--

LOCK TABLES `ec_customer_addresses` WRITE;
/*!40000 ALTER TABLE `ec_customer_addresses` DISABLE KEYS */;
INSERT INTO `ec_customer_addresses` VALUES (1,'Shaina Stracke','customer@botble.com','+19717484701','NF','Idaho','Vonview','52462 Gorczany Greens',1,1,'2024-03-15 02:59:58','2024-03-15 02:59:58','93319-7777'),(2,'Shaina Stracke','customer@botble.com','+18018875029','NR','North Carolina','Handberg','4184 Pouros Ramp Suite 508',1,0,'2024-03-15 02:59:58','2024-03-15 02:59:58','12854-3480'),(3,'Johann Koepp V','vendor@botble.com','+16032741257','VI','South Carolina','Lake Adolphus','425 Runolfsdottir Court Suite 727',2,1,'2024-03-15 02:59:58','2024-03-15 02:59:58','38724-2582'),(4,'Johann Koepp V','vendor@botble.com','+13614124722','AG','Mississippi','West Etha','22886 Durgan Inlet',2,0,'2024-03-15 02:59:58','2024-03-15 02:59:58','45699-6695'),(5,'Prof. Shawna Johns Jr.','domenico.heaney@example.org','+19513087514','GI','Oklahoma','Wolffshire','80854 Hudson Island Suite 924',3,1,'2024-03-15 02:59:58','2024-03-15 02:59:58','85687-3192'),(6,'Jovanny Bailey DVM','zora36@example.org','+18042255474','BA','Mississippi','Lake Veronicamouth','724 Jerde Ways Apt. 184',4,1,'2024-03-15 02:59:58','2024-03-15 02:59:58','24476-3340'),(7,'Treva Keebler','fred73@example.net','+17169206954','NL','Michigan','Jastside','8993 Marquardt Avenue',5,1,'2024-03-15 02:59:59','2024-03-15 02:59:59','21866'),(8,'Joy Murphy','kautzer.dixie@example.org','+12705096841','KM','Connecticut','New Juliet','820 Alta Summit Suite 801',6,1,'2024-03-15 02:59:59','2024-03-15 02:59:59','81518-5815'),(9,'Brennan Koepp','cole.robb@example.net','+18655485073','ZM','Oregon','Jonesborough','8009 Rowe Plaza Apt. 135',7,1,'2024-03-15 02:59:59','2024-03-15 02:59:59','67993-7508'),(10,'Elbert Kshlerin','cbogisich@example.com','+15627334364','KG','District of Columbia','West Germanview','710 Elizabeth Shoals',8,1,'2024-03-15 03:00:00','2024-03-15 03:00:00','49544-3809'),(11,'Daphney Toy','jakubowski.claudia@example.com','+15403405479','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',9,1,'2024-03-15 03:00:00','2024-03-15 03:00:00','50549-0012'),(12,'Prof. Tyreek Cremin','bhalvorson@example.com','+15054882884','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',10,1,'2024-03-15 03:00:00','2024-03-15 03:00:00','13232-5768');
/*!40000 ALTER TABLE `ec_customer_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_password_resets`
--

DROP TABLE IF EXISTS `ec_customer_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `ec_customer_password_resets_email_index` (`email`),
  KEY `ec_customer_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_password_resets`
--

LOCK TABLES `ec_customer_password_resets` WRITE;
/*!40000 ALTER TABLE `ec_customer_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_recently_viewed_products`
--

DROP TABLE IF EXISTS `ec_customer_recently_viewed_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_recently_viewed_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_recently_viewed_products`
--

LOCK TABLES `ec_customer_recently_viewed_products` WRITE;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_used_coupons`
--

DROP TABLE IF EXISTS `ec_customer_used_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_used_coupons` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_used_coupons`
--

LOCK TABLES `ec_customer_used_coupons` WRITE;
/*!40000 ALTER TABLE `ec_customer_used_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_used_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customers`
--

DROP TABLE IF EXISTS `ec_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_vendor` tinyint(1) NOT NULL DEFAULT '0',
  `vendor_verified_at` datetime DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `private_notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_customers_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customers`
--

LOCK TABLES `ec_customers` WRITE;
/*!40000 ALTER TABLE `ec_customers` DISABLE KEYS */;
INSERT INTO `ec_customers` VALUES (1,'Shaina Stracke','customer@botble.com','$2y$12$oD/kX5d9iMvkgbHolh4py.OKNf6h0ThQVmIB3uv5SGaa1ahEhCGE2','main/customers/9.jpg','1995-02-27','+18602529660',NULL,'2024-03-15 02:59:58','2024-03-15 03:00:03','2024-03-15 09:59:57',NULL,1,'2024-03-15 10:00:03','activated',NULL),(2,'Johann Koepp V','vendor@botble.com','$2y$12$X2MNfR1qg3wZp7LK7mYr6eSiFxdU8yrnk.HwCsBQ4RtDRUafjFQKG','main/customers/3.jpg','1992-02-14','+16785275961',NULL,'2024-03-15 02:59:58','2024-03-15 03:00:04','2024-03-15 09:59:57',NULL,1,'2024-03-15 10:00:03','activated',NULL),(3,'Prof. Shawna Johns Jr.','domenico.heaney@example.org','$2y$12$s3UtF9zCTd7nasM5dOh/huM4R6wPx6tz0vOBEsMjm3uJaPQHnhhzW','main/customers/1.jpg','2002-02-17','+18065925064',NULL,'2024-03-15 02:59:58','2024-03-15 03:00:04','2024-03-15 09:59:57',NULL,1,'2024-03-15 10:00:03','activated',NULL),(4,'Jovanny Bailey DVM','zora36@example.org','$2y$12$.zjW3EV3pOasJcjjR3Jf6uCKwr.g93qwNpdDCfKhgnLtXTYgGKuTu','main/customers/2.jpg','1991-02-14','+14235166366',NULL,'2024-03-15 02:59:58','2024-03-15 03:00:05','2024-03-15 09:59:57',NULL,1,'2024-03-15 10:00:03','activated',NULL),(5,'Treva Keebler','fred73@example.net','$2y$12$57ky8/G.EPbxauNpFq9AQupVdQKIllfwYjxKHg2U4NMrRVxjGrKme','main/customers/3.jpg','1990-03-04','+17204213029',NULL,'2024-03-15 02:59:59','2024-03-15 03:00:05','2024-03-15 09:59:57',NULL,1,'2024-03-15 10:00:03','activated',NULL),(6,'Joy Murphy','kautzer.dixie@example.org','$2y$12$1s3eDPJVORlxXnH/nYvUIeK8vyybRpq8d0Ahj1plV59lmTtWiOObC','main/customers/4.jpg','1989-02-21','+14805602570',NULL,'2024-03-15 02:59:59','2024-03-15 03:00:05','2024-03-15 09:59:57',NULL,1,'2024-03-15 10:00:03','activated',NULL),(7,'Brennan Koepp','cole.robb@example.net','$2y$12$mnLS6bNaOqSHsBSLqWZcGeugSuxP0VpGQuoEAf7lEKDMaAFeGiI5S','main/customers/5.jpg','1980-02-24','+19522321824',NULL,'2024-03-15 02:59:59','2024-03-15 03:00:06','2024-03-15 09:59:57',NULL,1,'2024-03-15 10:00:03','activated',NULL),(8,'Elbert Kshlerin','cbogisich@example.com','$2y$12$3trxeJNp/kiXJnFmcmtMpOGOvkZijf2qhm9dtDcZpc7rK6LEXEgeS','main/customers/6.jpg','1983-03-02','+17077905031',NULL,'2024-03-15 03:00:00','2024-03-15 03:00:06','2024-03-15 09:59:57',NULL,1,'2024-03-15 10:00:03','activated',NULL),(9,'Daphney Toy','jakubowski.claudia@example.com','$2y$12$mgwl7RZyGhrt4KqVzofDbeUjt1I2Wjh1pXCp.V2M/q1PKZvDDE0c6','main/customers/7.jpg','1999-03-01','+17169776493',NULL,'2024-03-15 03:00:00','2024-03-15 03:00:06','2024-03-15 09:59:57',NULL,0,NULL,'activated',NULL),(10,'Prof. Tyreek Cremin','bhalvorson@example.com','$2y$12$tz2UTJBFiSVBAPIp1eT2m.U3Zxcdp3.2cW3U8qqaN0MhHW.4lc0h2','main/customers/8.jpg','1991-03-13','+19092144917',NULL,'2024-03-15 03:00:00','2024-03-15 03:00:06','2024-03-15 09:59:57',NULL,0,NULL,'activated',NULL);
/*!40000 ALTER TABLE `ec_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_customers`
--

DROP TABLE IF EXISTS `ec_discount_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_customers` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_customers`
--

LOCK TABLES `ec_discount_customers` WRITE;
/*!40000 ALTER TABLE `ec_discount_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_categories`
--

DROP TABLE IF EXISTS `ec_discount_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_categories` (
  `discount_id` bigint unsigned NOT NULL,
  `product_category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_categories`
--

LOCK TABLES `ec_discount_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_collections`
--

DROP TABLE IF EXISTS `ec_discount_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_collections` (
  `discount_id` bigint unsigned NOT NULL,
  `product_collection_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_collections`
--

LOCK TABLES `ec_discount_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_collections` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_products`
--

DROP TABLE IF EXISTS `ec_discount_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_products` (
  `discount_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_products`
--

LOCK TABLES `ec_discount_products` WRITE;
/*!40000 ALTER TABLE `ec_discount_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discounts`
--

DROP TABLE IF EXISTS `ec_discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `value` double DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'coupon',
  `can_use_with_promotion` tinyint(1) NOT NULL DEFAULT '0',
  `discount_on` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_quantity` int unsigned DEFAULT NULL,
  `type_option` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'amount',
  `target` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'all-orders',
  `min_order_price` decimal(15,2) DEFAULT NULL,
  `apply_via_url` tinyint(1) NOT NULL DEFAULT '0',
  `display_at_checkout` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_discounts_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discounts`
--

LOCK TABLES `ec_discounts` WRITE;
/*!40000 ALTER TABLE `ec_discounts` DISABLE KEYS */;
INSERT INTO `ec_discounts` VALUES (1,'Discount 1','Y9DXJNG1FV66','2024-03-14 10:00:02','2024-04-09 10:00:02',NULL,0,20,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-15 03:00:02','2024-03-15 03:00:02',NULL,NULL),(2,'Discount 2','KP8KD5QMHPBA','2024-03-14 10:00:02','2024-04-04 10:00:02',NULL,0,477,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-15 03:00:02','2024-03-15 03:00:02',NULL,NULL),(3,'Discount 3','NYKRU49CS4FO','2024-03-14 10:00:02',NULL,NULL,0,718,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-15 03:00:02','2024-03-15 03:00:02',NULL,NULL),(4,'Discount 4','M71U3NDD7KQQ','2024-03-14 10:00:02','2024-03-19 10:00:02',NULL,0,277,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-15 03:00:02','2024-03-15 03:00:02',NULL,NULL),(5,'Discount 5','6IOXWMSILUGG','2024-03-14 10:00:02',NULL,NULL,0,80,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-15 03:00:02','2024-03-15 03:00:02',NULL,NULL),(6,'Discount 6','KOB3YRFMEKQH','2024-03-14 10:00:02',NULL,NULL,0,51,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-15 03:00:02','2024-03-15 03:00:02',NULL,NULL),(7,'Discount 7','HGRACCC2NWH2','2024-03-14 10:00:02',NULL,NULL,0,342,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-15 03:00:02','2024-03-15 03:00:02',NULL,NULL),(8,'Discount 8','SJUZUOCYKLGH','2024-03-14 10:00:02','2024-04-09 10:00:02',NULL,0,451,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-15 03:00:02','2024-03-15 03:00:02',NULL,NULL),(9,'Discount 9','3NYFCSS0CRPE','2024-03-14 10:00:02',NULL,NULL,0,790,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-15 03:00:02','2024-03-15 03:00:02',NULL,NULL),(10,'Discount 10','MKCLWDQIP8XV','2024-03-14 10:00:02','2024-03-29 10:00:02',NULL,0,695,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-15 03:00:02','2024-03-15 03:00:02',NULL,NULL);
/*!40000 ALTER TABLE `ec_discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sale_products`
--

DROP TABLE IF EXISTS `ec_flash_sale_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sale_products` (
  `flash_sale_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `price` double unsigned DEFAULT NULL,
  `quantity` int unsigned DEFAULT NULL,
  `sold` int unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sale_products`
--

LOCK TABLES `ec_flash_sale_products` WRITE;
/*!40000 ALTER TABLE `ec_flash_sale_products` DISABLE KEYS */;
INSERT INTO `ec_flash_sale_products` VALUES (1,1,292.4,20,4),(1,2,796.26,13,5),(1,3,815.36,8,1),(1,4,514.7315,20,2),(1,5,770.4,13,1),(1,6,966.78,8,5),(1,7,1803.12,7,3),(1,8,1023.12,20,2),(1,9,1336.23,11,4),(1,10,1153.95,17,3);
/*!40000 ALTER TABLE `ec_flash_sale_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales`
--

DROP TABLE IF EXISTS `ec_flash_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date` datetime NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales`
--

LOCK TABLES `ec_flash_sales` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales` DISABLE KEYS */;
INSERT INTO `ec_flash_sales` VALUES (1,'Winter Sale','2024-04-04 00:00:00','published','2024-03-15 03:00:32','2024-03-15 03:00:32');
/*!40000 ALTER TABLE `ec_flash_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales_translations`
--

DROP TABLE IF EXISTS `ec_flash_sales_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_flash_sales_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_flash_sales_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales_translations`
--

LOCK TABLES `ec_flash_sales_translations` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_flash_sales_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value`
--

DROP TABLE IF EXISTS `ec_global_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value`
--

LOCK TABLES `ec_global_option_value` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value` DISABLE KEYS */;
INSERT INTO `ec_global_option_value` VALUES (1,1,'1 Year',0,9999,0,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(1,2,'2 Year',10,9999,0,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(1,3,'3 Year',20,9999,0,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(2,4,'4GB',0,9999,0,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(2,5,'8GB',10,9999,0,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(2,6,'16GB',20,9999,0,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(3,7,'Core i5',0,9999,0,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(3,8,'Core i7',10,9999,0,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(3,9,'Core i9',20,9999,0,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(4,10,'128GB',0,9999,0,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(4,11,'256GB',10,9999,0,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(4,12,'512GB',20,9999,0,'2024-03-15 03:00:02','2024-03-15 03:00:02');
/*!40000 ALTER TABLE `ec_global_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value_translations`
--

DROP TABLE IF EXISTS `ec_global_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value_translations`
--

LOCK TABLES `ec_global_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options`
--

DROP TABLE IF EXISTS `ec_global_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'option type',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options`
--

LOCK TABLES `ec_global_options` WRITE;
/*!40000 ALTER TABLE `ec_global_options` DISABLE KEYS */;
INSERT INTO `ec_global_options` VALUES (1,'Warranty','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(2,'RAM','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(3,'CPU','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(4,'HDD','Botble\\Ecommerce\\Option\\OptionType\\Dropdown',0,'2024-03-15 03:00:02','2024-03-15 03:00:02');
/*!40000 ALTER TABLE `ec_global_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options_translations`
--

DROP TABLE IF EXISTS `ec_global_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_options_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options_translations`
--

LOCK TABLES `ec_global_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_grouped_products`
--

DROP TABLE IF EXISTS `ec_grouped_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_grouped_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_product_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `fixed_qty` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_grouped_products`
--

LOCK TABLES `ec_grouped_products` WRITE;
/*!40000 ALTER TABLE `ec_grouped_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_grouped_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoice_items`
--

DROP TABLE IF EXISTS `ec_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoice_items`
--

LOCK TABLES `ec_invoice_items` WRITE;
/*!40000 ALTER TABLE `ec_invoice_items` DISABLE KEYS */;
INSERT INTO `ec_invoice_items` VALUES (1,1,'Botble\\Ecommerce\\Models\\Product',87,'Samsung QN90A Neo QLED 4K Smart TV (Digital)',NULL,'main/products/product-10.jpg',3,2424.00,7272.00,0.00,0.00,7272.00,'{\"sku\":\"ZQ-172-A0-A1\",\"attributes\":\"(Color: Green, Size: XL)\"}','2024-03-15 03:00:34','2024-03-15 03:00:34'),(2,2,'Botble\\Ecommerce\\Models\\Product',114,'Razer Blade 15 Advanced Gaming Laptop',NULL,'main/products/product-5.jpg',1,2272.00,2272.00,0.00,0.00,2272.00,'{\"sku\":\"K7-170-A0-A3\",\"attributes\":\"(Color: Brown, Size: XXL)\"}','2024-03-15 03:00:35','2024-03-15 03:00:35'),(3,3,'Botble\\Ecommerce\\Models\\Product',176,'TCL 6-Series 4K UHD Dolby Vision HDR QLED Roku Smart TV',NULL,'main/products/product-6.jpg',3,1087.00,3261.00,0.00,0.00,3261.00,'{\"sku\":\"FH-109-A0-A3\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}','2024-03-15 03:00:35','2024-03-15 03:00:35'),(4,4,'Botble\\Ecommerce\\Models\\Product',200,'Google Chromecast with Google TV',NULL,'main/products/product-19.jpg',3,1088.00,3264.00,0.00,0.00,3264.00,'{\"sku\":\"PQ-100-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 1 Box)\"}','2024-03-15 03:00:36','2024-03-15 03:00:36'),(5,5,'Botble\\Ecommerce\\Models\\Product',168,'Samsung Odyssey G7 32-Inch Curved Gaming Monitor (Digital)',NULL,'main/products/product-10.jpg',3,1216.00,3648.00,0.00,0.00,3648.00,'{\"sku\":\"WP-103-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-15 03:00:36','2024-03-15 03:00:36'),(6,6,'Botble\\Ecommerce\\Models\\Product',171,'Sony X900H 4K Ultra HD Smart LED TV',NULL,'main/products/product-8.jpg',3,1609.00,4827.00,0.00,0.00,4827.00,'{\"sku\":\"PY-109-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}','2024-03-15 03:00:36','2024-03-15 03:00:36'),(7,7,'Botble\\Ecommerce\\Models\\Product',207,'Bose Smart Soundbar 900',NULL,'main/products/product-details-desc-1.jpg',3,922.00,2766.00,0.00,0.00,2766.00,'{\"sku\":\"JK-179-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}','2024-03-15 03:00:36','2024-03-15 03:00:36'),(8,8,'Botble\\Ecommerce\\Models\\Product',122,'Logitech G Pro X Superlight Wireless Gaming Mouse (Digital)',NULL,'main/products/product-8.jpg',1,511.00,511.00,0.00,0.00,511.00,'{\"sku\":\"FI-119-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-15 03:00:37','2024-03-15 03:00:37'),(9,8,'Botble\\Ecommerce\\Models\\Product',169,'Samsung Odyssey G7 32-Inch Curved Gaming Monitor (Digital)',NULL,'main/products/product-8.jpg',3,1216.00,3648.00,0.00,0.00,3648.00,'{\"sku\":\"WP-103-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 3KG)\"}','2024-03-15 03:00:37','2024-03-15 03:00:37'),(10,9,'Botble\\Ecommerce\\Models\\Product',157,'BenQ EW3280U 32-Inch 4K HDR Entertainment Monitor (Digital)',NULL,'main/products/product-5.jpg',2,1518.00,3036.00,0.00,0.00,3036.00,'{\"sku\":\"Z2-109-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 1 Box)\"}','2024-03-15 03:00:37','2024-03-15 03:00:37'),(11,10,'Botble\\Ecommerce\\Models\\Product',75,'GoPro HERO9 Black Action Camera',NULL,'main/products/product-13.jpg',2,2049.00,4098.00,0.00,0.00,4098.00,'{\"sku\":\"YX-108-A0\",\"attributes\":\"(Size: M, Color: Red)\"}','2024-03-15 03:00:37','2024-03-15 03:00:37'),(12,10,'Botble\\Ecommerce\\Models\\Product',77,'GoPro HERO9 Black Action Camera',NULL,'main/products/product-14.jpg',3,2049.00,6147.00,0.00,0.00,6147.00,'{\"sku\":\"YX-108-A0-A2\",\"attributes\":\"(Color: Red, Size: XL)\"}','2024-03-15 03:00:37','2024-03-15 03:00:37'),(13,10,'Botble\\Ecommerce\\Models\\Product',187,'Sony A90J 4K OLED Smart TV',NULL,'main/products/product-2.jpg',1,1972.00,1972.00,0.00,0.00,1972.00,'{\"sku\":\"PM-191-A0-A2\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}','2024-03-15 03:00:37','2024-03-15 03:00:37'),(14,11,'Botble\\Ecommerce\\Models\\Product',117,'Corsair K95 RGB Platinum XT Mechanical Gaming Keyboard',NULL,'main/products/product-8.jpg',2,1101.00,2202.00,0.00,0.00,2202.00,'{\"sku\":\"35-120-A0\",\"attributes\":\"(Color: Green, Size: XL)\"}','2024-03-15 03:00:38','2024-03-15 03:00:38'),(15,12,'Botble\\Ecommerce\\Models\\Product',72,'DJI Mavic Air 2 Drone',NULL,'main/products/product-14.jpg',1,2358.00,2358.00,0.00,0.00,2358.00,'{\"sku\":\"NW-195-A0\",\"attributes\":\"(Size: S, Color: Brown)\"}','2024-03-15 03:00:38','2024-03-15 03:00:38'),(16,13,'Botble\\Ecommerce\\Models\\Product',173,'TCL 6-Series 4K UHD Dolby Vision HDR QLED Roku Smart TV',NULL,'main/products/product-13.jpg',1,1087.00,1087.00,0.00,0.00,1087.00,'{\"sku\":\"FH-109-A0\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-15 03:00:38','2024-03-15 03:00:38'),(17,14,'Botble\\Ecommerce\\Models\\Product',186,'Sony A90J 4K OLED Smart TV',NULL,'main/products/product-3.jpg',2,1972.00,3944.00,0.00,0.00,3944.00,'{\"sku\":\"PM-191-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}','2024-03-15 03:00:39','2024-03-15 03:00:39'),(18,15,'Botble\\Ecommerce\\Models\\Product',208,'JBL Bar 9.1 Soundbar with Dolby Atmos',NULL,'main/products/product-18.jpg',3,832.00,2496.00,0.00,0.00,2496.00,'{\"sku\":\"UT-109-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}','2024-03-15 03:00:39','2024-03-15 03:00:39'),(19,16,'Botble\\Ecommerce\\Models\\Product',76,'GoPro HERO9 Black Action Camera',NULL,'main/products/product-20.jpg',1,2049.00,2049.00,0.00,0.00,2049.00,'{\"sku\":\"YX-108-A0-A1\",\"attributes\":\"(Size: M, Color: Black)\"}','2024-03-15 03:00:39','2024-03-15 03:00:39'),(20,17,'Botble\\Ecommerce\\Models\\Product',95,'Apple Watch Series 7',NULL,'main/products/product-details-desc-3.jpg',2,1020.00,2040.00,0.00,0.00,2040.00,'{\"sku\":\"14-156-A0-A1\",\"attributes\":\"(Color: Red, Size: XXL)\"}','2024-03-15 03:00:40','2024-03-15 03:00:40'),(21,18,'Botble\\Ecommerce\\Models\\Product',104,'Microsoft Surface Pro 8',NULL,'main/products/product-3.jpg',2,1788.00,3576.00,0.00,0.00,3576.00,'{\"sku\":\"2U-121-A0\",\"attributes\":\"(Color: Green, Size: XXL)\"}','2024-03-15 03:00:40','2024-03-15 03:00:40'),(22,19,'Botble\\Ecommerce\\Models\\Product',198,'Google Chromecast with Google TV',NULL,'main/products/product-15.jpg',2,1088.00,2176.00,0.00,0.00,2176.00,'{\"sku\":\"PQ-100-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}','2024-03-15 03:00:40','2024-03-15 03:00:40'),(23,20,'Botble\\Ecommerce\\Models\\Product',114,'Razer Blade 15 Advanced Gaming Laptop',NULL,'main/products/product-5.jpg',2,2272.00,4544.00,0.00,0.00,4544.00,'{\"sku\":\"K7-170-A0-A3\",\"attributes\":\"(Color: Brown, Size: XXL)\"}','2024-03-15 03:00:41','2024-03-15 03:00:41'),(24,21,'Botble\\Ecommerce\\Models\\Product',120,'Corsair K95 RGB Platinum XT Mechanical Gaming Keyboard',NULL,'main/products/product-17.jpg',2,1101.00,2202.00,0.00,0.00,2202.00,'{\"sku\":\"35-120-A0-A3\",\"attributes\":\"(Color: Red, Size: XL)\"}','2024-03-15 03:00:41','2024-03-15 03:00:41'),(25,22,'Botble\\Ecommerce\\Models\\Product',59,'EcoTech Marine Radion XR30w G5 Pro LED Light Fixture',NULL,'main/products/product-16.jpg',1,344.00,344.00,0.00,0.00,344.00,'{\"sku\":\"D6-153-A0-A1\",\"attributes\":\"(Color: Green, Size: L)\"}','2024-03-15 03:00:41','2024-03-15 03:00:41'),(26,22,'Botble\\Ecommerce\\Models\\Product',213,'Sony HT-A9 Home Theater System',NULL,'main/products/product-6.jpg',1,296.00,296.00,0.00,0.00,296.00,'{\"sku\":\"UF-174-A0-A1\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}','2024-03-15 03:00:41','2024-03-15 03:00:41'),(27,23,'Botble\\Ecommerce\\Models\\Product',184,'Samsung QN85A Neo QLED 4K Smart TV',NULL,'main/products/product-details-desc-3.jpg',3,989.00,2967.00,0.00,0.00,2967.00,'{\"sku\":\"NM-110-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}','2024-03-15 03:00:42','2024-03-15 03:00:42'),(28,24,'Botble\\Ecommerce\\Models\\Product',98,'Fitbit Charge 5 Fitness Tracker (Digital)',NULL,'main/products/product-18.jpg',3,893.00,2679.00,0.00,0.00,2679.00,'{\"sku\":\"8E-178-A0-A1\",\"attributes\":\"(Color: Green, Size: S)\"}','2024-03-15 03:00:42','2024-03-15 03:00:42'),(29,25,'Botble\\Ecommerce\\Models\\Product',110,'HP Spectre x360 14-Inch Convertible Laptop (Digital)',NULL,'main/products/product-details-desc-3.jpg',3,2356.00,7068.00,0.00,0.00,7068.00,'{\"sku\":\"7T-161-A0\",\"attributes\":\"(Color: Blue, Size: L)\"}','2024-03-15 03:00:42','2024-03-15 03:00:42'),(30,26,'Botble\\Ecommerce\\Models\\Product',188,'Apple TV 4K (2nd Generation) (Digital)',NULL,'main/products/product-1.jpg',1,906.00,906.00,0.00,0.00,906.00,'{\"sku\":\"WG-143-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}','2024-03-15 03:00:43','2024-03-15 03:00:43'),(31,27,'Botble\\Ecommerce\\Models\\Product',118,'Corsair K95 RGB Platinum XT Mechanical Gaming Keyboard',NULL,'main/products/product-18.jpg',3,1101.00,3303.00,0.00,0.00,3303.00,'{\"sku\":\"35-120-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}','2024-03-15 03:00:43','2024-03-15 03:00:43'),(32,27,'Botble\\Ecommerce\\Models\\Product',212,'Sony HT-A9 Home Theater System',NULL,'main/products/product-details-desc-3.jpg',2,296.00,592.00,0.00,0.00,592.00,'{\"sku\":\"UF-174-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}','2024-03-15 03:00:43','2024-03-15 03:00:43'),(33,28,'Botble\\Ecommerce\\Models\\Product',178,'Vizio OLED65-H1 65-Inch 4K OLED Smart TV',NULL,'main/products/product-16.jpg',3,439.00,1317.00,0.00,0.00,1317.00,'{\"sku\":\"EC-152-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}','2024-03-15 03:00:44','2024-03-15 03:00:44'),(34,29,'Botble\\Ecommerce\\Models\\Product',83,'Nest Learning Thermostat (3rd Generation)',NULL,'main/products/product-5.jpg',3,2121.00,6363.00,0.00,0.00,6363.00,'{\"sku\":\"B5-140-A0-A1\",\"attributes\":\"(Color: Blue, Size: XL)\"}','2024-03-15 03:00:44','2024-03-15 03:00:44'),(35,30,'Botble\\Ecommerce\\Models\\Product',96,'Apple Watch Series 7',NULL,'main/products/product-3.jpg',1,1020.00,1020.00,0.00,0.00,1020.00,'{\"sku\":\"14-156-A0-A2\",\"attributes\":\"(Color: Green, Size: M)\"}','2024-03-15 03:00:44','2024-03-15 03:00:44'),(36,31,'Botble\\Ecommerce\\Models\\Product',106,'Microsoft Surface Pro 8',NULL,'main/products/product-details-desc-2.jpg',1,1788.00,1788.00,0.00,0.00,1788.00,'{\"sku\":\"2U-121-A0-A2\",\"attributes\":\"(Color: Blue, Size: XL)\"}','2024-03-15 03:00:44','2024-03-15 03:00:44'),(37,32,'Botble\\Ecommerce\\Models\\Product',177,'Vizio OLED65-H1 65-Inch 4K OLED Smart TV',NULL,'main/products/product-details-desc-1.jpg',2,439.00,878.00,0.00,0.00,878.00,'{\"sku\":\"EC-152-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}','2024-03-15 03:00:45','2024-03-15 03:00:45'),(38,33,'Botble\\Ecommerce\\Models\\Product',58,'EcoTech Marine Radion XR30w G5 Pro LED Light Fixture',NULL,'main/products/product-12.jpg',3,344.00,1032.00,0.00,0.00,1032.00,'{\"sku\":\"D6-153-A0\",\"attributes\":\"(Size: S, Color: Blue)\"}','2024-03-15 03:00:45','2024-03-15 03:00:45'),(39,34,'Botble\\Ecommerce\\Models\\Product',111,'Razer Blade 15 Advanced Gaming Laptop',NULL,'main/products/product-5.jpg',3,2272.00,6816.00,0.00,0.00,6816.00,'{\"sku\":\"K7-170-A0\",\"attributes\":\"(Color: Green, Size: L)\"}','2024-03-15 03:00:45','2024-03-15 03:00:45'),(40,35,'Botble\\Ecommerce\\Models\\Product',178,'Vizio OLED65-H1 65-Inch 4K OLED Smart TV',NULL,'main/products/product-16.jpg',2,439.00,878.00,0.00,0.00,878.00,'{\"sku\":\"EC-152-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}','2024-03-15 03:00:45','2024-03-15 03:00:45'),(41,36,'Botble\\Ecommerce\\Models\\Product',82,'Nest Learning Thermostat (3rd Generation)',NULL,'main/products/product-13.jpg',2,2121.00,4242.00,0.00,0.00,4242.00,'{\"sku\":\"B5-140-A0\",\"attributes\":\"(Color: Blue, Size: XL)\"}','2024-03-15 03:00:45','2024-03-15 03:00:45'),(42,37,'Botble\\Ecommerce\\Models\\Product',88,'Samsung QN90A Neo QLED 4K Smart TV (Digital)',NULL,'main/products/product-19.jpg',1,2424.00,2424.00,0.00,0.00,2424.00,'{\"sku\":\"ZQ-172-A0-A2\",\"attributes\":\"(Color: Green, Size: XL)\"}','2024-03-15 03:00:46','2024-03-15 03:00:46'),(43,37,'Botble\\Ecommerce\\Models\\Product',123,'SteelSeries Arctis Pro Wireless Gaming Headset',NULL,'main/products/product-17.jpg',3,263.00,789.00,0.00,0.00,789.00,'{\"sku\":\"GO-147-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-15 03:00:46','2024-03-15 03:00:46'),(44,38,'Botble\\Ecommerce\\Models\\Product',122,'Logitech G Pro X Superlight Wireless Gaming Mouse (Digital)',NULL,'main/products/product-8.jpg',2,511.00,1022.00,0.00,0.00,1022.00,'{\"sku\":\"FI-119-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-15 03:00:46','2024-03-15 03:00:46'),(45,39,'Botble\\Ecommerce\\Models\\Product',160,'Dell UltraSharp U2720Q 27-Inch 4K USB-C Monitor',NULL,'main/products/product-details-desc-3.jpg',3,1278.00,3834.00,0.00,0.00,3834.00,'{\"sku\":\"EV-148-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-15 03:00:46','2024-03-15 03:00:46'),(46,39,'Botble\\Ecommerce\\Models\\Product',211,'Sennheiser Ambeo Soundbar (Digital)',NULL,'main/products/product-details-desc-1.jpg',1,431.00,431.00,0.00,0.00,431.00,'{\"sku\":\"K2-193-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}','2024-03-15 03:00:46','2024-03-15 03:00:46'),(47,40,'Botble\\Ecommerce\\Models\\Product',63,'Samsung Galaxy Tab S7+ 12.4-Inch Android Tablet',NULL,'main/products/product-12.jpg',1,1274.00,1274.00,0.00,0.00,1274.00,'{\"sku\":\"D9-163-A0-A1\",\"attributes\":\"(Size: L, Color: Black)\"}','2024-03-15 03:00:47','2024-03-15 03:00:47'),(48,40,'Botble\\Ecommerce\\Models\\Product',207,'Bose Smart Soundbar 900',NULL,'main/products/product-details-desc-1.jpg',3,922.00,2766.00,0.00,0.00,2766.00,'{\"sku\":\"JK-179-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}','2024-03-15 03:00:47','2024-03-15 03:00:47'),(49,41,'Botble\\Ecommerce\\Models\\Product',94,'Apple Watch Series 7',NULL,'main/products/product-7.jpg',1,1020.00,1020.00,0.00,0.00,1020.00,'{\"sku\":\"14-156-A0\",\"attributes\":\"(Size: S, Color: Brown)\"}','2024-03-15 03:00:47','2024-03-15 03:00:47'),(50,42,'Botble\\Ecommerce\\Models\\Product',98,'Fitbit Charge 5 Fitness Tracker (Digital)',NULL,'main/products/product-18.jpg',1,893.00,893.00,0.00,0.00,893.00,'{\"sku\":\"8E-178-A0-A1\",\"attributes\":\"(Color: Green, Size: S)\"}','2024-03-15 03:00:47','2024-03-15 03:00:47'),(51,43,'Botble\\Ecommerce\\Models\\Product',119,'Corsair K95 RGB Platinum XT Mechanical Gaming Keyboard',NULL,'main/products/product-19.jpg',2,1101.00,2202.00,0.00,0.00,2202.00,'{\"sku\":\"35-120-A0-A2\",\"attributes\":\"(Size: XL, Color: Brown)\"}','2024-03-15 03:00:47','2024-03-15 03:00:47'),(52,44,'Botble\\Ecommerce\\Models\\Product',129,'Elgato Stream Deck XL',NULL,'main/products/product-13.jpg',1,2040.00,2040.00,0.00,0.00,2040.00,'{\"sku\":\"JV-167-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-15 03:00:47','2024-03-15 03:00:47'),(53,45,'Botble\\Ecommerce\\Models\\Product',62,'Samsung Galaxy Tab S7+ 12.4-Inch Android Tablet',NULL,'main/products/product-1.jpg',1,1274.00,1274.00,0.00,0.00,1274.00,'{\"sku\":\"D9-163-A0\",\"attributes\":\"(Color: Red, Size: L)\"}','2024-03-15 03:00:48','2024-03-15 03:00:48'),(54,45,'Botble\\Ecommerce\\Models\\Product',63,'Samsung Galaxy Tab S7+ 12.4-Inch Android Tablet',NULL,'main/products/product-12.jpg',3,1274.00,3822.00,0.00,0.00,3822.00,'{\"sku\":\"D9-163-A0-A1\",\"attributes\":\"(Size: L, Color: Black)\"}','2024-03-15 03:00:48','2024-03-15 03:00:48'),(55,45,'Botble\\Ecommerce\\Models\\Product',107,'Lenovo ThinkPad X1 Carbon Gen 9 Laptop',NULL,'main/products/product-3.jpg',3,2394.00,7182.00,0.00,0.00,7182.00,'{\"sku\":\"FB-138-A0\",\"attributes\":\"(Color: Black, Size: XXL)\"}','2024-03-15 03:00:48','2024-03-15 03:00:48'),(56,46,'Botble\\Ecommerce\\Models\\Product',205,'Sonos Beam Gen 2 Soundbar',NULL,'main/products/product-18.jpg',2,2148.00,4296.00,0.00,0.00,4296.00,'{\"sku\":\"KW-195-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}','2024-03-15 03:00:48','2024-03-15 03:00:48'),(57,47,'Botble\\Ecommerce\\Models\\Product',101,'Garmin Fenix 7X Sapphire Solar GPS Watch',NULL,'main/products/product-17.jpg',3,2360.00,7080.00,0.00,0.00,7080.00,'{\"sku\":\"UL-142-A0\",\"attributes\":\"(Color: Black, Size: XL)\"}','2024-03-15 03:00:48','2024-03-15 03:00:48'),(58,48,'Botble\\Ecommerce\\Models\\Product',142,'HTC Vive Cosmos Elite VR Headset',NULL,'main/products/product-13.jpg',3,1454.00,4362.00,0.00,0.00,4362.00,'{\"sku\":\"8Q-195-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-15 03:00:48','2024-03-15 03:00:48'),(59,49,'Botble\\Ecommerce\\Models\\Product',152,'ASUS ROG Swift PG279QM 27-Inch Gaming Monitor',NULL,'main/products/product-15.jpg',2,1443.00,2886.00,0.00,0.00,2886.00,'{\"sku\":\"JS-195-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 4KG)\"}','2024-03-15 03:00:49','2024-03-15 03:00:49'),(60,50,'Botble\\Ecommerce\\Models\\Product',130,'Nintendo Switch OLED Model',NULL,'main/products/product-2.jpg',2,399.00,798.00,0.00,0.00,798.00,'{\"sku\":\"Q5-195-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}','2024-03-15 03:00:49','2024-03-15 03:00:49'),(61,51,'Botble\\Ecommerce\\Models\\Product',145,'Samsung Odyssey G9 49-Inch Curved Gaming Monitor (Digital)',NULL,'main/products/product-14.jpg',2,544.00,1088.00,0.00,0.00,1088.00,'{\"sku\":\"FD-181-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}','2024-03-15 03:00:49','2024-03-15 03:00:49'),(62,52,'Botble\\Ecommerce\\Models\\Product',166,'LG 27UK850-W 27-Inch 4K UHD IPS Monitor',NULL,'main/products/product-19.jpg',3,1928.00,5784.00,0.00,0.00,5784.00,'{\"sku\":\"SS-163-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}','2024-03-15 03:00:49','2024-03-15 03:00:49'),(63,53,'Botble\\Ecommerce\\Models\\Product',94,'Apple Watch Series 7',NULL,'main/products/product-7.jpg',1,1020.00,1020.00,0.00,0.00,1020.00,'{\"sku\":\"14-156-A0\",\"attributes\":\"(Size: S, Color: Brown)\"}','2024-03-15 03:00:50','2024-03-15 03:00:50'),(64,53,'Botble\\Ecommerce\\Models\\Product',188,'Apple TV 4K (2nd Generation) (Digital)',NULL,'main/products/product-1.jpg',2,906.00,1812.00,0.00,0.00,1812.00,'{\"sku\":\"WG-143-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}','2024-03-15 03:00:50','2024-03-15 03:00:50'),(65,54,'Botble\\Ecommerce\\Models\\Product',98,'Fitbit Charge 5 Fitness Tracker (Digital)',NULL,'main/products/product-18.jpg',3,893.00,2679.00,0.00,0.00,2679.00,'{\"sku\":\"8E-178-A0-A1\",\"attributes\":\"(Color: Green, Size: S)\"}','2024-03-15 03:00:50','2024-03-15 03:00:50'),(66,55,'Botble\\Ecommerce\\Models\\Product',104,'Microsoft Surface Pro 8',NULL,'main/products/product-3.jpg',1,1788.00,1788.00,0.00,0.00,1788.00,'{\"sku\":\"2U-121-A0\",\"attributes\":\"(Color: Green, Size: XXL)\"}','2024-03-15 03:00:50','2024-03-15 03:00:50');
/*!40000 ALTER TABLE `ec_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoices`
--

DROP TABLE IF EXISTS `ec_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_tax_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_invoices_code_unique` (`code`),
  KEY `ec_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `ec_invoices_payment_id_index` (`payment_id`),
  KEY `ec_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoices`
--

LOCK TABLES `ec_invoices` WRITE;
/*!40000 ALTER TABLE `ec_invoices` DISABLE KEYS */;
INSERT INTO `ec_invoices` VALUES (1,'Botble\\Ecommerce\\Models\\Order',1,'INV-1','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,7272.00,0.00,0.00,0.00,NULL,'',NULL,NULL,7272.00,NULL,1,'pending',NULL,'2024-03-10 03:00:34','2024-03-15 03:00:34'),(2,'Botble\\Ecommerce\\Models\\Order',2,'INV-2','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,2272.00,0.00,0.00,0.00,'1','default',NULL,NULL,2272.00,NULL,2,'pending',NULL,'2024-03-01 19:00:35','2024-03-15 03:00:35'),(3,'Botble\\Ecommerce\\Models\\Order',3,'INV-3','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,3261.00,0.00,0.00,0.00,'1','default',NULL,NULL,3261.00,NULL,3,'completed','2024-03-15 03:00:35','2024-03-10 03:00:35','2024-03-15 03:00:35'),(4,'Botble\\Ecommerce\\Models\\Order',4,'INV-4','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,3264.00,0.00,0.00,0.00,'1','default',NULL,NULL,3264.00,NULL,4,'completed','2024-03-15 03:00:36','2024-03-05 03:00:35','2024-03-15 03:00:36'),(5,'Botble\\Ecommerce\\Models\\Order',5,'INV-5','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,3648.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3648.00,NULL,5,'completed','2024-03-15 03:00:36','2024-03-02 11:00:36','2024-03-15 03:00:36'),(6,'Botble\\Ecommerce\\Models\\Order',6,'INV-6','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,4827.00,0.00,0.00,0.00,'1','default',NULL,NULL,4827.00,NULL,6,'completed','2024-03-15 03:00:36','2024-03-11 23:00:36','2024-03-15 03:00:36'),(7,'Botble\\Ecommerce\\Models\\Order',7,'INV-7','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,2766.00,0.00,0.00,0.00,'1','default',NULL,NULL,2766.00,NULL,7,'completed','2024-03-15 03:00:36','2024-03-05 15:00:36','2024-03-15 03:00:36'),(8,'Botble\\Ecommerce\\Models\\Order',8,'INV-8','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,4159.00,0.00,0.00,0.00,NULL,'',NULL,NULL,4159.00,NULL,8,'completed','2024-03-15 03:00:37','2024-03-03 03:00:37','2024-03-15 03:00:37'),(9,'Botble\\Ecommerce\\Models\\Order',9,'INV-9','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,3036.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3036.00,NULL,9,'pending',NULL,'2024-03-13 15:00:37','2024-03-15 03:00:37'),(10,'Botble\\Ecommerce\\Models\\Order',10,'INV-10','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,12217.00,0.00,0.00,0.00,'1','default',NULL,NULL,12217.00,NULL,10,'completed','2024-03-15 03:00:37','2024-03-10 21:00:37','2024-03-15 03:00:37'),(11,'Botble\\Ecommerce\\Models\\Order',11,'INV-11','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,2202.00,0.00,0.00,0.00,'1','default',NULL,NULL,2202.00,NULL,11,'completed','2024-03-15 03:00:38','2024-03-10 21:00:38','2024-03-15 03:00:38'),(12,'Botble\\Ecommerce\\Models\\Order',12,'INV-12','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,2358.00,0.00,0.00,0.00,'1','default',NULL,NULL,2358.00,NULL,12,'completed','2024-03-15 03:00:38','2024-03-07 03:00:38','2024-03-15 03:00:38'),(13,'Botble\\Ecommerce\\Models\\Order',13,'INV-13','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,1087.00,0.00,0.00,0.00,'1','default',NULL,NULL,1087.00,NULL,13,'completed','2024-03-15 03:00:38','2024-03-12 11:00:38','2024-03-15 03:00:38'),(14,'Botble\\Ecommerce\\Models\\Order',14,'INV-14','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,3944.00,0.00,0.00,0.00,'1','default',NULL,NULL,3944.00,NULL,14,'completed','2024-03-15 03:00:39','2024-03-13 19:00:39','2024-03-15 03:00:39'),(15,'Botble\\Ecommerce\\Models\\Order',15,'INV-15','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,2496.00,0.00,0.00,0.00,'1','default',NULL,NULL,2496.00,NULL,15,'completed','2024-03-15 03:00:39','2024-03-12 11:00:39','2024-03-15 03:00:39'),(16,'Botble\\Ecommerce\\Models\\Order',16,'INV-16','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,2049.00,0.00,0.00,0.00,'1','default',NULL,NULL,2049.00,NULL,16,'completed','2024-03-15 03:00:39','2024-03-03 21:00:39','2024-03-15 03:00:39'),(17,'Botble\\Ecommerce\\Models\\Order',17,'INV-17','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,2040.00,0.00,0.00,0.00,'1','default',NULL,NULL,2040.00,NULL,17,'completed','2024-03-15 03:00:40','2024-03-03 21:00:40','2024-03-15 03:00:40'),(18,'Botble\\Ecommerce\\Models\\Order',18,'INV-18','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,3576.00,0.00,0.00,0.00,'1','default',NULL,NULL,3576.00,NULL,18,'pending',NULL,'2024-03-13 21:00:40','2024-03-15 03:00:40'),(19,'Botble\\Ecommerce\\Models\\Order',19,'INV-19','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,2176.00,0.00,0.00,0.00,'1','default',NULL,NULL,2176.00,NULL,19,'completed','2024-03-15 03:00:40','2024-03-11 09:00:40','2024-03-15 03:00:40'),(20,'Botble\\Ecommerce\\Models\\Order',20,'INV-20','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,4544.00,0.00,0.00,0.00,'1','default',NULL,NULL,4544.00,NULL,20,'pending',NULL,'2024-03-04 15:00:41','2024-03-15 03:00:41'),(21,'Botble\\Ecommerce\\Models\\Order',21,'INV-21','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,2202.00,0.00,0.00,0.00,'1','default',NULL,NULL,2202.00,NULL,21,'completed','2024-03-15 03:00:41','2024-03-09 07:00:41','2024-03-15 03:00:41'),(22,'Botble\\Ecommerce\\Models\\Order',22,'INV-22','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,640.00,0.00,0.00,0.00,'1','default',NULL,NULL,640.00,NULL,22,'completed','2024-03-15 03:00:41','2024-03-09 17:00:41','2024-03-15 03:00:41'),(23,'Botble\\Ecommerce\\Models\\Order',23,'INV-23','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,2967.00,0.00,0.00,0.00,'1','default',NULL,NULL,2967.00,NULL,23,'pending',NULL,'2024-03-14 01:00:42','2024-03-15 03:00:42'),(24,'Botble\\Ecommerce\\Models\\Order',24,'INV-24','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,2679.00,0.00,0.00,0.00,NULL,'',NULL,NULL,2679.00,NULL,24,'completed','2024-03-15 03:00:42','2024-03-05 03:00:42','2024-03-15 03:00:42'),(25,'Botble\\Ecommerce\\Models\\Order',25,'INV-25','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,7068.00,0.00,0.00,0.00,NULL,'',NULL,NULL,7068.00,NULL,25,'completed','2024-03-15 03:00:42','2024-03-10 03:00:42','2024-03-15 03:00:42'),(26,'Botble\\Ecommerce\\Models\\Order',26,'INV-26','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,906.00,0.00,0.00,0.00,NULL,'',NULL,NULL,906.00,NULL,26,'completed','2024-03-15 03:00:43','2024-03-12 03:00:43','2024-03-15 03:00:43'),(27,'Botble\\Ecommerce\\Models\\Order',27,'INV-27','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,3895.00,0.00,0.00,0.00,'1','default',NULL,NULL,3895.00,NULL,27,'completed','2024-03-15 03:00:43','2024-03-11 11:00:43','2024-03-15 03:00:43'),(28,'Botble\\Ecommerce\\Models\\Order',28,'INV-28','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,1317.00,0.00,0.00,0.00,'1','default',NULL,NULL,1317.00,NULL,28,'pending',NULL,'2024-03-12 09:00:43','2024-03-15 03:00:44'),(29,'Botble\\Ecommerce\\Models\\Order',29,'INV-29','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,6363.00,0.00,0.00,0.00,'1','default',NULL,NULL,6363.00,NULL,29,'completed','2024-03-15 03:00:44','2024-03-10 23:00:44','2024-03-15 03:00:44'),(30,'Botble\\Ecommerce\\Models\\Order',30,'INV-30','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,1020.00,0.00,0.00,0.00,'1','default',NULL,NULL,1020.00,NULL,30,'pending',NULL,'2024-03-10 23:00:44','2024-03-15 03:00:44'),(31,'Botble\\Ecommerce\\Models\\Order',31,'INV-31','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,1788.00,0.00,0.00,0.00,'1','default',NULL,NULL,1788.00,NULL,31,'completed','2024-03-15 03:00:44','2024-03-09 07:00:44','2024-03-15 03:00:44'),(32,'Botble\\Ecommerce\\Models\\Order',32,'INV-32','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,878.00,0.00,0.00,0.00,'1','default',NULL,NULL,878.00,NULL,32,'completed','2024-03-15 03:00:45','2024-03-06 19:00:45','2024-03-15 03:00:45'),(33,'Botble\\Ecommerce\\Models\\Order',33,'INV-33','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,1032.00,0.00,0.00,0.00,'1','default',NULL,NULL,1032.00,NULL,33,'completed','2024-03-15 03:00:45','2024-03-14 09:00:45','2024-03-15 03:00:45'),(34,'Botble\\Ecommerce\\Models\\Order',34,'INV-34','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,6816.00,0.00,0.00,0.00,'1','default',NULL,NULL,6816.00,NULL,34,'completed','2024-03-15 03:00:45','2024-03-10 15:00:45','2024-03-15 03:00:45'),(35,'Botble\\Ecommerce\\Models\\Order',35,'INV-35','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,878.00,0.00,0.00,0.00,'1','default',NULL,NULL,878.00,NULL,35,'completed','2024-03-15 03:00:45','2024-03-12 21:00:45','2024-03-15 03:00:45'),(36,'Botble\\Ecommerce\\Models\\Order',36,'INV-36','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,4242.00,0.00,0.00,0.00,'1','default',NULL,NULL,4242.00,NULL,36,'pending',NULL,'2024-03-11 19:00:45','2024-03-15 03:00:45'),(37,'Botble\\Ecommerce\\Models\\Order',37,'INV-37','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,3213.00,0.00,0.00,0.00,'1','default',NULL,NULL,3213.00,NULL,37,'completed','2024-03-15 03:00:46','2024-03-10 11:00:46','2024-03-15 03:00:46'),(38,'Botble\\Ecommerce\\Models\\Order',38,'INV-38','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,1022.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1022.00,NULL,38,'pending',NULL,'2024-03-11 03:00:46','2024-03-15 03:00:46'),(39,'Botble\\Ecommerce\\Models\\Order',39,'INV-39','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,4265.00,0.00,0.00,0.00,'1','default',NULL,NULL,4265.00,NULL,39,'completed','2024-03-15 03:00:46','2024-03-11 01:00:46','2024-03-15 03:00:46'),(40,'Botble\\Ecommerce\\Models\\Order',40,'INV-40','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,4040.00,0.00,0.00,0.00,'1','default',NULL,NULL,4040.00,NULL,40,'completed','2024-03-15 03:00:47','2024-03-13 03:00:47','2024-03-15 03:00:47'),(41,'Botble\\Ecommerce\\Models\\Order',41,'INV-41','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,1020.00,0.00,0.00,0.00,'1','default',NULL,NULL,1020.00,NULL,41,'pending',NULL,'2024-03-14 17:00:47','2024-03-15 03:00:47'),(42,'Botble\\Ecommerce\\Models\\Order',42,'INV-42','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,893.00,0.00,0.00,0.00,NULL,'',NULL,NULL,893.00,NULL,42,'pending',NULL,'2024-03-12 15:00:47','2024-03-15 03:00:47'),(43,'Botble\\Ecommerce\\Models\\Order',43,'INV-43','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,2202.00,0.00,0.00,0.00,'1','default',NULL,NULL,2202.00,NULL,43,'completed','2024-03-15 03:00:47','2024-03-12 15:00:47','2024-03-15 03:00:47'),(44,'Botble\\Ecommerce\\Models\\Order',44,'INV-44','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,2040.00,0.00,0.00,0.00,'1','default',NULL,NULL,2040.00,NULL,44,'completed','2024-03-15 03:00:47','2024-03-13 21:00:47','2024-03-15 03:00:47'),(45,'Botble\\Ecommerce\\Models\\Order',45,'INV-45','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,12278.00,0.00,0.00,0.00,'1','default',NULL,NULL,12278.00,NULL,45,'pending',NULL,'2024-03-14 11:00:48','2024-03-15 03:00:48'),(46,'Botble\\Ecommerce\\Models\\Order',46,'INV-46','Prof. Tyreek Cremin','',NULL,'bhalvorson@example.com','+15054882884','105 Koss Crossroad Suite 051, North Eldred, North Carolina, NP',NULL,4296.00,0.00,0.00,0.00,'1','default',NULL,NULL,4296.00,NULL,46,'pending',NULL,'2024-03-12 19:00:48','2024-03-15 03:00:48'),(47,'Botble\\Ecommerce\\Models\\Order',47,'INV-47','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,7080.00,0.00,0.00,0.00,'1','default',NULL,NULL,7080.00,NULL,47,'completed','2024-03-15 03:00:48','2024-03-14 21:00:48','2024-03-15 03:00:48'),(48,'Botble\\Ecommerce\\Models\\Order',48,'INV-48','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,4362.00,0.00,0.00,0.00,'1','default',NULL,NULL,4362.00,NULL,48,'completed','2024-03-15 03:00:48','2024-03-14 21:00:48','2024-03-15 03:00:48'),(49,'Botble\\Ecommerce\\Models\\Order',49,'INV-49','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,2886.00,0.00,0.00,0.00,'1','default',NULL,NULL,2886.00,NULL,49,'pending',NULL,'2024-03-14 15:00:49','2024-03-15 03:00:49'),(50,'Botble\\Ecommerce\\Models\\Order',50,'INV-50','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,798.00,0.00,0.00,0.00,'1','default',NULL,NULL,798.00,NULL,50,'completed','2024-03-15 03:00:49','2024-03-14 07:00:49','2024-03-15 03:00:49'),(51,'Botble\\Ecommerce\\Models\\Order',51,'INV-51','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,1088.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1088.00,NULL,51,'completed','2024-03-15 03:00:49','2024-03-13 19:00:49','2024-03-15 03:00:49'),(52,'Botble\\Ecommerce\\Models\\Order',52,'INV-52','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,5784.00,0.00,0.00,0.00,'1','default',NULL,NULL,5784.00,NULL,52,'completed','2024-03-15 03:00:49','2024-03-14 03:00:49','2024-03-15 03:00:49'),(53,'Botble\\Ecommerce\\Models\\Order',53,'INV-53','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,2832.00,0.00,0.00,0.00,'1','default',NULL,NULL,2832.00,NULL,53,'pending',NULL,'2024-03-14 17:00:50','2024-03-15 03:00:50'),(54,'Botble\\Ecommerce\\Models\\Order',54,'INV-54','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,2679.00,0.00,0.00,0.00,NULL,'',NULL,NULL,2679.00,NULL,54,'pending',NULL,'2024-03-14 11:00:50','2024-03-15 03:00:50'),(55,'Botble\\Ecommerce\\Models\\Order',55,'INV-55','Daphney Toy','',NULL,'jakubowski.claudia@example.com','+15403405479','61753 Leo Locks, Lake Cleveland, Oklahoma, FJ',NULL,1788.00,0.00,0.00,0.00,'1','default',NULL,NULL,1788.00,NULL,55,'completed','2024-03-15 03:00:50','2024-03-14 09:00:50','2024-03-15 03:00:50');
/*!40000 ALTER TABLE `ec_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value`
--

DROP TABLE IF EXISTS `ec_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value`
--

LOCK TABLES `ec_option_value` WRITE;
/*!40000 ALTER TABLE `ec_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value_translations`
--

DROP TABLE IF EXISTS `ec_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value_translations`
--

LOCK TABLES `ec_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options`
--

DROP TABLE IF EXISTS `ec_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'option type',
  `product_id` bigint unsigned NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '9999',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options`
--

LOCK TABLES `ec_options` WRITE;
/*!40000 ALTER TABLE `ec_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options_translations`
--

DROP TABLE IF EXISTS `ec_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_options_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options_translations`
--

LOCK TABLES `ec_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_addresses`
--

DROP TABLE IF EXISTS `ec_order_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'shipping_address',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_addresses`
--

LOCK TABLES `ec_order_addresses` WRITE;
/*!40000 ALTER TABLE `ec_order_addresses` DISABLE KEYS */;
INSERT INTO `ec_order_addresses` VALUES (1,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',1,'13232-5768','shipping_address'),(2,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',2,'13232-5768','shipping_address'),(3,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',3,'13232-5768','shipping_address'),(4,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',4,'13232-5768','shipping_address'),(5,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',5,'50549-0012','shipping_address'),(6,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',6,'50549-0012','shipping_address'),(7,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',7,'50549-0012','shipping_address'),(8,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',8,'13232-5768','shipping_address'),(9,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',9,'13232-5768','shipping_address'),(10,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',10,'13232-5768','shipping_address'),(11,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',11,'13232-5768','shipping_address'),(12,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',12,'13232-5768','shipping_address'),(13,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',13,'13232-5768','shipping_address'),(14,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',14,'13232-5768','shipping_address'),(15,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',15,'13232-5768','shipping_address'),(16,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',16,'50549-0012','shipping_address'),(17,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',17,'50549-0012','shipping_address'),(18,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',18,'50549-0012','shipping_address'),(19,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',19,'50549-0012','shipping_address'),(20,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',20,'13232-5768','shipping_address'),(21,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',21,'13232-5768','shipping_address'),(22,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',22,'13232-5768','shipping_address'),(23,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',23,'13232-5768','shipping_address'),(24,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',24,'13232-5768','shipping_address'),(25,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',25,'13232-5768','shipping_address'),(26,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',26,'13232-5768','shipping_address'),(27,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',27,'50549-0012','shipping_address'),(28,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',28,'50549-0012','shipping_address'),(29,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',29,'50549-0012','shipping_address'),(30,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',30,'50549-0012','shipping_address'),(31,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',31,'50549-0012','shipping_address'),(32,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',32,'50549-0012','shipping_address'),(33,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',33,'13232-5768','shipping_address'),(34,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',34,'13232-5768','shipping_address'),(35,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',35,'13232-5768','shipping_address'),(36,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',36,'13232-5768','shipping_address'),(37,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',37,'13232-5768','shipping_address'),(38,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',38,'13232-5768','shipping_address'),(39,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',39,'50549-0012','shipping_address'),(40,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',40,'50549-0012','shipping_address'),(41,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',41,'50549-0012','shipping_address'),(42,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',42,'50549-0012','shipping_address'),(43,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',43,'50549-0012','shipping_address'),(44,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',44,'50549-0012','shipping_address'),(45,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',45,'13232-5768','shipping_address'),(46,'Prof. Tyreek Cremin','+15054882884','bhalvorson@example.com','NP','North Carolina','North Eldred','105 Koss Crossroad Suite 051',46,'13232-5768','shipping_address'),(47,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',47,'50549-0012','shipping_address'),(48,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',48,'50549-0012','shipping_address'),(49,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',49,'50549-0012','shipping_address'),(50,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',50,'50549-0012','shipping_address'),(51,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',51,'50549-0012','shipping_address'),(52,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',52,'50549-0012','shipping_address'),(53,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',53,'50549-0012','shipping_address'),(54,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',54,'50549-0012','shipping_address'),(55,'Daphney Toy','+15403405479','jakubowski.claudia@example.com','FJ','Oklahoma','Lake Cleveland','61753 Leo Locks',55,'50549-0012','shipping_address');
/*!40000 ALTER TABLE `ec_order_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_histories`
--

DROP TABLE IF EXISTS `ec_order_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `extras` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=242 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_histories`
--

LOCK TABLES `ec_order_histories` WRITE;
/*!40000 ALTER TABLE `ec_order_histories` DISABLE KEYS */;
INSERT INTO `ec_order_histories` VALUES (1,'create_order_from_seeder','Order is created from the checkout page',NULL,1,NULL,'2024-03-10 03:00:34','2024-03-10 03:00:34'),(2,'confirm_order','Order was verified by %user_name%',0,1,NULL,'2024-03-10 03:00:34','2024-03-10 03:00:34'),(3,'create_order_from_seeder','Order is created from the checkout page',NULL,2,NULL,'2024-03-01 19:00:35','2024-03-01 19:00:35'),(4,'confirm_order','Order was verified by %user_name%',0,2,NULL,'2024-03-01 19:00:35','2024-03-01 19:00:35'),(5,'create_shipment','Created shipment for order',0,2,NULL,'2024-03-15 03:00:35','2024-03-15 03:00:35'),(6,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,2,NULL,'2024-03-15 03:00:35','2024-03-15 03:00:35'),(7,'create_order_from_seeder','Order is created from the checkout page',NULL,3,NULL,'2024-03-10 03:00:35','2024-03-10 03:00:35'),(8,'confirm_order','Order was verified by %user_name%',0,3,NULL,'2024-03-10 03:00:35','2024-03-10 03:00:35'),(9,'confirm_payment','Payment was confirmed (amount $3,261.00) by %user_name%',0,3,NULL,'2024-03-15 03:00:35','2024-03-15 03:00:35'),(10,'create_shipment','Created shipment for order',0,3,NULL,'2024-03-15 03:00:35','2024-03-15 03:00:35'),(11,'create_order_from_seeder','Order is created from the checkout page',NULL,4,NULL,'2024-03-05 03:00:35','2024-03-05 03:00:35'),(12,'confirm_order','Order was verified by %user_name%',0,4,NULL,'2024-03-05 03:00:35','2024-03-05 03:00:35'),(13,'confirm_payment','Payment was confirmed (amount $3,264.00) by %user_name%',0,4,NULL,'2024-03-15 03:00:35','2024-03-15 03:00:35'),(14,'create_shipment','Created shipment for order',0,4,NULL,'2024-03-15 03:00:36','2024-03-15 03:00:36'),(15,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,4,NULL,'2024-03-15 03:00:36','2024-03-15 03:00:36'),(16,'create_order_from_seeder','Order is created from the checkout page',NULL,5,NULL,'2024-03-02 11:00:36','2024-03-02 11:00:36'),(17,'confirm_order','Order was verified by %user_name%',0,5,NULL,'2024-03-02 11:00:36','2024-03-02 11:00:36'),(18,'confirm_payment','Payment was confirmed (amount $3,648.00) by %user_name%',0,5,NULL,'2024-03-15 03:00:36','2024-03-15 03:00:36'),(19,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,5,NULL,'2024-03-15 03:00:36','2024-03-15 03:00:36'),(20,'create_order_from_seeder','Order is created from the checkout page',NULL,6,NULL,'2024-03-11 23:00:36','2024-03-11 23:00:36'),(21,'confirm_order','Order was verified by %user_name%',0,6,NULL,'2024-03-11 23:00:36','2024-03-11 23:00:36'),(22,'confirm_payment','Payment was confirmed (amount $4,827.00) by %user_name%',0,6,NULL,'2024-03-15 03:00:36','2024-03-15 03:00:36'),(23,'create_shipment','Created shipment for order',0,6,NULL,'2024-03-15 03:00:36','2024-03-15 03:00:36'),(24,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,6,NULL,'2024-03-15 03:00:36','2024-03-15 03:00:36'),(25,'create_order_from_seeder','Order is created from the checkout page',NULL,7,NULL,'2024-03-05 15:00:36','2024-03-05 15:00:36'),(26,'confirm_order','Order was verified by %user_name%',0,7,NULL,'2024-03-05 15:00:36','2024-03-05 15:00:36'),(27,'confirm_payment','Payment was confirmed (amount $2,766.00) by %user_name%',0,7,NULL,'2024-03-15 03:00:36','2024-03-15 03:00:36'),(28,'create_shipment','Created shipment for order',0,7,NULL,'2024-03-15 03:00:37','2024-03-15 03:00:37'),(29,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,7,NULL,'2024-03-15 03:00:37','2024-03-15 03:00:37'),(30,'create_order_from_seeder','Order is created from the checkout page',NULL,8,NULL,'2024-03-03 03:00:37','2024-03-03 03:00:37'),(31,'confirm_order','Order was verified by %user_name%',0,8,NULL,'2024-03-03 03:00:37','2024-03-03 03:00:37'),(32,'confirm_payment','Payment was confirmed (amount $4,159.00) by %user_name%',0,8,NULL,'2024-03-15 03:00:37','2024-03-15 03:00:37'),(33,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,8,NULL,'2024-03-15 03:00:37','2024-03-15 03:00:37'),(34,'create_order_from_seeder','Order is created from the checkout page',NULL,9,NULL,'2024-03-13 15:00:37','2024-03-13 15:00:37'),(35,'confirm_order','Order was verified by %user_name%',0,9,NULL,'2024-03-13 15:00:37','2024-03-13 15:00:37'),(36,'create_order_from_seeder','Order is created from the checkout page',NULL,10,NULL,'2024-03-10 21:00:37','2024-03-10 21:00:37'),(37,'confirm_order','Order was verified by %user_name%',0,10,NULL,'2024-03-10 21:00:37','2024-03-10 21:00:37'),(38,'confirm_payment','Payment was confirmed (amount $12,217.00) by %user_name%',0,10,NULL,'2024-03-15 03:00:37','2024-03-15 03:00:37'),(39,'create_shipment','Created shipment for order',0,10,NULL,'2024-03-15 03:00:38','2024-03-15 03:00:38'),(40,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,10,NULL,'2024-03-15 03:00:38','2024-03-15 03:00:38'),(41,'create_order_from_seeder','Order is created from the checkout page',NULL,11,NULL,'2024-03-10 21:00:38','2024-03-10 21:00:38'),(42,'confirm_order','Order was verified by %user_name%',0,11,NULL,'2024-03-10 21:00:38','2024-03-10 21:00:38'),(43,'confirm_payment','Payment was confirmed (amount $2,202.00) by %user_name%',0,11,NULL,'2024-03-15 03:00:38','2024-03-15 03:00:38'),(44,'create_shipment','Created shipment for order',0,11,NULL,'2024-03-15 03:00:38','2024-03-15 03:00:38'),(45,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,11,NULL,'2024-03-15 03:00:38','2024-03-15 03:00:38'),(46,'create_order_from_seeder','Order is created from the checkout page',NULL,12,NULL,'2024-03-07 03:00:38','2024-03-07 03:00:38'),(47,'confirm_order','Order was verified by %user_name%',0,12,NULL,'2024-03-07 03:00:38','2024-03-07 03:00:38'),(48,'confirm_payment','Payment was confirmed (amount $2,358.00) by %user_name%',0,12,NULL,'2024-03-15 03:00:38','2024-03-15 03:00:38'),(49,'create_shipment','Created shipment for order',0,12,NULL,'2024-03-15 03:00:38','2024-03-15 03:00:38'),(50,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,12,NULL,'2024-03-15 03:00:38','2024-03-15 03:00:38'),(51,'create_order_from_seeder','Order is created from the checkout page',NULL,13,NULL,'2024-03-12 11:00:38','2024-03-12 11:00:38'),(52,'confirm_order','Order was verified by %user_name%',0,13,NULL,'2024-03-12 11:00:38','2024-03-12 11:00:38'),(53,'confirm_payment','Payment was confirmed (amount $1,087.00) by %user_name%',0,13,NULL,'2024-03-15 03:00:38','2024-03-15 03:00:38'),(54,'create_shipment','Created shipment for order',0,13,NULL,'2024-03-15 03:00:39','2024-03-15 03:00:39'),(55,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,13,NULL,'2024-03-15 03:00:39','2024-03-15 03:00:39'),(56,'create_order_from_seeder','Order is created from the checkout page',NULL,14,NULL,'2024-03-13 19:00:39','2024-03-13 19:00:39'),(57,'confirm_order','Order was verified by %user_name%',0,14,NULL,'2024-03-13 19:00:39','2024-03-13 19:00:39'),(58,'confirm_payment','Payment was confirmed (amount $3,944.00) by %user_name%',0,14,NULL,'2024-03-15 03:00:39','2024-03-15 03:00:39'),(59,'create_shipment','Created shipment for order',0,14,NULL,'2024-03-15 03:00:39','2024-03-15 03:00:39'),(60,'create_order_from_seeder','Order is created from the checkout page',NULL,15,NULL,'2024-03-12 11:00:39','2024-03-12 11:00:39'),(61,'confirm_order','Order was verified by %user_name%',0,15,NULL,'2024-03-12 11:00:39','2024-03-12 11:00:39'),(62,'confirm_payment','Payment was confirmed (amount $2,496.00) by %user_name%',0,15,NULL,'2024-03-15 03:00:39','2024-03-15 03:00:39'),(63,'create_shipment','Created shipment for order',0,15,NULL,'2024-03-15 03:00:39','2024-03-15 03:00:39'),(64,'create_order_from_seeder','Order is created from the checkout page',NULL,16,NULL,'2024-03-03 21:00:39','2024-03-03 21:00:39'),(65,'confirm_order','Order was verified by %user_name%',0,16,NULL,'2024-03-03 21:00:39','2024-03-03 21:00:39'),(66,'confirm_payment','Payment was confirmed (amount $2,049.00) by %user_name%',0,16,NULL,'2024-03-15 03:00:39','2024-03-15 03:00:39'),(67,'create_shipment','Created shipment for order',0,16,NULL,'2024-03-15 03:00:40','2024-03-15 03:00:40'),(68,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,16,NULL,'2024-03-15 03:00:40','2024-03-15 03:00:40'),(69,'create_order_from_seeder','Order is created from the checkout page',NULL,17,NULL,'2024-03-03 21:00:40','2024-03-03 21:00:40'),(70,'confirm_order','Order was verified by %user_name%',0,17,NULL,'2024-03-03 21:00:40','2024-03-03 21:00:40'),(71,'confirm_payment','Payment was confirmed (amount $2,040.00) by %user_name%',0,17,NULL,'2024-03-15 03:00:40','2024-03-15 03:00:40'),(72,'create_shipment','Created shipment for order',0,17,NULL,'2024-03-15 03:00:40','2024-03-15 03:00:40'),(73,'create_order_from_seeder','Order is created from the checkout page',NULL,18,NULL,'2024-03-13 21:00:40','2024-03-13 21:00:40'),(74,'confirm_order','Order was verified by %user_name%',0,18,NULL,'2024-03-13 21:00:40','2024-03-13 21:00:40'),(75,'create_shipment','Created shipment for order',0,18,NULL,'2024-03-15 03:00:40','2024-03-15 03:00:40'),(76,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,NULL,'2024-03-15 03:00:40','2024-03-15 03:00:40'),(77,'create_order_from_seeder','Order is created from the checkout page',NULL,19,NULL,'2024-03-11 09:00:40','2024-03-11 09:00:40'),(78,'confirm_order','Order was verified by %user_name%',0,19,NULL,'2024-03-11 09:00:40','2024-03-11 09:00:40'),(79,'confirm_payment','Payment was confirmed (amount $2,176.00) by %user_name%',0,19,NULL,'2024-03-15 03:00:40','2024-03-15 03:00:40'),(80,'create_shipment','Created shipment for order',0,19,NULL,'2024-03-15 03:00:41','2024-03-15 03:00:41'),(81,'create_order_from_seeder','Order is created from the checkout page',NULL,20,NULL,'2024-03-04 15:00:41','2024-03-04 15:00:41'),(82,'confirm_order','Order was verified by %user_name%',0,20,NULL,'2024-03-04 15:00:41','2024-03-04 15:00:41'),(83,'create_shipment','Created shipment for order',0,20,NULL,'2024-03-15 03:00:41','2024-03-15 03:00:41'),(84,'create_order_from_seeder','Order is created from the checkout page',NULL,21,NULL,'2024-03-09 07:00:41','2024-03-09 07:00:41'),(85,'confirm_order','Order was verified by %user_name%',0,21,NULL,'2024-03-09 07:00:41','2024-03-09 07:00:41'),(86,'confirm_payment','Payment was confirmed (amount $2,202.00) by %user_name%',0,21,NULL,'2024-03-15 03:00:41','2024-03-15 03:00:41'),(87,'create_shipment','Created shipment for order',0,21,NULL,'2024-03-15 03:00:41','2024-03-15 03:00:41'),(88,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,21,NULL,'2024-03-15 03:00:41','2024-03-15 03:00:41'),(89,'create_order_from_seeder','Order is created from the checkout page',NULL,22,NULL,'2024-03-09 17:00:41','2024-03-09 17:00:41'),(90,'confirm_order','Order was verified by %user_name%',0,22,NULL,'2024-03-09 17:00:41','2024-03-09 17:00:41'),(91,'confirm_payment','Payment was confirmed (amount $640.00) by %user_name%',0,22,NULL,'2024-03-15 03:00:41','2024-03-15 03:00:41'),(92,'create_shipment','Created shipment for order',0,22,NULL,'2024-03-15 03:00:42','2024-03-15 03:00:42'),(93,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,22,NULL,'2024-03-15 03:00:42','2024-03-15 03:00:42'),(94,'create_order_from_seeder','Order is created from the checkout page',NULL,23,NULL,'2024-03-14 01:00:42','2024-03-14 01:00:42'),(95,'confirm_order','Order was verified by %user_name%',0,23,NULL,'2024-03-14 01:00:42','2024-03-14 01:00:42'),(96,'create_shipment','Created shipment for order',0,23,NULL,'2024-03-15 03:00:42','2024-03-15 03:00:42'),(97,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,23,NULL,'2024-03-15 03:00:42','2024-03-15 03:00:42'),(98,'create_order_from_seeder','Order is created from the checkout page',NULL,24,NULL,'2024-03-05 03:00:42','2024-03-05 03:00:42'),(99,'confirm_order','Order was verified by %user_name%',0,24,NULL,'2024-03-05 03:00:42','2024-03-05 03:00:42'),(100,'confirm_payment','Payment was confirmed (amount $2,679.00) by %user_name%',0,24,NULL,'2024-03-15 03:00:42','2024-03-15 03:00:42'),(101,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,24,NULL,'2024-03-15 03:00:42','2024-03-15 03:00:42'),(102,'create_order_from_seeder','Order is created from the checkout page',NULL,25,NULL,'2024-03-10 03:00:42','2024-03-10 03:00:42'),(103,'confirm_order','Order was verified by %user_name%',0,25,NULL,'2024-03-10 03:00:42','2024-03-10 03:00:42'),(104,'confirm_payment','Payment was confirmed (amount $7,068.00) by %user_name%',0,25,NULL,'2024-03-15 03:00:42','2024-03-15 03:00:42'),(105,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,25,NULL,'2024-03-15 03:00:43','2024-03-15 03:00:43'),(106,'create_order_from_seeder','Order is created from the checkout page',NULL,26,NULL,'2024-03-12 03:00:43','2024-03-12 03:00:43'),(107,'confirm_order','Order was verified by %user_name%',0,26,NULL,'2024-03-12 03:00:43','2024-03-12 03:00:43'),(108,'confirm_payment','Payment was confirmed (amount $906.00) by %user_name%',0,26,NULL,'2024-03-15 03:00:43','2024-03-15 03:00:43'),(109,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,26,NULL,'2024-03-15 03:00:43','2024-03-15 03:00:43'),(110,'create_order_from_seeder','Order is created from the checkout page',NULL,27,NULL,'2024-03-11 11:00:43','2024-03-11 11:00:43'),(111,'confirm_order','Order was verified by %user_name%',0,27,NULL,'2024-03-11 11:00:43','2024-03-11 11:00:43'),(112,'confirm_payment','Payment was confirmed (amount $3,895.00) by %user_name%',0,27,NULL,'2024-03-15 03:00:43','2024-03-15 03:00:43'),(113,'create_shipment','Created shipment for order',0,27,NULL,'2024-03-15 03:00:43','2024-03-15 03:00:43'),(114,'create_order_from_seeder','Order is created from the checkout page',NULL,28,NULL,'2024-03-12 09:00:43','2024-03-12 09:00:43'),(115,'confirm_order','Order was verified by %user_name%',0,28,NULL,'2024-03-12 09:00:43','2024-03-12 09:00:43'),(116,'create_shipment','Created shipment for order',0,28,NULL,'2024-03-15 03:00:44','2024-03-15 03:00:44'),(117,'create_order_from_seeder','Order is created from the checkout page',NULL,29,NULL,'2024-03-10 23:00:44','2024-03-10 23:00:44'),(118,'confirm_order','Order was verified by %user_name%',0,29,NULL,'2024-03-10 23:00:44','2024-03-10 23:00:44'),(119,'confirm_payment','Payment was confirmed (amount $6,363.00) by %user_name%',0,29,NULL,'2024-03-15 03:00:44','2024-03-15 03:00:44'),(120,'create_shipment','Created shipment for order',0,29,NULL,'2024-03-15 03:00:44','2024-03-15 03:00:44'),(121,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,29,NULL,'2024-03-15 03:00:44','2024-03-15 03:00:44'),(122,'create_order_from_seeder','Order is created from the checkout page',NULL,30,NULL,'2024-03-10 23:00:44','2024-03-10 23:00:44'),(123,'confirm_order','Order was verified by %user_name%',0,30,NULL,'2024-03-10 23:00:44','2024-03-10 23:00:44'),(124,'create_shipment','Created shipment for order',0,30,NULL,'2024-03-15 03:00:44','2024-03-15 03:00:44'),(125,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,30,NULL,'2024-03-15 03:00:44','2024-03-15 03:00:44'),(126,'create_order_from_seeder','Order is created from the checkout page',NULL,31,NULL,'2024-03-09 07:00:44','2024-03-09 07:00:44'),(127,'confirm_order','Order was verified by %user_name%',0,31,NULL,'2024-03-09 07:00:44','2024-03-09 07:00:44'),(128,'confirm_payment','Payment was confirmed (amount $1,788.00) by %user_name%',0,31,NULL,'2024-03-15 03:00:44','2024-03-15 03:00:44'),(129,'create_shipment','Created shipment for order',0,31,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45'),(130,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,31,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45'),(131,'create_order_from_seeder','Order is created from the checkout page',NULL,32,NULL,'2024-03-06 19:00:45','2024-03-06 19:00:45'),(132,'confirm_order','Order was verified by %user_name%',0,32,NULL,'2024-03-06 19:00:45','2024-03-06 19:00:45'),(133,'confirm_payment','Payment was confirmed (amount $878.00) by %user_name%',0,32,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45'),(134,'create_shipment','Created shipment for order',0,32,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45'),(135,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,32,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45'),(136,'create_order_from_seeder','Order is created from the checkout page',NULL,33,NULL,'2024-03-14 09:00:45','2024-03-14 09:00:45'),(137,'confirm_order','Order was verified by %user_name%',0,33,NULL,'2024-03-14 09:00:45','2024-03-14 09:00:45'),(138,'confirm_payment','Payment was confirmed (amount $1,032.00) by %user_name%',0,33,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45'),(139,'create_shipment','Created shipment for order',0,33,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45'),(140,'create_order_from_seeder','Order is created from the checkout page',NULL,34,NULL,'2024-03-10 15:00:45','2024-03-10 15:00:45'),(141,'confirm_order','Order was verified by %user_name%',0,34,NULL,'2024-03-10 15:00:45','2024-03-10 15:00:45'),(142,'confirm_payment','Payment was confirmed (amount $6,816.00) by %user_name%',0,34,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45'),(143,'create_shipment','Created shipment for order',0,34,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45'),(144,'create_order_from_seeder','Order is created from the checkout page',NULL,35,NULL,'2024-03-12 21:00:45','2024-03-12 21:00:45'),(145,'confirm_order','Order was verified by %user_name%',0,35,NULL,'2024-03-12 21:00:45','2024-03-12 21:00:45'),(146,'confirm_payment','Payment was confirmed (amount $878.00) by %user_name%',0,35,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45'),(147,'create_shipment','Created shipment for order',0,35,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45'),(148,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,35,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45'),(149,'create_order_from_seeder','Order is created from the checkout page',NULL,36,NULL,'2024-03-11 19:00:45','2024-03-11 19:00:45'),(150,'confirm_order','Order was verified by %user_name%',0,36,NULL,'2024-03-11 19:00:45','2024-03-11 19:00:45'),(151,'create_shipment','Created shipment for order',0,36,NULL,'2024-03-15 03:00:46','2024-03-15 03:00:46'),(152,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,36,NULL,'2024-03-15 03:00:46','2024-03-15 03:00:46'),(153,'create_order_from_seeder','Order is created from the checkout page',NULL,37,NULL,'2024-03-10 11:00:46','2024-03-10 11:00:46'),(154,'confirm_order','Order was verified by %user_name%',0,37,NULL,'2024-03-10 11:00:46','2024-03-10 11:00:46'),(155,'confirm_payment','Payment was confirmed (amount $3,213.00) by %user_name%',0,37,NULL,'2024-03-15 03:00:46','2024-03-15 03:00:46'),(156,'create_shipment','Created shipment for order',0,37,NULL,'2024-03-15 03:00:46','2024-03-15 03:00:46'),(157,'create_order_from_seeder','Order is created from the checkout page',NULL,38,NULL,'2024-03-11 03:00:46','2024-03-11 03:00:46'),(158,'confirm_order','Order was verified by %user_name%',0,38,NULL,'2024-03-11 03:00:46','2024-03-11 03:00:46'),(159,'create_order_from_seeder','Order is created from the checkout page',NULL,39,NULL,'2024-03-11 01:00:46','2024-03-11 01:00:46'),(160,'confirm_order','Order was verified by %user_name%',0,39,NULL,'2024-03-11 01:00:46','2024-03-11 01:00:46'),(161,'confirm_payment','Payment was confirmed (amount $4,265.00) by %user_name%',0,39,NULL,'2024-03-15 03:00:46','2024-03-15 03:00:46'),(162,'create_shipment','Created shipment for order',0,39,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47'),(163,'create_order_from_seeder','Order is created from the checkout page',NULL,40,NULL,'2024-03-13 03:00:47','2024-03-13 03:00:47'),(164,'confirm_order','Order was verified by %user_name%',0,40,NULL,'2024-03-13 03:00:47','2024-03-13 03:00:47'),(165,'confirm_payment','Payment was confirmed (amount $4,040.00) by %user_name%',0,40,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47'),(166,'create_shipment','Created shipment for order',0,40,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47'),(167,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,40,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47'),(168,'create_order_from_seeder','Order is created from the checkout page',NULL,41,NULL,'2024-03-14 17:00:47','2024-03-14 17:00:47'),(169,'confirm_order','Order was verified by %user_name%',0,41,NULL,'2024-03-14 17:00:47','2024-03-14 17:00:47'),(170,'create_shipment','Created shipment for order',0,41,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47'),(171,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,41,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47'),(172,'create_order_from_seeder','Order is created from the checkout page',NULL,42,NULL,'2024-03-12 15:00:47','2024-03-12 15:00:47'),(173,'confirm_order','Order was verified by %user_name%',0,42,NULL,'2024-03-12 15:00:47','2024-03-12 15:00:47'),(174,'create_order_from_seeder','Order is created from the checkout page',NULL,43,NULL,'2024-03-12 15:00:47','2024-03-12 15:00:47'),(175,'confirm_order','Order was verified by %user_name%',0,43,NULL,'2024-03-12 15:00:47','2024-03-12 15:00:47'),(176,'confirm_payment','Payment was confirmed (amount $2,202.00) by %user_name%',0,43,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47'),(177,'create_shipment','Created shipment for order',0,43,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47'),(178,'create_order_from_seeder','Order is created from the checkout page',NULL,44,NULL,'2024-03-13 21:00:47','2024-03-13 21:00:47'),(179,'confirm_order','Order was verified by %user_name%',0,44,NULL,'2024-03-13 21:00:47','2024-03-13 21:00:47'),(180,'confirm_payment','Payment was confirmed (amount $2,040.00) by %user_name%',0,44,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47'),(181,'create_shipment','Created shipment for order',0,44,NULL,'2024-03-15 03:00:48','2024-03-15 03:00:48'),(182,'create_order_from_seeder','Order is created from the checkout page',NULL,45,NULL,'2024-03-14 11:00:48','2024-03-14 11:00:48'),(183,'confirm_order','Order was verified by %user_name%',0,45,NULL,'2024-03-14 11:00:48','2024-03-14 11:00:48'),(184,'create_shipment','Created shipment for order',0,45,NULL,'2024-03-15 03:00:48','2024-03-15 03:00:48'),(185,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,45,NULL,'2024-03-15 03:00:48','2024-03-15 03:00:48'),(186,'create_order_from_seeder','Order is created from the checkout page',NULL,46,NULL,'2024-03-12 19:00:48','2024-03-12 19:00:48'),(187,'confirm_order','Order was verified by %user_name%',0,46,NULL,'2024-03-12 19:00:48','2024-03-12 19:00:48'),(188,'create_shipment','Created shipment for order',0,46,NULL,'2024-03-15 03:00:48','2024-03-15 03:00:48'),(189,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,46,NULL,'2024-03-15 03:00:48','2024-03-15 03:00:48'),(190,'create_order_from_seeder','Order is created from the checkout page',NULL,47,NULL,'2024-03-14 21:00:48','2024-03-14 21:00:48'),(191,'confirm_order','Order was verified by %user_name%',0,47,NULL,'2024-03-14 21:00:48','2024-03-14 21:00:48'),(192,'confirm_payment','Payment was confirmed (amount $7,080.00) by %user_name%',0,47,NULL,'2024-03-15 03:00:48','2024-03-15 03:00:48'),(193,'create_shipment','Created shipment for order',0,47,NULL,'2024-03-15 03:00:48','2024-03-15 03:00:48'),(194,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,47,NULL,'2024-03-15 03:00:48','2024-03-15 03:00:48'),(195,'create_order_from_seeder','Order is created from the checkout page',NULL,48,NULL,'2024-03-14 21:00:48','2024-03-14 21:00:48'),(196,'confirm_order','Order was verified by %user_name%',0,48,NULL,'2024-03-14 21:00:48','2024-03-14 21:00:48'),(197,'confirm_payment','Payment was confirmed (amount $4,362.00) by %user_name%',0,48,NULL,'2024-03-15 03:00:48','2024-03-15 03:00:48'),(198,'create_shipment','Created shipment for order',0,48,NULL,'2024-03-15 03:00:49','2024-03-15 03:00:49'),(199,'create_order_from_seeder','Order is created from the checkout page',NULL,49,NULL,'2024-03-14 15:00:49','2024-03-14 15:00:49'),(200,'confirm_order','Order was verified by %user_name%',0,49,NULL,'2024-03-14 15:00:49','2024-03-14 15:00:49'),(201,'create_shipment','Created shipment for order',0,49,NULL,'2024-03-15 03:00:49','2024-03-15 03:00:49'),(202,'create_order_from_seeder','Order is created from the checkout page',NULL,50,NULL,'2024-03-14 07:00:49','2024-03-14 07:00:49'),(203,'confirm_order','Order was verified by %user_name%',0,50,NULL,'2024-03-14 07:00:49','2024-03-14 07:00:49'),(204,'confirm_payment','Payment was confirmed (amount $798.00) by %user_name%',0,50,NULL,'2024-03-15 03:00:49','2024-03-15 03:00:49'),(205,'create_shipment','Created shipment for order',0,50,NULL,'2024-03-15 03:00:49','2024-03-15 03:00:49'),(206,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,50,NULL,'2024-03-15 03:00:49','2024-03-15 03:00:49'),(207,'create_order_from_seeder','Order is created from the checkout page',NULL,51,NULL,'2024-03-13 19:00:49','2024-03-13 19:00:49'),(208,'confirm_order','Order was verified by %user_name%',0,51,NULL,'2024-03-13 19:00:49','2024-03-13 19:00:49'),(209,'confirm_payment','Payment was confirmed (amount $1,088.00) by %user_name%',0,51,NULL,'2024-03-15 03:00:49','2024-03-15 03:00:49'),(210,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,51,NULL,'2024-03-15 03:00:49','2024-03-15 03:00:49'),(211,'create_order_from_seeder','Order is created from the checkout page',NULL,52,NULL,'2024-03-14 03:00:49','2024-03-14 03:00:49'),(212,'confirm_order','Order was verified by %user_name%',0,52,NULL,'2024-03-14 03:00:49','2024-03-14 03:00:49'),(213,'confirm_payment','Payment was confirmed (amount $5,784.00) by %user_name%',0,52,NULL,'2024-03-15 03:00:49','2024-03-15 03:00:49'),(214,'create_shipment','Created shipment for order',0,52,NULL,'2024-03-15 03:00:50','2024-03-15 03:00:50'),(215,'create_order_from_seeder','Order is created from the checkout page',NULL,53,NULL,'2024-03-14 17:00:50','2024-03-14 17:00:50'),(216,'confirm_order','Order was verified by %user_name%',0,53,NULL,'2024-03-14 17:00:50','2024-03-14 17:00:50'),(217,'create_shipment','Created shipment for order',0,53,NULL,'2024-03-15 03:00:50','2024-03-15 03:00:50'),(218,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,53,NULL,'2024-03-15 03:00:50','2024-03-15 03:00:50'),(219,'create_order_from_seeder','Order is created from the checkout page',NULL,54,NULL,'2024-03-14 11:00:50','2024-03-14 11:00:50'),(220,'confirm_order','Order was verified by %user_name%',0,54,NULL,'2024-03-14 11:00:50','2024-03-14 11:00:50'),(221,'create_order_from_seeder','Order is created from the checkout page',NULL,55,NULL,'2024-03-14 09:00:50','2024-03-14 09:00:50'),(222,'confirm_order','Order was verified by %user_name%',0,55,NULL,'2024-03-14 09:00:50','2024-03-14 09:00:50'),(223,'confirm_payment','Payment was confirmed (amount $1,788.00) by %user_name%',0,55,NULL,'2024-03-15 03:00:50','2024-03-15 03:00:50'),(224,'create_shipment','Created shipment for order',0,55,NULL,'2024-03-15 03:00:50','2024-03-15 03:00:50'),(225,'update_status','Order confirmed by %user_name%',0,4,NULL,'2024-03-15 03:00:50','2024-03-15 03:00:50'),(226,'update_status','Order confirmed by %user_name%',0,6,NULL,'2024-03-15 03:00:51','2024-03-15 03:00:51'),(227,'update_status','Order confirmed by %user_name%',0,7,NULL,'2024-03-15 03:00:51','2024-03-15 03:00:51'),(228,'update_status','Order confirmed by %user_name%',0,10,NULL,'2024-03-15 03:00:52','2024-03-15 03:00:52'),(229,'update_status','Order confirmed by %user_name%',0,11,NULL,'2024-03-15 03:00:53','2024-03-15 03:00:53'),(230,'update_status','Order confirmed by %user_name%',0,12,NULL,'2024-03-15 03:00:53','2024-03-15 03:00:53'),(231,'update_status','Order confirmed by %user_name%',0,13,NULL,'2024-03-15 03:00:54','2024-03-15 03:00:54'),(232,'update_status','Order confirmed by %user_name%',0,16,NULL,'2024-03-15 03:00:55','2024-03-15 03:00:55'),(233,'update_status','Order confirmed by %user_name%',0,21,NULL,'2024-03-15 03:00:56','2024-03-15 03:00:56'),(234,'update_status','Order confirmed by %user_name%',0,22,NULL,'2024-03-15 03:00:56','2024-03-15 03:00:56'),(235,'update_status','Order confirmed by %user_name%',0,29,NULL,'2024-03-15 03:00:57','2024-03-15 03:00:57'),(236,'update_status','Order confirmed by %user_name%',0,31,NULL,'2024-03-15 03:00:58','2024-03-15 03:00:58'),(237,'update_status','Order confirmed by %user_name%',0,32,NULL,'2024-03-15 03:00:58','2024-03-15 03:00:58'),(238,'update_status','Order confirmed by %user_name%',0,35,NULL,'2024-03-15 03:00:59','2024-03-15 03:00:59'),(239,'update_status','Order confirmed by %user_name%',0,40,NULL,'2024-03-15 03:01:00','2024-03-15 03:01:00'),(240,'update_status','Order confirmed by %user_name%',0,47,NULL,'2024-03-15 03:01:01','2024-03-15 03:01:01'),(241,'update_status','Order confirmed by %user_name%',0,50,NULL,'2024-03-15 03:01:01','2024-03-15 03:01:01');
/*!40000 ALTER TABLE `ec_order_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_product`
--

DROP TABLE IF EXISTS `ec_order_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_product` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `qty` int NOT NULL,
  `price` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `product_options` text COLLATE utf8mb4_unicode_ci COMMENT 'product option data',
  `product_id` bigint unsigned DEFAULT NULL,
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `restock_quantity` int unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'physical',
  `times_downloaded` int NOT NULL DEFAULT '0',
  `license_code` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_product`
--

LOCK TABLES `ec_order_product` WRITE;
/*!40000 ALTER TABLE `ec_order_product` DISABLE KEYS */;
INSERT INTO `ec_order_product` VALUES (1,1,3,2424.00,0.00,'{\"sku\":\"ZQ-172-A0-A1\",\"attributes\":\"(Color: Green, Size: XL)\"}',NULL,87,'Samsung QN90A Neo QLED 4K Smart TV (Digital)','main/products/product-10.jpg',2547.00,0,'2024-03-15 03:00:34','2024-03-15 03:00:34','digital',10,NULL),(2,2,1,2272.00,0.00,'{\"sku\":\"K7-170-A0-A3\",\"attributes\":\"(Color: Brown, Size: XXL)\"}',NULL,114,'Razer Blade 15 Advanced Gaming Laptop','main/products/product-5.jpg',559.00,0,'2024-03-15 03:00:35','2024-03-15 03:00:35','physical',0,NULL),(3,3,3,1087.00,0.00,'{\"sku\":\"FH-109-A0-A3\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}',NULL,176,'TCL 6-Series 4K UHD Dolby Vision HDR QLED Roku Smart TV','main/products/product-6.jpg',1593.00,0,'2024-03-15 03:00:35','2024-03-15 03:00:35','physical',0,NULL),(4,4,3,1088.00,0.00,'{\"sku\":\"PQ-100-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 1 Box)\"}',NULL,200,'Google Chromecast with Google TV','main/products/product-19.jpg',2280.00,0,'2024-03-15 03:00:35','2024-03-15 03:00:35','physical',0,NULL),(5,5,3,1216.00,0.00,'{\"sku\":\"WP-103-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,168,'Samsung Odyssey G7 32-Inch Curved Gaming Monitor (Digital)','main/products/product-10.jpg',2208.00,0,'2024-03-15 03:00:36','2024-03-15 03:00:36','digital',0,NULL),(6,6,3,1609.00,0.00,'{\"sku\":\"PY-109-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}',NULL,171,'Sony X900H 4K Ultra HD Smart LED TV','main/products/product-8.jpg',1554.00,0,'2024-03-15 03:00:36','2024-03-15 03:00:36','physical',0,NULL),(7,7,3,922.00,0.00,'{\"sku\":\"JK-179-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}',NULL,207,'Bose Smart Soundbar 900','main/products/product-details-desc-1.jpg',2640.00,0,'2024-03-15 03:00:36','2024-03-15 03:00:36','physical',0,NULL),(8,8,1,511.00,0.00,'{\"sku\":\"FI-119-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,122,'Logitech G Pro X Superlight Wireless Gaming Mouse (Digital)','main/products/product-8.jpg',706.00,0,'2024-03-15 03:00:37','2024-03-15 03:00:37','digital',5,NULL),(9,8,3,1216.00,0.00,'{\"sku\":\"WP-103-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 3KG)\"}',NULL,169,'Samsung Odyssey G7 32-Inch Curved Gaming Monitor (Digital)','main/products/product-8.jpg',2208.00,0,'2024-03-15 03:00:37','2024-03-15 03:00:37','digital',9,NULL),(10,9,2,1518.00,0.00,'{\"sku\":\"Z2-109-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 1 Box)\"}',NULL,157,'BenQ EW3280U 32-Inch 4K HDR Entertainment Monitor (Digital)','main/products/product-5.jpg',1130.00,0,'2024-03-15 03:00:37','2024-03-15 03:00:37','digital',9,NULL),(11,10,2,2049.00,0.00,'{\"sku\":\"YX-108-A0\",\"attributes\":\"(Size: M, Color: Red)\"}',NULL,75,'GoPro HERO9 Black Action Camera','main/products/product-13.jpg',1458.00,0,'2024-03-15 03:00:37','2024-03-15 03:00:37','physical',0,NULL),(12,10,3,2049.00,0.00,'{\"sku\":\"YX-108-A0-A2\",\"attributes\":\"(Color: Red, Size: XL)\"}',NULL,77,'GoPro HERO9 Black Action Camera','main/products/product-14.jpg',2187.00,0,'2024-03-15 03:00:37','2024-03-15 03:00:37','physical',0,NULL),(13,10,1,1972.00,0.00,'{\"sku\":\"PM-191-A0-A2\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}',NULL,187,'Sony A90J 4K OLED Smart TV','main/products/product-2.jpg',689.00,0,'2024-03-15 03:00:37','2024-03-15 03:00:37','physical',0,NULL),(14,11,2,1101.00,0.00,'{\"sku\":\"35-120-A0\",\"attributes\":\"(Color: Green, Size: XL)\"}',NULL,117,'Corsair K95 RGB Platinum XT Mechanical Gaming Keyboard','main/products/product-8.jpg',1518.00,0,'2024-03-15 03:00:38','2024-03-15 03:00:38','physical',0,NULL),(15,12,1,2358.00,0.00,'{\"sku\":\"NW-195-A0\",\"attributes\":\"(Size: S, Color: Brown)\"}',NULL,72,'DJI Mavic Air 2 Drone','main/products/product-14.jpg',900.00,0,'2024-03-15 03:00:38','2024-03-15 03:00:38','physical',0,NULL),(16,13,1,1087.00,0.00,'{\"sku\":\"FH-109-A0\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,173,'TCL 6-Series 4K UHD Dolby Vision HDR QLED Roku Smart TV','main/products/product-13.jpg',531.00,0,'2024-03-15 03:00:38','2024-03-15 03:00:38','physical',0,NULL),(17,14,2,1972.00,0.00,'{\"sku\":\"PM-191-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}',NULL,186,'Sony A90J 4K OLED Smart TV','main/products/product-3.jpg',1378.00,0,'2024-03-15 03:00:39','2024-03-15 03:00:39','physical',0,NULL),(18,15,3,832.00,0.00,'{\"sku\":\"UT-109-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}',NULL,208,'JBL Bar 9.1 Soundbar with Dolby Atmos','main/products/product-18.jpg',2322.00,0,'2024-03-15 03:00:39','2024-03-15 03:00:39','physical',0,NULL),(19,16,1,2049.00,0.00,'{\"sku\":\"YX-108-A0-A1\",\"attributes\":\"(Size: M, Color: Black)\"}',NULL,76,'GoPro HERO9 Black Action Camera','main/products/product-20.jpg',729.00,0,'2024-03-15 03:00:39','2024-03-15 03:00:39','physical',0,NULL),(20,17,2,1020.00,0.00,'{\"sku\":\"14-156-A0-A1\",\"attributes\":\"(Color: Red, Size: XXL)\"}',NULL,95,'Apple Watch Series 7','main/products/product-details-desc-3.jpg',1800.00,0,'2024-03-15 03:00:40','2024-03-15 03:00:40','physical',0,NULL),(21,18,2,1788.00,0.00,'{\"sku\":\"2U-121-A0\",\"attributes\":\"(Color: Green, Size: XXL)\"}',NULL,104,'Microsoft Surface Pro 8','main/products/product-3.jpg',1106.00,0,'2024-03-15 03:00:40','2024-03-15 03:00:40','physical',0,NULL),(22,19,2,1088.00,0.00,'{\"sku\":\"PQ-100-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}',NULL,198,'Google Chromecast with Google TV','main/products/product-15.jpg',1520.00,0,'2024-03-15 03:00:40','2024-03-15 03:00:40','physical',0,NULL),(23,20,2,2272.00,0.00,'{\"sku\":\"K7-170-A0-A3\",\"attributes\":\"(Color: Brown, Size: XXL)\"}',NULL,114,'Razer Blade 15 Advanced Gaming Laptop','main/products/product-5.jpg',1118.00,0,'2024-03-15 03:00:41','2024-03-15 03:00:41','physical',0,NULL),(24,21,2,1101.00,0.00,'{\"sku\":\"35-120-A0-A3\",\"attributes\":\"(Color: Red, Size: XL)\"}',NULL,120,'Corsair K95 RGB Platinum XT Mechanical Gaming Keyboard','main/products/product-17.jpg',1518.00,0,'2024-03-15 03:00:41','2024-03-15 03:00:41','physical',0,NULL),(25,22,1,344.00,0.00,'{\"sku\":\"D6-153-A0-A1\",\"attributes\":\"(Color: Green, Size: L)\"}',NULL,59,'EcoTech Marine Radion XR30w G5 Pro LED Light Fixture','main/products/product-16.jpg',866.00,0,'2024-03-15 03:00:41','2024-03-15 03:00:41','physical',0,NULL),(26,22,1,296.00,0.00,'{\"sku\":\"UF-174-A0-A1\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}',NULL,213,'Sony HT-A9 Home Theater System','main/products/product-6.jpg',798.00,0,'2024-03-15 03:00:41','2024-03-15 03:00:41','physical',0,NULL),(27,23,3,989.00,0.00,'{\"sku\":\"NM-110-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}',NULL,184,'Samsung QN85A Neo QLED 4K Smart TV','main/products/product-details-desc-3.jpg',2265.00,0,'2024-03-15 03:00:42','2024-03-15 03:00:42','physical',0,NULL),(28,24,3,893.00,0.00,'{\"sku\":\"8E-178-A0-A1\",\"attributes\":\"(Color: Green, Size: S)\"}',NULL,98,'Fitbit Charge 5 Fitness Tracker (Digital)','main/products/product-18.jpg',2376.00,0,'2024-03-15 03:00:42','2024-03-15 03:00:42','digital',1,NULL),(29,25,3,2356.00,0.00,'{\"sku\":\"7T-161-A0\",\"attributes\":\"(Color: Blue, Size: L)\"}',NULL,110,'HP Spectre x360 14-Inch Convertible Laptop (Digital)','main/products/product-details-desc-3.jpg',1986.00,0,'2024-03-15 03:00:42','2024-03-15 03:00:42','digital',6,NULL),(30,26,1,906.00,0.00,'{\"sku\":\"WG-143-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}',NULL,188,'Apple TV 4K (2nd Generation) (Digital)','main/products/product-1.jpg',569.00,0,'2024-03-15 03:00:43','2024-03-15 03:00:43','digital',5,NULL),(31,27,3,1101.00,0.00,'{\"sku\":\"35-120-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}',NULL,118,'Corsair K95 RGB Platinum XT Mechanical Gaming Keyboard','main/products/product-18.jpg',2277.00,0,'2024-03-15 03:00:43','2024-03-15 03:00:43','physical',0,NULL),(32,27,2,296.00,0.00,'{\"sku\":\"UF-174-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}',NULL,212,'Sony HT-A9 Home Theater System','main/products/product-details-desc-3.jpg',1596.00,0,'2024-03-15 03:00:43','2024-03-15 03:00:43','physical',0,NULL),(33,28,3,439.00,0.00,'{\"sku\":\"EC-152-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}',NULL,178,'Vizio OLED65-H1 65-Inch 4K OLED Smart TV','main/products/product-16.jpg',2637.00,0,'2024-03-15 03:00:44','2024-03-15 03:00:44','physical',0,NULL),(34,29,3,2121.00,0.00,'{\"sku\":\"B5-140-A0-A1\",\"attributes\":\"(Color: Blue, Size: XL)\"}',NULL,83,'Nest Learning Thermostat (3rd Generation)','main/products/product-5.jpg',2694.00,0,'2024-03-15 03:00:44','2024-03-15 03:00:44','physical',0,NULL),(35,30,1,1020.00,0.00,'{\"sku\":\"14-156-A0-A2\",\"attributes\":\"(Color: Green, Size: M)\"}',NULL,96,'Apple Watch Series 7','main/products/product-3.jpg',900.00,0,'2024-03-15 03:00:44','2024-03-15 03:00:44','physical',0,NULL),(36,31,1,1788.00,0.00,'{\"sku\":\"2U-121-A0-A2\",\"attributes\":\"(Color: Blue, Size: XL)\"}',NULL,106,'Microsoft Surface Pro 8','main/products/product-details-desc-2.jpg',553.00,0,'2024-03-15 03:00:44','2024-03-15 03:00:44','physical',0,NULL),(37,32,2,439.00,0.00,'{\"sku\":\"EC-152-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}',NULL,177,'Vizio OLED65-H1 65-Inch 4K OLED Smart TV','main/products/product-details-desc-1.jpg',1758.00,0,'2024-03-15 03:00:45','2024-03-15 03:00:45','physical',0,NULL),(38,33,3,344.00,0.00,'{\"sku\":\"D6-153-A0\",\"attributes\":\"(Size: S, Color: Blue)\"}',NULL,58,'EcoTech Marine Radion XR30w G5 Pro LED Light Fixture','main/products/product-12.jpg',2598.00,0,'2024-03-15 03:00:45','2024-03-15 03:00:45','physical',0,NULL),(39,34,3,2272.00,0.00,'{\"sku\":\"K7-170-A0\",\"attributes\":\"(Color: Green, Size: L)\"}',NULL,111,'Razer Blade 15 Advanced Gaming Laptop','main/products/product-5.jpg',1677.00,0,'2024-03-15 03:00:45','2024-03-15 03:00:45','physical',0,NULL),(40,35,2,439.00,0.00,'{\"sku\":\"EC-152-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}',NULL,178,'Vizio OLED65-H1 65-Inch 4K OLED Smart TV','main/products/product-16.jpg',1758.00,0,'2024-03-15 03:00:45','2024-03-15 03:00:45','physical',0,NULL),(41,36,2,2121.00,0.00,'{\"sku\":\"B5-140-A0\",\"attributes\":\"(Color: Blue, Size: XL)\"}',NULL,82,'Nest Learning Thermostat (3rd Generation)','main/products/product-13.jpg',1796.00,0,'2024-03-15 03:00:45','2024-03-15 03:00:45','physical',0,NULL),(42,37,1,2424.00,0.00,'{\"sku\":\"ZQ-172-A0-A2\",\"attributes\":\"(Color: Green, Size: XL)\"}',NULL,88,'Samsung QN90A Neo QLED 4K Smart TV (Digital)','main/products/product-19.jpg',849.00,0,'2024-03-15 03:00:46','2024-03-15 03:00:46','digital',1,NULL),(43,37,3,263.00,0.00,'{\"sku\":\"GO-147-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,123,'SteelSeries Arctis Pro Wireless Gaming Headset','main/products/product-17.jpg',1605.00,0,'2024-03-15 03:00:46','2024-03-15 03:00:46','physical',0,NULL),(44,38,2,511.00,0.00,'{\"sku\":\"FI-119-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,122,'Logitech G Pro X Superlight Wireless Gaming Mouse (Digital)','main/products/product-8.jpg',1412.00,0,'2024-03-15 03:00:46','2024-03-15 03:00:46','digital',10,NULL),(45,39,3,1278.00,0.00,'{\"sku\":\"EV-148-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,160,'Dell UltraSharp U2720Q 27-Inch 4K USB-C Monitor','main/products/product-details-desc-3.jpg',1728.00,0,'2024-03-15 03:00:46','2024-03-15 03:00:46','physical',0,NULL),(46,39,1,431.00,0.00,'{\"sku\":\"K2-193-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}',NULL,211,'Sennheiser Ambeo Soundbar (Digital)','main/products/product-details-desc-1.jpg',754.00,0,'2024-03-15 03:00:46','2024-03-15 03:00:46','digital',8,NULL),(47,40,1,1274.00,0.00,'{\"sku\":\"D9-163-A0-A1\",\"attributes\":\"(Size: L, Color: Black)\"}',NULL,63,'Samsung Galaxy Tab S7+ 12.4-Inch Android Tablet','main/products/product-12.jpg',833.00,0,'2024-03-15 03:00:47','2024-03-15 03:00:47','physical',0,NULL),(48,40,3,922.00,0.00,'{\"sku\":\"JK-179-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}',NULL,207,'Bose Smart Soundbar 900','main/products/product-details-desc-1.jpg',2640.00,0,'2024-03-15 03:00:47','2024-03-15 03:00:47','physical',0,NULL),(49,41,1,1020.00,0.00,'{\"sku\":\"14-156-A0\",\"attributes\":\"(Size: S, Color: Brown)\"}',NULL,94,'Apple Watch Series 7','main/products/product-7.jpg',900.00,0,'2024-03-15 03:00:47','2024-03-15 03:00:47','physical',0,NULL),(50,42,1,893.00,0.00,'{\"sku\":\"8E-178-A0-A1\",\"attributes\":\"(Color: Green, Size: S)\"}',NULL,98,'Fitbit Charge 5 Fitness Tracker (Digital)','main/products/product-18.jpg',792.00,0,'2024-03-15 03:00:47','2024-03-15 03:00:47','digital',5,NULL),(51,43,2,1101.00,0.00,'{\"sku\":\"35-120-A0-A2\",\"attributes\":\"(Size: XL, Color: Brown)\"}',NULL,119,'Corsair K95 RGB Platinum XT Mechanical Gaming Keyboard','main/products/product-19.jpg',1518.00,0,'2024-03-15 03:00:47','2024-03-15 03:00:47','physical',0,NULL),(52,44,1,2040.00,0.00,'{\"sku\":\"JV-167-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,129,'Elgato Stream Deck XL','main/products/product-13.jpg',759.00,0,'2024-03-15 03:00:47','2024-03-15 03:00:47','physical',0,NULL),(53,45,1,1274.00,0.00,'{\"sku\":\"D9-163-A0\",\"attributes\":\"(Color: Red, Size: L)\"}',NULL,62,'Samsung Galaxy Tab S7+ 12.4-Inch Android Tablet','main/products/product-1.jpg',833.00,0,'2024-03-15 03:00:48','2024-03-15 03:00:48','physical',0,NULL),(54,45,3,1274.00,0.00,'{\"sku\":\"D9-163-A0-A1\",\"attributes\":\"(Size: L, Color: Black)\"}',NULL,63,'Samsung Galaxy Tab S7+ 12.4-Inch Android Tablet','main/products/product-12.jpg',2499.00,0,'2024-03-15 03:00:48','2024-03-15 03:00:48','physical',0,NULL),(55,45,3,2394.00,0.00,'{\"sku\":\"FB-138-A0\",\"attributes\":\"(Color: Black, Size: XXL)\"}',NULL,107,'Lenovo ThinkPad X1 Carbon Gen 9 Laptop','main/products/product-3.jpg',1563.00,0,'2024-03-15 03:00:48','2024-03-15 03:00:48','physical',0,NULL),(56,46,2,2148.00,0.00,'{\"sku\":\"KW-195-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}',NULL,205,'Sonos Beam Gen 2 Soundbar','main/products/product-18.jpg',1032.00,0,'2024-03-15 03:00:48','2024-03-15 03:00:48','physical',0,NULL),(57,47,3,2360.00,0.00,'{\"sku\":\"UL-142-A0\",\"attributes\":\"(Color: Black, Size: XL)\"}',NULL,101,'Garmin Fenix 7X Sapphire Solar GPS Watch','main/products/product-17.jpg',2514.00,0,'2024-03-15 03:00:48','2024-03-15 03:00:48','physical',0,NULL),(58,48,3,1454.00,0.00,'{\"sku\":\"8Q-195-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,142,'HTC Vive Cosmos Elite VR Headset','main/products/product-13.jpg',2649.00,0,'2024-03-15 03:00:48','2024-03-15 03:00:48','physical',0,NULL),(59,49,2,1443.00,0.00,'{\"sku\":\"JS-195-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 4KG)\"}',NULL,152,'ASUS ROG Swift PG279QM 27-Inch Gaming Monitor','main/products/product-15.jpg',1264.00,0,'2024-03-15 03:00:49','2024-03-15 03:00:49','physical',0,NULL),(60,50,2,399.00,0.00,'{\"sku\":\"Q5-195-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}',NULL,130,'Nintendo Switch OLED Model','main/products/product-2.jpg',1362.00,0,'2024-03-15 03:00:49','2024-03-15 03:00:49','physical',0,NULL),(61,51,2,544.00,0.00,'{\"sku\":\"FD-181-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}',NULL,145,'Samsung Odyssey G9 49-Inch Curved Gaming Monitor (Digital)','main/products/product-14.jpg',1340.00,0,'2024-03-15 03:00:49','2024-03-15 03:00:49','digital',2,NULL),(62,52,3,1928.00,0.00,'{\"sku\":\"SS-163-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}',NULL,166,'LG 27UK850-W 27-Inch 4K UHD IPS Monitor','main/products/product-19.jpg',2190.00,0,'2024-03-15 03:00:49','2024-03-15 03:00:49','physical',0,NULL),(63,53,1,1020.00,0.00,'{\"sku\":\"14-156-A0\",\"attributes\":\"(Size: S, Color: Brown)\"}',NULL,94,'Apple Watch Series 7','main/products/product-7.jpg',900.00,0,'2024-03-15 03:00:50','2024-03-15 03:00:50','physical',0,NULL),(64,53,2,906.00,0.00,'{\"sku\":\"WG-143-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}',NULL,188,'Apple TV 4K (2nd Generation) (Digital)','main/products/product-1.jpg',1138.00,0,'2024-03-15 03:00:50','2024-03-15 03:00:50','digital',1,NULL),(65,54,3,893.00,0.00,'{\"sku\":\"8E-178-A0-A1\",\"attributes\":\"(Color: Green, Size: S)\"}',NULL,98,'Fitbit Charge 5 Fitness Tracker (Digital)','main/products/product-18.jpg',2376.00,0,'2024-03-15 03:00:50','2024-03-15 03:00:50','digital',3,NULL),(66,55,1,1788.00,0.00,'{\"sku\":\"2U-121-A0\",\"attributes\":\"(Color: Green, Size: XXL)\"}',NULL,104,'Microsoft Surface Pro 8','main/products/product-3.jpg',553.00,0,'2024-03-15 03:00:50','2024-03-15 03:00:50','physical',0,NULL);
/*!40000 ALTER TABLE `ec_order_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_referrals`
--

DROP TABLE IF EXISTS `ec_order_referrals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_referrals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_page` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_params` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referral` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gclid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fclid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_campaign` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_medium` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_term` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_content` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer_url` text COLLATE utf8mb4_unicode_ci,
  `referrer_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_referrals_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_referrals`
--

LOCK TABLES `ec_order_referrals` WRITE;
/*!40000 ALTER TABLE `ec_order_referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_referrals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_return_items`
--

DROP TABLE IF EXISTS `ec_order_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_return_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_return_id` bigint unsigned NOT NULL COMMENT 'Order return id',
  `order_product_id` bigint unsigned NOT NULL COMMENT 'Order product id',
  `product_id` bigint unsigned NOT NULL COMMENT 'Product id',
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int NOT NULL COMMENT 'Quantity return',
  `price` decimal(15,2) NOT NULL COMMENT 'Price Product',
  `reason` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `refund_amount` decimal(12,2) DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_return_items`
--

LOCK TABLES `ec_order_return_items` WRITE;
/*!40000 ALTER TABLE `ec_order_return_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_return_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_returns`
--

DROP TABLE IF EXISTS `ec_order_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_returns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL COMMENT 'Order ID',
  `store_id` bigint unsigned DEFAULT NULL COMMENT 'Store ID',
  `user_id` bigint unsigned NOT NULL COMMENT 'Customer ID',
  `reason` text COLLATE utf8mb4_unicode_ci COMMENT 'Reason return order',
  `order_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Order current status',
  `return_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Return status',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_order_returns_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_returns`
--

LOCK TABLES `ec_order_returns` WRITE;
/*!40000 ALTER TABLE `ec_order_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_tax_information`
--

DROP TABLE IF EXISTS `ec_order_tax_information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_tax_information` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `company_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_tax_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_tax_information_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_tax_information`
--

LOCK TABLES `ec_order_tax_information` WRITE;
/*!40000 ALTER TABLE `ec_order_tax_information` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_tax_information` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_orders`
--

DROP TABLE IF EXISTS `ec_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT NULL,
  `shipping_amount` decimal(15,2) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(15,2) DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `is_confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `discount_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_finished` tinyint(1) DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `proof_file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_orders_code_unique` (`code`),
  KEY `ec_orders_user_id_status_created_at_index` (`user_id`,`status`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_orders`
--

LOCK TABLES `ec_orders` WRITE;
/*!40000 ALTER TABLE `ec_orders` DISABLE KEYS */;
INSERT INTO `ec_orders` VALUES (1,'#10000001',10,NULL,'','pending',7272.00,0.00,0.00,NULL,NULL,0.00,7272.00,1,NULL,1,NULL,'oeebCfbYxg3Z2zhCzT2fBQcJIR3ZR',1,'2024-03-10 03:00:34','2024-03-15 03:00:34',8,NULL),(2,'#10000002',10,'1','default','completed',2272.00,0.00,0.00,NULL,NULL,0.00,2272.00,1,NULL,1,'2024-03-15 03:00:35','OKwT8uJnhO2TcwqohmBYa7WpAwSu6',2,'2024-03-01 19:00:35','2024-03-15 03:00:35',1,NULL),(3,'#10000003',10,'1','default','pending',3261.00,0.00,0.00,NULL,NULL,0.00,3261.00,1,NULL,1,NULL,'hR3DuvWjeukCLL6av4KTG2V4xanaV',3,'2024-03-10 03:00:35','2024-03-15 03:00:35',2,NULL),(4,'#10000004',10,'1','default','completed',3264.00,0.00,0.00,NULL,NULL,0.00,3264.00,1,NULL,1,'2024-03-15 03:00:50','nPRCtysJWdKUn5VN8LLbphKvNFEAP',4,'2024-03-05 03:00:35','2024-03-15 03:00:50',5,NULL),(5,'#10000005',9,NULL,'','completed',3648.00,0.00,0.00,NULL,NULL,0.00,3648.00,1,NULL,1,'2024-03-15 03:00:36','QrONYGN0uKcYvNZCW8283LodDvbd2',5,'2024-03-02 11:00:36','2024-03-15 03:00:36',5,NULL),(6,'#10000006',9,'1','default','completed',4827.00,0.00,0.00,NULL,NULL,0.00,4827.00,1,NULL,1,'2024-03-15 03:00:51','f4vyn0tvRX9NzwSFedtRiTslAjFK8',6,'2024-03-11 23:00:36','2024-03-15 03:00:51',3,NULL),(7,'#10000007',9,'1','default','completed',2766.00,0.00,0.00,NULL,NULL,0.00,2766.00,1,NULL,1,'2024-03-15 03:00:51','iw4rGPDE1CeQReROqvjIo4XBPDi4m',7,'2024-03-05 15:00:36','2024-03-15 03:00:51',1,NULL),(8,'#10000008',10,NULL,'','completed',4159.00,0.00,0.00,NULL,NULL,0.00,4159.00,1,NULL,1,'2024-03-15 03:00:37','I2RCs61uzIUAJdurNDdDfNHH6fr1k',8,'2024-03-03 03:00:37','2024-03-15 03:00:37',5,NULL),(9,'#10000009',10,NULL,'','pending',3036.00,0.00,0.00,NULL,NULL,0.00,3036.00,1,NULL,1,NULL,'kd44XVlYwwXBG1BhrNcKvcV3jFOsT',9,'2024-03-13 15:00:37','2024-03-15 03:00:37',8,NULL),(10,'#10000010',10,'1','default','completed',12217.00,0.00,0.00,NULL,NULL,0.00,12217.00,1,NULL,1,'2024-03-15 03:00:52','EH9pDp162wAoCJVKYCM9LKuhVhzWV',10,'2024-03-10 21:00:37','2024-03-15 03:00:52',8,NULL),(11,'#10000011',10,'1','default','completed',2202.00,0.00,0.00,NULL,NULL,0.00,2202.00,1,NULL,1,'2024-03-15 03:00:53','wxbMyKtoqVGeqzvJfMnVYSQofrMEf',11,'2024-03-10 21:00:38','2024-03-15 03:00:53',4,NULL),(12,'#10000012',10,'1','default','completed',2358.00,0.00,0.00,NULL,NULL,0.00,2358.00,1,NULL,1,'2024-03-15 03:00:53','DPV83KtqGczrM0erSHleo270EDI2a',12,'2024-03-07 03:00:38','2024-03-15 03:00:53',3,NULL),(13,'#10000013',10,'1','default','completed',1087.00,0.00,0.00,NULL,NULL,0.00,1087.00,1,NULL,1,'2024-03-15 03:00:54','yzATpB3TwcycGJ7GlvgGGCzIHn7fD',13,'2024-03-12 11:00:38','2024-03-15 03:00:54',2,NULL),(14,'#10000014',10,'1','default','pending',3944.00,0.00,0.00,NULL,NULL,0.00,3944.00,1,NULL,1,NULL,'yNvP3kVantry8ZdprNvFWE60kkRgj',14,'2024-03-13 19:00:39','2024-03-15 03:00:39',8,NULL),(15,'#10000015',10,'1','default','pending',2496.00,0.00,0.00,NULL,NULL,0.00,2496.00,1,NULL,1,NULL,'gQwHAUfEJG8bPLqrZCPYczCBS3OZx',15,'2024-03-12 11:00:39','2024-03-15 03:00:39',5,NULL),(16,'#10000016',9,'1','default','completed',2049.00,0.00,0.00,NULL,NULL,0.00,2049.00,1,NULL,1,'2024-03-15 03:00:55','uYrgL5UCQ6Ua0qSdiYnRXAlcHj7hX',16,'2024-03-03 21:00:39','2024-03-15 03:00:55',8,NULL),(17,'#10000017',9,'1','default','pending',2040.00,0.00,0.00,NULL,NULL,0.00,2040.00,1,NULL,1,NULL,'3QtK4DN4ivHUudVE3pKyeLgQetUWv',17,'2024-03-03 21:00:40','2024-03-15 03:00:40',3,NULL),(18,'#10000018',9,'1','default','completed',3576.00,0.00,0.00,NULL,NULL,0.00,3576.00,1,NULL,1,'2024-03-15 03:00:40','peu1B60jTrz4o4t4puI9kiOJ615TJ',18,'2024-03-13 21:00:40','2024-03-15 03:00:40',4,NULL),(19,'#10000019',9,'1','default','pending',2176.00,0.00,0.00,NULL,NULL,0.00,2176.00,1,NULL,1,NULL,'zQtDROzOGK8hDTMNHgd1Z9FlAo5Xn',19,'2024-03-11 09:00:40','2024-03-15 03:00:40',5,NULL),(20,'#10000020',10,'1','default','pending',4544.00,0.00,0.00,NULL,NULL,0.00,4544.00,1,NULL,1,NULL,'ibZqF8PBrc44c2HKUQ86pBn3nAZA5',20,'2024-03-04 15:00:41','2024-03-15 03:00:41',1,NULL),(21,'#10000021',10,'1','default','completed',2202.00,0.00,0.00,NULL,NULL,0.00,2202.00,1,NULL,1,'2024-03-15 03:00:56','tNIijcf29HoS3oinx6wn3kOMY6F1L',21,'2024-03-09 07:00:41','2024-03-15 03:00:56',4,NULL),(22,'#10000022',10,'1','default','completed',640.00,0.00,0.00,NULL,NULL,0.00,640.00,1,NULL,1,'2024-03-15 03:00:56','d4H0Q4MUNQdcIxzeCYJILzNIwv8fj',22,'2024-03-09 17:00:41','2024-03-15 03:00:56',4,NULL),(23,'#10000023',10,'1','default','completed',2967.00,0.00,0.00,NULL,NULL,0.00,2967.00,1,NULL,1,'2024-03-15 03:00:42','jJsoqKrcgsFeXHJpuQztJdq1PUyIp',23,'2024-03-14 01:00:42','2024-03-15 03:00:42',8,NULL),(24,'#10000024',10,NULL,'','completed',2679.00,0.00,0.00,NULL,NULL,0.00,2679.00,1,NULL,1,'2024-03-15 03:00:42','TSwVUcNfrbbW9JwjAjII0lHVwIGe2',24,'2024-03-05 03:00:42','2024-03-15 03:00:42',5,NULL),(25,'#10000025',10,NULL,'','completed',7068.00,0.00,0.00,NULL,NULL,0.00,7068.00,1,NULL,1,'2024-03-15 03:00:43','N3Cl3cF6fwTUnXjW7ob9ymSwlXycQ',25,'2024-03-10 03:00:42','2024-03-15 03:00:43',7,NULL),(26,'#10000026',10,NULL,'','completed',906.00,0.00,0.00,NULL,NULL,0.00,906.00,1,NULL,1,'2024-03-15 03:00:43','m6aPIWUgs3OvTE0kXaEj2RDvjxYz8',26,'2024-03-12 03:00:43','2024-03-15 03:00:43',3,NULL),(27,'#10000027',9,'1','default','pending',3895.00,0.00,0.00,NULL,NULL,0.00,3895.00,1,NULL,1,NULL,'6zKT29NoDrvUmAQyT8ppAHtQ9fEuz',27,'2024-03-11 11:00:43','2024-03-15 03:00:43',4,NULL),(28,'#10000028',9,'1','default','pending',1317.00,0.00,0.00,NULL,NULL,0.00,1317.00,1,NULL,1,NULL,'RwDAvpiy5vdUaGb73QKtHSdhWxpwN',28,'2024-03-12 09:00:43','2024-03-15 03:00:44',8,NULL),(29,'#10000029',9,'1','default','completed',6363.00,0.00,0.00,NULL,NULL,0.00,6363.00,1,NULL,1,'2024-03-15 03:00:57','aFGSxxur72UhrCIIw5NxO4xUr2kky',29,'2024-03-10 23:00:44','2024-03-15 03:00:57',6,NULL),(30,'#10000030',9,'1','default','completed',1020.00,0.00,0.00,NULL,NULL,0.00,1020.00,1,NULL,1,'2024-03-15 03:00:44','Drhh3Mfp57Kpc8dQIWfysEdKSDPfY',30,'2024-03-10 23:00:44','2024-03-15 03:00:44',3,NULL),(31,'#10000031',9,'1','default','completed',1788.00,0.00,0.00,NULL,NULL,0.00,1788.00,1,NULL,1,'2024-03-15 03:00:58','DNlGkVSUKt0L16yYXPHJmKsOY8NH8',31,'2024-03-09 07:00:44','2024-03-15 03:00:58',4,NULL),(32,'#10000032',9,'1','default','completed',878.00,0.00,0.00,NULL,NULL,0.00,878.00,1,NULL,1,'2024-03-15 03:00:58','RCjjT1T3BB7JFXNQqQINkjsljQ93W',32,'2024-03-06 19:00:45','2024-03-15 03:00:58',8,NULL),(33,'#10000033',10,'1','default','pending',1032.00,0.00,0.00,NULL,NULL,0.00,1032.00,1,NULL,1,NULL,'THO6mhN56N6xLOeUAA5rnmnxz5pt9',33,'2024-03-14 09:00:45','2024-03-15 03:00:45',4,NULL),(34,'#10000034',10,'1','default','pending',6816.00,0.00,0.00,NULL,NULL,0.00,6816.00,1,NULL,1,NULL,'sasIhWFBKimf8cylBPxgQYLPusu0b',34,'2024-03-10 15:00:45','2024-03-15 03:00:45',1,NULL),(35,'#10000035',10,'1','default','completed',878.00,0.00,0.00,NULL,NULL,0.00,878.00,1,NULL,1,'2024-03-15 03:00:59','gxjcUuiuHNdJqNtkFD5eBhf6GAypL',35,'2024-03-12 21:00:45','2024-03-15 03:00:59',8,NULL),(36,'#10000036',10,'1','default','completed',4242.00,0.00,0.00,NULL,NULL,0.00,4242.00,1,NULL,1,'2024-03-15 03:00:46','MWvVZlZPXFwxxJ8IR7CzCJrxhGs6L',36,'2024-03-11 19:00:45','2024-03-15 03:00:46',6,NULL),(37,'#10000037',10,'1','default','pending',3213.00,0.00,0.00,NULL,NULL,0.00,3213.00,1,NULL,1,NULL,'ouHkFVuiQzK2xenGHcjKyMXe9BHj7',37,'2024-03-10 11:00:46','2024-03-15 03:00:46',8,NULL),(38,'#10000038',10,NULL,'','pending',1022.00,0.00,0.00,NULL,NULL,0.00,1022.00,1,NULL,1,NULL,'HxqsbG9cPP1xa71M5ZgUjLmsVKKFK',38,'2024-03-11 03:00:46','2024-03-15 03:00:46',5,NULL),(39,'#10000039',9,'1','default','pending',4265.00,0.00,0.00,NULL,NULL,0.00,4265.00,1,NULL,1,NULL,'CS0G1ZYWgdFF46P7ZsauqpVuKojn6',39,'2024-03-11 01:00:46','2024-03-15 03:00:46',5,NULL),(40,'#10000040',9,'1','default','completed',4040.00,0.00,0.00,NULL,NULL,0.00,4040.00,1,NULL,1,'2024-03-15 03:01:00','UUVWyVln2jw76wOcRBANfC6z3NtL8',40,'2024-03-13 03:00:47','2024-03-15 03:01:00',1,NULL),(41,'#10000041',9,'1','default','completed',1020.00,0.00,0.00,NULL,NULL,0.00,1020.00,1,NULL,1,'2024-03-15 03:00:47','jbEJoQtzpZpuuaDvyD9nwxvtZqvlL',41,'2024-03-14 17:00:47','2024-03-15 03:00:47',3,NULL),(42,'#10000042',9,NULL,'','pending',893.00,0.00,0.00,NULL,NULL,0.00,893.00,1,NULL,1,NULL,'vHHQwlbUIS8Fg0xVZZyyGyjK9EJpc',42,'2024-03-12 15:00:47','2024-03-15 03:00:47',5,NULL),(43,'#10000043',9,'1','default','pending',2202.00,0.00,0.00,NULL,NULL,0.00,2202.00,1,NULL,1,NULL,'Vu53iHI4HRglnjeEObg3WUnGBOC4L',43,'2024-03-12 15:00:47','2024-03-15 03:00:47',4,NULL),(44,'#10000044',9,'1','default','pending',2040.00,0.00,0.00,NULL,NULL,0.00,2040.00,1,NULL,1,NULL,'uOZsQoMRIcc6ek4iUF6DFzEpgx6TQ',44,'2024-03-13 21:00:47','2024-03-15 03:00:47',6,NULL),(45,'#10000045',10,'1','default','completed',12278.00,0.00,0.00,NULL,NULL,0.00,12278.00,1,NULL,1,'2024-03-15 03:00:48','3bkVd7pDwcLRsrCnXRT94FV0QhiVq',45,'2024-03-14 11:00:48','2024-03-15 03:00:48',1,NULL),(46,'#10000046',10,'1','default','completed',4296.00,0.00,0.00,NULL,NULL,0.00,4296.00,1,NULL,1,'2024-03-15 03:00:48','DTdoKyd5iMqMxe2MIExKZAdjZMIPq',46,'2024-03-12 19:00:48','2024-03-15 03:00:48',7,NULL),(47,'#10000047',9,'1','default','completed',7080.00,0.00,0.00,NULL,NULL,0.00,7080.00,1,NULL,1,'2024-03-15 03:01:01','naW4nM9oSysH1Xrka6BcauYLpzll4',47,'2024-03-14 21:00:48','2024-03-15 03:01:01',8,NULL),(48,'#10000048',9,'1','default','pending',4362.00,0.00,0.00,NULL,NULL,0.00,4362.00,1,NULL,1,NULL,'Ce0hkIZ0ilKhbeVI8R6WPOi0MqEMh',48,'2024-03-14 21:00:48','2024-03-15 03:00:48',5,NULL),(49,'#10000049',9,'1','default','pending',2886.00,0.00,0.00,NULL,NULL,0.00,2886.00,1,NULL,1,NULL,'r1v1xqti2dpDDET6luiOhBQ3K8r18',49,'2024-03-14 15:00:49','2024-03-15 03:00:49',6,NULL),(50,'#10000050',9,'1','default','completed',798.00,0.00,0.00,NULL,NULL,0.00,798.00,1,NULL,1,'2024-03-15 03:01:01','4vPEmdUYVZ6cloxb4ZLhYQXtAhoSR',50,'2024-03-14 07:00:49','2024-03-15 03:01:01',8,NULL),(51,'#10000051',9,NULL,'','completed',1088.00,0.00,0.00,NULL,NULL,0.00,1088.00,1,NULL,1,'2024-03-15 03:00:49','MzM198TlrGD9TBrz2BoeZkujv79uQ',51,'2024-03-13 19:00:49','2024-03-15 03:00:49',5,NULL),(52,'#10000052',9,'1','default','pending',5784.00,0.00,0.00,NULL,NULL,0.00,5784.00,1,NULL,1,NULL,'5rzG1UnKLB9Ap7oxola8H4sGIlZDU',52,'2024-03-14 03:00:49','2024-03-15 03:00:49',1,NULL),(53,'#10000053',9,'1','default','completed',2832.00,0.00,0.00,NULL,NULL,0.00,2832.00,1,NULL,1,'2024-03-15 03:00:50','9nqZpui122phWxzcwloMVD4QmRzpn',53,'2024-03-14 17:00:50','2024-03-15 03:00:50',3,NULL),(54,'#10000054',9,NULL,'','pending',2679.00,0.00,0.00,NULL,NULL,0.00,2679.00,1,NULL,1,NULL,'Ya3oRiLbOsjBNM9W7rfS3hzBf48LQ',54,'2024-03-14 11:00:50','2024-03-15 03:00:50',5,NULL),(55,'#10000055',9,'1','default','pending',1788.00,0.00,0.00,NULL,NULL,0.00,1788.00,1,NULL,1,NULL,'sTSZtN2ly22tEOqydBRdL7oJtIKjl',55,'2024-03-14 09:00:50','2024-03-15 03:00:50',4,NULL);
/*!40000 ALTER TABLE `ec_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_layout` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'swatch_dropdown',
  `is_searchable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_comparable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_use_in_product_listing` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `use_image_from_product_variation` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets`
--

LOCK TABLES `ec_product_attribute_sets` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets` DISABLE KEYS */;
INSERT INTO `ec_product_attribute_sets` VALUES (1,'Color','color','visual',1,1,1,'published',0,'2024-03-15 02:59:56','2024-03-15 02:59:56',0),(2,'Size','size','text',1,1,1,'published',1,'2024-03-15 02:59:56','2024-03-15 02:59:56',0),(3,'Weight','weight','text',1,1,1,'published',0,'2024-03-15 02:59:56','2024-03-15 02:59:56',0),(4,'Boxes','boxes','text',1,1,1,'published',1,'2024-03-15 02:59:56','2024-03-15 02:59:56',0);
/*!40000 ALTER TABLE `ec_product_attribute_sets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets_translations`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attribute_sets_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attribute_sets_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets_translations`
--

LOCK TABLES `ec_product_attribute_sets_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes`
--

DROP TABLE IF EXISTS `ec_product_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` bigint unsigned NOT NULL,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_set_status_index` (`attribute_set_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes`
--

LOCK TABLES `ec_product_attributes` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes` DISABLE KEYS */;
INSERT INTO `ec_product_attributes` VALUES (1,1,'Green','green','#5FB7D4',NULL,1,1,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(2,1,'Blue','blue','#333333',NULL,0,2,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(3,1,'Red','red','#DA323F',NULL,0,3,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(4,1,'Black','black','#2F366C',NULL,0,4,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(5,1,'Brown','brown','#87554B',NULL,0,5,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(6,2,'S','s',NULL,NULL,1,1,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(7,2,'M','m',NULL,NULL,0,2,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(8,2,'L','l',NULL,NULL,0,3,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(9,2,'XL','xl',NULL,NULL,0,4,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(10,2,'XXL','xxl',NULL,NULL,0,5,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(11,3,'1KG','1kg',NULL,NULL,1,1,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(12,3,'2KG','2kg',NULL,NULL,0,2,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(13,3,'3KG','3kg',NULL,NULL,0,3,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(14,3,'4KG','4kg',NULL,NULL,0,4,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(15,3,'5KG','5kg',NULL,NULL,0,5,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(16,4,'1 Box','1-box',NULL,NULL,1,1,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(17,4,'2 Boxes','2-boxes',NULL,NULL,0,2,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(18,4,'3 Boxes','3-boxes',NULL,NULL,0,3,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(19,4,'4 Boxes','4-boxes',NULL,NULL,0,4,'2024-03-15 02:59:56','2024-03-15 02:59:56'),(20,4,'5 Boxes','5-boxes',NULL,NULL,0,5,'2024-03-15 02:59:56','2024-03-15 02:59:56');
/*!40000 ALTER TABLE `ec_product_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes_translations`
--

DROP TABLE IF EXISTS `ec_product_attributes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attributes_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes_translations`
--

LOCK TABLES `ec_product_attributes_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attributes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories`
--

DROP TABLE IF EXISTS `ec_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` int unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_categories_parent_id_status_created_at_index` (`parent_id`,`status`,`created_at`),
  KEY `ec_product_categories_parent_id_status_index` (`parent_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories`
--

LOCK TABLES `ec_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_product_categories` DISABLE KEYS */;
INSERT INTO `ec_product_categories` VALUES (1,'New Arrivals',0,NULL,'published',0,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-home',NULL),(2,'Electronics',0,NULL,'published',1,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-tv',NULL),(3,'Featured',2,NULL,'published',0,'main/product-categories/menu-1.jpg',0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(4,'New Arrivals',3,NULL,'published',0,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(5,'Best Sellers',3,NULL,'published',1,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(6,'Mobile Phone',3,NULL,'published',2,'main/product-categories/2.png',1,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(7,'Computers & Laptops',2,NULL,'published',1,'main/product-categories/menu-2.jpg',0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(8,'Top Brands',7,NULL,'published',0,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(9,'Weekly Best Selling',7,NULL,'published',1,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(10,'CPU Heat Pipes',7,NULL,'published',2,'main/product-categories/3.png',1,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(11,'CPU Coolers',7,NULL,'published',3,'main/product-categories/category-thumb-9.jpg',0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(12,'Accessories',2,NULL,'published',2,'main/product-categories/menu-3.jpg',0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(13,'Headphones',12,NULL,'published',0,'main/product-categories/1.png',1,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(14,'Wireless Headphones',12,NULL,'published',1,'main/product-categories/category-thumb-1.jpg',0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(15,'TWS Earphones',12,NULL,'published',2,'main/product-categories/category-thumb-6.jpg',0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(16,'Smart Watch',12,NULL,'published',3,'main/product-categories/4.png',1,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(17,'Gaming Console',2,NULL,'published',3,'main/product-categories/category-thumb-8.jpg',0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(18,'Playstation',2,NULL,'published',4,'main/product-categories/category-thumb-12.jpg',0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(19,'Gifts',0,NULL,'published',2,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-gift',NULL),(20,'Computers',0,NULL,'published',3,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-laptop',NULL),(21,'Desktop',20,NULL,'published',0,'main/product-categories/category-thumb-5.jpg',0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-desktop',NULL),(22,'Laptop',20,NULL,'published',1,'main/product-categories/category-thumb-3.jpg',0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-laptop',NULL),(23,'Tablet',20,NULL,'published',2,'main/product-categories/category-thumb-4.jpg',0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-tablet-alt',NULL),(24,'Accessories',20,NULL,'published',3,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-keyboard',NULL),(25,'Smartphones & Tablets',0,NULL,'published',4,'main/product-categories/category-thumb-10.jpg',0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-mobile',NULL),(26,'TV, Video & Music',0,NULL,'published',5,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-tv',NULL),(27,'Cameras',0,NULL,'published',6,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-camera',NULL),(28,'Cooking',0,NULL,'published',7,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-utensils',NULL),(29,'Accessories',0,NULL,'published',8,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-store',NULL),(30,'With Bluetooth',29,NULL,'published',0,'main/product-categories/5.png',1,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(31,'Sports',0,NULL,'published',9,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-football-ball',NULL),(32,'Electronics Gadgets',0,NULL,'published',10,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09','fa-regular fa-microchip',NULL),(33,'Micrscope',32,NULL,'published',0,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(34,'Remote Control',32,NULL,'published',1,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(35,'Monitor',32,NULL,'published',2,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(36,'Thermometer',32,NULL,'published',3,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(37,'Backpack',32,NULL,'published',4,NULL,0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL),(38,'Headphones',32,NULL,'published',5,'main/product-categories/category-thumb-1.jpg',0,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL,NULL);
/*!40000 ALTER TABLE `ec_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories_translations`
--

DROP TABLE IF EXISTS `ec_product_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_product_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories_translations`
--

LOCK TABLES `ec_product_categories_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categorizables`
--

DROP TABLE IF EXISTS `ec_product_categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categorizables` (
  `category_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`category_id`,`reference_id`,`reference_type`),
  KEY `ec_product_categorizables_category_id_index` (`category_id`),
  KEY `ec_product_categorizables_reference_id_index` (`reference_id`),
  KEY `ec_product_categorizables_reference_type_index` (`reference_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categorizables`
--

LOCK TABLES `ec_product_categorizables` WRITE;
/*!40000 ALTER TABLE `ec_product_categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categorizables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_category_product`
--

DROP TABLE IF EXISTS `ec_product_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_category_product` (
  `category_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`category_id`),
  KEY `ec_product_category_product_category_id_index` (`category_id`),
  KEY `ec_product_category_product_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_category_product`
--

LOCK TABLES `ec_product_category_product` WRITE;
/*!40000 ALTER TABLE `ec_product_category_product` DISABLE KEYS */;
INSERT INTO `ec_product_category_product` VALUES (1,9),(1,15),(1,22),(1,32),(1,34),(1,36),(1,44),(1,46),(1,53),(1,56),(2,16),(2,17),(2,46),(2,48),(2,53),(3,6),(3,25),(3,53),(3,54),(4,10),(4,16),(4,20),(4,21),(4,30),(4,33),(5,1),(5,24),(5,31),(5,41),(5,47),(5,57),(6,5),(6,13),(6,14),(6,18),(6,27),(6,37),(7,5),(7,11),(7,22),(7,34),(7,40),(7,48),(7,56),(8,6),(8,9),(8,11),(8,35),(8,57),(9,37),(9,43),(9,45),(9,46),(9,49),(10,15),(10,19),(10,31),(10,38),(10,55),(11,12),(11,22),(11,25),(11,32),(11,55),(12,4),(12,13),(12,49),(12,50),(12,57),(13,9),(13,27),(13,36),(14,13),(14,26),(14,29),(14,47),(14,51),(15,3),(15,7),(15,8),(15,28),(15,50),(16,1),(16,11),(16,20),(16,21),(16,34),(16,40),(16,56),(17,2),(17,5),(17,8),(17,24),(17,29),(17,42),(17,45),(17,48),(18,1),(18,7),(18,39),(18,41),(18,42),(18,54),(18,55),(19,4),(19,6),(19,14),(19,18),(19,20),(19,29),(19,41),(19,47),(20,12),(20,15),(20,26),(20,33),(20,40),(21,12),(21,29),(21,39),(21,40),(21,44),(22,17),(22,19),(22,23),(22,43),(22,45),(22,49),(22,54),(22,55),(23,2),(23,5),(23,35),(23,38),(24,6),(24,7),(24,18),(24,36),(24,38),(24,49),(24,50),(25,4),(25,17),(25,21),(25,30),(25,51),(26,16),(26,19),(26,20),(26,23),(26,25),(26,35),(26,52),(27,14),(27,24),(27,31),(27,32),(27,41),(28,3),(28,16),(28,28),(28,32),(28,33),(28,48),(29,1),(29,2),(29,23),(29,26),(29,37),(30,2),(30,3),(30,30),(30,31),(30,50),(30,52),(30,57),(31,8),(31,10),(31,18),(31,26),(31,33),(31,35),(31,39),(31,47),(31,52),(32,9),(32,27),(32,28),(32,30),(32,37),(32,51),(33,8),(33,10),(33,14),(33,21),(33,22),(33,39),(33,54),(34,4),(34,34),(34,43),(35,7),(35,10),(35,12),(35,19),(35,36),(35,44),(36,3),(36,11),(36,17),(36,25),(36,42),(36,44),(37,13),(37,38),(37,42),(37,43),(37,45),(37,46),(38,15),(38,23),(38,24),(38,27),(38,28),(38,51),(38,52),(38,53),(38,56);
/*!40000 ALTER TABLE `ec_product_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collection_products`
--

DROP TABLE IF EXISTS `ec_product_collection_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collection_products` (
  `product_collection_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`product_collection_id`),
  KEY `ec_product_collection_products_product_collection_id_index` (`product_collection_id`),
  KEY `ec_product_collection_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collection_products`
--

LOCK TABLES `ec_product_collection_products` WRITE;
/*!40000 ALTER TABLE `ec_product_collection_products` DISABLE KEYS */;
INSERT INTO `ec_product_collection_products` VALUES (1,1),(1,7),(1,13),(1,19),(1,20),(1,22),(1,28),(1,30),(1,39),(1,40),(1,44),(1,54),(1,57),(2,2),(2,3),(2,4),(2,5),(2,6),(2,10),(2,11),(2,15),(2,21),(2,29),(2,34),(2,35),(2,36),(2,41),(2,51),(2,55),(2,56),(3,8),(3,12),(3,14),(3,16),(3,17),(3,18),(3,23),(3,25),(3,26),(3,27),(3,32),(3,38),(3,43),(3,45),(3,46),(3,48),(3,53),(4,9),(4,24),(4,31),(4,33),(4,37),(4,42),(4,47),(4,49),(4,50),(4,52);
/*!40000 ALTER TABLE `ec_product_collection_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections`
--

DROP TABLE IF EXISTS `ec_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections`
--

LOCK TABLES `ec_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_product_collections` DISABLE KEYS */;
INSERT INTO `ec_product_collections` VALUES (1,'Weekly Gadget Spotlight','weekly-gadget-spotlight',NULL,NULL,'published','2024-03-15 03:00:09','2024-03-15 03:00:09',0),(2,'Electronics Trendsetters','electronics-trendsetters',NULL,NULL,'published','2024-03-15 03:00:09','2024-03-15 03:00:09',0),(3,'Digital Workspace Gear','digital-workspace-gear',NULL,NULL,'published','2024-03-15 03:00:09','2024-03-15 03:00:09',0),(4,'Cutting-Edge Tech Showcase','cutting-edge-tech-showcase',NULL,NULL,'published','2024-03-15 03:00:09','2024-03-15 03:00:09',0);
/*!40000 ALTER TABLE `ec_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections_translations`
--

DROP TABLE IF EXISTS `ec_product_collections_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_collections_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_collections_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections_translations`
--

LOCK TABLES `ec_product_collections_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_collections_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_collections_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_cross_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_cross_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_cross_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  `is_variant` tinyint(1) NOT NULL DEFAULT '0',
  `price` decimal(15,2) DEFAULT '0.00',
  `price_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed',
  `apply_to_all_variations` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_cross_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_cross_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_cross_sale_relations`
--

LOCK TABLES `ec_product_cross_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` DISABLE KEYS */;
INSERT INTO `ec_product_cross_sale_relations` VALUES (1,8,0,0.00,'fixed',1),(1,9,0,0.00,'fixed',1),(1,10,0,0.00,'fixed',1),(1,12,0,0.00,'fixed',1),(1,16,0,0.00,'fixed',1),(1,18,0,0.00,'fixed',1),(1,19,0,0.00,'fixed',1),(2,1,0,0.00,'fixed',1),(2,5,0,0.00,'fixed',1),(2,7,0,0.00,'fixed',1),(2,9,0,0.00,'fixed',1),(2,12,0,0.00,'fixed',1),(2,14,0,0.00,'fixed',1),(2,15,0,0.00,'fixed',1),(3,1,0,0.00,'fixed',1),(3,5,0,0.00,'fixed',1),(3,7,0,0.00,'fixed',1),(3,11,0,0.00,'fixed',1),(3,14,0,0.00,'fixed',1),(3,16,0,0.00,'fixed',1),(4,7,0,0.00,'fixed',1),(4,9,0,0.00,'fixed',1),(4,11,0,0.00,'fixed',1),(4,13,0,0.00,'fixed',1),(4,16,0,0.00,'fixed',1),(4,20,0,0.00,'fixed',1),(5,2,0,0.00,'fixed',1),(5,3,0,0.00,'fixed',1),(5,7,0,0.00,'fixed',1),(5,14,0,0.00,'fixed',1),(5,15,0,0.00,'fixed',1),(5,18,0,0.00,'fixed',1),(5,19,0,0.00,'fixed',1),(6,1,0,0.00,'fixed',1),(6,4,0,0.00,'fixed',1),(6,9,0,0.00,'fixed',1),(6,16,0,0.00,'fixed',1),(6,19,0,0.00,'fixed',1),(6,20,0,0.00,'fixed',1),(7,2,0,0.00,'fixed',1),(7,6,0,0.00,'fixed',1),(7,9,0,0.00,'fixed',1),(7,13,0,0.00,'fixed',1),(7,15,0,0.00,'fixed',1),(7,20,0,0.00,'fixed',1),(8,2,0,0.00,'fixed',1),(8,6,0,0.00,'fixed',1),(8,13,0,0.00,'fixed',1),(8,17,0,0.00,'fixed',1),(8,18,0,0.00,'fixed',1),(9,15,0,0.00,'fixed',1),(9,16,0,0.00,'fixed',1),(9,18,0,0.00,'fixed',1),(9,19,0,0.00,'fixed',1),(10,1,0,0.00,'fixed',1),(10,2,0,0.00,'fixed',1),(10,8,0,0.00,'fixed',1),(10,14,0,0.00,'fixed',1),(10,15,0,0.00,'fixed',1),(10,17,0,0.00,'fixed',1),(11,12,0,0.00,'fixed',1),(11,17,0,0.00,'fixed',1),(11,18,0,0.00,'fixed',1),(11,19,0,0.00,'fixed',1),(11,20,0,0.00,'fixed',1),(12,4,0,0.00,'fixed',1),(12,5,0,0.00,'fixed',1),(12,10,0,0.00,'fixed',1),(12,11,0,0.00,'fixed',1),(12,13,0,0.00,'fixed',1),(12,18,0,0.00,'fixed',1),(13,1,0,0.00,'fixed',1),(13,6,0,0.00,'fixed',1),(13,7,0,0.00,'fixed',1),(13,9,0,0.00,'fixed',1),(13,12,0,0.00,'fixed',1),(13,19,0,0.00,'fixed',1),(13,20,0,0.00,'fixed',1),(14,2,0,0.00,'fixed',1),(14,6,0,0.00,'fixed',1),(14,7,0,0.00,'fixed',1),(14,10,0,0.00,'fixed',1),(14,13,0,0.00,'fixed',1),(14,19,0,0.00,'fixed',1),(15,5,0,0.00,'fixed',1),(15,6,0,0.00,'fixed',1),(15,11,0,0.00,'fixed',1),(15,17,0,0.00,'fixed',1),(16,1,0,0.00,'fixed',1),(16,5,0,0.00,'fixed',1),(16,7,0,0.00,'fixed',1),(16,8,0,0.00,'fixed',1),(16,9,0,0.00,'fixed',1),(16,12,0,0.00,'fixed',1),(16,15,0,0.00,'fixed',1),(17,2,0,0.00,'fixed',1),(17,4,0,0.00,'fixed',1),(17,9,0,0.00,'fixed',1),(17,13,0,0.00,'fixed',1),(17,15,0,0.00,'fixed',1),(17,18,0,0.00,'fixed',1),(18,5,0,0.00,'fixed',1),(18,6,0,0.00,'fixed',1),(18,7,0,0.00,'fixed',1),(18,8,0,0.00,'fixed',1),(18,14,0,0.00,'fixed',1),(18,16,0,0.00,'fixed',1),(19,1,0,0.00,'fixed',1),(19,2,0,0.00,'fixed',1),(19,9,0,0.00,'fixed',1),(19,10,0,0.00,'fixed',1),(19,15,0,0.00,'fixed',1),(19,17,0,0.00,'fixed',1),(20,7,0,0.00,'fixed',1),(20,9,0,0.00,'fixed',1),(20,10,0,0.00,'fixed',1),(20,11,0,0.00,'fixed',1),(20,12,0,0.00,'fixed',1),(20,15,0,0.00,'fixed',1),(20,17,0,0.00,'fixed',1),(21,3,0,0.00,'fixed',1),(21,5,0,0.00,'fixed',1),(21,6,0,0.00,'fixed',1),(21,7,0,0.00,'fixed',1),(21,12,0,0.00,'fixed',1),(21,15,0,0.00,'fixed',1),(21,17,0,0.00,'fixed',1),(22,1,0,0.00,'fixed',1),(22,6,0,0.00,'fixed',1),(22,8,0,0.00,'fixed',1),(22,13,0,0.00,'fixed',1),(22,15,0,0.00,'fixed',1),(22,16,0,0.00,'fixed',1),(22,19,0,0.00,'fixed',1),(23,4,0,0.00,'fixed',1),(23,6,0,0.00,'fixed',1),(23,8,0,0.00,'fixed',1),(23,10,0,0.00,'fixed',1),(23,15,0,0.00,'fixed',1),(23,17,0,0.00,'fixed',1),(23,19,0,0.00,'fixed',1),(24,4,0,0.00,'fixed',1),(24,5,0,0.00,'fixed',1),(24,7,0,0.00,'fixed',1),(24,10,0,0.00,'fixed',1),(24,11,0,0.00,'fixed',1),(24,13,0,0.00,'fixed',1),(25,3,0,0.00,'fixed',1),(25,4,0,0.00,'fixed',1),(25,10,0,0.00,'fixed',1),(25,11,0,0.00,'fixed',1),(25,15,0,0.00,'fixed',1),(25,16,0,0.00,'fixed',1),(26,1,0,0.00,'fixed',1),(26,2,0,0.00,'fixed',1),(26,7,0,0.00,'fixed',1),(26,10,0,0.00,'fixed',1),(26,15,0,0.00,'fixed',1),(26,17,0,0.00,'fixed',1),(26,19,0,0.00,'fixed',1),(27,1,0,0.00,'fixed',1),(27,2,0,0.00,'fixed',1),(27,3,0,0.00,'fixed',1),(27,7,0,0.00,'fixed',1),(27,11,0,0.00,'fixed',1),(27,13,0,0.00,'fixed',1),(27,14,0,0.00,'fixed',1),(28,2,0,0.00,'fixed',1),(28,6,0,0.00,'fixed',1),(28,7,0,0.00,'fixed',1),(28,8,0,0.00,'fixed',1),(28,11,0,0.00,'fixed',1),(28,13,0,0.00,'fixed',1),(29,4,0,0.00,'fixed',1),(29,5,0,0.00,'fixed',1),(29,9,0,0.00,'fixed',1),(29,16,0,0.00,'fixed',1),(29,17,0,0.00,'fixed',1),(29,18,0,0.00,'fixed',1),(30,5,0,0.00,'fixed',1),(30,9,0,0.00,'fixed',1),(30,10,0,0.00,'fixed',1),(30,12,0,0.00,'fixed',1),(30,13,0,0.00,'fixed',1),(30,15,0,0.00,'fixed',1),(30,16,0,0.00,'fixed',1),(31,2,0,0.00,'fixed',1),(31,11,0,0.00,'fixed',1),(31,17,0,0.00,'fixed',1),(31,18,0,0.00,'fixed',1),(32,1,0,0.00,'fixed',1),(32,2,0,0.00,'fixed',1),(32,5,0,0.00,'fixed',1),(32,6,0,0.00,'fixed',1),(32,10,0,0.00,'fixed',1),(32,12,0,0.00,'fixed',1),(33,2,0,0.00,'fixed',1),(33,5,0,0.00,'fixed',1),(33,7,0,0.00,'fixed',1),(33,12,0,0.00,'fixed',1),(33,17,0,0.00,'fixed',1),(33,18,0,0.00,'fixed',1),(34,1,0,0.00,'fixed',1),(34,8,0,0.00,'fixed',1),(34,9,0,0.00,'fixed',1),(34,11,0,0.00,'fixed',1),(34,12,0,0.00,'fixed',1),(34,16,0,0.00,'fixed',1),(35,1,0,0.00,'fixed',1),(35,7,0,0.00,'fixed',1),(35,14,0,0.00,'fixed',1),(35,16,0,0.00,'fixed',1),(35,17,0,0.00,'fixed',1),(35,19,0,0.00,'fixed',1),(36,1,0,0.00,'fixed',1),(36,4,0,0.00,'fixed',1),(36,5,0,0.00,'fixed',1),(36,6,0,0.00,'fixed',1),(36,10,0,0.00,'fixed',1),(36,11,0,0.00,'fixed',1),(36,17,0,0.00,'fixed',1),(37,1,0,0.00,'fixed',1),(37,8,0,0.00,'fixed',1),(37,11,0,0.00,'fixed',1),(37,13,0,0.00,'fixed',1),(37,14,0,0.00,'fixed',1),(37,15,0,0.00,'fixed',1),(38,2,0,0.00,'fixed',1),(38,3,0,0.00,'fixed',1),(38,10,0,0.00,'fixed',1),(38,13,0,0.00,'fixed',1),(38,17,0,0.00,'fixed',1),(38,19,0,0.00,'fixed',1),(39,3,0,0.00,'fixed',1),(39,10,0,0.00,'fixed',1),(39,11,0,0.00,'fixed',1),(39,14,0,0.00,'fixed',1),(39,17,0,0.00,'fixed',1),(40,2,0,0.00,'fixed',1),(40,4,0,0.00,'fixed',1),(40,5,0,0.00,'fixed',1),(40,6,0,0.00,'fixed',1),(40,8,0,0.00,'fixed',1),(40,19,0,0.00,'fixed',1),(41,2,0,0.00,'fixed',1),(41,3,0,0.00,'fixed',1),(41,11,0,0.00,'fixed',1),(41,12,0,0.00,'fixed',1),(41,18,0,0.00,'fixed',1),(42,1,0,0.00,'fixed',1),(42,4,0,0.00,'fixed',1),(42,6,0,0.00,'fixed',1),(42,7,0,0.00,'fixed',1),(42,14,0,0.00,'fixed',1),(42,17,0,0.00,'fixed',1),(43,3,0,0.00,'fixed',1),(43,5,0,0.00,'fixed',1),(43,7,0,0.00,'fixed',1),(43,10,0,0.00,'fixed',1),(43,11,0,0.00,'fixed',1),(43,17,0,0.00,'fixed',1),(43,18,0,0.00,'fixed',1),(44,1,0,0.00,'fixed',1),(44,4,0,0.00,'fixed',1),(44,5,0,0.00,'fixed',1),(44,8,0,0.00,'fixed',1),(44,12,0,0.00,'fixed',1),(44,17,0,0.00,'fixed',1),(44,18,0,0.00,'fixed',1),(45,1,0,0.00,'fixed',1),(45,3,0,0.00,'fixed',1),(45,8,0,0.00,'fixed',1),(45,9,0,0.00,'fixed',1),(46,5,0,0.00,'fixed',1),(46,8,0,0.00,'fixed',1),(46,9,0,0.00,'fixed',1),(46,12,0,0.00,'fixed',1),(46,15,0,0.00,'fixed',1),(46,18,0,0.00,'fixed',1),(47,2,0,0.00,'fixed',1),(47,5,0,0.00,'fixed',1),(47,6,0,0.00,'fixed',1),(47,7,0,0.00,'fixed',1),(47,15,0,0.00,'fixed',1),(47,17,0,0.00,'fixed',1),(48,6,0,0.00,'fixed',1),(48,8,0,0.00,'fixed',1),(48,10,0,0.00,'fixed',1),(48,11,0,0.00,'fixed',1),(48,18,0,0.00,'fixed',1),(48,19,0,0.00,'fixed',1),(49,4,0,0.00,'fixed',1),(49,7,0,0.00,'fixed',1),(49,9,0,0.00,'fixed',1),(49,10,0,0.00,'fixed',1),(49,12,0,0.00,'fixed',1),(49,14,0,0.00,'fixed',1),(50,1,0,0.00,'fixed',1),(50,2,0,0.00,'fixed',1),(50,3,0,0.00,'fixed',1),(50,4,0,0.00,'fixed',1),(50,5,0,0.00,'fixed',1),(51,1,0,0.00,'fixed',1),(51,3,0,0.00,'fixed',1),(51,5,0,0.00,'fixed',1),(51,10,0,0.00,'fixed',1),(51,12,0,0.00,'fixed',1),(51,13,0,0.00,'fixed',1),(51,18,0,0.00,'fixed',1),(52,2,0,0.00,'fixed',1),(52,8,0,0.00,'fixed',1),(52,15,0,0.00,'fixed',1),(52,16,0,0.00,'fixed',1),(52,17,0,0.00,'fixed',1),(52,19,0,0.00,'fixed',1),(53,2,0,0.00,'fixed',1),(53,3,0,0.00,'fixed',1),(53,7,0,0.00,'fixed',1),(53,9,0,0.00,'fixed',1),(53,17,0,0.00,'fixed',1),(53,18,0,0.00,'fixed',1),(53,19,0,0.00,'fixed',1),(54,1,0,0.00,'fixed',1),(54,5,0,0.00,'fixed',1),(54,10,0,0.00,'fixed',1),(54,13,0,0.00,'fixed',1),(54,14,0,0.00,'fixed',1),(54,15,0,0.00,'fixed',1),(55,1,0,0.00,'fixed',1),(55,4,0,0.00,'fixed',1),(55,8,0,0.00,'fixed',1),(55,14,0,0.00,'fixed',1),(55,15,0,0.00,'fixed',1),(55,16,0,0.00,'fixed',1),(55,19,0,0.00,'fixed',1),(56,3,0,0.00,'fixed',1),(56,9,0,0.00,'fixed',1),(56,12,0,0.00,'fixed',1),(56,14,0,0.00,'fixed',1),(56,15,0,0.00,'fixed',1),(56,18,0,0.00,'fixed',1),(57,1,0,0.00,'fixed',1),(57,6,0,0.00,'fixed',1),(57,10,0,0.00,'fixed',1),(57,12,0,0.00,'fixed',1),(57,14,0,0.00,'fixed',1),(57,17,0,0.00,'fixed',1),(57,18,0,0.00,'fixed',1);
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_files`
--

DROP TABLE IF EXISTS `ec_product_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extras` mediumtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_files_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=194 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_files`
--

LOCK TABLES `ec_product_files` WRITE;
/*!40000 ALTER TABLE `ec_product_files` DISABLE KEYS */;
INSERT INTO `ec_product_files` VALUES (1,64,'product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(2,64,'product-files/product-11.jpg','{\"filename\":\"product-11.jpg\",\"url\":\"product-files\\/product-11.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-11\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(3,64,'product-files/product-15.jpg','{\"filename\":\"product-15.jpg\",\"url\":\"product-files\\/product-15.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-15\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(4,64,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(5,64,'product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(6,64,'product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(7,64,'product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(8,64,'product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(9,65,'product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(10,65,'product-files/product-11.jpg','{\"filename\":\"product-11.jpg\",\"url\":\"product-files\\/product-11.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-11\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(11,65,'product-files/product-15.jpg','{\"filename\":\"product-15.jpg\",\"url\":\"product-files\\/product-15.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-15\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(12,65,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(13,65,'product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(14,65,'product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(15,65,'product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(16,65,'product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(17,66,'product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(18,66,'product-files/product-11.jpg','{\"filename\":\"product-11.jpg\",\"url\":\"product-files\\/product-11.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-11\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(19,66,'product-files/product-15.jpg','{\"filename\":\"product-15.jpg\",\"url\":\"product-files\\/product-15.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-15\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(20,66,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(21,66,'product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(22,66,'product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(23,66,'product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(24,66,'product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:19\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2024-03-15 03:00:19','2024-03-15 03:00:19'),(25,78,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(26,78,'product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(27,78,'product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(28,78,'product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(29,78,'product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(30,78,'product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(31,78,'product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(32,79,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(33,79,'product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(34,79,'product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(35,79,'product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(36,79,'product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(37,79,'product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(38,79,'product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(39,80,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(40,80,'product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(41,80,'product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(42,80,'product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(43,80,'product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(44,80,'product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(45,80,'product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(46,81,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(47,81,'product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(48,81,'product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(49,81,'product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(50,81,'product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(51,81,'product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(52,81,'product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:20\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2024-03-15 03:00:20','2024-03-15 03:00:20'),(53,86,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(54,86,'product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(55,86,'product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(56,86,'product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(57,86,'product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(58,86,'product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(59,86,'product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(60,87,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(61,87,'product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(62,87,'product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(63,87,'product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(64,87,'product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(65,87,'product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(66,87,'product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(67,88,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(68,88,'product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(69,88,'product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(70,88,'product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(71,88,'product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(72,88,'product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(73,88,'product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(74,89,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(75,89,'product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(76,89,'product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(77,89,'product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(78,89,'product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(79,89,'product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(80,89,'product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(81,97,'product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(82,97,'product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(83,97,'product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(84,97,'product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(85,97,'product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(86,97,'product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:21\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2024-03-15 03:00:21','2024-03-15 03:00:21'),(87,98,'product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(88,98,'product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(89,98,'product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(90,98,'product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(91,98,'product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(92,98,'product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(93,99,'product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(94,99,'product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(95,99,'product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(96,99,'product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(97,99,'product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(98,99,'product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(99,100,'product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(100,100,'product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(101,100,'product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(102,100,'product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(103,100,'product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(104,100,'product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:22\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2024-03-15 03:00:22','2024-03-15 03:00:22'),(105,110,'product-files/product-details-desc-3.jpg','{\"filename\":\"product-details-desc-3.jpg\",\"url\":\"product-files\\/product-details-desc-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:23\",\"name\":\"product-details-desc-3\",\"extension\":\"jpg\"}','2024-03-15 03:00:23','2024-03-15 03:00:23'),(106,110,'product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:23\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2024-03-15 03:00:23','2024-03-15 03:00:23'),(107,110,'product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:23\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2024-03-15 03:00:23','2024-03-15 03:00:23'),(108,110,'product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:23\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2024-03-15 03:00:23','2024-03-15 03:00:23'),(109,110,'product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:23\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2024-03-15 03:00:23','2024-03-15 03:00:23'),(110,110,'product-files/product-3.jpg','{\"filename\":\"product-3.jpg\",\"url\":\"product-files\\/product-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:23\",\"name\":\"product-3\",\"extension\":\"jpg\"}','2024-03-15 03:00:23','2024-03-15 03:00:23'),(111,110,'product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:23\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2024-03-15 03:00:23','2024-03-15 03:00:23'),(112,121,'product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:23\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2024-03-15 03:00:23','2024-03-15 03:00:23'),(113,121,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:23\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:23','2024-03-15 03:00:23'),(114,121,'product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:23\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2024-03-15 03:00:23','2024-03-15 03:00:23'),(115,122,'product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:24\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2024-03-15 03:00:24','2024-03-15 03:00:24'),(116,122,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:24\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:24','2024-03-15 03:00:24'),(117,122,'product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:24\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2024-03-15 03:00:24','2024-03-15 03:00:24'),(118,132,'product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:24\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2024-03-15 03:00:24','2024-03-15 03:00:24'),(119,132,'product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:24\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2024-03-15 03:00:24','2024-03-15 03:00:24'),(120,132,'product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:24\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2024-03-15 03:00:24','2024-03-15 03:00:24'),(121,132,'product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:24\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2024-03-15 03:00:24','2024-03-15 03:00:24'),(122,132,'product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:24\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2024-03-15 03:00:24','2024-03-15 03:00:24'),(123,133,'product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:24\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2024-03-15 03:00:24','2024-03-15 03:00:24'),(124,133,'product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:24\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2024-03-15 03:00:24','2024-03-15 03:00:24'),(125,133,'product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:24\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2024-03-15 03:00:24','2024-03-15 03:00:24'),(126,133,'product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:24\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2024-03-15 03:00:24','2024-03-15 03:00:24'),(127,133,'product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:24\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2024-03-15 03:00:24','2024-03-15 03:00:24'),(128,144,'product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(129,144,'product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(130,144,'product-files/product-details-desc-2.jpg','{\"filename\":\"product-details-desc-2.jpg\",\"url\":\"product-files\\/product-details-desc-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-details-desc-2\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(131,144,'product-files/product-details-desc-3.jpg','{\"filename\":\"product-details-desc-3.jpg\",\"url\":\"product-files\\/product-details-desc-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-details-desc-3\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(132,145,'product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(133,145,'product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(134,145,'product-files/product-details-desc-2.jpg','{\"filename\":\"product-details-desc-2.jpg\",\"url\":\"product-files\\/product-details-desc-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-details-desc-2\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(135,145,'product-files/product-details-desc-3.jpg','{\"filename\":\"product-details-desc-3.jpg\",\"url\":\"product-files\\/product-details-desc-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-details-desc-3\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(136,157,'product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(137,157,'product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(138,157,'product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(139,158,'product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(140,158,'product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(141,158,'product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:25\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2024-03-15 03:00:25','2024-03-15 03:00:25'),(142,167,'product-files/product-3.jpg','{\"filename\":\"product-3.jpg\",\"url\":\"product-files\\/product-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-3\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(143,167,'product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(144,167,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(145,168,'product-files/product-3.jpg','{\"filename\":\"product-3.jpg\",\"url\":\"product-files\\/product-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-3\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(146,168,'product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(147,168,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(148,169,'product-files/product-3.jpg','{\"filename\":\"product-3.jpg\",\"url\":\"product-files\\/product-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-3\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(149,169,'product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(150,169,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(151,170,'product-files/product-3.jpg','{\"filename\":\"product-3.jpg\",\"url\":\"product-files\\/product-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-3\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(152,170,'product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(153,170,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(154,180,'product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(155,180,'product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(156,180,'product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(157,180,'product-files/product-details-desc-1.jpg','{\"filename\":\"product-details-desc-1.jpg\",\"url\":\"product-files\\/product-details-desc-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-details-desc-1\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(158,180,'product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:26\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2024-03-15 03:00:26','2024-03-15 03:00:26'),(159,188,'product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(160,188,'product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(161,188,'product-files/product-6.jpg','{\"filename\":\"product-6.jpg\",\"url\":\"product-files\\/product-6.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-6\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(162,188,'product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(163,188,'product-files/product-15.jpg','{\"filename\":\"product-15.jpg\",\"url\":\"product-files\\/product-15.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-15\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(164,189,'product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(165,189,'product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(166,189,'product-files/product-6.jpg','{\"filename\":\"product-6.jpg\",\"url\":\"product-files\\/product-6.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-6\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(167,189,'product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(168,189,'product-files/product-15.jpg','{\"filename\":\"product-15.jpg\",\"url\":\"product-files\\/product-15.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-15\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(169,201,'product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(170,201,'product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(171,201,'product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(172,202,'product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(173,202,'product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(174,202,'product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(175,203,'product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(176,203,'product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(177,203,'product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:27\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2024-03-15 03:00:27','2024-03-15 03:00:27'),(178,210,'product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(179,210,'product-files/product-details-desc-1.jpg','{\"filename\":\"product-details-desc-1.jpg\",\"url\":\"product-files\\/product-details-desc-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-details-desc-1\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(180,210,'product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(181,210,'product-files/product-11.jpg','{\"filename\":\"product-11.jpg\",\"url\":\"product-files\\/product-11.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-11\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(182,210,'product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(183,210,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(184,210,'product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(185,210,'product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(186,211,'product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(187,211,'product-files/product-details-desc-1.jpg','{\"filename\":\"product-details-desc-1.jpg\",\"url\":\"product-files\\/product-details-desc-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-details-desc-1\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(188,211,'product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(189,211,'product-files/product-11.jpg','{\"filename\":\"product-11.jpg\",\"url\":\"product-files\\/product-11.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-11\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(190,211,'product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(191,211,'product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(192,211,'product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28'),(193,211,'product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2024-03-15 10:00:28\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2024-03-15 03:00:28','2024-03-15 03:00:28');
/*!40000 ALTER TABLE `ec_product_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_label_products`
--

DROP TABLE IF EXISTS `ec_product_label_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_label_products` (
  `product_label_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_label_id`,`product_id`),
  KEY `ec_product_label_products_product_label_id_index` (`product_label_id`),
  KEY `ec_product_label_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_label_products`
--

LOCK TABLES `ec_product_label_products` WRITE;
/*!40000 ALTER TABLE `ec_product_label_products` DISABLE KEYS */;
INSERT INTO `ec_product_label_products` VALUES (1,9),(1,21),(1,36),(1,39),(1,42),(1,57),(2,3),(2,6),(2,18),(2,24),(2,48),(2,51),(3,12),(3,15),(3,27),(3,30),(3,33),(3,45),(3,54);
/*!40000 ALTER TABLE `ec_product_label_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels`
--

DROP TABLE IF EXISTS `ec_product_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels`
--

LOCK TABLES `ec_product_labels` WRITE;
/*!40000 ALTER TABLE `ec_product_labels` DISABLE KEYS */;
INSERT INTO `ec_product_labels` VALUES (1,'Hot','#cb4321','published','2024-03-15 02:59:56','2024-03-15 02:59:56'),(2,'New','#00c9a7','published','2024-03-15 02:59:56','2024-03-15 02:59:56'),(3,'Sale','#ba591d','published','2024-03-15 02:59:56','2024-03-15 02:59:56');
/*!40000 ALTER TABLE `ec_product_labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels_translations`
--

DROP TABLE IF EXISTS `ec_product_labels_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_labels_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_labels_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels_translations`
--

LOCK TABLES `ec_product_labels_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_labels_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_labels_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_related_relations`
--

DROP TABLE IF EXISTS `ec_product_related_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_related_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_related_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_related_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_related_relations`
--

LOCK TABLES `ec_product_related_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_related_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_related_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tag_product`
--

DROP TABLE IF EXISTS `ec_product_tag_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tag_product` (
  `product_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tag_id`),
  KEY `ec_product_tag_product_product_id_index` (`product_id`),
  KEY `ec_product_tag_product_tag_id_index` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tag_product`
--

LOCK TABLES `ec_product_tag_product` WRITE;
/*!40000 ALTER TABLE `ec_product_tag_product` DISABLE KEYS */;
INSERT INTO `ec_product_tag_product` VALUES (1,3),(1,5),(1,6),(2,1),(2,5),(2,6),(3,3),(3,4),(3,5),(4,3),(4,5),(4,6),(5,3),(5,4),(5,6),(6,1),(6,3),(6,5),(7,2),(7,3),(7,6),(8,1),(8,2),(8,6),(9,1),(9,5),(9,6),(10,2),(10,3),(10,5),(11,1),(11,3),(11,6),(12,2),(12,4),(12,6),(13,1),(13,5),(13,6),(14,2),(14,4),(14,5),(15,2),(15,3),(15,6),(16,2),(16,4),(16,6),(17,1),(17,3),(17,4),(18,3),(18,4),(18,5),(19,3),(19,4),(19,6),(20,1),(20,4),(20,5),(21,2),(21,3),(21,4),(22,1),(22,2),(22,5),(23,2),(23,3),(23,6),(24,2),(24,4),(24,5),(25,1),(25,2),(25,5),(26,1),(26,3),(26,5),(27,2),(27,3),(27,4),(28,1),(28,4),(28,5),(29,1),(29,3),(29,5),(30,1),(30,2),(30,6),(31,2),(31,5),(31,6),(32,1),(32,2),(32,4),(33,1),(33,3),(33,4),(34,2),(34,4),(34,5),(35,2),(35,4),(35,5),(36,4),(36,5),(36,6),(37,2),(37,3),(37,6),(38,2),(38,3),(38,5),(39,2),(39,3),(39,6),(40,1),(40,2),(40,3),(41,3),(41,4),(41,5),(42,4),(42,5),(42,6),(43,1),(43,2),(43,5),(44,2),(44,3),(44,5),(45,2),(45,5),(45,6),(46,1),(46,4),(46,5),(47,1),(47,3),(47,4),(48,1),(48,2),(48,3),(49,3),(49,5),(49,6),(50,1),(50,4),(50,5),(51,3),(51,4),(51,5),(52,1),(52,4),(52,5),(53,1),(53,2),(53,3),(54,1),(54,3),(54,5),(55,1),(55,2),(55,5),(56,3),(56,5),(56,6),(57,1),(57,4),(57,6);
/*!40000 ALTER TABLE `ec_product_tag_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags`
--

DROP TABLE IF EXISTS `ec_product_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags`
--

LOCK TABLES `ec_product_tags` WRITE;
/*!40000 ALTER TABLE `ec_product_tags` DISABLE KEYS */;
INSERT INTO `ec_product_tags` VALUES (1,'Electronic',NULL,'published','2024-03-15 03:00:00','2024-03-15 03:00:00'),(2,'Mobile',NULL,'published','2024-03-15 03:00:00','2024-03-15 03:00:00'),(3,'Iphone',NULL,'published','2024-03-15 03:00:00','2024-03-15 03:00:00'),(4,'Printer',NULL,'published','2024-03-15 03:00:00','2024-03-15 03:00:00'),(5,'Office',NULL,'published','2024-03-15 03:00:00','2024-03-15 03:00:00'),(6,'IT',NULL,'published','2024-03-15 03:00:00','2024-03-15 03:00:00');
/*!40000 ALTER TABLE `ec_product_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags_translations`
--

DROP TABLE IF EXISTS `ec_product_tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags_translations`
--

LOCK TABLES `ec_product_tags_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_up_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_up_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_up_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_up_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_up_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_up_sale_relations`
--

LOCK TABLES `ec_product_up_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variation_items`
--

DROP TABLE IF EXISTS `ec_product_variation_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variation_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_variation_index` (`attribute_id`,`variation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=313 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variation_items`
--

LOCK TABLES `ec_product_variation_items` WRITE;
/*!40000 ALTER TABLE `ec_product_variation_items` DISABLE KEYS */;
INSERT INTO `ec_product_variation_items` VALUES (3,1,2),(5,1,3),(13,1,7),(25,1,13),(59,1,30),(61,1,31),(69,1,35),(77,1,39),(81,1,41),(89,1,45),(93,1,47),(107,1,54),(119,1,60),(1,2,1),(15,2,8),(27,2,14),(47,2,24),(49,2,25),(51,2,26),(57,2,29),(63,2,32),(71,2,36),(83,2,42),(97,2,49),(105,2,53),(115,2,58),(7,3,4),(9,3,5),(21,3,11),(23,3,12),(35,3,18),(39,3,20),(41,3,21),(43,3,22),(53,3,27),(75,3,38),(85,3,43),(103,3,52),(109,3,55),(125,3,63),(11,4,6),(17,4,9),(31,4,16),(33,4,17),(37,4,19),(55,4,28),(79,4,40),(87,4,44),(91,4,46),(99,4,50),(101,4,51),(111,4,56),(19,5,10),(29,5,15),(45,5,23),(65,5,33),(67,5,34),(73,5,37),(95,5,48),(113,5,57),(117,5,59),(121,5,61),(123,5,62),(2,6,1),(16,6,8),(20,6,10),(22,6,11),(30,6,15),(34,6,17),(68,6,34),(72,6,36),(74,6,37),(82,6,41),(84,6,42),(96,6,48),(122,6,61),(8,7,4),(36,7,18),(38,7,19),(48,7,24),(54,7,27),(56,7,28),(70,7,35),(78,7,39),(80,7,40),(104,7,52),(4,8,2),(10,8,5),(12,8,6),(42,8,21),(44,8,22),(46,8,23),(58,8,29),(102,8,51),(106,8,53),(108,8,54),(110,8,55),(118,8,59),(6,9,3),(14,9,7),(26,9,13),(28,9,14),(32,9,16),(40,9,20),(50,9,25),(52,9,26),(60,9,30),(62,9,31),(88,9,44),(92,9,46),(98,9,49),(112,9,56),(116,9,58),(120,9,60),(124,9,62),(126,9,63),(18,10,9),(24,10,12),(64,10,32),(66,10,33),(76,10,38),(86,10,43),(90,10,45),(94,10,47),(100,10,50),(114,10,57),(129,11,65),(135,11,68),(141,11,71),(143,11,72),(159,11,80),(169,11,85),(175,11,88),(179,11,90),(187,11,94),(193,11,97),(199,11,100),(205,11,103),(215,11,108),(217,11,109),(221,11,111),(229,11,115),(243,11,122),(245,11,123),(251,11,126),(273,11,137),(285,11,143),(291,11,146),(305,11,153),(131,12,66),(149,12,75),(163,12,82),(167,12,84),(177,12,89),(183,12,92),(209,12,105),(227,12,114),(241,12,121),(247,12,124),(265,12,133),(275,12,138),(299,12,150),(309,12,155),(133,13,67),(139,13,70),(153,13,77),(155,13,78),(165,13,83),(171,13,86),(191,13,96),(195,13,98),(197,13,99),(201,13,101),(223,13,112),(225,13,113),(235,13,118),(237,13,119),(257,13,129),(287,13,144),(289,13,145),(293,13,147),(303,13,152),(127,14,64),(145,14,73),(151,14,76),(157,14,79),(173,14,87),(181,14,91),(185,14,93),(189,14,95),(203,14,102),(207,14,104),(211,14,106),(219,14,110),(249,14,125),(253,14,127),(259,14,130),(263,14,132),(267,14,134),(277,14,139),(283,14,142),(295,14,148),(307,14,154),(137,15,69),(147,15,74),(161,15,81),(213,15,107),(231,15,116),(233,15,117),(239,15,120),(255,15,128),(261,15,131),(269,15,135),(271,15,136),(279,15,140),(281,15,141),(297,15,149),(301,15,151),(311,15,156),(128,16,64),(142,16,71),(148,16,74),(150,16,75),(166,16,83),(178,16,89),(182,16,91),(186,16,93),(190,16,95),(200,16,100),(202,16,101),(212,16,106),(224,16,112),(240,16,120),(244,16,122),(246,16,123),(268,16,134),(270,16,135),(278,16,139),(286,16,143),(302,16,151),(304,16,152),(310,16,155),(130,17,65),(134,17,67),(136,17,68),(140,17,70),(160,17,80),(164,17,82),(184,17,92),(210,17,105),(222,17,111),(226,17,113),(234,17,117),(252,17,126),(254,17,127),(272,17,136),(298,17,149),(300,17,150),(152,18,76),(158,18,79),(162,18,81),(168,18,84),(172,18,86),(194,18,97),(238,18,119),(256,18,128),(258,18,129),(260,18,130),(264,18,132),(266,18,133),(280,18,140),(284,18,142),(294,18,147),(138,19,69),(146,19,73),(154,19,77),(174,19,87),(176,19,88),(188,19,94),(204,19,102),(208,19,104),(218,19,109),(228,19,114),(236,19,118),(242,19,121),(248,19,124),(262,19,131),(274,19,137),(276,19,138),(282,19,141),(290,19,145),(292,19,146),(296,19,148),(306,19,153),(308,19,154),(312,19,156),(132,20,66),(144,20,72),(156,20,78),(170,20,85),(180,20,90),(192,20,96),(196,20,98),(198,20,99),(206,20,103),(214,20,107),(216,20,108),(220,20,110),(230,20,115),(232,20,116),(250,20,125),(288,20,144);
/*!40000 ALTER TABLE `ec_product_variation_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variations`
--

DROP TABLE IF EXISTS `ec_product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `configurable_product_id` bigint unsigned NOT NULL,
  `is_default` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_variations_product_id_configurable_product_id_unique` (`product_id`,`configurable_product_id`),
  KEY `configurable_product_index` (`product_id`,`configurable_product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=157 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variations`
--

LOCK TABLES `ec_product_variations` WRITE;
/*!40000 ALTER TABLE `ec_product_variations` DISABLE KEYS */;
INSERT INTO `ec_product_variations` VALUES (1,58,1,1),(2,59,1,0),(3,60,2,1),(4,61,2,0),(5,62,3,1),(6,63,3,0),(7,64,4,1),(8,65,4,0),(9,66,4,0),(10,67,5,1),(11,68,5,0),(12,69,5,0),(13,70,5,0),(14,71,5,0),(15,72,6,1),(16,73,6,0),(17,74,6,0),(18,75,7,1),(19,76,7,0),(20,77,7,0),(21,78,8,1),(22,79,8,0),(23,80,8,0),(24,81,8,0),(25,82,9,1),(26,83,9,0),(27,84,10,1),(28,85,11,1),(29,86,12,1),(30,87,12,0),(31,88,12,0),(32,89,12,0),(33,90,13,1),(34,91,13,0),(35,92,14,1),(36,93,14,0),(37,94,15,1),(38,95,15,0),(39,96,15,0),(40,97,16,1),(41,98,16,0),(42,99,16,0),(43,100,16,0),(44,101,17,1),(45,102,17,0),(46,103,17,0),(47,104,18,1),(48,105,18,0),(49,106,18,0),(50,107,19,1),(51,108,19,0),(52,109,19,0),(53,110,20,1),(54,111,21,1),(55,112,21,0),(56,113,21,0),(57,114,21,0),(58,115,22,1),(59,116,22,0),(60,117,23,1),(61,118,23,0),(62,119,23,0),(63,120,23,0),(64,121,24,1),(65,122,24,0),(66,123,25,1),(67,124,25,0),(68,125,25,0),(69,126,26,1),(70,127,26,0),(71,128,26,0),(72,129,26,0),(73,130,27,1),(74,131,27,0),(75,132,28,1),(76,133,28,0),(77,134,29,1),(78,135,29,0),(79,136,29,0),(80,137,29,0),(81,138,30,1),(82,139,30,0),(83,140,30,0),(84,141,31,1),(85,142,31,0),(86,143,31,0),(87,144,32,1),(88,145,32,0),(89,146,33,1),(90,147,33,0),(91,148,34,1),(92,149,34,0),(93,150,34,0),(94,151,34,0),(95,152,35,1),(96,153,35,0),(97,154,35,0),(98,155,35,0),(99,156,35,0),(100,157,36,1),(101,158,36,0),(102,159,37,1),(103,160,37,0),(104,161,37,0),(105,162,38,1),(106,163,38,0),(107,164,38,0),(108,165,39,1),(109,166,39,0),(110,167,40,1),(111,168,40,0),(112,169,40,0),(113,170,40,0),(114,171,41,1),(115,172,41,0),(116,173,42,1),(117,174,42,0),(118,175,42,0),(119,176,42,0),(120,177,43,1),(121,178,43,0),(122,179,43,0),(123,180,44,1),(124,181,45,1),(125,182,45,0),(126,183,46,1),(127,184,46,0),(128,185,47,1),(129,186,47,0),(130,187,47,0),(131,188,48,1),(132,189,48,0),(133,190,49,1),(134,191,49,0),(135,192,49,0),(136,193,49,0),(137,194,50,1),(138,195,50,0),(139,196,50,0),(140,197,50,0),(141,198,51,1),(142,199,51,0),(143,200,51,0),(144,201,52,1),(145,202,52,0),(146,203,52,0),(147,204,53,1),(148,205,53,0),(149,206,54,1),(150,207,54,0),(151,208,55,1),(152,209,55,0),(153,210,56,1),(154,211,56,0),(155,212,57,1),(156,213,57,0);
/*!40000 ALTER TABLE `ec_product_variations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_views`
--

DROP TABLE IF EXISTS `ec_product_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `views` int NOT NULL DEFAULT '1',
  `date` date NOT NULL DEFAULT '2024-03-15',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_views_product_id_date_unique` (`product_id`,`date`),
  KEY `ec_product_views_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_views`
--

LOCK TABLES `ec_product_views` WRITE;
/*!40000 ALTER TABLE `ec_product_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_with_attribute_set`
--

DROP TABLE IF EXISTS `ec_product_with_attribute_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_with_attribute_set` (
  `attribute_set_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`attribute_set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_with_attribute_set`
--

LOCK TABLES `ec_product_with_attribute_set` WRITE;
/*!40000 ALTER TABLE `ec_product_with_attribute_set` DISABLE KEYS */;
INSERT INTO `ec_product_with_attribute_set` VALUES (1,1,0),(2,1,0),(1,2,0),(2,2,0),(1,3,0),(2,3,0),(1,4,0),(2,4,0),(1,5,0),(2,5,0),(1,6,0),(2,6,0),(1,7,0),(2,7,0),(1,8,0),(2,8,0),(1,9,0),(2,9,0),(1,10,0),(2,10,0),(1,11,0),(2,11,0),(1,12,0),(2,12,0),(1,13,0),(2,13,0),(1,14,0),(2,14,0),(1,15,0),(2,15,0),(1,16,0),(2,16,0),(1,17,0),(2,17,0),(1,18,0),(2,18,0),(1,19,0),(2,19,0),(1,20,0),(2,20,0),(1,21,0),(2,21,0),(1,22,0),(2,22,0),(1,23,0),(2,23,0),(3,24,0),(4,24,0),(3,25,0),(4,25,0),(3,26,0),(4,26,0),(3,27,0),(4,27,0),(3,28,0),(4,28,0),(3,29,0),(4,29,0),(3,30,0),(4,30,0),(3,31,0),(4,31,0),(3,32,0),(4,32,0),(3,33,0),(4,33,0),(3,34,0),(4,34,0),(3,35,0),(4,35,0),(3,36,0),(4,36,0),(3,37,0),(4,37,0),(3,38,0),(4,38,0),(3,39,0),(4,39,0),(3,40,0),(4,40,0),(3,41,0),(4,41,0),(3,42,0),(4,42,0),(3,43,0),(4,43,0),(3,44,0),(4,44,0),(3,45,0),(4,45,0),(3,46,0),(4,46,0),(3,47,0),(4,47,0),(3,48,0),(4,48,0),(3,49,0),(4,49,0),(3,50,0),(4,50,0),(3,51,0),(4,51,0),(3,52,0),(4,52,0),(3,53,0),(4,53,0),(3,54,0),(4,54,0),(3,55,0),(4,55,0),(3,56,0),(4,56,0),(3,57,0),(4,57,0);
/*!40000 ALTER TABLE `ec_product_with_attribute_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products`
--

DROP TABLE IF EXISTS `ec_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `images` text COLLATE utf8mb4_unicode_ci,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `quantity` int unsigned DEFAULT NULL,
  `allow_checkout_when_out_of_stock` tinyint unsigned NOT NULL DEFAULT '0',
  `with_storehouse_management` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `brand_id` bigint unsigned DEFAULT NULL,
  `is_variation` tinyint NOT NULL DEFAULT '0',
  `sale_type` tinyint NOT NULL DEFAULT '0',
  `price` double unsigned DEFAULT NULL,
  `sale_price` double unsigned DEFAULT NULL,
  `start_date` timestamp NULL DEFAULT NULL,
  `end_date` timestamp NULL DEFAULT NULL,
  `length` double(8,2) DEFAULT NULL,
  `wide` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `weight` double(8,2) DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `views` bigint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `stock_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'in_stock',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_by_id` bigint unsigned DEFAULT '0',
  `created_by_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `approved_by` bigint unsigned DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'physical',
  `barcode` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost_per_item` double DEFAULT NULL,
  `generate_license_code` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ec_products_brand_id_status_is_variation_created_at_index` (`brand_id`,`status`,`is_variation`,`created_at`),
  KEY `sale_type_index` (`sale_type`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `sale_price_index` (`sale_price`),
  KEY `is_variation_index` (`is_variation`),
  KEY `ec_products_sku_index` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=214 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products`
--

LOCK TABLES `ec_products` WRITE;
/*!40000 ALTER TABLE `ec_products` DISABLE KEYS */;
INSERT INTO `ec_products` VALUES (1,'EcoTech Marine Radion XR30w G5 Pro LED Light Fixture','With this intelligent headset, you can stay connected and productive from the first call of the day to the last train home. With an ergonomic earcup design, this headset invented a brand-new dual-foam technology. You will be comfortable from the first call to the last thanks to the re-engineered leatherette ear cushion design that allows for better airflow.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-1.jpg\"]','D6-153-A0',0,20,0,1,1,3,0,0,344,NULL,NULL,NULL,16.00,13.00,16.00,866.00,NULL,171108,'2024-03-15 03:00:12','2024-03-15 03:00:19','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(2,'Philips Hue White and Color Ambiance A19 LED Smart Bulb','The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]','DM-188-A0',0,16,0,1,0,3,0,0,1731,NULL,NULL,NULL,13.00,13.00,11.00,684.00,NULL,177743,'2024-03-15 03:00:12','2024-03-15 03:00:19','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(3,'Samsung Galaxy Tab S7+ 12.4-Inch Android Tablet','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]','D9-163-A0',0,11,0,1,1,1,0,0,1274,NULL,NULL,NULL,12.00,12.00,11.00,833.00,NULL,136786,'2024-03-15 03:00:12','2024-03-15 03:00:19','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(4,'Apple MacBook Pro 16-Inch Laptop (Digital)','Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-1.jpg\"]','8P-173-A0',0,19,0,1,0,4,0,0,1345,1197.05,NULL,NULL,14.00,12.00,15.00,598.00,NULL,4590,'2024-03-15 03:00:12','2024-03-15 03:00:19','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(5,'Sony WH-1000XM4 Wireless Noise-Canceling Headphones','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]','AW-105-A0',0,20,0,1,0,3,0,0,1605,NULL,NULL,NULL,19.00,10.00,10.00,521.00,NULL,76661,'2024-03-15 03:00:12','2024-03-15 03:00:20','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(6,'DJI Mavic Air 2 Drone','Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-1.jpg\"]','NW-195-A0',0,11,0,1,1,4,0,0,2358,NULL,NULL,NULL,12.00,10.00,12.00,900.00,NULL,130093,'2024-03-15 03:00:12','2024-03-15 03:00:20','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(7,'GoPro HERO9 Black Action Camera','We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-14.jpg\"]','YX-108-A0',0,15,0,1,1,2,0,0,2049,NULL,NULL,NULL,18.00,12.00,14.00,729.00,NULL,133070,'2024-03-15 03:00:12','2024-03-15 03:00:20','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(8,'Bose SoundLink Revolve+ Portable Bluetooth Speaker (Digital)','Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-7.jpg\"]','HS-115-A0',0,17,0,1,0,5,0,0,1960,1764,NULL,NULL,15.00,20.00,13.00,876.00,NULL,109605,'2024-03-15 03:00:12','2024-03-15 03:00:20','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(9,'Nest Learning Thermostat (3rd Generation)','With this intelligent headset, you can stay connected and productive from the first call of the day to the last train home. With an ergonomic earcup design, this headset invented a brand-new dual-foam technology. You will be comfortable from the first call to the last thanks to the re-engineered leatherette ear cushion design that allows for better airflow.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]','B5-140-A0',0,18,0,1,0,4,0,0,2121,NULL,NULL,NULL,18.00,11.00,19.00,898.00,NULL,113303,'2024-03-15 03:00:12','2024-03-15 03:00:20','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(10,'Ring Video Doorbell Pro','With this intelligent headset, you can stay connected and productive from the first call of the day to the last train home. With an ergonomic earcup design, this headset invented a brand-new dual-foam technology. You will be comfortable from the first call to the last thanks to the re-engineered leatherette ear cushion design that allows for better airflow.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]','XS-126-A0',0,18,0,1,1,3,0,0,2355,NULL,NULL,NULL,10.00,12.00,11.00,790.00,NULL,8929,'2024-03-15 03:00:12','2024-03-15 03:00:20','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(11,'Amazon Echo Show 10 (3rd Gen)','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]','0T-159-A0',0,18,0,1,1,5,0,0,2036,NULL,NULL,NULL,17.00,18.00,14.00,500.00,NULL,169296,'2024-03-15 03:00:12','2024-03-15 03:00:20','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(12,'Samsung QN90A Neo QLED 4K Smart TV (Digital)','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\"]','ZQ-172-A0',0,11,0,1,1,3,0,0,2424,1818,NULL,NULL,19.00,11.00,16.00,849.00,NULL,128587,'2024-03-15 03:00:12','2024-03-15 03:00:21','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(13,'LG OLED C1 Series 4K Smart TV','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-13.jpg\"]','MA-106-A0',0,17,0,1,0,2,0,0,1745,NULL,NULL,NULL,14.00,14.00,18.00,855.00,NULL,56756,'2024-03-15 03:00:12','2024-03-15 03:00:21','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(14,'Sony X950H 4K Ultra HD Smart LED TV','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\"]','I7-136-A0',0,15,0,1,1,1,0,0,757,NULL,NULL,NULL,16.00,10.00,19.00,851.00,NULL,94595,'2024-03-15 03:00:12','2024-03-15 03:00:21','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(15,'Apple Watch Series 7','We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-3.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-9.jpg\"]','14-156-A0',0,16,0,1,1,3,0,0,1020,NULL,NULL,NULL,11.00,15.00,16.00,900.00,NULL,92901,'2024-03-15 03:00:12','2024-03-15 03:00:21','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(16,'Fitbit Charge 5 Fitness Tracker (Digital)','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-13.jpg\"]','8E-178-A0',0,15,0,1,0,1,0,0,893,794.77,NULL,NULL,18.00,17.00,16.00,792.00,NULL,106471,'2024-03-15 03:00:12','2024-03-15 03:00:21','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(17,'Garmin Fenix 7X Sapphire Solar GPS Watch','Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]','UL-142-A0',0,10,0,1,1,2,0,0,2360,NULL,NULL,NULL,16.00,14.00,18.00,838.00,NULL,89309,'2024-03-15 03:00:12','2024-03-15 03:00:22','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(18,'Microsoft Surface Pro 8','We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\"]','2U-121-A0',0,20,0,1,1,5,0,0,1788,NULL,NULL,NULL,15.00,17.00,12.00,553.00,NULL,146743,'2024-03-15 03:00:12','2024-03-15 03:00:22','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(19,'Lenovo ThinkPad X1 Carbon Gen 9 Laptop','We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]','FB-138-A0',0,10,0,1,0,1,0,0,2394,NULL,NULL,NULL,10.00,16.00,13.00,521.00,NULL,34545,'2024-03-15 03:00:12','2024-03-15 03:00:23','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(20,'HP Spectre x360 14-Inch Convertible Laptop (Digital)','We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-details-desc-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\"]','7T-161-A0',0,20,0,1,1,2,0,0,2356,2002.6,NULL,NULL,16.00,19.00,17.00,662.00,NULL,186018,'2024-03-15 03:00:13','2024-03-15 03:00:23','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(21,'Razer Blade 15 Advanced Gaming Laptop','Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-10.jpg\"]','K7-170-A0',0,17,0,1,1,1,0,0,2272,NULL,NULL,NULL,14.00,17.00,19.00,559.00,NULL,166512,'2024-03-15 03:00:13','2024-03-15 03:00:23','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(22,'Alienware m15 R6 Gaming Laptop','Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-15.jpg\"]','ZA-128-A0',0,10,0,1,0,3,0,0,631,NULL,NULL,NULL,16.00,17.00,14.00,645.00,NULL,117786,'2024-03-15 03:00:13','2024-03-15 03:00:23','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(23,'Corsair K95 RGB Platinum XT Mechanical Gaming Keyboard','Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-2.jpg\"]','35-120-A0',0,18,0,1,1,5,0,0,1101,NULL,NULL,NULL,14.00,18.00,17.00,759.00,NULL,120341,'2024-03-15 03:00:13','2024-03-15 03:00:23','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(24,'Logitech G Pro X Superlight Wireless Gaming Mouse (Digital)','It complies with Microsoft\'s Open Office criteria and is specially tuned for outstanding conversations in open-plan workplaces and other loud environments when the microphone boom arm is lowered in Performance Mode','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]','FI-119-A0',0,10,0,1,0,5,0,0,511,413.91,NULL,NULL,14.00,11.00,10.00,706.00,NULL,31658,'2024-03-15 03:00:13','2024-03-15 03:00:23','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(25,'SteelSeries Arctis Pro Wireless Gaming Headset','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]','GO-147-A0',0,11,0,1,1,4,0,0,263,NULL,NULL,NULL,11.00,12.00,19.00,535.00,NULL,64489,'2024-03-15 03:00:13','2024-03-15 03:00:24','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(26,'Elgato Stream Deck XL','The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\"]','JV-167-A0',0,19,0,1,0,4,0,0,2040,NULL,NULL,NULL,17.00,10.00,20.00,759.00,NULL,165204,'2024-03-15 03:00:13','2024-03-15 03:00:24','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(27,'Nintendo Switch OLED Model','Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-15.jpg\"]','Q5-195-A0',0,19,0,1,0,3,0,0,399,NULL,NULL,NULL,14.00,20.00,10.00,681.00,NULL,85883,'2024-03-15 03:00:13','2024-03-15 03:00:24','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(28,'PlayStation 5 Console (Digital)','With this intelligent headset, you can stay connected and productive from the first call of the day to the last train home. With an ergonomic earcup design, this headset invented a brand-new dual-foam technology. You will be comfortable from the first call to the last thanks to the re-engineered leatherette ear cushion design that allows for better airflow.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-19.jpg\"]','KM-138-A0',0,20,0,1,0,3,0,0,2310,2079,NULL,NULL,13.00,15.00,15.00,823.00,NULL,121693,'2024-03-15 03:00:13','2024-03-15 03:00:24','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(29,'Xbox Series X Console','The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\"]','PJ-196-A0',0,11,0,1,0,5,0,0,2056,NULL,NULL,NULL,13.00,20.00,18.00,846.00,NULL,95562,'2024-03-15 03:00:13','2024-03-15 03:00:24','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(30,'Oculus Quest 2 VR Headset','It complies with Microsoft\'s Open Office criteria and is specially tuned for outstanding conversations in open-plan workplaces and other loud environments when the microphone boom arm is lowered in Performance Mode','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\"]','HQ-186-A0',0,17,0,1,1,1,0,0,1769,NULL,NULL,NULL,15.00,16.00,18.00,554.00,NULL,13490,'2024-03-15 03:00:13','2024-03-15 03:00:24','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(31,'HTC Vive Cosmos Elite VR Headset','The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-1.jpg\"]','8Q-195-A0',0,18,0,1,1,4,0,0,1454,NULL,NULL,NULL,11.00,17.00,11.00,883.00,NULL,187170,'2024-03-15 03:00:13','2024-03-15 03:00:25','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(32,'Samsung Odyssey G9 49-Inch Curved Gaming Monitor (Digital)','Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]','FD-181-A0',0,14,0,1,1,5,0,0,544,451.52,NULL,NULL,12.00,17.00,18.00,670.00,NULL,142721,'2024-03-15 03:00:13','2024-03-15 03:00:25','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(33,'LG UltraGear 27GN950-B 4K Gaming Monitor','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-16.jpg\"]','5R-159-A0',0,16,0,1,1,3,0,0,1096,NULL,NULL,NULL,11.00,13.00,13.00,589.00,NULL,13332,'2024-03-15 03:00:13','2024-03-15 03:00:25','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(34,'Acer Predator X38 Pbmiphzx 38-Inch Curved Gaming Monitor','We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-12.jpg\"]','MY-126-A0',0,11,0,1,0,5,0,0,1281,NULL,NULL,NULL,18.00,11.00,15.00,764.00,NULL,152669,'2024-03-15 03:00:13','2024-03-15 03:00:25','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(35,'ASUS ROG Swift PG279QM 27-Inch Gaming Monitor','We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-5.jpg\"]','JS-195-A0',0,20,0,1,0,3,0,0,1443,NULL,NULL,NULL,11.00,10.00,10.00,632.00,NULL,4764,'2024-03-15 03:00:13','2024-03-15 03:00:25','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(36,'BenQ EW3280U 32-Inch 4K HDR Entertainment Monitor (Digital)','With this intelligent headset, you can stay connected and productive from the first call of the day to the last train home. With an ergonomic earcup design, this headset invented a brand-new dual-foam technology. You will be comfortable from the first call to the last thanks to the re-engineered leatherette ear cushion design that allows for better airflow.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-1.jpg\"]','Z2-109-A0',0,10,0,1,1,1,0,0,1518,1077.78,NULL,NULL,17.00,15.00,11.00,565.00,NULL,20200,'2024-03-15 03:00:13','2024-03-15 03:00:25','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(37,'Dell UltraSharp U2720Q 27-Inch 4K USB-C Monitor','The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\"]','EV-148-A0',0,12,0,1,0,3,0,0,1278,NULL,NULL,NULL,17.00,10.00,13.00,576.00,NULL,146018,'2024-03-15 03:00:13','2024-03-15 03:00:25','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(38,'HP Z27k G3 4K USB-C Monitor','Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-11.jpg\"]','LN-163-A0',0,11,0,1,1,1,0,0,1578,NULL,NULL,NULL,11.00,11.00,14.00,515.00,NULL,130488,'2024-03-15 03:00:14','2024-03-15 03:00:25','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(39,'LG 27UK850-W 27-Inch 4K UHD IPS Monitor','The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\",\"main\\/products\\/product-14.jpg\"]','SS-163-A0',0,13,0,1,1,4,0,0,1928,NULL,NULL,NULL,11.00,19.00,12.00,730.00,NULL,41489,'2024-03-15 03:00:14','2024-03-15 03:00:26','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(40,'Samsung Odyssey G7 32-Inch Curved Gaming Monitor (Digital)','Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-8.jpg\"]','WP-103-A0',0,12,0,1,0,5,0,0,1216,997.12,NULL,NULL,20.00,19.00,17.00,736.00,NULL,35686,'2024-03-15 03:00:14','2024-03-15 03:00:26','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(41,'Sony X900H 4K Ultra HD Smart LED TV','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-6.jpg\"]','PY-109-A0',0,17,0,1,0,2,0,0,1609,NULL,NULL,NULL,20.00,19.00,19.00,518.00,NULL,65723,'2024-03-15 03:00:14','2024-03-15 03:00:26','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(42,'TCL 6-Series 4K UHD Dolby Vision HDR QLED Roku Smart TV','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-9.jpg\"]','FH-109-A0',0,18,0,1,1,1,0,0,1087,NULL,NULL,NULL,14.00,13.00,12.00,531.00,NULL,155167,'2024-03-15 03:00:14','2024-03-15 03:00:26','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(43,'Vizio OLED65-H1 65-Inch 4K OLED Smart TV','We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-10.jpg\"]','EC-152-A0',0,15,0,1,0,5,0,0,439,NULL,NULL,NULL,17.00,15.00,19.00,879.00,NULL,96131,'2024-03-15 03:00:14','2024-03-15 03:00:26','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(44,'Hisense U8G Quantum Series 4K ULED Android TV (Digital)','With this intelligent headset, you can stay connected and productive from the first call of the day to the last train home. With an ergonomic earcup design, this headset invented a brand-new dual-foam technology. You will be comfortable from the first call to the last thanks to the re-engineered leatherette ear cushion design that allows for better airflow.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-20.jpg\"]','VP-127-A0',0,16,0,1,0,2,0,0,1956,1427.88,NULL,NULL,19.00,16.00,20.00,806.00,NULL,60997,'2024-03-15 03:00:14','2024-03-15 03:00:26','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(45,'LG C1 Series 4K OLED Smart TV','Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]','KU-109-A0',0,17,0,1,0,4,0,0,2050,NULL,NULL,NULL,18.00,17.00,12.00,539.00,NULL,192380,'2024-03-15 03:00:14','2024-03-15 03:00:27','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(46,'Samsung QN85A Neo QLED 4K Smart TV','We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\"]','NM-110-A0',0,13,0,1,0,4,0,0,989,NULL,NULL,NULL,20.00,12.00,10.00,755.00,NULL,74740,'2024-03-15 03:00:14','2024-03-15 03:00:27','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(47,'Sony A90J 4K OLED Smart TV','With this intelligent headset, you can stay connected and productive from the first call of the day to the last train home. With an ergonomic earcup design, this headset invented a brand-new dual-foam technology. You will be comfortable from the first call to the last thanks to the re-engineered leatherette ear cushion design that allows for better airflow.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-3.jpg\",\"main\\/products\\/product-17.jpg\"]','PM-191-A0',0,15,0,1,0,1,0,0,1972,NULL,NULL,NULL,19.00,16.00,16.00,689.00,NULL,3179,'2024-03-15 03:00:14','2024-03-15 03:00:27','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(48,'Apple TV 4K (2nd Generation) (Digital)','We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]','WG-143-A0',0,17,0,1,1,3,0,0,906,679.5,NULL,NULL,18.00,12.00,18.00,569.00,NULL,166815,'2024-03-15 03:00:15','2024-03-15 03:00:27','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(49,'Roku Ultra 2020 Streaming Media Player','We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-6.jpg\"]','T3-161-A0',0,10,0,1,0,4,0,0,919,NULL,NULL,NULL,15.00,18.00,15.00,586.00,NULL,64795,'2024-03-15 03:00:15','2024-03-15 03:00:27','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(50,'Amazon Fire TV Stick 4K Max','The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-12.jpg\"]','YX-132-A0',0,18,0,1,1,4,0,0,1942,NULL,NULL,NULL,12.00,11.00,10.00,722.00,NULL,3759,'2024-03-15 03:00:16','2024-03-15 03:00:27','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(51,'Google Chromecast with Google TV','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]','PQ-100-A0',0,14,0,1,0,5,0,0,1088,NULL,NULL,NULL,20.00,13.00,10.00,760.00,NULL,157439,'2024-03-15 03:00:16','2024-03-15 03:00:27','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(52,'NVIDIA SHIELD TV Pro (Digital)','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-20.jpg\"]','KC-147-A0',0,13,0,1,1,4,0,0,2185,1595.05,NULL,NULL,16.00,12.00,16.00,511.00,NULL,50555,'2024-03-15 03:00:17','2024-03-15 03:00:27','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(53,'Sonos Beam Gen 2 Soundbar','Jabra Evolve2 75 USB-A MS Teams Stereo Headset The Jabra Evolve2 75 USB-A MS Teams Stereo Headset has replaced previous hybrid working standards. Industry-leading call quality thanks to top-notch audio engineering.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-13.jpg\"]','KW-195-A0',0,19,0,1,1,3,0,0,2148,NULL,NULL,NULL,10.00,12.00,10.00,516.00,NULL,186604,'2024-03-15 03:00:17','2024-03-15 03:00:27','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(54,'Bose Smart Soundbar 900','The headset also offers MS Teams Certifications and other features like Busylight, Calls controls, Voice guiding, and Wireless range (ft): Up to 100 feet. Best-in-class. Boom The most recent Jabra Evolve2 75 USB-A MS Teams Stereo Headset offers professional-grade call performance that leads the industry, yet Evolve2 75 wins best-in-class.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-2.jpg\"]','JK-179-A0',0,16,0,1,1,3,0,0,922,NULL,NULL,NULL,14.00,18.00,15.00,880.00,NULL,88244,'2024-03-15 03:00:17','2024-03-15 03:00:27','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(55,'JBL Bar 9.1 Soundbar with Dolby Atmos','Additionally, this includes a redesigned microphone boom arm that is 33 percent shorter than the Evolve 75 and offers the industry-leading call performance for which Jabra headsets are known.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]','UT-109-A0',0,16,0,1,1,4,0,0,832,NULL,NULL,NULL,18.00,13.00,15.00,774.00,NULL,95001,'2024-03-15 03:00:18','2024-03-15 03:00:28','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(56,'Sennheiser Ambeo Soundbar (Digital)','We can provide exceptional noise isolation and the best all-day comfort by mixing firm foam for the outer with soft foam for the interior of the ear cushions. So that you may receive Active Noise-Cancellation (ANC) performance that is even greater in a headset that you can wear for whatever length you wish.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-9.jpg\"]','K2-193-A0',0,14,0,1,0,4,0,0,431,370.66,NULL,NULL,19.00,15.00,11.00,754.00,NULL,159422,'2024-03-15 03:00:18','2024-03-15 03:00:28','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(57,'Sony HT-A9 Home Theater System','It complies with Microsoft\'s Open Office criteria and is specially tuned for outstanding conversations in open-plan workplaces and other loud environments when the microphone boom arm is lowered in Performance Mode','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"main\\/products\\/product-details-desc-3.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-7.jpg\"]','UF-174-A0',0,20,0,1,0,4,0,0,296,NULL,NULL,NULL,11.00,16.00,18.00,798.00,NULL,184148,'2024-03-15 03:00:19','2024-03-15 03:00:28','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(58,'EcoTech Marine Radion XR30w G5 Pro LED Light Fixture',NULL,NULL,'published','[\"main\\/products\\/product-12.jpg\"]','D6-153-A0',0,20,0,1,0,3,1,0,344,NULL,NULL,NULL,16.00,13.00,16.00,866.00,NULL,0,'2024-03-15 03:00:19','2024-03-15 03:00:19','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(59,'EcoTech Marine Radion XR30w G5 Pro LED Light Fixture',NULL,NULL,'published','[\"main\\/products\\/product-16.jpg\"]','D6-153-A0-A1',0,20,0,1,0,3,1,0,344,NULL,NULL,NULL,16.00,13.00,16.00,866.00,NULL,0,'2024-03-15 03:00:19','2024-03-15 03:00:19','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(60,'Philips Hue White and Color Ambiance A19 LED Smart Bulb',NULL,NULL,'published','[\"main\\/products\\/product-6.jpg\"]','DM-188-A0',0,16,0,1,0,3,1,0,1731,NULL,NULL,NULL,13.00,13.00,11.00,684.00,NULL,0,'2024-03-15 03:00:19','2024-03-15 03:00:19','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(61,'Philips Hue White and Color Ambiance A19 LED Smart Bulb',NULL,NULL,'published','[\"main\\/products\\/product-10.jpg\"]','DM-188-A0-A1',0,16,0,1,0,3,1,0,1731,NULL,NULL,NULL,13.00,13.00,11.00,684.00,NULL,0,'2024-03-15 03:00:19','2024-03-15 03:00:19','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(62,'Samsung Galaxy Tab S7+ 12.4-Inch Android Tablet',NULL,NULL,'published','[\"main\\/products\\/product-1.jpg\"]','D9-163-A0',0,11,0,1,0,1,1,0,1274,NULL,NULL,NULL,12.00,12.00,11.00,833.00,NULL,0,'2024-03-15 03:00:19','2024-03-15 03:00:19','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(63,'Samsung Galaxy Tab S7+ 12.4-Inch Android Tablet',NULL,NULL,'published','[\"main\\/products\\/product-12.jpg\"]','D9-163-A0-A1',0,11,0,1,0,1,1,0,1274,NULL,NULL,NULL,12.00,12.00,11.00,833.00,NULL,0,'2024-03-15 03:00:19','2024-03-15 03:00:19','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(64,'Apple MacBook Pro 16-Inch Laptop (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-16.jpg\"]','8P-173-A0',0,19,0,1,0,4,1,0,1345,1197.05,NULL,NULL,14.00,12.00,15.00,598.00,NULL,0,'2024-03-15 03:00:19','2024-03-15 03:00:19','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(65,'Apple MacBook Pro 16-Inch Laptop (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-11.jpg\"]','8P-173-A0-A1',0,19,0,1,0,4,1,0,1345,1210.5,NULL,NULL,14.00,12.00,15.00,598.00,NULL,0,'2024-03-15 03:00:19','2024-03-15 03:00:19','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(66,'Apple MacBook Pro 16-Inch Laptop (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-15.jpg\"]','8P-173-A0-A2',0,19,0,1,0,4,1,0,1345,968.4,NULL,NULL,14.00,12.00,15.00,598.00,NULL,0,'2024-03-15 03:00:19','2024-03-15 03:00:19','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(67,'Sony WH-1000XM4 Wireless Noise-Canceling Headphones',NULL,NULL,'published','[\"main\\/products\\/product-11.jpg\"]','AW-105-A0',0,20,0,1,0,3,1,0,1605,NULL,NULL,NULL,19.00,10.00,10.00,521.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(68,'Sony WH-1000XM4 Wireless Noise-Canceling Headphones',NULL,NULL,'published','[\"main\\/products\\/product-7.jpg\"]','AW-105-A0-A1',0,20,0,1,0,3,1,0,1605,NULL,NULL,NULL,19.00,10.00,10.00,521.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(69,'Sony WH-1000XM4 Wireless Noise-Canceling Headphones',NULL,NULL,'published','[\"main\\/products\\/product-17.jpg\"]','AW-105-A0-A2',0,20,0,1,0,3,1,0,1605,NULL,NULL,NULL,19.00,10.00,10.00,521.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(70,'Sony WH-1000XM4 Wireless Noise-Canceling Headphones',NULL,NULL,'published','[\"main\\/products\\/product-18.jpg\"]','AW-105-A0-A3',0,20,0,1,0,3,1,0,1605,NULL,NULL,NULL,19.00,10.00,10.00,521.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(71,'Sony WH-1000XM4 Wireless Noise-Canceling Headphones',NULL,NULL,'published','[\"main\\/products\\/product-11.jpg\"]','AW-105-A0-A4',0,20,0,1,0,3,1,0,1605,NULL,NULL,NULL,19.00,10.00,10.00,521.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(72,'DJI Mavic Air 2 Drone',NULL,NULL,'published','[\"main\\/products\\/product-14.jpg\"]','NW-195-A0',0,11,0,1,0,4,1,0,2358,NULL,NULL,NULL,12.00,10.00,12.00,900.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(73,'DJI Mavic Air 2 Drone',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-2.jpg\"]','NW-195-A0-A1',0,11,0,1,0,4,1,0,2358,NULL,NULL,NULL,12.00,10.00,12.00,900.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(74,'DJI Mavic Air 2 Drone',NULL,NULL,'published','[\"main\\/products\\/product-17.jpg\"]','NW-195-A0-A2',0,11,0,1,0,4,1,0,2358,NULL,NULL,NULL,12.00,10.00,12.00,900.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(75,'GoPro HERO9 Black Action Camera',NULL,NULL,'published','[\"main\\/products\\/product-13.jpg\"]','YX-108-A0',0,15,0,1,0,2,1,0,2049,NULL,NULL,NULL,18.00,12.00,14.00,729.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(76,'GoPro HERO9 Black Action Camera',NULL,NULL,'published','[\"main\\/products\\/product-20.jpg\"]','YX-108-A0-A1',0,15,0,1,0,2,1,0,2049,NULL,NULL,NULL,18.00,12.00,14.00,729.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(77,'GoPro HERO9 Black Action Camera',NULL,NULL,'published','[\"main\\/products\\/product-14.jpg\"]','YX-108-A0-A2',0,15,0,1,0,2,1,0,2049,NULL,NULL,NULL,18.00,12.00,14.00,729.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(78,'Bose SoundLink Revolve+ Portable Bluetooth Speaker (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-8.jpg\"]','HS-115-A0',0,17,0,1,0,5,1,0,1960,1764,NULL,NULL,15.00,20.00,13.00,876.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(79,'Bose SoundLink Revolve+ Portable Bluetooth Speaker (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-12.jpg\"]','HS-115-A0-A1',0,17,0,1,0,5,1,0,1960,1450.4,NULL,NULL,15.00,20.00,13.00,876.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(80,'Bose SoundLink Revolve+ Portable Bluetooth Speaker (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-4.jpg\"]','HS-115-A0-A2',0,17,0,1,0,5,1,0,1960,1450.4,NULL,NULL,15.00,20.00,13.00,876.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(81,'Bose SoundLink Revolve+ Portable Bluetooth Speaker (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-5.jpg\"]','HS-115-A0-A3',0,17,0,1,0,5,1,0,1960,1646.4,NULL,NULL,15.00,20.00,13.00,876.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(82,'Nest Learning Thermostat (3rd Generation)',NULL,NULL,'published','[\"main\\/products\\/product-13.jpg\"]','B5-140-A0',0,18,0,1,0,4,1,0,2121,NULL,NULL,NULL,18.00,11.00,19.00,898.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(83,'Nest Learning Thermostat (3rd Generation)',NULL,NULL,'published','[\"main\\/products\\/product-5.jpg\"]','B5-140-A0-A1',0,18,0,1,0,4,1,0,2121,NULL,NULL,NULL,18.00,11.00,19.00,898.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(84,'Ring Video Doorbell Pro',NULL,NULL,'published','[\"main\\/products\\/product-14.jpg\"]','XS-126-A0',0,18,0,1,0,3,1,0,2355,NULL,NULL,NULL,10.00,12.00,11.00,790.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(85,'Amazon Echo Show 10 (3rd Gen)',NULL,NULL,'published','[\"main\\/products\\/product-6.jpg\"]','0T-159-A0',0,18,0,1,0,5,1,0,2036,NULL,NULL,NULL,17.00,18.00,14.00,500.00,NULL,0,'2024-03-15 03:00:20','2024-03-15 03:00:20','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(86,'Samsung QN90A Neo QLED 4K Smart TV (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-8.jpg\"]','ZQ-172-A0',0,11,0,1,0,3,1,0,2424,1818,NULL,NULL,19.00,11.00,16.00,849.00,NULL,0,'2024-03-15 03:00:21','2024-03-15 03:00:21','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(87,'Samsung QN90A Neo QLED 4K Smart TV (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-10.jpg\"]','ZQ-172-A0-A1',0,11,0,1,0,3,1,0,2424,2181.6,NULL,NULL,19.00,11.00,16.00,849.00,NULL,0,'2024-03-15 03:00:21','2024-03-15 03:00:21','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(88,'Samsung QN90A Neo QLED 4K Smart TV (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-19.jpg\"]','ZQ-172-A0-A2',0,11,0,1,0,3,1,0,2424,2036.16,NULL,NULL,19.00,11.00,16.00,849.00,NULL,0,'2024-03-15 03:00:21','2024-03-15 03:00:21','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(89,'Samsung QN90A Neo QLED 4K Smart TV (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-18.jpg\"]','ZQ-172-A0-A3',0,11,0,1,0,3,1,0,2424,1939.2,NULL,NULL,19.00,11.00,16.00,849.00,NULL,0,'2024-03-15 03:00:21','2024-03-15 03:00:21','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(90,'LG OLED C1 Series 4K Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-4.jpg\"]','MA-106-A0',0,17,0,1,0,2,1,0,1745,NULL,NULL,NULL,14.00,14.00,18.00,855.00,NULL,0,'2024-03-15 03:00:21','2024-03-15 03:00:21','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(91,'LG OLED C1 Series 4K Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-8.jpg\"]','MA-106-A0-A1',0,17,0,1,0,2,1,0,1745,NULL,NULL,NULL,14.00,14.00,18.00,855.00,NULL,0,'2024-03-15 03:00:21','2024-03-15 03:00:21','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(92,'Sony X950H 4K Ultra HD Smart LED TV',NULL,NULL,'published','[\"main\\/products\\/product-9.jpg\"]','I7-136-A0',0,15,0,1,0,1,1,0,757,NULL,NULL,NULL,16.00,10.00,19.00,851.00,NULL,0,'2024-03-15 03:00:21','2024-03-15 03:00:21','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(93,'Sony X950H 4K Ultra HD Smart LED TV',NULL,NULL,'published','[\"main\\/products\\/product-1.jpg\"]','I7-136-A0-A1',0,15,0,1,0,1,1,0,757,NULL,NULL,NULL,16.00,10.00,19.00,851.00,NULL,0,'2024-03-15 03:00:21','2024-03-15 03:00:21','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(94,'Apple Watch Series 7',NULL,NULL,'published','[\"main\\/products\\/product-7.jpg\"]','14-156-A0',0,16,0,1,0,3,1,0,1020,NULL,NULL,NULL,11.00,15.00,16.00,900.00,NULL,0,'2024-03-15 03:00:21','2024-03-15 03:00:21','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(95,'Apple Watch Series 7',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-3.jpg\"]','14-156-A0-A1',0,16,0,1,0,3,1,0,1020,NULL,NULL,NULL,11.00,15.00,16.00,900.00,NULL,0,'2024-03-15 03:00:21','2024-03-15 03:00:21','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(96,'Apple Watch Series 7',NULL,NULL,'published','[\"main\\/products\\/product-3.jpg\"]','14-156-A0-A2',0,16,0,1,0,3,1,0,1020,NULL,NULL,NULL,11.00,15.00,16.00,900.00,NULL,0,'2024-03-15 03:00:21','2024-03-15 03:00:21','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(97,'Fitbit Charge 5 Fitness Tracker (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-10.jpg\"]','8E-178-A0',0,15,0,1,0,1,1,0,893,794.77,NULL,NULL,18.00,17.00,16.00,792.00,NULL,0,'2024-03-15 03:00:21','2024-03-15 03:00:21','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(98,'Fitbit Charge 5 Fitness Tracker (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-18.jpg\"]','8E-178-A0-A1',0,15,0,1,0,1,1,0,893,642.96,NULL,NULL,18.00,17.00,16.00,792.00,NULL,0,'2024-03-15 03:00:21','2024-03-15 03:00:21','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(99,'Fitbit Charge 5 Fitness Tracker (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-17.jpg\"]','8E-178-A0-A2',0,15,0,1,0,1,1,0,893,642.96,NULL,NULL,18.00,17.00,16.00,792.00,NULL,0,'2024-03-15 03:00:22','2024-03-15 03:00:22','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(100,'Fitbit Charge 5 Fitness Tracker (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-20.jpg\"]','8E-178-A0-A3',0,15,0,1,0,1,1,0,893,803.7,NULL,NULL,18.00,17.00,16.00,792.00,NULL,0,'2024-03-15 03:00:22','2024-03-15 03:00:22','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(101,'Garmin Fenix 7X Sapphire Solar GPS Watch',NULL,NULL,'published','[\"main\\/products\\/product-17.jpg\"]','UL-142-A0',0,10,0,1,0,2,1,0,2360,NULL,NULL,NULL,16.00,14.00,18.00,838.00,NULL,0,'2024-03-15 03:00:22','2024-03-15 03:00:22','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(102,'Garmin Fenix 7X Sapphire Solar GPS Watch',NULL,NULL,'published','[\"main\\/products\\/product-15.jpg\"]','UL-142-A0-A1',0,10,0,1,0,2,1,0,2360,NULL,NULL,NULL,16.00,14.00,18.00,838.00,NULL,0,'2024-03-15 03:00:22','2024-03-15 03:00:22','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(103,'Garmin Fenix 7X Sapphire Solar GPS Watch',NULL,NULL,'published','[\"main\\/products\\/product-8.jpg\"]','UL-142-A0-A2',0,10,0,1,0,2,1,0,2360,NULL,NULL,NULL,16.00,14.00,18.00,838.00,NULL,0,'2024-03-15 03:00:22','2024-03-15 03:00:22','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(104,'Microsoft Surface Pro 8',NULL,NULL,'published','[\"main\\/products\\/product-3.jpg\"]','2U-121-A0',0,20,0,1,0,5,1,0,1788,NULL,NULL,NULL,15.00,17.00,12.00,553.00,NULL,0,'2024-03-15 03:00:22','2024-03-15 03:00:22','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(105,'Microsoft Surface Pro 8',NULL,NULL,'published','[\"main\\/products\\/product-11.jpg\"]','2U-121-A0-A1',0,20,0,1,0,5,1,0,1788,NULL,NULL,NULL,15.00,17.00,12.00,553.00,NULL,0,'2024-03-15 03:00:22','2024-03-15 03:00:22','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(106,'Microsoft Surface Pro 8',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-2.jpg\"]','2U-121-A0-A2',0,20,0,1,0,5,1,0,1788,NULL,NULL,NULL,15.00,17.00,12.00,553.00,NULL,0,'2024-03-15 03:00:22','2024-03-15 03:00:22','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(107,'Lenovo ThinkPad X1 Carbon Gen 9 Laptop',NULL,NULL,'published','[\"main\\/products\\/product-3.jpg\"]','FB-138-A0',0,10,0,1,0,1,1,0,2394,NULL,NULL,NULL,10.00,16.00,13.00,521.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(108,'Lenovo ThinkPad X1 Carbon Gen 9 Laptop',NULL,NULL,'published','[\"main\\/products\\/product-14.jpg\"]','FB-138-A0-A1',0,10,0,1,0,1,1,0,2394,NULL,NULL,NULL,10.00,16.00,13.00,521.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(109,'Lenovo ThinkPad X1 Carbon Gen 9 Laptop',NULL,NULL,'published','[\"main\\/products\\/product-2.jpg\"]','FB-138-A0-A2',0,10,0,1,0,1,1,0,2394,NULL,NULL,NULL,10.00,16.00,13.00,521.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(110,'HP Spectre x360 14-Inch Convertible Laptop (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-3.jpg\"]','7T-161-A0',0,20,0,1,0,2,1,0,2356,2002.6,NULL,NULL,16.00,19.00,17.00,662.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(111,'Razer Blade 15 Advanced Gaming Laptop',NULL,NULL,'published','[\"main\\/products\\/product-5.jpg\"]','K7-170-A0',0,17,0,1,0,1,1,0,2272,NULL,NULL,NULL,14.00,17.00,19.00,559.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(112,'Razer Blade 15 Advanced Gaming Laptop',NULL,NULL,'published','[\"main\\/products\\/product-14.jpg\"]','K7-170-A0-A1',0,17,0,1,0,1,1,0,2272,NULL,NULL,NULL,14.00,17.00,19.00,559.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(113,'Razer Blade 15 Advanced Gaming Laptop',NULL,NULL,'published','[\"main\\/products\\/product-10.jpg\"]','K7-170-A0-A2',0,17,0,1,0,1,1,0,2272,NULL,NULL,NULL,14.00,17.00,19.00,559.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(114,'Razer Blade 15 Advanced Gaming Laptop',NULL,NULL,'published','[\"main\\/products\\/product-5.jpg\"]','K7-170-A0-A3',0,17,0,1,0,1,1,0,2272,NULL,NULL,NULL,14.00,17.00,19.00,559.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(115,'Alienware m15 R6 Gaming Laptop',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-1.jpg\"]','ZA-128-A0',0,10,0,1,0,3,1,0,631,NULL,NULL,NULL,16.00,17.00,14.00,645.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(116,'Alienware m15 R6 Gaming Laptop',NULL,NULL,'published','[\"main\\/products\\/product-2.jpg\"]','ZA-128-A0-A1',0,10,0,1,0,3,1,0,631,NULL,NULL,NULL,16.00,17.00,14.00,645.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(117,'Corsair K95 RGB Platinum XT Mechanical Gaming Keyboard',NULL,NULL,'published','[\"main\\/products\\/product-8.jpg\"]','35-120-A0',0,18,0,1,0,5,1,0,1101,NULL,NULL,NULL,14.00,18.00,17.00,759.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(118,'Corsair K95 RGB Platinum XT Mechanical Gaming Keyboard',NULL,NULL,'published','[\"main\\/products\\/product-18.jpg\"]','35-120-A0-A1',0,18,0,1,0,5,1,0,1101,NULL,NULL,NULL,14.00,18.00,17.00,759.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(119,'Corsair K95 RGB Platinum XT Mechanical Gaming Keyboard',NULL,NULL,'published','[\"main\\/products\\/product-19.jpg\"]','35-120-A0-A2',0,18,0,1,0,5,1,0,1101,NULL,NULL,NULL,14.00,18.00,17.00,759.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(120,'Corsair K95 RGB Platinum XT Mechanical Gaming Keyboard',NULL,NULL,'published','[\"main\\/products\\/product-17.jpg\"]','35-120-A0-A3',0,18,0,1,0,5,1,0,1101,NULL,NULL,NULL,14.00,18.00,17.00,759.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(121,'Logitech G Pro X Superlight Wireless Gaming Mouse (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-7.jpg\"]','FI-119-A0',0,10,0,1,0,5,1,0,511,413.91,NULL,NULL,14.00,11.00,10.00,706.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(122,'Logitech G Pro X Superlight Wireless Gaming Mouse (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-8.jpg\"]','FI-119-A0-A1',0,10,0,1,0,5,1,0,511,403.69,NULL,NULL,14.00,11.00,10.00,706.00,NULL,0,'2024-03-15 03:00:23','2024-03-15 03:00:23','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(123,'SteelSeries Arctis Pro Wireless Gaming Headset',NULL,NULL,'published','[\"main\\/products\\/product-17.jpg\"]','GO-147-A0',0,11,0,1,0,4,1,0,263,NULL,NULL,NULL,11.00,12.00,19.00,535.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(124,'SteelSeries Arctis Pro Wireless Gaming Headset',NULL,NULL,'published','[\"main\\/products\\/product-5.jpg\"]','GO-147-A0-A1',0,11,0,1,0,4,1,0,263,NULL,NULL,NULL,11.00,12.00,19.00,535.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(125,'SteelSeries Arctis Pro Wireless Gaming Headset',NULL,NULL,'published','[\"main\\/products\\/product-11.jpg\"]','GO-147-A0-A2',0,11,0,1,0,4,1,0,263,NULL,NULL,NULL,11.00,12.00,19.00,535.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(126,'Elgato Stream Deck XL',NULL,NULL,'published','[\"main\\/products\\/product-9.jpg\"]','JV-167-A0',0,19,0,1,0,4,1,0,2040,NULL,NULL,NULL,17.00,10.00,20.00,759.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(127,'Elgato Stream Deck XL',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-2.jpg\"]','JV-167-A0-A1',0,19,0,1,0,4,1,0,2040,NULL,NULL,NULL,17.00,10.00,20.00,759.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(128,'Elgato Stream Deck XL',NULL,NULL,'published','[\"main\\/products\\/product-8.jpg\"]','JV-167-A0-A2',0,19,0,1,0,4,1,0,2040,NULL,NULL,NULL,17.00,10.00,20.00,759.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(129,'Elgato Stream Deck XL',NULL,NULL,'published','[\"main\\/products\\/product-13.jpg\"]','JV-167-A0-A3',0,19,0,1,0,4,1,0,2040,NULL,NULL,NULL,17.00,10.00,20.00,759.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(130,'Nintendo Switch OLED Model',NULL,NULL,'published','[\"main\\/products\\/product-2.jpg\"]','Q5-195-A0',0,19,0,1,0,3,1,0,399,NULL,NULL,NULL,14.00,20.00,10.00,681.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(131,'Nintendo Switch OLED Model',NULL,NULL,'published','[\"main\\/products\\/product-16.jpg\"]','Q5-195-A0-A1',0,19,0,1,0,3,1,0,399,NULL,NULL,NULL,14.00,20.00,10.00,681.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(132,'PlayStation 5 Console (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-4.jpg\"]','KM-138-A0',0,20,0,1,0,3,1,0,2310,2079,NULL,NULL,13.00,15.00,15.00,823.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(133,'PlayStation 5 Console (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-9.jpg\"]','KM-138-A0-A1',0,20,0,1,0,3,1,0,2310,1617,NULL,NULL,13.00,15.00,15.00,823.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(134,'Xbox Series X Console',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-2.jpg\"]','PJ-196-A0',0,11,0,1,0,5,1,0,2056,NULL,NULL,NULL,13.00,20.00,18.00,846.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(135,'Xbox Series X Console',NULL,NULL,'published','[\"main\\/products\\/product-1.jpg\"]','PJ-196-A0-A1',0,11,0,1,0,5,1,0,2056,NULL,NULL,NULL,13.00,20.00,18.00,846.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(136,'Xbox Series X Console',NULL,NULL,'published','[\"main\\/products\\/product-15.jpg\"]','PJ-196-A0-A2',0,11,0,1,0,5,1,0,2056,NULL,NULL,NULL,13.00,20.00,18.00,846.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(137,'Xbox Series X Console',NULL,NULL,'published','[\"main\\/products\\/product-2.jpg\"]','PJ-196-A0-A3',0,11,0,1,0,5,1,0,2056,NULL,NULL,NULL,13.00,20.00,18.00,846.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(138,'Oculus Quest 2 VR Headset',NULL,NULL,'published','[\"main\\/products\\/product-6.jpg\"]','HQ-186-A0',0,17,0,1,0,1,1,0,1769,NULL,NULL,NULL,15.00,16.00,18.00,554.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(139,'Oculus Quest 2 VR Headset',NULL,NULL,'published','[\"main\\/products\\/product-4.jpg\"]','HQ-186-A0-A1',0,17,0,1,0,1,1,0,1769,NULL,NULL,NULL,15.00,16.00,18.00,554.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(140,'Oculus Quest 2 VR Headset',NULL,NULL,'published','[\"main\\/products\\/product-3.jpg\"]','HQ-186-A0-A2',0,17,0,1,0,1,1,0,1769,NULL,NULL,NULL,15.00,16.00,18.00,554.00,NULL,0,'2024-03-15 03:00:24','2024-03-15 03:00:24','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(141,'HTC Vive Cosmos Elite VR Headset',NULL,NULL,'published','[\"main\\/products\\/product-19.jpg\"]','8Q-195-A0',0,18,0,1,0,4,1,0,1454,NULL,NULL,NULL,11.00,17.00,11.00,883.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(142,'HTC Vive Cosmos Elite VR Headset',NULL,NULL,'published','[\"main\\/products\\/product-13.jpg\"]','8Q-195-A0-A1',0,18,0,1,0,4,1,0,1454,NULL,NULL,NULL,11.00,17.00,11.00,883.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(143,'HTC Vive Cosmos Elite VR Headset',NULL,NULL,'published','[\"main\\/products\\/product-1.jpg\"]','8Q-195-A0-A2',0,18,0,1,0,4,1,0,1454,NULL,NULL,NULL,11.00,17.00,11.00,883.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(144,'Samsung Odyssey G9 49-Inch Curved Gaming Monitor (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-1.jpg\"]','FD-181-A0',0,14,0,1,0,5,1,0,544,451.52,NULL,NULL,12.00,17.00,18.00,670.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(145,'Samsung Odyssey G9 49-Inch Curved Gaming Monitor (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-14.jpg\"]','FD-181-A0-A1',0,14,0,1,0,5,1,0,544,418.88,NULL,NULL,12.00,17.00,18.00,670.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(146,'LG UltraGear 27GN950-B 4K Gaming Monitor',NULL,NULL,'published','[\"main\\/products\\/product-2.jpg\"]','5R-159-A0',0,16,0,1,0,3,1,0,1096,NULL,NULL,NULL,11.00,13.00,13.00,589.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(147,'LG UltraGear 27GN950-B 4K Gaming Monitor',NULL,NULL,'published','[\"main\\/products\\/product-7.jpg\"]','5R-159-A0-A1',0,16,0,1,0,3,1,0,1096,NULL,NULL,NULL,11.00,13.00,13.00,589.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(148,'Acer Predator X38 Pbmiphzx 38-Inch Curved Gaming Monitor',NULL,NULL,'published','[\"main\\/products\\/product-19.jpg\"]','MY-126-A0',0,11,0,1,0,5,1,0,1281,NULL,NULL,NULL,18.00,11.00,15.00,764.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(149,'Acer Predator X38 Pbmiphzx 38-Inch Curved Gaming Monitor',NULL,NULL,'published','[\"main\\/products\\/product-9.jpg\"]','MY-126-A0-A1',0,11,0,1,0,5,1,0,1281,NULL,NULL,NULL,18.00,11.00,15.00,764.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(150,'Acer Predator X38 Pbmiphzx 38-Inch Curved Gaming Monitor',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-1.jpg\"]','MY-126-A0-A2',0,11,0,1,0,5,1,0,1281,NULL,NULL,NULL,18.00,11.00,15.00,764.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(151,'Acer Predator X38 Pbmiphzx 38-Inch Curved Gaming Monitor',NULL,NULL,'published','[\"main\\/products\\/product-18.jpg\"]','MY-126-A0-A3',0,11,0,1,0,5,1,0,1281,NULL,NULL,NULL,18.00,11.00,15.00,764.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(152,'ASUS ROG Swift PG279QM 27-Inch Gaming Monitor',NULL,NULL,'published','[\"main\\/products\\/product-15.jpg\"]','JS-195-A0',0,20,0,1,0,3,1,0,1443,NULL,NULL,NULL,11.00,10.00,10.00,632.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(153,'ASUS ROG Swift PG279QM 27-Inch Gaming Monitor',NULL,NULL,'published','[\"main\\/products\\/product-12.jpg\"]','JS-195-A0-A1',0,20,0,1,0,3,1,0,1443,NULL,NULL,NULL,11.00,10.00,10.00,632.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(154,'ASUS ROG Swift PG279QM 27-Inch Gaming Monitor',NULL,NULL,'published','[\"main\\/products\\/product-5.jpg\"]','JS-195-A0-A2',0,20,0,1,0,3,1,0,1443,NULL,NULL,NULL,11.00,10.00,10.00,632.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(155,'ASUS ROG Swift PG279QM 27-Inch Gaming Monitor',NULL,NULL,'published','[\"main\\/products\\/product-15.jpg\"]','JS-195-A0-A3',0,20,0,1,0,3,1,0,1443,NULL,NULL,NULL,11.00,10.00,10.00,632.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(156,'ASUS ROG Swift PG279QM 27-Inch Gaming Monitor',NULL,NULL,'published','[\"main\\/products\\/product-15.jpg\"]','JS-195-A0-A4',0,20,0,1,0,3,1,0,1443,NULL,NULL,NULL,11.00,10.00,10.00,632.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(157,'BenQ EW3280U 32-Inch 4K HDR Entertainment Monitor (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-5.jpg\"]','Z2-109-A0',0,10,0,1,0,1,1,0,1518,1077.78,NULL,NULL,17.00,15.00,11.00,565.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(158,'BenQ EW3280U 32-Inch 4K HDR Entertainment Monitor (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-13.jpg\"]','Z2-109-A0-A1',0,10,0,1,0,1,1,0,1518,1184.04,NULL,NULL,17.00,15.00,11.00,565.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(159,'Dell UltraSharp U2720Q 27-Inch 4K USB-C Monitor',NULL,NULL,'published','[\"main\\/products\\/product-1.jpg\"]','EV-148-A0',0,12,0,1,0,3,1,0,1278,NULL,NULL,NULL,17.00,10.00,13.00,576.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(160,'Dell UltraSharp U2720Q 27-Inch 4K USB-C Monitor',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-3.jpg\"]','EV-148-A0-A1',0,12,0,1,0,3,1,0,1278,NULL,NULL,NULL,17.00,10.00,13.00,576.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(161,'Dell UltraSharp U2720Q 27-Inch 4K USB-C Monitor',NULL,NULL,'published','[\"main\\/products\\/product-8.jpg\"]','EV-148-A0-A2',0,12,0,1,0,3,1,0,1278,NULL,NULL,NULL,17.00,10.00,13.00,576.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(162,'HP Z27k G3 4K USB-C Monitor',NULL,NULL,'published','[\"main\\/products\\/product-4.jpg\"]','LN-163-A0',0,11,0,1,0,1,1,0,1578,NULL,NULL,NULL,11.00,11.00,14.00,515.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(163,'HP Z27k G3 4K USB-C Monitor',NULL,NULL,'published','[\"main\\/products\\/product-15.jpg\"]','LN-163-A0-A1',0,11,0,1,0,1,1,0,1578,NULL,NULL,NULL,11.00,11.00,14.00,515.00,NULL,0,'2024-03-15 03:00:25','2024-03-15 03:00:25','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(164,'HP Z27k G3 4K USB-C Monitor',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-2.jpg\"]','LN-163-A0-A2',0,11,0,1,0,1,1,0,1578,NULL,NULL,NULL,11.00,11.00,14.00,515.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(165,'LG 27UK850-W 27-Inch 4K UHD IPS Monitor',NULL,NULL,'published','[\"main\\/products\\/product-10.jpg\"]','SS-163-A0',0,13,0,1,0,4,1,0,1928,NULL,NULL,NULL,11.00,19.00,12.00,730.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(166,'LG 27UK850-W 27-Inch 4K UHD IPS Monitor',NULL,NULL,'published','[\"main\\/products\\/product-19.jpg\"]','SS-163-A0-A1',0,13,0,1,0,4,1,0,1928,NULL,NULL,NULL,11.00,19.00,12.00,730.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(167,'Samsung Odyssey G7 32-Inch Curved Gaming Monitor (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-3.jpg\"]','WP-103-A0',0,12,0,1,0,5,1,0,1216,997.12,NULL,NULL,20.00,19.00,17.00,736.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(168,'Samsung Odyssey G7 32-Inch Curved Gaming Monitor (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-10.jpg\"]','WP-103-A0-A1',0,12,0,1,0,5,1,0,1216,899.84,NULL,NULL,20.00,19.00,17.00,736.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(169,'Samsung Odyssey G7 32-Inch Curved Gaming Monitor (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-8.jpg\"]','WP-103-A0-A2',0,12,0,1,0,5,1,0,1216,1094.4,NULL,NULL,20.00,19.00,17.00,736.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(170,'Samsung Odyssey G7 32-Inch Curved Gaming Monitor (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-3.jpg\"]','WP-103-A0-A3',0,12,0,1,0,5,1,0,1216,875.52,NULL,NULL,20.00,19.00,17.00,736.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(171,'Sony X900H 4K Ultra HD Smart LED TV',NULL,NULL,'published','[\"main\\/products\\/product-8.jpg\"]','PY-109-A0',0,17,0,1,0,2,1,0,1609,NULL,NULL,NULL,20.00,19.00,19.00,518.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(172,'Sony X900H 4K Ultra HD Smart LED TV',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-1.jpg\"]','PY-109-A0-A1',0,17,0,1,0,2,1,0,1609,NULL,NULL,NULL,20.00,19.00,19.00,518.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(173,'TCL 6-Series 4K UHD Dolby Vision HDR QLED Roku Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-13.jpg\"]','FH-109-A0',0,18,0,1,0,1,1,0,1087,NULL,NULL,NULL,14.00,13.00,12.00,531.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(174,'TCL 6-Series 4K UHD Dolby Vision HDR QLED Roku Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-17.jpg\"]','FH-109-A0-A1',0,18,0,1,0,1,1,0,1087,NULL,NULL,NULL,14.00,13.00,12.00,531.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(175,'TCL 6-Series 4K UHD Dolby Vision HDR QLED Roku Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-2.jpg\"]','FH-109-A0-A2',0,18,0,1,0,1,1,0,1087,NULL,NULL,NULL,14.00,13.00,12.00,531.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(176,'TCL 6-Series 4K UHD Dolby Vision HDR QLED Roku Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-6.jpg\"]','FH-109-A0-A3',0,18,0,1,0,1,1,0,1087,NULL,NULL,NULL,14.00,13.00,12.00,531.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(177,'Vizio OLED65-H1 65-Inch 4K OLED Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-1.jpg\"]','EC-152-A0',0,15,0,1,0,5,1,0,439,NULL,NULL,NULL,17.00,15.00,19.00,879.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(178,'Vizio OLED65-H1 65-Inch 4K OLED Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-16.jpg\"]','EC-152-A0-A1',0,15,0,1,0,5,1,0,439,NULL,NULL,NULL,17.00,15.00,19.00,879.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(179,'Vizio OLED65-H1 65-Inch 4K OLED Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-15.jpg\"]','EC-152-A0-A2',0,15,0,1,0,5,1,0,439,NULL,NULL,NULL,17.00,15.00,19.00,879.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(180,'Hisense U8G Quantum Series 4K ULED Android TV (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-13.jpg\"]','VP-127-A0',0,16,0,1,0,2,1,0,1956,1427.88,NULL,NULL,19.00,16.00,20.00,806.00,NULL,0,'2024-03-15 03:00:26','2024-03-15 03:00:26','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(181,'LG C1 Series 4K OLED Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-10.jpg\"]','KU-109-A0',0,17,0,1,0,4,1,0,2050,NULL,NULL,NULL,18.00,17.00,12.00,539.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(182,'LG C1 Series 4K OLED Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-6.jpg\"]','KU-109-A0-A1',0,17,0,1,0,4,1,0,2050,NULL,NULL,NULL,18.00,17.00,12.00,539.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(183,'Samsung QN85A Neo QLED 4K Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-12.jpg\"]','NM-110-A0',0,13,0,1,0,4,1,0,989,NULL,NULL,NULL,20.00,12.00,10.00,755.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(184,'Samsung QN85A Neo QLED 4K Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-3.jpg\"]','NM-110-A0-A1',0,13,0,1,0,4,1,0,989,NULL,NULL,NULL,20.00,12.00,10.00,755.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(185,'Sony A90J 4K OLED Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-18.jpg\"]','PM-191-A0',0,15,0,1,0,1,1,0,1972,NULL,NULL,NULL,19.00,16.00,16.00,689.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(186,'Sony A90J 4K OLED Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-3.jpg\"]','PM-191-A0-A1',0,15,0,1,0,1,1,0,1972,NULL,NULL,NULL,19.00,16.00,16.00,689.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(187,'Sony A90J 4K OLED Smart TV',NULL,NULL,'published','[\"main\\/products\\/product-2.jpg\"]','PM-191-A0-A2',0,15,0,1,0,1,1,0,1972,NULL,NULL,NULL,19.00,16.00,16.00,689.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(188,'Apple TV 4K (2nd Generation) (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-1.jpg\"]','WG-143-A0',0,17,0,1,0,3,1,0,906,679.5,NULL,NULL,18.00,12.00,18.00,569.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(189,'Apple TV 4K (2nd Generation) (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-18.jpg\"]','WG-143-A0-A1',0,17,0,1,0,3,1,0,906,679.5,NULL,NULL,18.00,12.00,18.00,569.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(190,'Roku Ultra 2020 Streaming Media Player',NULL,NULL,'published','[\"main\\/products\\/product-16.jpg\"]','T3-161-A0',0,10,0,1,0,4,1,0,919,NULL,NULL,NULL,15.00,18.00,15.00,586.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(191,'Roku Ultra 2020 Streaming Media Player',NULL,NULL,'published','[\"main\\/products\\/product-9.jpg\"]','T3-161-A0-A1',0,10,0,1,0,4,1,0,919,NULL,NULL,NULL,15.00,18.00,15.00,586.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(192,'Roku Ultra 2020 Streaming Media Player',NULL,NULL,'published','[\"main\\/products\\/product-12.jpg\"]','T3-161-A0-A2',0,10,0,1,0,4,1,0,919,NULL,NULL,NULL,15.00,18.00,15.00,586.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(193,'Roku Ultra 2020 Streaming Media Player',NULL,NULL,'published','[\"main\\/products\\/product-7.jpg\"]','T3-161-A0-A3',0,10,0,1,0,4,1,0,919,NULL,NULL,NULL,15.00,18.00,15.00,586.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(194,'Amazon Fire TV Stick 4K Max',NULL,NULL,'published','[\"main\\/products\\/product-7.jpg\"]','YX-132-A0',0,18,0,1,0,4,1,0,1942,NULL,NULL,NULL,12.00,11.00,10.00,722.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(195,'Amazon Fire TV Stick 4K Max',NULL,NULL,'published','[\"main\\/products\\/product-9.jpg\"]','YX-132-A0-A1',0,18,0,1,0,4,1,0,1942,NULL,NULL,NULL,12.00,11.00,10.00,722.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(196,'Amazon Fire TV Stick 4K Max',NULL,NULL,'published','[\"main\\/products\\/product-11.jpg\"]','YX-132-A0-A2',0,18,0,1,0,4,1,0,1942,NULL,NULL,NULL,12.00,11.00,10.00,722.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(197,'Amazon Fire TV Stick 4K Max',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-2.jpg\"]','YX-132-A0-A3',0,18,0,1,0,4,1,0,1942,NULL,NULL,NULL,12.00,11.00,10.00,722.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(198,'Google Chromecast with Google TV',NULL,NULL,'published','[\"main\\/products\\/product-15.jpg\"]','PQ-100-A0',0,14,0,1,0,5,1,0,1088,NULL,NULL,NULL,20.00,13.00,10.00,760.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(199,'Google Chromecast with Google TV',NULL,NULL,'published','[\"main\\/products\\/product-2.jpg\"]','PQ-100-A0-A1',0,14,0,1,0,5,1,0,1088,NULL,NULL,NULL,20.00,13.00,10.00,760.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(200,'Google Chromecast with Google TV',NULL,NULL,'published','[\"main\\/products\\/product-19.jpg\"]','PQ-100-A0-A2',0,14,0,1,0,5,1,0,1088,NULL,NULL,NULL,20.00,13.00,10.00,760.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(201,'NVIDIA SHIELD TV Pro (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-4.jpg\"]','KC-147-A0',0,13,0,1,0,4,1,0,2185,1595.05,NULL,NULL,16.00,12.00,16.00,511.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(202,'NVIDIA SHIELD TV Pro (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-2.jpg\"]','KC-147-A0-A1',0,13,0,1,0,4,1,0,2185,1704.3,NULL,NULL,16.00,12.00,16.00,511.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(203,'NVIDIA SHIELD TV Pro (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-20.jpg\"]','KC-147-A0-A2',0,13,0,1,0,4,1,0,2185,1769.85,NULL,NULL,16.00,12.00,16.00,511.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(204,'Sonos Beam Gen 2 Soundbar',NULL,NULL,'published','[\"main\\/products\\/product-15.jpg\"]','KW-195-A0',0,19,0,1,0,3,1,0,2148,NULL,NULL,NULL,10.00,12.00,10.00,516.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(205,'Sonos Beam Gen 2 Soundbar',NULL,NULL,'published','[\"main\\/products\\/product-18.jpg\"]','KW-195-A0-A1',0,19,0,1,0,3,1,0,2148,NULL,NULL,NULL,10.00,12.00,10.00,516.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:27','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(206,'Bose Smart Soundbar 900',NULL,NULL,'published','[\"main\\/products\\/product-13.jpg\"]','JK-179-A0',0,16,0,1,0,3,1,0,922,NULL,NULL,NULL,14.00,18.00,15.00,880.00,NULL,0,'2024-03-15 03:00:27','2024-03-15 03:00:28','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(207,'Bose Smart Soundbar 900',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-1.jpg\"]','JK-179-A0-A1',0,16,0,1,0,3,1,0,922,NULL,NULL,NULL,14.00,18.00,15.00,880.00,NULL,0,'2024-03-15 03:00:28','2024-03-15 03:00:28','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(208,'JBL Bar 9.1 Soundbar with Dolby Atmos',NULL,NULL,'published','[\"main\\/products\\/product-18.jpg\"]','UT-109-A0',0,16,0,1,0,4,1,0,832,NULL,NULL,NULL,18.00,13.00,15.00,774.00,NULL,0,'2024-03-15 03:00:28','2024-03-15 03:00:28','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(209,'JBL Bar 9.1 Soundbar with Dolby Atmos',NULL,NULL,'published','[\"main\\/products\\/product-16.jpg\"]','UT-109-A0-A1',0,16,0,1,0,4,1,0,832,NULL,NULL,NULL,18.00,13.00,15.00,774.00,NULL,0,'2024-03-15 03:00:28','2024-03-15 03:00:28','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(210,'Sennheiser Ambeo Soundbar (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-16.jpg\"]','K2-193-A0',0,14,0,1,0,4,1,0,431,370.66,NULL,NULL,19.00,15.00,11.00,754.00,NULL,0,'2024-03-15 03:00:28','2024-03-15 03:00:28','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(211,'Sennheiser Ambeo Soundbar (Digital)',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-1.jpg\"]','K2-193-A0-A1',0,14,0,1,0,4,1,0,431,323.25,NULL,NULL,19.00,15.00,11.00,754.00,NULL,0,'2024-03-15 03:00:28','2024-03-15 03:00:28','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(212,'Sony HT-A9 Home Theater System',NULL,NULL,'published','[\"main\\/products\\/product-details-desc-3.jpg\"]','UF-174-A0',0,20,0,1,0,4,1,0,296,NULL,NULL,NULL,11.00,16.00,18.00,798.00,NULL,0,'2024-03-15 03:00:28','2024-03-15 03:00:28','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(213,'Sony HT-A9 Home Theater System',NULL,NULL,'published','[\"main\\/products\\/product-6.jpg\"]','UF-174-A0-A1',0,20,0,1,0,4,1,0,296,NULL,NULL,NULL,11.00,16.00,18.00,798.00,NULL,0,'2024-03-15 03:00:28','2024-03-15 03:00:28','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0);
/*!40000 ALTER TABLE `ec_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products_translations`
--

DROP TABLE IF EXISTS `ec_products_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_products_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products_translations`
--

LOCK TABLES `ec_products_translations` WRITE;
/*!40000 ALTER TABLE `ec_products_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_products_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_review_replies`
--

DROP TABLE IF EXISTS `ec_review_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_review_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `review_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_review_replies_review_id_user_id_unique` (`review_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_review_replies`
--

LOCK TABLES `ec_review_replies` WRITE;
/*!40000 ALTER TABLE `ec_review_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_review_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_reviews`
--

DROP TABLE IF EXISTS `ec_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `star` double(8,2) NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_reviews_product_id_customer_id_unique` (`product_id`,`customer_id`),
  KEY `ec_reviews_product_id_customer_id_status_created_at_index` (`product_id`,`customer_id`,`status`,`created_at`),
  KEY `review_relation_index` (`product_id`,`customer_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_reviews`
--

LOCK TABLES `ec_reviews` WRITE;
/*!40000 ALTER TABLE `ec_reviews` DISABLE KEYS */;
INSERT INTO `ec_reviews` VALUES (1,9,33,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\"]'),(2,8,27,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(3,1,5,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(4,7,28,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\"]'),(5,10,27,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\"]'),(6,6,52,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\"]'),(7,3,27,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\"]'),(8,7,37,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(9,7,30,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-20.jpg\"]'),(10,2,13,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-16.jpg\"]'),(11,2,7,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\"]'),(12,6,4,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\"]'),(13,7,35,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(14,10,26,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(15,6,56,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(16,8,11,4.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(17,6,47,2.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-20.jpg\"]'),(18,3,26,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\"]'),(19,9,39,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(20,6,30,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(21,10,19,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\"]'),(22,7,9,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\"]'),(23,10,32,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(24,7,55,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(25,10,5,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-16.jpg\"]'),(26,6,12,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\"]'),(28,9,34,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(29,1,9,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-18.jpg\"]'),(30,7,40,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\"]'),(31,4,54,5.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(32,10,18,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(33,2,56,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(34,7,19,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\"]'),(35,7,4,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\"]'),(36,6,39,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(37,6,34,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\"]'),(38,2,42,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(39,6,45,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-17.jpg\"]'),(40,6,3,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(41,8,46,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(42,5,9,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\"]'),(43,6,27,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(44,7,25,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\"]'),(45,6,46,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\"]'),(46,2,45,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\"]'),(47,8,2,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\"]'),(48,1,52,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\"]'),(49,1,24,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\"]'),(50,1,8,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(51,7,50,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\"]'),(52,8,21,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(53,8,50,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-15.jpg\"]'),(54,4,8,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\"]'),(55,4,27,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(56,1,47,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\"]'),(58,9,18,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\"]'),(59,9,55,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\"]'),(60,4,44,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-17.jpg\"]'),(61,7,27,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\"]'),(62,5,49,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(64,1,40,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(65,1,57,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\"]'),(66,6,6,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\"]'),(67,9,14,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(69,7,48,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(70,5,18,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\"]'),(71,4,33,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\"]'),(72,1,25,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\"]'),(74,9,41,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\"]'),(76,2,9,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(79,10,37,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\"]'),(80,3,25,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(82,2,50,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-20.jpg\"]'),(83,3,20,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\"]'),(85,4,55,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\"]'),(86,3,5,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(87,7,11,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\"]'),(88,1,37,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(89,2,30,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(90,6,33,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(91,9,19,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(92,1,48,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\"]'),(93,3,1,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(94,5,35,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]'),(95,6,10,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\"]'),(96,2,3,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\"]'),(97,5,7,4.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(98,4,50,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\"]'),(99,5,51,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(100,1,21,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\"]'),(101,4,37,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(102,4,4,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(103,1,14,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\"]'),(104,6,9,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(105,4,32,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(106,3,29,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(107,10,31,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\"]'),(109,9,11,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\"]'),(110,1,15,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-19.jpg\"]'),(111,8,49,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(113,1,39,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\"]'),(114,8,10,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(115,3,13,1.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\"]'),(117,8,18,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\"]'),(118,1,55,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-17.jpg\"]'),(120,7,56,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(121,2,49,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\"]'),(122,2,21,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\"]'),(123,8,14,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(124,7,32,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\"]'),(125,2,11,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(126,10,20,3.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\"]'),(127,6,40,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(128,2,48,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-18.jpg\"]'),(129,8,20,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(130,4,3,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(131,6,35,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(132,5,41,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(135,10,49,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-20.jpg\"]'),(139,9,3,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-20.jpg\"]'),(142,4,29,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(143,9,43,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-17.jpg\"]'),(146,7,24,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(147,9,30,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-18.jpg\"]'),(149,9,57,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\"]'),(150,1,20,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(151,8,48,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\"]'),(152,1,11,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\"]'),(154,1,42,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\"]'),(155,1,16,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\"]'),(156,6,29,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(157,9,53,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(158,9,22,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(159,2,4,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-13.jpg\"]'),(160,6,24,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\"]'),(161,4,46,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(163,4,1,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(166,4,6,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\"]'),(168,2,53,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-10.jpg\"]'),(170,7,22,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\"]'),(171,10,53,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(172,7,52,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\"]'),(173,9,27,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\"]'),(174,3,15,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\"]'),(176,8,51,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-17.jpg\"]'),(177,5,34,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(178,5,42,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-20.jpg\"]'),(179,7,16,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(181,6,21,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-16.jpg\"]'),(183,6,7,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\"]'),(184,7,3,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\"]'),(185,5,46,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\"]'),(186,7,46,2.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(187,9,10,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(189,8,7,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(190,2,2,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(191,3,6,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(192,1,35,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\"]'),(194,10,55,4.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-20.jpg\"]'),(196,8,45,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(197,10,57,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-20.jpg\"]'),(198,4,2,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(199,2,54,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\"]'),(200,9,51,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-18.jpg\"]'),(202,3,40,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(203,10,28,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\"]'),(204,3,19,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\"]'),(207,5,37,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-18.jpg\"]'),(208,5,53,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\"]'),(209,6,18,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\"]'),(210,9,4,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(212,1,56,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(213,10,35,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\"]'),(215,6,53,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(216,5,36,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\"]'),(218,7,45,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(219,7,49,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\"]'),(220,8,37,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\"]'),(221,5,55,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(223,2,23,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\"]'),(224,10,36,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\"]'),(226,5,31,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(228,9,45,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\"]'),(229,3,32,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(230,3,23,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(231,2,19,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\"]'),(232,3,51,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(233,8,22,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\"]'),(235,1,3,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\"]'),(237,1,12,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\"]'),(239,6,17,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\"]'),(241,1,28,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\"]'),(242,2,46,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-20.jpg\"]'),(243,1,46,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(244,6,14,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\"]'),(245,4,11,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-18.jpg\"]'),(247,4,41,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(248,8,31,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(249,9,49,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(250,10,38,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(252,5,43,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(253,7,51,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(254,6,19,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(256,3,34,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\"]'),(257,1,29,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-20.jpg\"]'),(258,10,24,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(259,9,23,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-15.jpg\"]'),(260,5,38,1.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(261,2,20,1.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-19.jpg\"]'),(263,9,26,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\"]'),(264,10,48,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(265,1,27,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(266,7,42,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\"]'),(267,3,11,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-15.jpg\"]'),(270,5,32,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(271,4,38,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(272,10,4,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(273,10,30,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(274,5,14,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(275,6,41,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\"]'),(277,8,6,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(278,3,7,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(279,10,52,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\"]'),(280,9,32,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(281,3,50,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\"]'),(282,6,13,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\"]'),(285,9,7,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\"]'),(287,8,12,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(288,9,56,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(292,4,56,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\"]'),(293,10,51,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-20.jpg\"]'),(294,3,2,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(295,2,40,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(299,2,5,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\"]'),(302,7,13,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(304,7,5,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(305,4,23,2.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\"]'),(310,7,1,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\"]'),(311,2,43,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\"]'),(312,7,53,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\"]'),(314,6,36,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(315,2,18,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\"]'),(318,2,39,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-18.jpg\"]'),(319,5,47,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(321,1,45,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\"]'),(322,10,54,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(323,2,38,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(324,5,27,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(325,1,1,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\"]'),(326,8,39,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(331,4,22,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-20.jpg\"]'),(332,10,29,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(333,9,52,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\"]'),(334,5,2,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(337,3,55,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(338,10,43,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\"]'),(340,10,44,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\"]'),(341,6,51,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-20.jpg\"]'),(345,7,39,1.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(347,1,51,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\"]'),(348,1,23,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\"]'),(349,8,34,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(350,7,26,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(352,9,31,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\"]'),(356,5,8,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\"]'),(357,8,57,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\"]'),(358,6,23,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(362,7,15,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-19.jpg\"]'),(364,5,24,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-17.jpg\"]'),(366,3,31,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\"]'),(368,9,13,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(370,4,28,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\"]'),(373,4,34,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(374,9,21,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\"]'),(378,2,57,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\"]'),(380,2,14,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\"]'),(381,6,2,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(383,10,25,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(384,9,29,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(389,4,48,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-19.jpg\"]'),(390,5,6,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(392,10,23,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(393,2,44,3.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(396,5,52,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(397,5,28,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(399,7,54,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(400,3,45,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\"]'),(401,2,24,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(402,7,47,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\"]'),(407,3,44,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\"]'),(408,9,47,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(411,8,42,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(412,9,28,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\"]'),(413,5,50,4.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\"]'),(414,3,17,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(415,9,25,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\"]'),(417,8,53,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\"]'),(418,10,21,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(419,6,38,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(420,6,15,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-20.jpg\"]'),(424,4,10,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(426,5,5,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(427,9,6,1.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(431,8,32,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\"]'),(433,3,41,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(434,1,33,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-17.jpg\"]'),(435,2,10,4.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(438,6,16,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(442,8,4,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\"]'),(443,6,28,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-17.jpg\"]'),(445,5,54,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(446,1,22,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\"]'),(449,7,57,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-16.jpg\"]'),(453,5,33,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(454,6,11,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(455,5,16,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(456,4,15,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\"]'),(458,6,55,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\"]'),(459,2,37,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(463,8,56,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\"]'),(465,6,26,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(483,6,42,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(484,7,14,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\"]'),(492,7,2,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\"]'),(493,10,6,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-19.jpg\"]'),(494,10,10,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\"]'),(501,2,6,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(503,3,49,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\"]'),(510,7,38,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\"]'),(513,7,41,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(514,3,53,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-15.jpg\"]'),(515,7,33,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\"]'),(520,8,17,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(522,3,37,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(523,5,17,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-20.jpg\"]'),(524,8,29,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\"]'),(526,3,42,4.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\"]'),(529,7,8,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-20.jpg\"]'),(530,3,21,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(531,10,56,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\"]'),(532,2,15,5.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\"]'),(534,5,20,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-17.jpg\"]'),(536,9,15,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(541,9,35,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\"]'),(545,8,5,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\"]'),(547,2,27,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-11.jpg\"]'),(549,4,40,4.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(551,7,43,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(552,10,1,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(554,7,10,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]'),(556,3,52,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(560,10,42,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-20.jpg\"]'),(563,2,32,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\"]'),(566,8,36,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(568,5,21,4.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(569,2,55,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\"]'),(570,4,57,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(571,3,36,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(573,4,25,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(574,1,17,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\"]'),(576,2,8,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\"]'),(578,8,33,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(583,10,46,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\"]'),(585,1,26,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\"]'),(591,2,1,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-16.jpg\"]'),(592,7,20,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-15.jpg\"]'),(601,6,37,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\"]'),(603,10,9,4.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(606,5,44,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(608,4,31,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\"]'),(610,4,14,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(611,5,3,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(616,1,54,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\"]'),(617,8,55,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\"]'),(623,10,2,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(633,8,13,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(634,8,28,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(636,5,48,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\"]'),(637,8,26,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\"]'),(642,9,8,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(647,3,16,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-13.jpg\"]'),(648,7,34,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(661,10,39,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\"]'),(662,5,13,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(663,4,19,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(667,4,36,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(670,3,56,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(675,1,7,5.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\"]'),(679,2,51,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(684,1,50,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-19.jpg\"]'),(688,8,23,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-20.jpg\"]'),(693,5,22,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(700,1,2,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\"]'),(704,5,15,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(705,9,40,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(706,10,12,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\"]'),(709,3,18,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-20.jpg\"]'),(711,1,19,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(712,10,11,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\"]'),(714,3,48,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\"]'),(716,8,47,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\"]'),(721,10,41,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\"]'),(724,9,42,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(725,4,26,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(727,3,35,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(728,8,15,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(732,3,14,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-14.jpg\"]'),(735,4,17,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\"]'),(736,5,11,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(737,6,32,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\"]'),(738,9,5,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(747,6,57,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(748,3,39,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(750,6,22,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(754,4,39,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(755,1,53,5.00,'Clean & perfect source code','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(758,5,4,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\"]'),(763,10,40,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-17.jpg\"]'),(766,9,36,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(772,2,33,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(779,3,8,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\"]'),(785,5,56,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(803,3,22,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(811,9,17,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\"]'),(812,8,1,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(827,4,35,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(832,8,52,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\"]'),(834,6,49,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(837,9,16,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-20.jpg\"]'),(838,9,24,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\"]'),(842,8,3,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\"]'),(844,2,31,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\"]'),(846,9,38,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\"]'),(852,4,43,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\"]'),(863,8,44,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\"]'),(865,1,6,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(870,4,7,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\"]'),(875,8,19,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-17.jpg\"]'),(883,8,40,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(887,10,3,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(893,2,34,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(895,8,43,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(899,10,47,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\"]'),(903,3,4,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\"]'),(905,7,23,4.00,'Best ecommerce CMS online store!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\"]'),(906,9,46,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-11.jpg\"]'),(910,3,24,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\"]'),(914,7,29,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(919,1,4,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(920,6,20,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(923,6,43,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(930,1,36,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-19.jpg\"]'),(931,4,53,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(934,4,9,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(941,1,49,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\"]'),(945,9,48,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\"]'),(952,4,12,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(955,8,16,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-18.jpg\"]'),(960,10,45,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-8.jpg\"]'),(964,9,50,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\"]'),(984,2,28,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(990,7,31,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(993,8,9,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-17.jpg\"]'),(997,9,9,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:01:17','2024-03-15 03:01:17','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\"]');
/*!40000 ALTER TABLE `ec_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipment_histories`
--

DROP TABLE IF EXISTS `ec_shipment_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipment_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `shipment_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=118 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipment_histories`
--

LOCK TABLES `ec_shipment_histories` WRITE;
/*!40000 ALTER TABLE `ec_shipment_histories` DISABLE KEYS */;
INSERT INTO `ec_shipment_histories` VALUES (1,'create_from_order','Shipping was created from order %order_id%',0,1,2,'2024-03-01 19:00:35','2024-03-01 19:00:35','Botble\\ACL\\Models\\User'),(2,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,1,2,'2024-03-13 11:00:35','2024-03-15 03:00:35','Botble\\ACL\\Models\\User'),(3,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,1,2,'2024-03-15 03:00:35','2024-03-15 03:00:35','Botble\\ACL\\Models\\User'),(4,'create_from_order','Shipping was created from order %order_id%',0,2,3,'2024-03-10 03:00:35','2024-03-10 03:00:35','Botble\\ACL\\Models\\User'),(5,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,2,3,'2024-03-13 11:00:35','2024-03-15 03:00:35','Botble\\ACL\\Models\\User'),(6,'create_from_order','Shipping was created from order %order_id%',0,3,4,'2024-03-05 03:00:35','2024-03-05 03:00:35','Botble\\ACL\\Models\\User'),(7,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,3,4,'2024-03-13 11:00:36','2024-03-15 03:00:36','Botble\\ACL\\Models\\User'),(8,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,3,4,'2024-03-15 03:00:36','2024-03-15 03:00:36','Botble\\ACL\\Models\\User'),(9,'create_from_order','Shipping was created from order %order_id%',0,4,6,'2024-03-11 23:00:36','2024-03-11 23:00:36','Botble\\ACL\\Models\\User'),(10,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,4,6,'2024-03-13 13:00:36','2024-03-15 03:00:36','Botble\\ACL\\Models\\User'),(11,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,4,6,'2024-03-15 03:00:36','2024-03-15 03:00:36','Botble\\ACL\\Models\\User'),(12,'create_from_order','Shipping was created from order %order_id%',0,5,7,'2024-03-05 15:00:36','2024-03-05 15:00:36','Botble\\ACL\\Models\\User'),(13,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,5,7,'2024-03-13 13:00:37','2024-03-15 03:00:37','Botble\\ACL\\Models\\User'),(14,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,5,7,'2024-03-15 03:00:37','2024-03-15 03:00:37','Botble\\ACL\\Models\\User'),(15,'create_from_order','Shipping was created from order %order_id%',0,6,10,'2024-03-10 21:00:37','2024-03-10 21:00:37','Botble\\ACL\\Models\\User'),(16,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,6,10,'2024-03-13 17:00:38','2024-03-15 03:00:38','Botble\\ACL\\Models\\User'),(17,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,6,10,'2024-03-15 03:00:38','2024-03-15 03:00:38','Botble\\ACL\\Models\\User'),(18,'create_from_order','Shipping was created from order %order_id%',0,7,11,'2024-03-10 21:00:38','2024-03-10 21:00:38','Botble\\ACL\\Models\\User'),(19,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,7,11,'2024-03-13 17:00:38','2024-03-15 03:00:38','Botble\\ACL\\Models\\User'),(20,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,7,11,'2024-03-15 03:00:38','2024-03-15 03:00:38','Botble\\ACL\\Models\\User'),(21,'create_from_order','Shipping was created from order %order_id%',0,8,12,'2024-03-07 03:00:38','2024-03-07 03:00:38','Botble\\ACL\\Models\\User'),(22,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,8,12,'2024-03-13 19:00:38','2024-03-15 03:00:38','Botble\\ACL\\Models\\User'),(23,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,8,12,'2024-03-15 03:00:38','2024-03-15 03:00:38','Botble\\ACL\\Models\\User'),(24,'create_from_order','Shipping was created from order %order_id%',0,9,13,'2024-03-12 11:00:38','2024-03-12 11:00:38','Botble\\ACL\\Models\\User'),(25,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,9,13,'2024-03-13 19:00:39','2024-03-15 03:00:39','Botble\\ACL\\Models\\User'),(26,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,9,13,'2024-03-15 03:00:39','2024-03-15 03:00:39','Botble\\ACL\\Models\\User'),(27,'create_from_order','Shipping was created from order %order_id%',0,10,14,'2024-03-13 19:00:39','2024-03-13 19:00:39','Botble\\ACL\\Models\\User'),(28,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,10,14,'2024-03-13 19:00:39','2024-03-15 03:00:39','Botble\\ACL\\Models\\User'),(29,'create_from_order','Shipping was created from order %order_id%',0,11,15,'2024-03-12 11:00:39','2024-03-12 11:00:39','Botble\\ACL\\Models\\User'),(30,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,11,15,'2024-03-13 19:00:39','2024-03-15 03:00:39','Botble\\ACL\\Models\\User'),(31,'create_from_order','Shipping was created from order %order_id%',0,12,16,'2024-03-03 21:00:39','2024-03-03 21:00:39','Botble\\ACL\\Models\\User'),(32,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,12,16,'2024-03-13 21:00:40','2024-03-15 03:00:40','Botble\\ACL\\Models\\User'),(33,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,12,16,'2024-03-15 03:00:40','2024-03-15 03:00:40','Botble\\ACL\\Models\\User'),(34,'create_from_order','Shipping was created from order %order_id%',0,13,17,'2024-03-03 21:00:40','2024-03-03 21:00:40','Botble\\ACL\\Models\\User'),(35,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,13,17,'2024-03-13 21:00:40','2024-03-15 03:00:40','Botble\\ACL\\Models\\User'),(36,'create_from_order','Shipping was created from order %order_id%',0,14,18,'2024-03-13 21:00:40','2024-03-13 21:00:40','Botble\\ACL\\Models\\User'),(37,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,14,18,'2024-03-13 21:00:40','2024-03-15 03:00:40','Botble\\ACL\\Models\\User'),(38,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,14,18,'2024-03-15 03:00:40','2024-03-15 03:00:40','Botble\\ACL\\Models\\User'),(39,'create_from_order','Shipping was created from order %order_id%',0,15,19,'2024-03-11 09:00:40','2024-03-11 09:00:40','Botble\\ACL\\Models\\User'),(40,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,15,19,'2024-03-13 21:00:41','2024-03-15 03:00:41','Botble\\ACL\\Models\\User'),(41,'create_from_order','Shipping was created from order %order_id%',0,16,20,'2024-03-04 15:00:41','2024-03-04 15:00:41','Botble\\ACL\\Models\\User'),(42,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,16,20,'2024-03-13 23:00:41','2024-03-15 03:00:41','Botble\\ACL\\Models\\User'),(43,'create_from_order','Shipping was created from order %order_id%',0,17,21,'2024-03-09 07:00:41','2024-03-09 07:00:41','Botble\\ACL\\Models\\User'),(44,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,17,21,'2024-03-13 23:00:41','2024-03-15 03:00:41','Botble\\ACL\\Models\\User'),(45,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,17,21,'2024-03-15 03:00:41','2024-03-15 03:00:41','Botble\\ACL\\Models\\User'),(46,'create_from_order','Shipping was created from order %order_id%',0,18,22,'2024-03-09 17:00:41','2024-03-09 17:00:41','Botble\\ACL\\Models\\User'),(47,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,18,22,'2024-03-14 01:00:42','2024-03-15 03:00:42','Botble\\ACL\\Models\\User'),(48,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,22,'2024-03-15 03:00:42','2024-03-15 03:00:42','Botble\\ACL\\Models\\User'),(49,'create_from_order','Shipping was created from order %order_id%',0,19,23,'2024-03-14 01:00:42','2024-03-14 01:00:42','Botble\\ACL\\Models\\User'),(50,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,19,23,'2024-03-14 01:00:42','2024-03-15 03:00:42','Botble\\ACL\\Models\\User'),(51,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,19,23,'2024-03-15 03:00:42','2024-03-15 03:00:42','Botble\\ACL\\Models\\User'),(52,'create_from_order','Shipping was created from order %order_id%',0,20,27,'2024-03-11 11:00:43','2024-03-11 11:00:43','Botble\\ACL\\Models\\User'),(53,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,20,27,'2024-03-14 05:00:43','2024-03-15 03:00:43','Botble\\ACL\\Models\\User'),(54,'create_from_order','Shipping was created from order %order_id%',0,21,28,'2024-03-12 09:00:43','2024-03-12 09:00:43','Botble\\ACL\\Models\\User'),(55,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,21,28,'2024-03-14 05:00:44','2024-03-15 03:00:44','Botble\\ACL\\Models\\User'),(56,'create_from_order','Shipping was created from order %order_id%',0,22,29,'2024-03-10 23:00:44','2024-03-10 23:00:44','Botble\\ACL\\Models\\User'),(57,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,22,29,'2024-03-14 07:00:44','2024-03-15 03:00:44','Botble\\ACL\\Models\\User'),(58,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,22,29,'2024-03-15 03:00:44','2024-03-15 03:00:44','Botble\\ACL\\Models\\User'),(59,'create_from_order','Shipping was created from order %order_id%',0,23,30,'2024-03-10 23:00:44','2024-03-10 23:00:44','Botble\\ACL\\Models\\User'),(60,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,23,30,'2024-03-14 07:00:44','2024-03-15 03:00:44','Botble\\ACL\\Models\\User'),(61,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,23,30,'2024-03-15 03:00:44','2024-03-15 03:00:44','Botble\\ACL\\Models\\User'),(62,'create_from_order','Shipping was created from order %order_id%',0,24,31,'2024-03-09 07:00:44','2024-03-09 07:00:44','Botble\\ACL\\Models\\User'),(63,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,24,31,'2024-03-14 07:00:45','2024-03-15 03:00:45','Botble\\ACL\\Models\\User'),(64,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,24,31,'2024-03-15 03:00:45','2024-03-15 03:00:45','Botble\\ACL\\Models\\User'),(65,'create_from_order','Shipping was created from order %order_id%',0,25,32,'2024-03-06 19:00:45','2024-03-06 19:00:45','Botble\\ACL\\Models\\User'),(66,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,25,32,'2024-03-14 07:00:45','2024-03-15 03:00:45','Botble\\ACL\\Models\\User'),(67,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,25,32,'2024-03-15 03:00:45','2024-03-15 03:00:45','Botble\\ACL\\Models\\User'),(68,'create_from_order','Shipping was created from order %order_id%',0,26,33,'2024-03-14 09:00:45','2024-03-14 09:00:45','Botble\\ACL\\Models\\User'),(69,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,26,33,'2024-03-14 09:00:45','2024-03-15 03:00:45','Botble\\ACL\\Models\\User'),(70,'create_from_order','Shipping was created from order %order_id%',0,27,34,'2024-03-10 15:00:45','2024-03-10 15:00:45','Botble\\ACL\\Models\\User'),(71,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,27,34,'2024-03-14 09:00:45','2024-03-15 03:00:45','Botble\\ACL\\Models\\User'),(72,'create_from_order','Shipping was created from order %order_id%',0,28,35,'2024-03-12 21:00:45','2024-03-12 21:00:45','Botble\\ACL\\Models\\User'),(73,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,28,35,'2024-03-14 09:00:45','2024-03-15 03:00:45','Botble\\ACL\\Models\\User'),(74,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,28,35,'2024-03-15 03:00:45','2024-03-15 03:00:45','Botble\\ACL\\Models\\User'),(75,'create_from_order','Shipping was created from order %order_id%',0,29,36,'2024-03-11 19:00:45','2024-03-11 19:00:45','Botble\\ACL\\Models\\User'),(76,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,29,36,'2024-03-14 11:00:46','2024-03-15 03:00:46','Botble\\ACL\\Models\\User'),(77,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,29,36,'2024-03-15 03:00:46','2024-03-15 03:00:46','Botble\\ACL\\Models\\User'),(78,'create_from_order','Shipping was created from order %order_id%',0,30,37,'2024-03-10 11:00:46','2024-03-10 11:00:46','Botble\\ACL\\Models\\User'),(79,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,30,37,'2024-03-14 11:00:46','2024-03-15 03:00:46','Botble\\ACL\\Models\\User'),(80,'create_from_order','Shipping was created from order %order_id%',0,31,39,'2024-03-11 01:00:46','2024-03-11 01:00:46','Botble\\ACL\\Models\\User'),(81,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,31,39,'2024-03-14 13:00:47','2024-03-15 03:00:47','Botble\\ACL\\Models\\User'),(82,'create_from_order','Shipping was created from order %order_id%',0,32,40,'2024-03-13 03:00:47','2024-03-13 03:00:47','Botble\\ACL\\Models\\User'),(83,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,32,40,'2024-03-14 15:00:47','2024-03-15 03:00:47','Botble\\ACL\\Models\\User'),(84,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,32,40,'2024-03-15 03:00:47','2024-03-15 03:00:47','Botble\\ACL\\Models\\User'),(85,'create_from_order','Shipping was created from order %order_id%',0,33,41,'2024-03-14 17:00:47','2024-03-14 17:00:47','Botble\\ACL\\Models\\User'),(86,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,33,41,'2024-03-14 17:00:47','2024-03-15 03:00:47','Botble\\ACL\\Models\\User'),(87,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,33,41,'2024-03-15 03:00:47','2024-03-15 03:00:47','Botble\\ACL\\Models\\User'),(88,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,33,41,'2024-03-15 03:00:47','2024-03-15 03:00:47','Botble\\ACL\\Models\\User'),(89,'create_from_order','Shipping was created from order %order_id%',0,34,43,'2024-03-12 15:00:47','2024-03-12 15:00:47','Botble\\ACL\\Models\\User'),(90,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,34,43,'2024-03-14 17:00:47','2024-03-15 03:00:47','Botble\\ACL\\Models\\User'),(91,'create_from_order','Shipping was created from order %order_id%',0,35,44,'2024-03-13 21:00:47','2024-03-13 21:00:47','Botble\\ACL\\Models\\User'),(92,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,35,44,'2024-03-14 17:00:48','2024-03-15 03:00:48','Botble\\ACL\\Models\\User'),(93,'create_from_order','Shipping was created from order %order_id%',0,36,45,'2024-03-14 11:00:48','2024-03-14 11:00:48','Botble\\ACL\\Models\\User'),(94,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,36,45,'2024-03-14 19:00:48','2024-03-15 03:00:48','Botble\\ACL\\Models\\User'),(95,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,36,45,'2024-03-15 03:00:48','2024-03-15 03:00:48','Botble\\ACL\\Models\\User'),(96,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,36,45,'2024-03-15 03:00:48','2024-03-15 03:00:48','Botble\\ACL\\Models\\User'),(97,'create_from_order','Shipping was created from order %order_id%',0,37,46,'2024-03-12 19:00:48','2024-03-12 19:00:48','Botble\\ACL\\Models\\User'),(98,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,37,46,'2024-03-14 19:00:48','2024-03-15 03:00:48','Botble\\ACL\\Models\\User'),(99,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,37,46,'2024-03-15 03:00:48','2024-03-15 03:00:48','Botble\\ACL\\Models\\User'),(100,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,37,46,'2024-03-15 03:00:48','2024-03-15 03:00:48','Botble\\ACL\\Models\\User'),(101,'create_from_order','Shipping was created from order %order_id%',0,38,47,'2024-03-14 21:00:48','2024-03-14 21:00:48','Botble\\ACL\\Models\\User'),(102,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,38,47,'2024-03-14 21:00:48','2024-03-15 03:00:48','Botble\\ACL\\Models\\User'),(103,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,38,47,'2024-03-15 03:00:48','2024-03-15 03:00:48','Botble\\ACL\\Models\\User'),(104,'create_from_order','Shipping was created from order %order_id%',0,39,48,'2024-03-14 21:00:48','2024-03-14 21:00:48','Botble\\ACL\\Models\\User'),(105,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,39,48,'2024-03-14 21:00:49','2024-03-15 03:00:49','Botble\\ACL\\Models\\User'),(106,'create_from_order','Shipping was created from order %order_id%',0,40,49,'2024-03-14 15:00:49','2024-03-14 15:00:49','Botble\\ACL\\Models\\User'),(107,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,40,49,'2024-03-14 21:00:49','2024-03-15 03:00:49','Botble\\ACL\\Models\\User'),(108,'create_from_order','Shipping was created from order %order_id%',0,41,50,'2024-03-14 07:00:49','2024-03-14 07:00:49','Botble\\ACL\\Models\\User'),(109,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,41,50,'2024-03-14 23:00:49','2024-03-15 03:00:49','Botble\\ACL\\Models\\User'),(110,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,41,50,'2024-03-15 03:00:49','2024-03-15 03:00:49','Botble\\ACL\\Models\\User'),(111,'create_from_order','Shipping was created from order %order_id%',0,42,52,'2024-03-14 03:00:49','2024-03-14 03:00:49','Botble\\ACL\\Models\\User'),(112,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,42,52,'2024-03-14 23:00:50','2024-03-15 03:00:50','Botble\\ACL\\Models\\User'),(113,'create_from_order','Shipping was created from order %order_id%',0,43,53,'2024-03-14 17:00:50','2024-03-14 17:00:50','Botble\\ACL\\Models\\User'),(114,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,43,53,'2024-03-15 01:00:50','2024-03-15 03:00:50','Botble\\ACL\\Models\\User'),(115,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,43,53,'2024-03-15 03:00:50','2024-03-15 03:00:50','Botble\\ACL\\Models\\User'),(116,'create_from_order','Shipping was created from order %order_id%',0,44,55,'2024-03-14 09:00:50','2024-03-14 09:00:50','Botble\\ACL\\Models\\User'),(117,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,44,55,'2024-03-15 01:00:50','2024-03-15 03:00:50','Botble\\ACL\\Models\\User');
/*!40000 ALTER TABLE `ec_shipment_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipments`
--

DROP TABLE IF EXISTS `ec_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `shipment_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rate_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cod_amount` decimal(15,2) DEFAULT '0.00',
  `cod_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cross_checking_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `price` decimal(15,2) DEFAULT '0.00',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tracking_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estimate_date_shipped` datetime DEFAULT NULL,
  `date_shipped` datetime DEFAULT NULL,
  `label_url` text COLLATE utf8mb4_unicode_ci,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipments`
--

LOCK TABLES `ec_shipments` WRITE;
/*!40000 ALTER TABLE `ec_shipments` DISABLE KEYS */;
INSERT INTO `ec_shipments` VALUES (1,2,NULL,559.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:35','2024-03-15 03:00:35','JJD0056993075','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:00:35','2024-03-15 10:00:35',NULL,NULL),(2,3,NULL,1593.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:35','2024-03-15 03:00:35','JJD001264068','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:00:35',NULL,NULL,NULL),(3,4,NULL,2280.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:36','2024-03-15 03:00:36','JJD0025546794','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:00:36','2024-03-15 10:00:36',NULL,NULL),(4,6,NULL,1554.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:36','2024-03-15 03:00:36','JJD0021872367','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:00:36','2024-03-15 10:00:36',NULL,NULL),(5,7,NULL,2640.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:37','2024-03-15 03:00:37','JJD0039022968','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-19 10:00:37','2024-03-15 10:00:37',NULL,NULL),(6,10,NULL,4334.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:38','2024-03-15 03:00:38','JJD002713898','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:00:38','2024-03-15 10:00:38',NULL,NULL),(7,11,NULL,1518.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:38','2024-03-15 03:00:38','JJD0032158911','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:00:38','2024-03-15 10:00:38',NULL,NULL),(8,12,NULL,900.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:38','2024-03-15 03:00:38','JJD001979135','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:00:38','2024-03-15 10:00:38',NULL,NULL),(9,13,NULL,531.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:39','2024-03-15 03:00:39','JJD0088019913','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:00:39','2024-03-15 10:00:39',NULL,NULL),(10,14,NULL,1378.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:39','2024-03-15 03:00:39','JJD0019594653','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:00:39',NULL,NULL,NULL),(11,15,NULL,2322.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:39','2024-03-15 03:00:39','JJD0074417783','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:00:39',NULL,NULL,NULL),(12,16,NULL,729.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:40','2024-03-15 03:00:40','JJD009973393','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:00:40','2024-03-15 10:00:40',NULL,NULL),(13,17,NULL,1800.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:40','2024-03-15 03:00:40','JJD0092800864','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:00:40',NULL,NULL,NULL),(14,18,NULL,1106.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:40','2024-03-15 03:00:40','JJD0070076206','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-19 10:00:40','2024-03-15 10:00:40',NULL,NULL),(15,19,NULL,1520.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:41','2024-03-15 03:00:41','JJD0046759223','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:00:41',NULL,NULL,NULL),(16,20,NULL,1118.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:41','2024-03-15 03:00:41','JJD0058981313','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:00:41',NULL,NULL,NULL),(17,21,NULL,1518.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:41','2024-03-15 03:00:41','JJD0090919709','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:00:41','2024-03-15 10:00:41',NULL,NULL),(18,22,NULL,1664.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:42','2024-03-15 03:00:42','JJD005332408','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:00:42','2024-03-15 10:00:42',NULL,NULL),(19,23,NULL,2265.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:42','2024-03-15 03:00:42','JJD0088646916','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:00:42','2024-03-15 10:00:42',NULL,NULL),(20,27,NULL,3873.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:43','2024-03-15 03:00:43','JJD0033400438','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:00:43',NULL,NULL,NULL),(21,28,NULL,2637.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:44','2024-03-15 03:00:44','JJD0069187463','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:00:44',NULL,NULL,NULL),(22,29,NULL,2694.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:44','2024-03-15 03:00:44','JJD0081975925','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:00:44','2024-03-15 10:00:44',NULL,NULL),(23,30,NULL,900.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:44','2024-03-15 03:00:44','JJD0072178130','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:00:44','2024-03-15 10:00:44',NULL,NULL),(24,31,NULL,553.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:45','2024-03-15 03:00:45','JJD0089594503','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:00:45','2024-03-15 10:00:45',NULL,NULL),(25,32,NULL,1758.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:45','2024-03-15 03:00:45','JJD0017390350','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:00:45','2024-03-15 10:00:45',NULL,NULL),(26,33,NULL,2598.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:45','2024-03-15 03:00:45','JJD0093450774','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:00:45',NULL,NULL,NULL),(27,34,NULL,1677.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:45','2024-03-15 03:00:45','JJD0074073216','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-18 10:00:45',NULL,NULL,NULL),(28,35,NULL,1758.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:45','2024-03-15 03:00:45','JJD0068975692','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:00:45','2024-03-15 10:00:45',NULL,NULL),(29,36,NULL,1796.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:46','2024-03-15 03:00:46','JJD009827506','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-18 10:00:46','2024-03-15 10:00:46',NULL,NULL),(30,37,NULL,2454.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:46','2024-03-15 03:00:46','JJD0066195354','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-19 10:00:46',NULL,NULL,NULL),(31,39,NULL,2482.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:47','2024-03-15 03:00:47','JJD0096361826','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:00:47',NULL,NULL,NULL),(32,40,NULL,3473.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:47','2024-03-15 03:00:47','JJD0080677060','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:00:47','2024-03-15 10:00:47',NULL,NULL),(33,41,NULL,900.00,NULL,NULL,'','delivered',1020.00,'completed','pending',0.00,0,'2024-03-15 03:00:47','2024-03-15 03:00:47','JJD0018859709','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:00:47','2024-03-15 10:00:47',NULL,NULL),(34,43,NULL,1518.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:47','2024-03-15 03:00:47','JJD0040093249','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:00:47',NULL,NULL,NULL),(35,44,NULL,759.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:48','2024-03-15 03:00:48','JJD0096353089','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:00:48',NULL,NULL,NULL),(36,45,NULL,4895.00,NULL,NULL,'','delivered',12278.00,'completed','pending',0.00,0,'2024-03-15 03:00:48','2024-03-15 03:00:48','JJD0074069133','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:00:48','2024-03-15 10:00:48',NULL,NULL),(37,46,NULL,1032.00,NULL,NULL,'','delivered',4296.00,'completed','pending',0.00,0,'2024-03-15 03:00:48','2024-03-15 03:00:48','JJD0060435640','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-19 10:00:48','2024-03-15 10:00:48',NULL,NULL),(38,47,NULL,2514.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:48','2024-03-15 03:00:48','JJD0022311540','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:00:48','2024-03-15 10:00:48',NULL,NULL),(39,48,NULL,2649.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:49','2024-03-15 03:00:49','JJD0078818893','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:00:49',NULL,NULL,NULL),(40,49,NULL,1264.00,NULL,NULL,'','approved',2886.00,'pending','pending',0.00,0,'2024-03-15 03:00:49','2024-03-15 03:00:49','JJD0095028710','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-18 10:00:49',NULL,NULL,NULL),(41,50,NULL,1362.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:49','2024-03-15 03:00:49','JJD0025169795','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:00:49','2024-03-15 10:00:49',NULL,NULL),(42,52,NULL,2190.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:50','2024-03-15 03:00:50','JJD0048006686','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:00:50',NULL,NULL,NULL),(43,53,NULL,2038.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:50','2024-03-15 03:00:50','JJD0094820163','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:00:50','2024-03-15 10:00:50',NULL,NULL),(44,55,NULL,553.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:00:50','2024-03-15 03:00:50','JJD0017564679','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:00:50',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ec_shipments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping`
--

DROP TABLE IF EXISTS `ec_shipping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping`
--

LOCK TABLES `ec_shipping` WRITE;
/*!40000 ALTER TABLE `ec_shipping` DISABLE KEYS */;
INSERT INTO `ec_shipping` VALUES (1,'All',NULL,'2024-03-15 03:00:00','2024-03-15 03:00:00');
/*!40000 ALTER TABLE `ec_shipping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rule_items`
--

DROP TABLE IF EXISTS `ec_shipping_rule_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rule_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `shipping_rule_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_price` decimal(15,2) DEFAULT '0.00',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rule_items`
--

LOCK TABLES `ec_shipping_rule_items` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rule_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipping_rule_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rules`
--

DROP TABLE IF EXISTS `ec_shipping_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_id` bigint unsigned NOT NULL,
  `type` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT 'based_on_price',
  `from` decimal(15,2) DEFAULT '0.00',
  `to` decimal(15,2) DEFAULT '0.00',
  `price` decimal(15,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rules`
--

LOCK TABLES `ec_shipping_rules` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rules` DISABLE KEYS */;
INSERT INTO `ec_shipping_rules` VALUES (1,'Free delivery',1,'based_on_price',0.00,NULL,0.00,'2024-03-15 03:00:00','2024-03-15 03:00:00');
/*!40000 ALTER TABLE `ec_shipping_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_store_locators`
--

DROP TABLE IF EXISTS `ec_store_locators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_store_locators` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) DEFAULT '0',
  `is_shipping_location` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_store_locators`
--

LOCK TABLES `ec_store_locators` WRITE;
/*!40000 ALTER TABLE `ec_store_locators` DISABLE KEYS */;
INSERT INTO `ec_store_locators` VALUES (1,'Shofy','sales@botble.com','1800979769','502 New Street','AU','Brighton VIC','Brighton VIC',1,1,'2024-03-15 03:00:02','2024-03-15 03:00:02');
/*!40000 ALTER TABLE `ec_store_locators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_products`
--

DROP TABLE IF EXISTS `ec_tax_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_products` (
  `tax_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tax_id`),
  KEY `ec_tax_products_tax_id_index` (`tax_id`),
  KEY `ec_tax_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_products`
--

LOCK TABLES `ec_tax_products` WRITE;
/*!40000 ALTER TABLE `ec_tax_products` DISABLE KEYS */;
INSERT INTO `ec_tax_products` VALUES (1,5),(1,8),(1,10),(1,14),(1,16),(1,19),(1,20),(1,24),(1,25),(1,33),(1,37),(1,39),(1,41),(1,42),(1,46),(1,47),(1,49),(1,51),(1,52),(1,53),(1,55),(2,1),(2,4),(2,9),(2,11),(2,12),(2,13),(2,18),(2,23),(2,29),(2,31),(2,35),(2,36),(2,40),(2,43),(2,44),(2,50),(2,54),(3,2),(3,3),(3,6),(3,7),(3,15),(3,17),(3,21),(3,22),(3,26),(3,27),(3,28),(3,30),(3,32),(3,34),(3,38),(3,45),(3,48),(3,56),(3,57);
/*!40000 ALTER TABLE `ec_tax_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_rules`
--

DROP TABLE IF EXISTS `ec_tax_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_rules`
--

LOCK TABLES `ec_tax_rules` WRITE;
/*!40000 ALTER TABLE `ec_tax_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_tax_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_taxes`
--

DROP TABLE IF EXISTS `ec_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` double(8,6) DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_taxes`
--

LOCK TABLES `ec_taxes` WRITE;
/*!40000 ALTER TABLE `ec_taxes` DISABLE KEYS */;
INSERT INTO `ec_taxes` VALUES (1,'VAT',10.000000,1,'published','2024-03-15 03:00:00','2024-03-15 03:00:00'),(2,'None',0.000000,2,'published','2024-03-15 03:00:00','2024-03-15 03:00:00'),(3,'Import Tax',15.000000,3,'published','2024-03-15 03:00:00','2024-03-15 03:00:00');
/*!40000 ALTER TABLE `ec_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_wish_lists`
--

DROP TABLE IF EXISTS `ec_wish_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_wish_lists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wishlist_relation_index` (`product_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_wish_lists`
--

LOCK TABLES `ec_wish_lists` WRITE;
/*!40000 ALTER TABLE `ec_wish_lists` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_wish_lists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'SHIPPING',0,'published','2024-03-15 02:59:56','2024-03-15 02:59:56',NULL),(2,'PAYMENT',1,'published','2024-03-15 02:59:56','2024-03-15 02:59:56',NULL),(3,'ORDER &amp; RETURNS',2,'published','2024-03-15 02:59:56','2024-03-15 02:59:56',NULL);
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'What Shipping Methods Are Available?','Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.',1,'published','2024-03-15 02:59:56','2024-03-15 02:59:56'),(2,'Do You Ship Internationally?','Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.',1,'published','2024-03-15 02:59:56','2024-03-15 02:59:56'),(3,'How Long Will It Take To Get My Package?','Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.',1,'published','2024-03-15 02:59:56','2024-03-15 02:59:56'),(4,'What Payment Methods Are Accepted?','Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.',2,'published','2024-03-15 02:59:56','2024-03-15 02:59:56'),(5,'Is Buying On-Line Safe?','Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.',2,'published','2024-03-15 02:59:56','2024-03-15 02:59:56'),(6,'How do I place an Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level. Raw denim polaroid paleo farm-to-table, put a bird on it lo-fi tattooed Wes Anderson Pinterest letterpress. Fingerstache McSweeney’s pour-over, letterpress Schlitz photo booth master cleanse bespoke hashtag chillwave gentrify.',3,'published','2024-03-15 02:59:56','2024-03-15 02:59:56'),(7,'How Can I Cancel Or Change My Order?','Plaid letterpress leggings craft beer meh ethical Pinterest. Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth.',3,'published','2024-03-15 02:59:56','2024-03-15 02:59:56'),(8,'Do I need an account to place an order?','Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY. Cray ugh 3 wolf moon fap, fashion axe irony butcher cornhole typewriter chambray VHS banjo street art.',3,'published','2024-03-15 02:59:56','2024-03-15 02:59:56'),(9,'How Do I Track My Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb @Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level.',3,'published','2024-03-15 02:59:56','2024-03-15 02:59:56'),(10,'How Can I Return a Product?','Kale chips Truffaut Williamsburg, hashtag fixie Pinterest raw denim c hambray drinking vinegar Carles street art Bushwick gastropub. Wolf Tumblr paleo church-key. Plaid food truck Echo Park YOLO bitters hella, direct trade Thundercats leggings quinoa before they sold out. You probably haven’t heard of them wayfarers authentic umami drinking vinegar Pinterest Cosby sweater, fingerstache fap High Life.',3,'published','2024-03-15 02:59:56','2024-03-15 02:59:56');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Perfect','Alice to herself. \'Of the mushroom,\' said the Hatter, and, just as well go back, and barking hoarsely all the rest, Between yourself and me.\' \'That\'s the judge,\' she said this she looked up, but it.',1,0,'main/galleries/1.jpg',1,'published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(2,'New Day','I wonder if I\'ve kept her waiting!\' Alice felt so desperate that she still held the pieces of mushroom in her hand, and made believe to worry it; then Alice put down yet, before the end of your.',1,0,'main/galleries/2.jpg',1,'published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(3,'Happy Day','Mock Turtle angrily: \'really you are painting those roses?\' Five and Seven said nothing, but looked at Two. Two began in a hoarse growl, \'the world would go anywhere without a moment\'s delay would.',1,0,'main/galleries/3.jpg',1,'published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(4,'Nature','King replied. Here the Dormouse sulkily remarked, \'If you please, sir--\' The Rabbit started violently, dropped the white kid gloves in one hand and a scroll of parchment in the pool a little.',1,0,'main/galleries/4.jpg',1,'published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(5,'Morning','It was high time to avoid shrinking away altogether. \'That WAS a curious appearance in the distance, and she had got to go through next walking about at the March Hare. \'It was the first sentence in.',1,0,'main/galleries/5.jpg',1,'published','2024-03-15 03:00:33','2024-03-15 03:00:33');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"main\\/galleries\\/5.jpg\",\"description\":\"By this time the Mouse to tell me your history, she do.\' \'I\'ll tell it her,\' said the Duchess: \'what a clear way you have to whisper a hint to Time, and round the hall, but they began solemnly.\"},{\"img\":\"main\\/galleries\\/1.jpg\",\"description\":\"The twelve jurors were all talking together: she made it out loud. \'Thinking again?\' the Duchess to play with, and oh! ever so many out-of-the-way things had happened lately, that Alice said.\"},{\"img\":\"main\\/galleries\\/3.jpg\",\"description\":\"PERSONS MORE THAN A MILE HIGH TO LEAVE THE COURT.\' Everybody looked at her with large eyes like a serpent. She had already heard her voice close to her, though, as they were nice grand words to.\"},{\"img\":\"main\\/galleries\\/4.jpg\",\"description\":\"Five! Always lay the blame on others!\' \'YOU\'D better not do that again!\' which produced another dead silence. \'It\'s a pun!\' the King had said that day. \'No, no!\' said the Duchess, as she picked her.\"},{\"img\":\"main\\/galleries\\/2.jpg\",\"description\":\"Alice had been would have appeared to them to be no chance of getting her hands up to them she heard a voice of thunder, and people began running about in the air: it puzzled her too much, so she.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:00:33','2024-03-15 03:00:33'),(2,'[{\"img\":\"main\\/galleries\\/5.jpg\",\"description\":\"By this time the Mouse to tell me your history, she do.\' \'I\'ll tell it her,\' said the Duchess: \'what a clear way you have to whisper a hint to Time, and round the hall, but they began solemnly.\"},{\"img\":\"main\\/galleries\\/1.jpg\",\"description\":\"The twelve jurors were all talking together: she made it out loud. \'Thinking again?\' the Duchess to play with, and oh! ever so many out-of-the-way things had happened lately, that Alice said.\"},{\"img\":\"main\\/galleries\\/3.jpg\",\"description\":\"PERSONS MORE THAN A MILE HIGH TO LEAVE THE COURT.\' Everybody looked at her with large eyes like a serpent. She had already heard her voice close to her, though, as they were nice grand words to.\"},{\"img\":\"main\\/galleries\\/4.jpg\",\"description\":\"Five! Always lay the blame on others!\' \'YOU\'D better not do that again!\' which produced another dead silence. \'It\'s a pun!\' the King had said that day. \'No, no!\' said the Duchess, as she picked her.\"},{\"img\":\"main\\/galleries\\/2.jpg\",\"description\":\"Alice had been would have appeared to them to be no chance of getting her hands up to them she heard a voice of thunder, and people began running about in the air: it puzzled her too much, so she.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:00:33','2024-03-15 03:00:33'),(3,'[{\"img\":\"main\\/galleries\\/5.jpg\",\"description\":\"By this time the Mouse to tell me your history, she do.\' \'I\'ll tell it her,\' said the Duchess: \'what a clear way you have to whisper a hint to Time, and round the hall, but they began solemnly.\"},{\"img\":\"main\\/galleries\\/1.jpg\",\"description\":\"The twelve jurors were all talking together: she made it out loud. \'Thinking again?\' the Duchess to play with, and oh! ever so many out-of-the-way things had happened lately, that Alice said.\"},{\"img\":\"main\\/galleries\\/3.jpg\",\"description\":\"PERSONS MORE THAN A MILE HIGH TO LEAVE THE COURT.\' Everybody looked at her with large eyes like a serpent. She had already heard her voice close to her, though, as they were nice grand words to.\"},{\"img\":\"main\\/galleries\\/4.jpg\",\"description\":\"Five! Always lay the blame on others!\' \'YOU\'D better not do that again!\' which produced another dead silence. \'It\'s a pun!\' the King had said that day. \'No, no!\' said the Duchess, as she picked her.\"},{\"img\":\"main\\/galleries\\/2.jpg\",\"description\":\"Alice had been would have appeared to them to be no chance of getting her hands up to them she heard a voice of thunder, and people began running about in the air: it puzzled her too much, so she.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:00:33','2024-03-15 03:00:33'),(4,'[{\"img\":\"main\\/galleries\\/5.jpg\",\"description\":\"By this time the Mouse to tell me your history, she do.\' \'I\'ll tell it her,\' said the Duchess: \'what a clear way you have to whisper a hint to Time, and round the hall, but they began solemnly.\"},{\"img\":\"main\\/galleries\\/1.jpg\",\"description\":\"The twelve jurors were all talking together: she made it out loud. \'Thinking again?\' the Duchess to play with, and oh! ever so many out-of-the-way things had happened lately, that Alice said.\"},{\"img\":\"main\\/galleries\\/3.jpg\",\"description\":\"PERSONS MORE THAN A MILE HIGH TO LEAVE THE COURT.\' Everybody looked at her with large eyes like a serpent. She had already heard her voice close to her, though, as they were nice grand words to.\"},{\"img\":\"main\\/galleries\\/4.jpg\",\"description\":\"Five! Always lay the blame on others!\' \'YOU\'D better not do that again!\' which produced another dead silence. \'It\'s a pun!\' the King had said that day. \'No, no!\' said the Duchess, as she picked her.\"},{\"img\":\"main\\/galleries\\/2.jpg\",\"description\":\"Alice had been would have appeared to them to be no chance of getting her hands up to them she heard a voice of thunder, and people began running about in the air: it puzzled her too much, so she.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:00:33','2024-03-15 03:00:33'),(5,'[{\"img\":\"main\\/galleries\\/5.jpg\",\"description\":\"By this time the Mouse to tell me your history, she do.\' \'I\'ll tell it her,\' said the Duchess: \'what a clear way you have to whisper a hint to Time, and round the hall, but they began solemnly.\"},{\"img\":\"main\\/galleries\\/1.jpg\",\"description\":\"The twelve jurors were all talking together: she made it out loud. \'Thinking again?\' the Duchess to play with, and oh! ever so many out-of-the-way things had happened lately, that Alice said.\"},{\"img\":\"main\\/galleries\\/3.jpg\",\"description\":\"PERSONS MORE THAN A MILE HIGH TO LEAVE THE COURT.\' Everybody looked at her with large eyes like a serpent. She had already heard her voice close to her, though, as they were nice grand words to.\"},{\"img\":\"main\\/galleries\\/4.jpg\",\"description\":\"Five! Always lay the blame on others!\' \'YOU\'D better not do that again!\' which produced another dead silence. \'It\'s a pun!\' the King had said that day. \'No, no!\' said the Duchess, as she picked her.\"},{\"img\":\"main\\/galleries\\/2.jpg\",\"description\":\"Alice had been would have appeared to them to be no chance of getting her hands up to them she heard a voice of thunder, and people began running about in the air: it puzzled her too much, so she.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:00:33','2024-03-15 03:00:33');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','5a291c9d4fc5095e97ecc180aed6f9d4',1,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(2,'en_US','bc1bd6a04598dba39859f9eb2e0dac08',1,'Botble\\Menu\\Models\\MenuLocation'),(3,'en_US','0fae36120a0364b738d66a4c74b2ff62',1,'Botble\\Menu\\Models\\Menu'),(4,'en_US','b80dd154512aa430eb300ba6b91398cd',2,'Botble\\Menu\\Models\\Menu'),(5,'en_US','bb443908db39464f0d28127ffc59502a',3,'Botble\\Menu\\Models\\Menu');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'404','404',2,'image/png',15820,'main/general/404.png','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(2,0,'about-1','about-1',2,'image/jpeg',9222,'main/general/about-1.jpg','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(3,0,'about-2','about-2',2,'image/jpeg',5105,'main/general/about-2.jpg','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(4,0,'breadcrumb','breadcrumb',2,'image/jpeg',5276,'main/general/breadcrumb.jpg','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(5,0,'cta-shape-1','cta-shape-1',2,'image/png',22860,'main/general/cta-shape-1.png','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(6,0,'cta-shape-2','cta-shape-2',2,'image/png',16796,'main/general/cta-shape-2.png','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(7,0,'cta-thumb-1','cta-thumb-1',2,'image/jpeg',6053,'main/general/cta-thumb-1.jpg','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(8,0,'favicon','favicon',2,'image/png',1831,'main/general/favicon.png','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(9,0,'footer-pay','footer-pay',2,'image/png',490,'main/general/footer-pay.png','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(10,0,'logo-white','logo-white',2,'image/png',22020,'main/general/logo-white.png','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(11,0,'logo','logo',2,'image/png',22398,'main/general/logo.png','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(12,0,'newsletter-popup','newsletter-popup',2,'image/png',17253,'main/general/newsletter-popup.png','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(13,0,'placeholder','placeholder',2,'image/png',2100,'main/general/placeholder.png','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(14,0,'preloader-icon','preloader-icon',2,'image/png',4182,'main/general/preloader-icon.png','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(15,0,'signature','signature',2,'image/png',2117,'main/general/signature.png','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(16,0,'slider-offer','slider-offer',2,'image/png',970,'main/general/slider-offer.png','[]','2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(27,0,'1','1',4,'image/jpeg',4294,'main/customers/1.jpg','[]','2024-03-15 02:59:56','2024-03-15 02:59:56',NULL),(28,0,'10','10',4,'image/jpeg',4294,'main/customers/10.jpg','[]','2024-03-15 02:59:57','2024-03-15 02:59:57',NULL),(29,0,'2','2',4,'image/jpeg',4294,'main/customers/2.jpg','[]','2024-03-15 02:59:57','2024-03-15 02:59:57',NULL),(30,0,'3','3',4,'image/jpeg',4294,'main/customers/3.jpg','[]','2024-03-15 02:59:57','2024-03-15 02:59:57',NULL),(31,0,'4','4',4,'image/jpeg',4294,'main/customers/4.jpg','[]','2024-03-15 02:59:57','2024-03-15 02:59:57',NULL),(32,0,'5','5',4,'image/jpeg',4294,'main/customers/5.jpg','[]','2024-03-15 02:59:57','2024-03-15 02:59:57',NULL),(33,0,'6','6',4,'image/jpeg',4294,'main/customers/6.jpg','[]','2024-03-15 02:59:57','2024-03-15 02:59:57',NULL),(34,0,'7','7',4,'image/jpeg',4294,'main/customers/7.jpg','[]','2024-03-15 02:59:57','2024-03-15 02:59:57',NULL),(35,0,'8','8',4,'image/jpeg',4294,'main/customers/8.jpg','[]','2024-03-15 02:59:57','2024-03-15 02:59:57',NULL),(36,0,'9','9',4,'image/jpeg',4294,'main/customers/9.jpg','[]','2024-03-15 02:59:57','2024-03-15 02:59:57',NULL),(37,0,'blog-big-1','blog-big-1',5,'image/jpeg',13885,'main/blog/blog-big-1.jpg','[]','2024-03-15 03:00:00','2024-03-15 03:00:00',NULL),(38,0,'blog-details-sm-1','blog-details-sm-1',5,'image/jpeg',8166,'main/blog/blog-details-sm-1.jpg','[]','2024-03-15 03:00:00','2024-03-15 03:00:00',NULL),(39,0,'post-1','post-1',5,'image/jpeg',6189,'main/blog/post-1.jpg','[]','2024-03-15 03:00:00','2024-03-15 03:00:00',NULL),(40,0,'post-10','post-10',5,'image/jpeg',5907,'main/blog/post-10.jpg','[]','2024-03-15 03:00:00','2024-03-15 03:00:00',NULL),(41,0,'post-11','post-11',5,'image/jpeg',5907,'main/blog/post-11.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(42,0,'post-12','post-12',5,'image/jpeg',5907,'main/blog/post-12.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(43,0,'post-2','post-2',5,'image/jpeg',6189,'main/blog/post-2.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(44,0,'post-3','post-3',5,'image/jpeg',6189,'main/blog/post-3.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(45,0,'post-4','post-4',5,'image/jpeg',6045,'main/blog/post-4.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(46,0,'post-5','post-5',5,'image/jpeg',6045,'main/blog/post-5.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(47,0,'post-6','post-6',5,'image/jpeg',6045,'main/blog/post-6.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(48,0,'post-7','post-7',5,'image/jpeg',5907,'main/blog/post-7.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(49,0,'post-8','post-8',5,'image/jpeg',5907,'main/blog/post-8.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(50,0,'post-9','post-9',5,'image/jpeg',5907,'main/blog/post-9.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(51,0,'1','1',3,'image/jpeg',4068,'main/users/1.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(52,0,'10','10',3,'image/jpeg',7599,'main/users/10.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(53,0,'2','2',3,'image/jpeg',7599,'main/users/2.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(54,0,'3','3',3,'image/jpeg',6387,'main/users/3.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(55,0,'4','4',3,'image/jpeg',7599,'main/users/4.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(56,0,'5','5',3,'image/jpeg',6387,'main/users/5.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(57,0,'6','6',3,'image/jpeg',7599,'main/users/6.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(58,0,'7','7',3,'image/jpeg',6387,'main/users/7.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(59,0,'8','8',3,'image/jpeg',7599,'main/users/8.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(60,0,'9','9',3,'image/jpeg',6387,'main/users/9.jpg','[]','2024-03-15 03:00:01','2024-03-15 03:00:01',NULL),(61,0,'1','1',6,'image/png',9133,'main/stores/1.png','[]','2024-03-15 03:00:02','2024-03-15 03:00:02',NULL),(62,0,'10','10',6,'image/png',4263,'main/stores/10.png','[]','2024-03-15 03:00:02','2024-03-15 03:00:02',NULL),(63,0,'11','11',6,'image/png',4420,'main/stores/11.png','[]','2024-03-15 03:00:02','2024-03-15 03:00:02',NULL),(64,0,'12','12',6,'image/png',4908,'main/stores/12.png','[]','2024-03-15 03:00:02','2024-03-15 03:00:02',NULL),(65,0,'13','13',6,'image/png',3441,'main/stores/13.png','[]','2024-03-15 03:00:02','2024-03-15 03:00:02',NULL),(66,0,'14','14',6,'image/png',4209,'main/stores/14.png','[]','2024-03-15 03:00:02','2024-03-15 03:00:02',NULL),(67,0,'15','15',6,'image/png',5113,'main/stores/15.png','[]','2024-03-15 03:00:02','2024-03-15 03:00:02',NULL),(68,0,'16','16',6,'image/png',4563,'main/stores/16.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(69,0,'17','17',6,'image/png',4896,'main/stores/17.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(70,0,'2','2',6,'image/png',9008,'main/stores/2.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(71,0,'3','3',6,'image/png',8006,'main/stores/3.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(72,0,'4','4',6,'image/png',8728,'main/stores/4.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(73,0,'5','5',6,'image/png',10689,'main/stores/5.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(74,0,'6','6',6,'image/png',10989,'main/stores/6.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(75,0,'7','7',6,'image/png',3730,'main/stores/7.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(76,0,'8','8',6,'image/png',4030,'main/stores/8.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(77,0,'9','9',6,'image/png',3810,'main/stores/9.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(78,0,'cover-1','cover-1',6,'image/png',4208,'main/stores/cover-1.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(79,0,'cover-2','cover-2',6,'image/png',8798,'main/stores/cover-2.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(80,0,'cover-3','cover-3',6,'image/png',3888,'main/stores/cover-3.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(81,0,'cover-4','cover-4',6,'image/png',11893,'main/stores/cover-4.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(82,0,'cover-5','cover-5',6,'image/png',8798,'main/stores/cover-5.png','[]','2024-03-15 03:00:03','2024-03-15 03:00:03',NULL),(83,0,'shape-1','shape-1',7,'image/png',18992,'main/sliders/shape-1.png','[]','2024-03-15 03:00:07','2024-03-15 03:00:07',NULL),(84,0,'shape-2','shape-2',7,'image/png',803,'main/sliders/shape-2.png','[]','2024-03-15 03:00:07','2024-03-15 03:00:07',NULL),(85,0,'shape-3','shape-3',7,'image/png',658,'main/sliders/shape-3.png','[]','2024-03-15 03:00:07','2024-03-15 03:00:07',NULL),(86,0,'shape-4','shape-4',7,'image/png',475,'main/sliders/shape-4.png','[]','2024-03-15 03:00:07','2024-03-15 03:00:07',NULL),(87,0,'slider-1','slider-1',7,'image/png',7405,'main/sliders/slider-1.png','[]','2024-03-15 03:00:07','2024-03-15 03:00:07',NULL),(88,0,'slider-2','slider-2',7,'image/png',8434,'main/sliders/slider-2.png','[]','2024-03-15 03:00:07','2024-03-15 03:00:07',NULL),(89,0,'slider-3','slider-3',7,'image/png',7794,'main/sliders/slider-3.png','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(90,0,'1','1',8,'image/png',4294,'main/product-categories/1.png','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(91,0,'2','2',8,'image/png',4294,'main/product-categories/2.png','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(92,0,'3','3',8,'image/png',4294,'main/product-categories/3.png','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(93,0,'4','4',8,'image/png',4294,'main/product-categories/4.png','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(94,0,'5','5',8,'image/png',4294,'main/product-categories/5.png','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(95,0,'category-thumb-1','category-thumb-1',8,'image/jpeg',4294,'main/product-categories/category-thumb-1.jpg','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(96,0,'category-thumb-10','category-thumb-10',8,'image/jpeg',4294,'main/product-categories/category-thumb-10.jpg','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(97,0,'category-thumb-11','category-thumb-11',8,'image/jpeg',4294,'main/product-categories/category-thumb-11.jpg','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(98,0,'category-thumb-12','category-thumb-12',8,'image/jpeg',4294,'main/product-categories/category-thumb-12.jpg','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(99,0,'category-thumb-3','category-thumb-3',8,'image/jpeg',4294,'main/product-categories/category-thumb-3.jpg','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(100,0,'category-thumb-4','category-thumb-4',8,'image/jpeg',4294,'main/product-categories/category-thumb-4.jpg','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(101,0,'category-thumb-5','category-thumb-5',8,'image/jpeg',4294,'main/product-categories/category-thumb-5.jpg','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(102,0,'category-thumb-6','category-thumb-6',8,'image/jpeg',4294,'main/product-categories/category-thumb-6.jpg','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(103,0,'category-thumb-8','category-thumb-8',8,'image/jpeg',4294,'main/product-categories/category-thumb-8.jpg','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(104,0,'category-thumb-9','category-thumb-9',8,'image/jpeg',4294,'main/product-categories/category-thumb-9.jpg','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(105,0,'menu-1','menu-1',8,'image/jpeg',4294,'main/product-categories/menu-1.jpg','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(106,0,'menu-2','menu-2',8,'image/jpeg',4294,'main/product-categories/menu-2.jpg','[]','2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(107,0,'menu-3','menu-3',8,'image/jpeg',4294,'main/product-categories/menu-3.jpg','[]','2024-03-15 03:00:09','2024-03-15 03:00:09',NULL),(108,0,'product-1','product-1',9,'image/jpeg',9803,'main/products/product-1.jpg','[]','2024-03-15 03:00:09','2024-03-15 03:00:09',NULL),(109,0,'product-10','product-10',9,'image/jpeg',9803,'main/products/product-10.jpg','[]','2024-03-15 03:00:09','2024-03-15 03:00:09',NULL),(110,0,'product-11','product-11',9,'image/jpeg',9803,'main/products/product-11.jpg','[]','2024-03-15 03:00:09','2024-03-15 03:00:09',NULL),(111,0,'product-12','product-12',9,'image/jpeg',9803,'main/products/product-12.jpg','[]','2024-03-15 03:00:09','2024-03-15 03:00:09',NULL),(112,0,'product-13','product-13',9,'image/jpeg',9803,'main/products/product-13.jpg','[]','2024-03-15 03:00:09','2024-03-15 03:00:09',NULL),(113,0,'product-14','product-14',9,'image/jpeg',9803,'main/products/product-14.jpg','[]','2024-03-15 03:00:09','2024-03-15 03:00:09',NULL),(114,0,'product-15','product-15',9,'image/jpeg',9803,'main/products/product-15.jpg','[]','2024-03-15 03:00:09','2024-03-15 03:00:09',NULL),(115,0,'product-16','product-16',9,'image/jpeg',9803,'main/products/product-16.jpg','[]','2024-03-15 03:00:09','2024-03-15 03:00:09',NULL),(116,0,'product-17','product-17',9,'image/jpeg',9803,'main/products/product-17.jpg','[]','2024-03-15 03:00:10','2024-03-15 03:00:10',NULL),(117,0,'product-18','product-18',9,'image/jpeg',9803,'main/products/product-18.jpg','[]','2024-03-15 03:00:10','2024-03-15 03:00:10',NULL),(118,0,'product-19','product-19',9,'image/jpeg',9803,'main/products/product-19.jpg','[]','2024-03-15 03:00:10','2024-03-15 03:00:10',NULL),(119,0,'product-2','product-2',9,'image/jpeg',9803,'main/products/product-2.jpg','[]','2024-03-15 03:00:10','2024-03-15 03:00:10',NULL),(120,0,'product-20','product-20',9,'image/jpeg',9803,'main/products/product-20.jpg','[]','2024-03-15 03:00:10','2024-03-15 03:00:10',NULL),(121,0,'product-3','product-3',9,'image/jpeg',9803,'main/products/product-3.jpg','[]','2024-03-15 03:00:10','2024-03-15 03:00:10',NULL),(122,0,'product-4','product-4',9,'image/jpeg',9803,'main/products/product-4.jpg','[]','2024-03-15 03:00:10','2024-03-15 03:00:10',NULL),(123,0,'product-5','product-5',9,'image/jpeg',9803,'main/products/product-5.jpg','[]','2024-03-15 03:00:10','2024-03-15 03:00:10',NULL),(124,0,'product-6','product-6',9,'image/jpeg',9803,'main/products/product-6.jpg','[]','2024-03-15 03:00:10','2024-03-15 03:00:10',NULL),(125,0,'product-7','product-7',9,'image/jpeg',9803,'main/products/product-7.jpg','[]','2024-03-15 03:00:10','2024-03-15 03:00:10',NULL),(126,0,'product-8','product-8',9,'image/jpeg',9803,'main/products/product-8.jpg','[]','2024-03-15 03:00:10','2024-03-15 03:00:10',NULL),(127,0,'product-9','product-9',9,'image/jpeg',9803,'main/products/product-9.jpg','[]','2024-03-15 03:00:10','2024-03-15 03:00:10',NULL),(128,0,'product-details-desc-1','product-details-desc-1',9,'image/jpeg',9803,'main/products/product-details-desc-1.jpg','[]','2024-03-15 03:00:10','2024-03-15 03:00:10',NULL),(129,0,'product-details-desc-2','product-details-desc-2',9,'image/jpeg',9803,'main/products/product-details-desc-2.jpg','[]','2024-03-15 03:00:11','2024-03-15 03:00:11',NULL),(130,0,'product-details-desc-3','product-details-desc-3',9,'image/jpeg',9803,'main/products/product-details-desc-3.jpg','[]','2024-03-15 03:00:11','2024-03-15 03:00:11',NULL),(131,0,'1','1',10,'image/jpeg',6309,'main/banners/1.jpg','[]','2024-03-15 03:00:28','2024-03-15 03:00:28',NULL),(132,0,'2','2',10,'image/jpeg',6275,'main/banners/2.jpg','[]','2024-03-15 03:00:28','2024-03-15 03:00:28',NULL),(133,0,'slider-1','slider-1',10,'image/png',8207,'main/banners/slider-1.png','[]','2024-03-15 03:00:29','2024-03-15 03:00:29',NULL),(134,0,'slider-2','slider-2',10,'image/png',8497,'main/banners/slider-2.png','[]','2024-03-15 03:00:29','2024-03-15 03:00:29',NULL),(135,0,'slider-3','slider-3',10,'image/png',6239,'main/banners/slider-3.png','[]','2024-03-15 03:00:29','2024-03-15 03:00:29',NULL),(136,0,'gadget-banner-1','gadget-banner-1',11,'image/jpeg',3870,'main/gadgets/gadget-banner-1.jpg','[]','2024-03-15 03:00:30','2024-03-15 03:00:30',NULL),(137,0,'gadget-banner-2','gadget-banner-2',11,'image/jpeg',3870,'main/gadgets/gadget-banner-2.jpg','[]','2024-03-15 03:00:30','2024-03-15 03:00:30',NULL),(138,0,'gadget-girl','gadget-girl',11,'image/png',4417,'main/gadgets/gadget-girl.png','[]','2024-03-15 03:00:30','2024-03-15 03:00:30',NULL),(139,0,'1','1',12,'image/jpeg',4294,'main/galleries/1.jpg','[]','2024-03-15 03:00:32','2024-03-15 03:00:32',NULL),(140,0,'2','2',12,'image/jpeg',4294,'main/galleries/2.jpg','[]','2024-03-15 03:00:32','2024-03-15 03:00:32',NULL),(141,0,'3','3',12,'image/jpeg',4294,'main/galleries/3.jpg','[]','2024-03-15 03:00:32','2024-03-15 03:00:32',NULL),(142,0,'4','4',12,'image/jpeg',4294,'main/galleries/4.jpg','[]','2024-03-15 03:00:32','2024-03-15 03:00:32',NULL),(143,0,'5','5',12,'image/jpeg',4294,'main/galleries/5.jpg','[]','2024-03-15 03:00:32','2024-03-15 03:00:32',NULL),(147,0,'icon-1','icon-1',13,'image/png',4469,'main/contact/icon-1.png','[]','2024-03-15 03:00:33','2024-03-15 03:00:33',NULL),(148,0,'icon-2','icon-2',13,'image/png',5977,'main/contact/icon-2.png','[]','2024-03-15 03:00:33','2024-03-15 03:00:33',NULL),(149,0,'icon-3','icon-3',13,'image/png',6082,'main/contact/icon-3.png','[]','2024-03-15 03:00:33','2024-03-15 03:00:33',NULL),(150,0,'line','line',14,'image/png',6152,'main/shapes/line.png','[]','2024-03-15 03:00:34','2024-03-15 03:00:34',NULL),(151,0,'quote','quote',14,'image/png',595,'main/shapes/quote.png','[]','2024-03-15 03:00:34','2024-03-15 03:00:34',NULL);
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(2,0,'general',NULL,'general',1,'2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(3,0,'users',NULL,'users',1,'2024-03-15 02:59:52','2024-03-15 02:59:52',NULL),(4,0,'customers',NULL,'customers',1,'2024-03-15 02:59:56','2024-03-15 02:59:56',NULL),(5,0,'blog',NULL,'blog',1,'2024-03-15 03:00:00','2024-03-15 03:00:00',NULL),(6,0,'stores',NULL,'stores',1,'2024-03-15 03:00:02','2024-03-15 03:00:02',NULL),(7,0,'sliders',NULL,'sliders',1,'2024-03-15 03:00:07','2024-03-15 03:00:07',NULL),(8,0,'product-categories',NULL,'product-categories',1,'2024-03-15 03:00:08','2024-03-15 03:00:08',NULL),(9,0,'products',NULL,'products',1,'2024-03-15 03:00:09','2024-03-15 03:00:09',NULL),(10,0,'banners',NULL,'banners',1,'2024-03-15 03:00:28','2024-03-15 03:00:28',NULL),(11,0,'gadgets',NULL,'gadgets',1,'2024-03-15 03:00:30','2024-03-15 03:00:30',NULL),(12,0,'galleries',NULL,'galleries',1,'2024-03-15 03:00:32','2024-03-15 03:00:32',NULL),(13,0,'contact',NULL,'contact',1,'2024-03-15 03:00:33','2024-03-15 03:00:33',NULL),(14,0,'shapes',NULL,'shapes',1,'2024-03-15 03:00:34','2024-03-15 03:00:34',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2024-03-15 03:00:33','2024-03-15 03:00:33');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,1,'Botble\\Page\\Models\\Page','/home',NULL,0,'Home',NULL,'_self',1,'2024-03-15 03:00:33','2024-03-15 03:00:34'),(2,1,1,NULL,NULL,'https://shofy.botble.com',NULL,0,'Electronics',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(3,1,1,NULL,NULL,'https://shofy-fashion.botble.com',NULL,0,'Fashion',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(4,1,1,NULL,NULL,'https://shofy-beauty.botble.com',NULL,0,'Beauty',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(5,1,1,NULL,NULL,'https://shofy-jewelry.botble.com',NULL,0,'Jewelry',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(6,1,1,NULL,NULL,'https://shofy-grocery.botble.com',NULL,0,'Grocery',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(7,1,0,NULL,NULL,NULL,NULL,0,'Shop',NULL,'_self',1,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(8,1,7,2,'Botble\\Page\\Models\\Page','/product-categories',NULL,0,'Shop Categories',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:34'),(9,1,7,NULL,NULL,'/products?layout=list',NULL,0,'Shop List',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(10,1,7,NULL,NULL,'/products?layout=grid',NULL,0,'Shop Grid',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(11,1,7,NULL,NULL,'/products/amazon-fire-tv-stick-4k-max',NULL,0,'Product Detail',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(12,1,7,3,'Botble\\Page\\Models\\Page','/coupons',NULL,0,'Grab Coupons',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:34'),(13,1,7,NULL,NULL,'/cart',NULL,0,'Cart',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(14,1,7,NULL,NULL,'/compare',NULL,0,'Compare',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(15,1,7,NULL,NULL,'/wishlist',NULL,0,'Wishlist',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(16,1,7,NULL,NULL,'/orders/tracking',NULL,0,'Track Your Order',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(17,1,0,NULL,NULL,'/stores',NULL,0,'Vendors',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(18,1,0,NULL,NULL,NULL,NULL,0,'Pages',NULL,'_self',1,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(19,1,18,NULL,NULL,'/login',NULL,0,'Login',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(20,1,18,NULL,NULL,'/register',NULL,0,'Register',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(21,1,18,NULL,NULL,'/password/reset',NULL,0,'Forgot Password',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(22,1,18,NULL,NULL,'/404',NULL,0,'404 Error',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(23,1,0,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Blog',NULL,'_self',1,'2024-03-15 03:00:33','2024-03-15 03:00:34'),(24,1,23,NULL,NULL,'/blog?layout=grid',NULL,0,'Blog Grid',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(25,1,23,NULL,NULL,'/blog?layout=list',NULL,0,'Blog List',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(26,1,23,NULL,NULL,'/blog/were-crushing-hard-on-summers-10-biggest-bag-trends',NULL,0,'Blog Detail',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(27,1,0,5,'Botble\\Page\\Models\\Page','/contact',NULL,0,'Contact',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:34'),(28,2,0,NULL,NULL,'/orders/tracking',NULL,1,'Track Orders',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:33'),(29,2,0,9,'Botble\\Page\\Models\\Page','/shipping',NULL,1,'Shipping',NULL,'_self',0,'2024-03-15 03:00:33','2024-03-15 03:00:34'),(30,2,0,NULL,NULL,'/wishlist',NULL,1,'Wishlist',NULL,'_self',0,'2024-03-15 03:00:34','2024-03-15 03:00:34'),(31,2,0,NULL,NULL,'/customer/overview',NULL,1,'My Account',NULL,'_self',0,'2024-03-15 03:00:34','2024-03-15 03:00:34'),(32,2,0,NULL,NULL,'/customer/orders',NULL,1,'Order History',NULL,'_self',0,'2024-03-15 03:00:34','2024-03-15 03:00:34'),(33,2,0,NULL,NULL,'/customer/order-returns',NULL,1,'Returns',NULL,'_self',0,'2024-03-15 03:00:34','2024-03-15 03:00:34'),(34,3,0,7,'Botble\\Page\\Models\\Page','/our-story',NULL,2,'Our Story',NULL,'_self',0,'2024-03-15 03:00:34','2024-03-15 03:00:34'),(35,3,0,8,'Botble\\Page\\Models\\Page','/careers',NULL,2,'Careers',NULL,'_self',0,'2024-03-15 03:00:34','2024-03-15 03:00:34'),(36,3,0,6,'Botble\\Page\\Models\\Page','/cookie-policy',NULL,2,'Privacy Policy',NULL,'_self',0,'2024-03-15 03:00:34','2024-03-15 03:00:34'),(37,3,0,NULL,NULL,'/blog',NULL,2,'Latest News',NULL,'_self',0,'2024-03-15 03:00:34','2024-03-15 03:00:34'),(38,3,0,5,'Botble\\Page\\Models\\Page','/contact',NULL,2,'Contact Us',NULL,'_self',0,'2024-03-15 03:00:34','2024-03-15 03:00:34');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(2,'My Account','my-account','published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(3,'Information','information','published','2024-03-15 03:00:34','2024-03-15 03:00:34');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'background','[\"main\\/stores\\/cover-2.png\"]',1,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:06','2024-03-15 03:00:06'),(2,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',1,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:06','2024-03-15 03:00:06'),(3,'background','[\"main\\/stores\\/cover-3.png\"]',2,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:06','2024-03-15 03:00:06'),(4,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',2,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:06','2024-03-15 03:00:06'),(5,'background','[\"main\\/stores\\/cover-5.png\"]',3,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:06','2024-03-15 03:00:06'),(6,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',3,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:06','2024-03-15 03:00:06'),(7,'background','[\"main\\/stores\\/cover-3.png\"]',4,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:06','2024-03-15 03:00:06'),(8,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',4,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:06','2024-03-15 03:00:06'),(9,'background','[\"main\\/stores\\/cover-4.png\"]',5,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:06','2024-03-15 03:00:06'),(10,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',5,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:06','2024-03-15 03:00:06'),(11,'background','[\"main\\/stores\\/cover-1.png\"]',6,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:06','2024-03-15 03:00:06'),(12,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',6,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:06','2024-03-15 03:00:06'),(13,'background','[\"main\\/stores\\/cover-4.png\"]',7,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:07','2024-03-15 03:00:07'),(14,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',7,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:07','2024-03-15 03:00:07'),(15,'background','[\"main\\/stores\\/cover-4.png\"]',8,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:07','2024-03-15 03:00:07'),(16,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',8,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:00:07','2024-03-15 03:00:07'),(17,'background_color','[\"#115061\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:00:08','2024-03-15 03:00:08'),(18,'is_light','[0]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:00:08','2024-03-15 03:00:08'),(19,'subtitle','[\"Starting at <b>$274.00<\\/b>\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:00:08','2024-03-15 03:00:08'),(20,'button_label','[\"Shop Now\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:00:08','2024-03-15 03:00:08'),(21,'background_color','[\"#115061\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:00:08','2024-03-15 03:00:08'),(22,'is_light','[0]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:00:08','2024-03-15 03:00:08'),(23,'subtitle','[\"Starting at <b>$999.00<\\/b>\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:00:08','2024-03-15 03:00:08'),(24,'button_label','[\"Shop Now\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:00:08','2024-03-15 03:00:08'),(25,'background_color','[\"#E3EDF6\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:00:08','2024-03-15 03:00:08'),(26,'is_light','[1]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:00:08','2024-03-15 03:00:08'),(27,'subtitle','[\"Starting at <b>$999.00<\\/b>\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:00:08','2024-03-15 03:00:08'),(28,'button_label','[\"Shop Now\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:00:08','2024-03-15 03:00:08'),(29,'faq_ids','[[3,6,7,8,9]]',1,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(30,'faq_ids','[[1,4,5,8,10]]',2,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(31,'faq_ids','[[1,2,4,5,10]]',3,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(32,'faq_ids','[[3,4,7,8,10]]',4,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(33,'faq_ids','[[1,2,3,4,7]]',5,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(34,'faq_ids','[[2,3,7,8,9]]',6,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(35,'faq_ids','[[1,3,4,6,10]]',7,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(36,'faq_ids','[[1,3,4,5,8]]',8,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(37,'faq_ids','[[2,3,6,7,9]]',9,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(38,'faq_ids','[[3,4,5,7,8]]',10,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(39,'faq_ids','[[2,3,7,8,10]]',11,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(40,'faq_ids','[[2,5,6,9,10]]',12,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(41,'faq_ids','[[2,4,7,8,10]]',13,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(42,'faq_ids','[[1,2,4,5,8]]',14,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(43,'faq_ids','[[4,5,6,7,8]]',15,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(44,'faq_ids','[[5,6,7,8,10]]',16,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(45,'faq_ids','[[1,5,6,7,10]]',17,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(46,'faq_ids','[[1,4,8,9,10]]',18,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:12','2024-03-15 03:00:12'),(47,'faq_ids','[[2,3,5,6,7]]',19,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(48,'faq_ids','[[3,6,7,8,9]]',20,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(49,'faq_ids','[[3,5,8,9,10]]',21,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(50,'faq_ids','[[1,3,7,8,10]]',22,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(51,'faq_ids','[[1,3,8,9,10]]',23,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(52,'faq_ids','[[2,3,7,9,10]]',24,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(53,'faq_ids','[[1,2,4,8,10]]',25,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(54,'faq_ids','[[2,3,4,6,9]]',26,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(55,'faq_ids','[[4,6,7,8,9]]',27,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(56,'faq_ids','[[1,2,6,8,10]]',28,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(57,'faq_ids','[[4,5,7,8,9]]',29,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(58,'faq_ids','[[4,6,8,9,10]]',30,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(59,'faq_ids','[[3,4,5,6,7]]',31,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(60,'faq_ids','[[1,3,4,6,9]]',32,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(61,'faq_ids','[[1,4,5,7,10]]',33,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(62,'faq_ids','[[3,6,7,8,9]]',34,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(63,'faq_ids','[[3,5,7,9,10]]',35,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(64,'faq_ids','[[1,2,3,5,10]]',36,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:13','2024-03-15 03:00:13'),(65,'faq_ids','[[2,4,5,7,8]]',37,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:14','2024-03-15 03:00:14'),(66,'faq_ids','[[1,2,4,8,10]]',38,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:14','2024-03-15 03:00:14'),(67,'faq_ids','[[1,4,5,7,8]]',39,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:14','2024-03-15 03:00:14'),(68,'faq_ids','[[1,2,3,7,9]]',40,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:14','2024-03-15 03:00:14'),(69,'faq_ids','[[1,2,3,5,10]]',41,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:14','2024-03-15 03:00:14'),(70,'faq_ids','[[4,5,7,9,10]]',42,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:14','2024-03-15 03:00:14'),(71,'faq_ids','[[1,3,7,9,10]]',43,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:14','2024-03-15 03:00:14'),(72,'faq_ids','[[3,4,8,9,10]]',44,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:14','2024-03-15 03:00:14'),(73,'faq_ids','[[3,5,7,8,10]]',45,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:14','2024-03-15 03:00:14'),(74,'faq_ids','[[1,2,3,6,7]]',46,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:14','2024-03-15 03:00:14'),(75,'faq_ids','[[1,5,6,7,8]]',47,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:15','2024-03-15 03:00:15'),(76,'faq_ids','[[1,2,6,9,10]]',48,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:15','2024-03-15 03:00:15'),(77,'faq_ids','[[2,3,5,9,10]]',49,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:16','2024-03-15 03:00:16'),(78,'faq_ids','[[2,5,6,7,9]]',50,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:16','2024-03-15 03:00:16'),(79,'faq_ids','[[1,3,4,5,10]]',51,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:17','2024-03-15 03:00:17'),(80,'faq_ids','[[4,5,6,8,10]]',52,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:17','2024-03-15 03:00:17'),(81,'faq_ids','[[2,4,5,8,10]]',53,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:17','2024-03-15 03:00:17'),(82,'faq_ids','[[3,5,7,9,10]]',54,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:18','2024-03-15 03:00:18'),(83,'faq_ids','[[1,3,7,8,10]]',55,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:18','2024-03-15 03:00:18'),(84,'faq_ids','[[3,5,6,7,9]]',56,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:19','2024-03-15 03:00:19'),(85,'faq_ids','[[1,2,3,6,10]]',57,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:00:19','2024-03-15 03:00:19'),(86,'title','[\"Smartphone \\n BLU G91 Pro 2022\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:31','2024-03-15 03:00:31'),(87,'subtitle','[\"Sale 20% off all store\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:31','2024-03-15 03:00:31'),(88,'button_label','[\"Shop Now\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:31','2024-03-15 03:00:31'),(89,'title','[\"HyperX Cloud II \\n Wireless\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:31','2024-03-15 03:00:31'),(90,'subtitle','[\"Sale 35% off\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:31','2024-03-15 03:00:31'),(91,'button_label','[\"Shop Now\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:31','2024-03-15 03:00:31'),(92,'title','[\"Selected novelty \\n Products\"]',3,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:31','2024-03-15 03:00:31'),(93,'subtitle','[\"Only $99.00\"]',3,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:31','2024-03-15 03:00:31'),(94,'title','[\"Top Rated \\n Products\"]',4,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:31','2024-03-15 03:00:31'),(95,'subtitle','[\"Only $55.00\"]',4,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:31','2024-03-15 03:00:31'),(96,'title','[\"Samsung Galaxy Tab S6, Wifi Tablet\"]',5,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:31','2024-03-15 03:00:31'),(97,'subtitle','[\"Tablet Collection 2023\"]',5,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:32','2024-03-15 03:00:32'),(98,'button_label','[\"Shop Now\"]',5,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:32','2024-03-15 03:00:32'),(99,'title','[\"Samsung Galaxy Tab S6, Wifi Tablet\"]',6,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:32','2024-03-15 03:00:32'),(100,'subtitle','[\"Tablet Collection 2023\"]',6,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:32','2024-03-15 03:00:32'),(101,'button_label','[\"Shop Now\"]',6,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:32','2024-03-15 03:00:32'),(102,'title','[\"Samsung Galaxy Tab S6, Wifi Tablet\"]',7,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:32','2024-03-15 03:00:32'),(103,'subtitle','[\"Tablet Collection 2023\"]',7,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:32','2024-03-15 03:00:32'),(104,'button_label','[\"Shop Now\"]',7,'Botble\\Ads\\Models\\Ads','2024-03-15 03:00:32','2024-03-15 03:00:32'),(105,'breadcrumb_style','[\"none\"]',1,'Botble\\Page\\Models\\Page','2024-03-15 03:00:33','2024-03-15 03:00:33');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2013_04_09_032329_create_base_tables',1),(2,'2013_04_09_062329_create_revisions_table',1),(3,'2014_10_12_000000_create_users_table',1),(4,'2014_10_12_100000_create_password_reset_tokens_table',1),(5,'2015_06_18_033822_create_blog_table',1),(6,'2015_06_29_025744_create_audit_history',1),(7,'2016_05_28_112028_create_system_request_logs_table',1),(8,'2016_06_10_230148_create_acl_tables',1),(9,'2016_06_14_230857_create_menus_table',1),(10,'2016_06_17_091537_create_contacts_table',1),(11,'2016_06_28_221418_create_pages_table',1),(12,'2016_10_03_032336_create_languages_table',1),(13,'2016_10_05_074239_create_setting_table',1),(14,'2016_10_07_193005_create_translations_table',1),(15,'2016_10_13_150201_create_galleries_table',1),(16,'2016_11_28_032840_create_dashboard_widget_tables',1),(17,'2016_12_16_084601_create_widgets_table',1),(18,'2017_05_09_070343_create_media_tables',1),(19,'2017_05_18_080441_create_payment_tables',1),(20,'2017_07_11_140018_create_simple_slider_table',1),(21,'2017_10_24_154832_create_newsletter_table',1),(22,'2017_11_03_070450_create_slug_table',1),(23,'2018_07_09_214610_create_testimonial_table',1),(24,'2018_07_09_221238_create_faq_table',1),(25,'2019_01_05_053554_create_jobs_table',1),(26,'2019_08_19_000000_create_failed_jobs_table',1),(27,'2019_11_18_061011_create_country_table',1),(28,'2019_12_14_000001_create_personal_access_tokens_table',1),(29,'2020_03_05_041139_create_ecommerce_tables',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_01_01_044147_ecommerce_create_flash_sale_table',1),(32,'2021_01_17_082713_add_column_is_featured_to_product_collections_table',1),(33,'2021_01_18_024333_add_zip_code_into_table_customer_addresses',1),(34,'2021_02_16_092633_remove_default_value_for_author_type',1),(35,'2021_02_18_073505_update_table_ec_reviews',1),(36,'2021_03_10_024419_add_column_confirmed_at_to_table_ec_customers',1),(37,'2021_03_10_025153_change_column_tax_amount',1),(38,'2021_03_20_033103_add_column_availability_to_table_ec_products',1),(39,'2021_03_27_144913_add_customer_type_into_table_payments',1),(40,'2021_04_28_074008_ecommerce_create_product_label_table',1),(41,'2021_05_24_034720_make_column_currency_nullable',1),(42,'2021_05_31_173037_ecommerce_create_ec_products_translations',1),(43,'2021_07_06_030002_create_marketplace_table',1),(44,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(45,'2021_08_17_105016_remove_column_currency_id_in_some_tables',1),(46,'2021_08_30_142128_add_images_column_to_ec_reviews_table',1),(47,'2021_09_04_150137_add_vendor_verified_at_to_ec_customers_table',1),(48,'2021_10_04_030050_add_column_created_by_to_table_ec_products',1),(49,'2021_10_04_033903_add_column_approved_by_into_table_ec_products',1),(50,'2021_10_05_122616_add_status_column_to_ec_customers_table',1),(51,'2021_10_06_124943_add_transaction_id_column_to_mp_customer_withdrawals_table',1),(52,'2021_10_10_054216_add_columns_to_mp_customer_revenues_table',1),(53,'2021_10_19_020859_update_metadata_field',1),(54,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(55,'2021_11_03_025806_nullable_phone_number_in_ec_customer_addresses',1),(56,'2021_11_23_071403_correct_languages_for_product_variations',1),(57,'2021_11_28_031808_add_product_tags_translations',1),(58,'2021_12_01_031123_add_featured_image_to_ec_products',1),(59,'2021_12_02_035301_add_ads_translations_table',1),(60,'2021_12_03_030600_create_blog_translations',1),(61,'2021_12_03_075608_create_page_translations',1),(62,'2021_12_03_082134_create_faq_translations',1),(63,'2021_12_03_082953_create_gallery_translations',1),(64,'2021_12_03_083642_create_testimonials_translations',1),(65,'2021_12_03_084118_create_location_translations',1),(66,'2021_12_03_094518_migrate_old_location_data',1),(67,'2021_12_06_031304_update_table_mp_customer_revenues',1),(68,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(69,'2022_01_01_033107_update_table_ec_shipments',1),(70,'2022_01_16_085908_improve_plugin_location',1),(71,'2022_02_16_042457_improve_product_attribute_sets',1),(72,'2022_03_22_075758_correct_product_name',1),(73,'2022_04_19_113334_add_index_to_ec_products',1),(74,'2022_04_19_113923_add_index_to_table_posts',1),(75,'2022_04_20_100851_add_index_to_media_table',1),(76,'2022_04_20_101046_add_index_to_menu_table',1),(77,'2022_04_28_144405_remove_unused_table',1),(78,'2022_04_30_034048_create_gallery_meta_translations_table',1),(79,'2022_05_05_115015_create_ec_customer_recently_viewed_products_table',1),(80,'2022_05_18_143720_add_index_to_table_ec_product_categories',1),(81,'2022_06_16_095633_add_index_to_some_tables',1),(82,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(83,'2022_06_30_035148_create_order_referrals_table',1),(84,'2022_07_07_153354_update_charge_id_in_table_payments',1),(85,'2022_07_10_034813_move_lang_folder_to_root',1),(86,'2022_07_24_153815_add_completed_at_to_ec_orders_table',1),(87,'2022_08_04_051940_add_missing_column_expires_at',1),(88,'2022_08_04_052122_delete_location_backup_tables',1),(89,'2022_08_14_032836_create_ec_order_returns_table',1),(90,'2022_08_14_033554_create_ec_order_return_items_table',1),(91,'2022_08_15_040324_add_billing_address',1),(92,'2022_08_30_091114_support_digital_products_table',1),(93,'2022_09_01_000001_create_admin_notifications_tables',1),(94,'2022_09_13_095744_create_options_table',1),(95,'2022_09_13_104347_create_option_value_table',1),(96,'2022_10_05_163518_alter_table_ec_order_product',1),(97,'2022_10_12_041517_create_invoices_table',1),(98,'2022_10_12_142226_update_orders_table',1),(99,'2022_10_13_024916_update_table_order_returns',1),(100,'2022_10_14_024629_drop_column_is_featured',1),(101,'2022_10_19_152916_add_columns_to_mp_stores_table',1),(102,'2022_10_20_062849_create_mp_category_sale_commissions_table',1),(103,'2022_10_21_030830_update_columns_in_ec_shipments_table',1),(104,'2022_10_28_021046_update_columns_in_ec_shipments_table',1),(105,'2022_11_02_071413_add_more_info_for_store',1),(106,'2022_11_02_080444_add_tax_info',1),(107,'2022_11_16_034522_update_type_column_in_ec_shipping_rules_table',1),(108,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(109,'2022_11_19_041643_add_ec_tax_product_table',1),(110,'2022_12_02_093615_update_slug_index_columns',1),(111,'2022_12_12_063830_update_tax_defadult_in_ec_tax_products_table',1),(112,'2022_12_17_041532_fix_address_in_order_invoice',1),(113,'2022_12_26_070329_create_ec_product_views_table',1),(114,'2023_01_04_033051_fix_product_categories',1),(115,'2023_01_09_050400_add_ec_global_options_translations_table',1),(116,'2023_01_10_093754_add_missing_option_value_id',1),(117,'2023_01_17_082713_add_column_barcode_and_cost_per_item_to_product_table',1),(118,'2023_01_26_021854_add_ec_customer_used_coupons_table',1),(119,'2023_01_30_024431_add_alt_to_media_table',1),(120,'2023_02_01_062030_add_store_translations',1),(121,'2023_02_08_015900_update_options_column_in_ec_order_product_table',1),(122,'2023_02_13_032133_update_fee_column_mp_customer_revenues_table',1),(123,'2023_02_16_042611_drop_table_password_resets',1),(124,'2023_02_17_023648_fix_store_prefix',1),(125,'2023_02_27_095752_remove_duplicate_reviews',1),(126,'2023_03_20_115757_add_user_type_column_to_ec_shipment_histories_table',1),(127,'2023_04_17_062645_add_open_in_new_tab',1),(128,'2023_04_21_082427_create_ec_product_categorizables_table',1),(129,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(130,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(131,'2023_05_03_011331_add_missing_column_price_into_invoice_items_table',1),(132,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(133,'2023_05_17_025812_fix_invoice_issue',1),(134,'2023_05_26_073140_move_option_make_phone_field_optional_at_checkout_page_to_mandatory_fields',1),(135,'2023_05_27_144611_fix_exchange_rate_setting',1),(136,'2023_06_22_084331_add_generate_license_code_to_ec_products_table',1),(137,'2023_06_30_042512_create_ec_order_tax_information_table',1),(138,'2023_07_06_011444_create_slug_translations_table',1),(139,'2023_07_14_022724_remove_column_id_from_ec_product_collection_products',1),(140,'2023_07_26_041451_add_more_columns_to_location_table',1),(141,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(142,'2023_08_09_012940_remove_column_status_in_ec_product_attributes',1),(143,'2023_08_11_060908_create_announcements_table',1),(144,'2023_08_15_064505_create_ec_tax_rules_table',1),(145,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(146,'2023_08_21_021819_make_column_address_in_ec_customer_addresses_nullable',1),(147,'2023_08_21_090810_make_page_content_nullable',1),(148,'2023_08_22_094114_drop_unique_for_barcode',1),(149,'2023_08_29_074620_make_column_author_id_nullable',1),(150,'2023_08_29_075308_make_column_user_id_nullable',1),(151,'2023_08_30_031811_add_apply_via_url_column_to_ec_discounts_table',1),(152,'2023_09_07_094312_add_index_to_product_sku_and_translations',1),(153,'2023_09_14_021936_update_index_for_slugs_table',1),(154,'2023_09_14_022423_add_index_for_language_table',1),(155,'2023_09_19_024955_create_discount_product_categories_table',1),(156,'2023_10_17_070728_add_icon_and_icon_image_to_product_categories_table',1),(157,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(158,'2023_11_07_023805_add_tablet_mobile_image',1),(159,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(160,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(161,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(162,'2023_11_22_154643_add_unique_in_table_ec_products_variations',1),(163,'2023_11_27_032313_add_price_columns_to_ec_product_cross_sale_relations_table',1),(164,'2023_12_06_023945_add_display_on_checkout_column_to_ec_discounts_table',1),(165,'2023_12_06_100448_change_random_hash_for_media',1),(166,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(167,'2023_12_12_105220_drop_translations_table',1),(168,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(169,'2023_12_25_040604_ec_create_review_replies_table',1),(170,'2023_12_26_090340_add_private_notes_column_to_ec_customers_table',1),(171,'2024_01_16_070706_fix_translation_tables',1),(172,'2024_01_23_075227_add_proof_file_to_ec_orders_table',1),(173,'2024_03_14_041050_migrate_lazy_load_theme_options',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_category_sale_commissions`
--

DROP TABLE IF EXISTS `mp_category_sale_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_category_sale_commissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_category_id` bigint unsigned NOT NULL,
  `commission_percentage` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mp_category_sale_commissions_product_category_id_unique` (`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_category_sale_commissions`
--

LOCK TABLES `mp_category_sale_commissions` WRITE;
/*!40000 ALTER TABLE `mp_category_sale_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_category_sale_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_revenues`
--

DROP TABLE IF EXISTS `mp_customer_revenues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_revenues` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `sub_amount` decimal(15,2) DEFAULT '0.00',
  `fee` decimal(15,2) DEFAULT '0.00',
  `amount` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_revenues`
--

LOCK TABLES `mp_customer_revenues` WRITE;
/*!40000 ALTER TABLE `mp_customer_revenues` DISABLE KEYS */;
INSERT INTO `mp_customer_revenues` VALUES (1,5,4,3264.00,0.00,3264.00,0.00,'USD',NULL,'2024-03-11 09:00:50','2024-03-11 09:00:50',0,'add-amount'),(2,3,6,4827.00,0.00,4827.00,0.00,'USD',NULL,'2024-03-11 01:00:51','2024-03-11 01:00:51',0,'add-amount'),(3,1,7,2766.00,0.00,2766.00,0.00,'USD',NULL,'2024-03-09 19:00:51','2024-03-09 19:00:51',0,'add-amount'),(4,8,10,12217.00,0.00,12217.00,0.00,'USD',NULL,'2024-03-05 23:00:52','2024-03-05 23:00:52',0,'add-amount'),(5,4,11,2202.00,0.00,2202.00,0.00,'USD',NULL,'2024-03-05 03:00:53','2024-03-05 03:00:53',0,'add-amount'),(6,3,12,2358.00,0.00,2358.00,4827.00,'USD',NULL,'2024-03-14 01:00:53','2024-03-14 01:00:53',0,'add-amount'),(7,2,13,1087.00,0.00,1087.00,0.00,'USD',NULL,'2024-03-12 19:00:54','2024-03-12 19:00:54',0,'add-amount'),(8,8,16,2049.00,0.00,2049.00,12217.00,'USD',NULL,'2024-03-13 17:00:55','2024-03-13 17:00:55',0,'add-amount'),(9,4,21,2202.00,0.00,2202.00,2202.00,'USD',NULL,'2024-03-02 07:00:56','2024-03-02 07:00:56',0,'add-amount'),(10,4,22,640.00,0.00,640.00,4404.00,'USD',NULL,'2024-03-01 17:00:56','2024-03-01 17:00:56',0,'add-amount'),(11,6,29,6363.00,0.00,6363.00,0.00,'USD',NULL,'2024-03-05 03:00:57','2024-03-05 03:00:57',0,'add-amount'),(12,4,31,1788.00,0.00,1788.00,5044.00,'USD',NULL,'2024-02-17 11:00:58','2024-02-17 11:00:58',0,'add-amount'),(13,8,32,878.00,0.00,878.00,14266.00,'USD',NULL,'2024-02-22 03:00:58','2024-02-22 03:00:58',0,'add-amount'),(14,8,35,878.00,0.00,878.00,15144.00,'USD',NULL,'2024-03-09 03:00:59','2024-03-09 03:00:59',0,'add-amount'),(15,1,40,4040.00,0.00,4040.00,2766.00,'USD',NULL,'2024-03-08 07:01:00','2024-03-08 07:01:00',0,'add-amount'),(16,8,47,7080.00,0.00,7080.00,16022.00,'USD',NULL,'2024-02-24 03:01:01','2024-02-24 03:01:01',0,'add-amount'),(17,8,50,798.00,0.00,798.00,23102.00,'USD',NULL,'2024-03-02 09:01:01','2024-03-02 09:01:01',0,'add-amount');
/*!40000 ALTER TABLE `mp_customer_revenues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_withdrawals`
--

DROP TABLE IF EXISTS `mp_customer_withdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_withdrawals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `fee` decimal(15,2) unsigned DEFAULT '0.00',
  `amount` decimal(15,2) unsigned DEFAULT '0.00',
  `current_balance` decimal(15,2) unsigned DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `images` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `transaction_id` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_withdrawals`
--

LOCK TABLES `mp_customer_withdrawals` WRITE;
/*!40000 ALTER TABLE `mp_customer_withdrawals` DISABLE KEYS */;
INSERT INTO `mp_customer_withdrawals` VALUES (1,1,0.00,731.00,6806.00,'USD','','{\"name\":\"Breanna Yost\",\"number\":\"+13323515949\",\"full_name\":\"Darius Jast\",\"description\":\"Rhiannon Kozey\"}',NULL,0,'processing',NULL,'2024-03-15 03:01:02','2024-03-15 03:01:02',NULL),(2,1,0.00,938.00,6075.00,'USD','','{\"name\":\"Breanna Yost\",\"number\":\"+13323515949\",\"full_name\":\"Darius Jast\",\"description\":\"Rhiannon Kozey\"}',NULL,0,'processing',NULL,'2024-03-15 03:01:03','2024-03-15 03:01:03',NULL),(3,1,0.00,864.00,5137.00,'USD','','{\"name\":\"Breanna Yost\",\"number\":\"+13323515949\",\"full_name\":\"Darius Jast\",\"description\":\"Rhiannon Kozey\"}',NULL,0,'pending',NULL,'2024-03-15 03:01:04','2024-03-15 03:01:04',NULL),(4,1,0.00,1407.00,4273.00,'USD','','{\"name\":\"Breanna Yost\",\"number\":\"+13323515949\",\"full_name\":\"Darius Jast\",\"description\":\"Rhiannon Kozey\"}',NULL,0,'pending',NULL,'2024-03-15 03:01:05','2024-03-15 03:01:05',NULL),(5,2,0.00,231.00,1087.00,'USD','','{\"name\":\"Laverne Robel\",\"number\":\"+18473509511\",\"full_name\":\"Bethel Davis\",\"description\":\"Dr. Keon Gleason\"}',NULL,0,'completed',NULL,'2024-03-15 03:01:05','2024-03-15 03:01:05',NULL),(6,2,0.00,165.00,856.00,'USD','','{\"name\":\"Laverne Robel\",\"number\":\"+18473509511\",\"full_name\":\"Bethel Davis\",\"description\":\"Dr. Keon Gleason\"}',NULL,0,'completed',NULL,'2024-03-15 03:01:06','2024-03-15 03:01:06',NULL),(7,2,0.00,172.00,691.00,'USD','','{\"name\":\"Laverne Robel\",\"number\":\"+18473509511\",\"full_name\":\"Bethel Davis\",\"description\":\"Dr. Keon Gleason\"}',NULL,0,'pending',NULL,'2024-03-15 03:01:07','2024-03-15 03:01:07',NULL),(8,2,0.00,136.00,519.00,'USD','','{\"name\":\"Laverne Robel\",\"number\":\"+18473509511\",\"full_name\":\"Bethel Davis\",\"description\":\"Dr. Keon Gleason\"}',NULL,0,'completed',NULL,'2024-03-15 03:01:07','2024-03-15 03:01:07',NULL),(9,3,0.00,223.00,7185.00,'USD','','{\"name\":\"Dr. Lauryn Mertz DDS\",\"number\":\"+16519893507\",\"full_name\":\"Ms. Assunta Macejkovic Jr.\",\"description\":\"Brannon Hagenes IV\"}',NULL,0,'completed',NULL,'2024-03-15 03:01:08','2024-03-15 03:01:08',NULL),(10,3,0.00,280.00,6962.00,'USD','','{\"name\":\"Dr. Lauryn Mertz DDS\",\"number\":\"+16519893507\",\"full_name\":\"Ms. Assunta Macejkovic Jr.\",\"description\":\"Brannon Hagenes IV\"}',NULL,0,'processing',NULL,'2024-03-15 03:01:09','2024-03-15 03:01:09',NULL),(11,4,0.00,1933.00,6832.00,'USD','','{\"name\":\"Abbigail Bahringer II\",\"number\":\"+17349772961\",\"full_name\":\"Jaylan Hodkiewicz\",\"description\":\"Herminia Raynor\"}',NULL,0,'completed',NULL,'2024-03-15 03:01:09','2024-03-15 03:01:09',NULL),(12,4,0.00,899.00,4899.00,'USD','','{\"name\":\"Abbigail Bahringer II\",\"number\":\"+17349772961\",\"full_name\":\"Jaylan Hodkiewicz\",\"description\":\"Herminia Raynor\"}',NULL,0,'completed',NULL,'2024-03-15 03:01:10','2024-03-15 03:01:10',NULL),(13,4,0.00,941.00,4000.00,'USD','','{\"name\":\"Abbigail Bahringer II\",\"number\":\"+17349772961\",\"full_name\":\"Jaylan Hodkiewicz\",\"description\":\"Herminia Raynor\"}',NULL,0,'completed',NULL,'2024-03-15 03:01:11','2024-03-15 03:01:11',NULL),(14,5,0.00,908.00,3264.00,'USD','','{\"name\":\"Adelbert West\",\"number\":\"+12319302682\",\"full_name\":\"Monserrat Satterfield\",\"description\":\"Prof. Bridget Rutherford\"}',NULL,0,'processing',NULL,'2024-03-15 03:01:11','2024-03-15 03:01:11',NULL),(15,5,0.00,284.00,2356.00,'USD','','{\"name\":\"Adelbert West\",\"number\":\"+12319302682\",\"full_name\":\"Monserrat Satterfield\",\"description\":\"Prof. Bridget Rutherford\"}',NULL,0,'processing',NULL,'2024-03-15 03:01:12','2024-03-15 03:01:12',NULL),(16,6,0.00,1115.00,6363.00,'USD','','{\"name\":\"Houston Connelly DDS\",\"number\":\"+14327753683\",\"full_name\":\"Norris Wyman\",\"description\":\"Prof. Era Schaefer DVM\"}',NULL,0,'processing',NULL,'2024-03-15 03:01:13','2024-03-15 03:01:13',NULL),(17,6,0.00,1445.00,5248.00,'USD','','{\"name\":\"Houston Connelly DDS\",\"number\":\"+14327753683\",\"full_name\":\"Norris Wyman\",\"description\":\"Prof. Era Schaefer DVM\"}',NULL,0,'pending',NULL,'2024-03-15 03:01:14','2024-03-15 03:01:14',NULL),(18,6,0.00,718.00,3803.00,'USD','','{\"name\":\"Houston Connelly DDS\",\"number\":\"+14327753683\",\"full_name\":\"Norris Wyman\",\"description\":\"Prof. Era Schaefer DVM\"}',NULL,0,'processing',NULL,'2024-03-15 03:01:14','2024-03-15 03:01:14',NULL),(19,8,0.00,943.00,23900.00,'USD','','{\"name\":\"Elva Walker MD\",\"number\":\"+12835006830\",\"full_name\":\"Gianni Bogisich V\",\"description\":\"Miss Elinore Collins III\"}',NULL,0,'processing',NULL,'2024-03-15 03:01:15','2024-03-15 03:01:15',NULL),(20,8,0.00,1174.00,22957.00,'USD','','{\"name\":\"Elva Walker MD\",\"number\":\"+12835006830\",\"full_name\":\"Gianni Bogisich V\",\"description\":\"Miss Elinore Collins III\"}',NULL,0,'processing',NULL,'2024-03-15 03:01:16','2024-03-15 03:01:16',NULL);
/*!40000 ALTER TABLE `mp_customer_withdrawals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores`
--

DROP TABLE IF EXISTS `mp_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `vendor_verified_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores`
--

LOCK TABLES `mp_stores` WRITE;
/*!40000 ALTER TABLE `mp_stores` DISABLE KEYS */;
INSERT INTO `mp_stores` VALUES (1,'GoPro','npredovic@example.org','+19349567041','523 Hilda Centers','VC','Indiana','Steuberton',1,'main/stores/1.png','Repudiandae repudiandae nemo vero quae aliquid. Laborum consequatur temporibus perspiciatis necessitatibus vero enim debitis iure. Et non nostrum animi ratione quis sed et. Consequatur non voluptatem rem soluta tempora ut aut incidunt. Iure et rerum iste qui sint voluptate et. Accusantium ipsum laborum amet ut ullam ut fugiat. Fuga nihil cum enim odit incidunt. Ut sed et quas architecto a nemo.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:00:06','2024-03-15 03:00:06',NULL,NULL),(2,'Global Office','david.mann@example.net','+16465790387','722 Tremayne Junction Apt. 748','TD','West Virginia','North Orlo',2,'main/stores/2.png','Culpa dolorum voluptate aut hic iusto rerum sint. Fugit ut qui nesciunt sed dolorum sint eius. Quis et perspiciatis ut eum molestiae tenetur. Eaque porro optio neque voluptatem aut. Assumenda dolores nulla nesciunt consequatur. Magnam nisi voluptas eligendi aut omnis. Quo dicta et vero. Est debitis enim officiis nisi voluptatibus facilis. Blanditiis numquam nobis ipsum harum dolores.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:00:06','2024-03-15 03:00:06',NULL,NULL),(3,'Young Shop','bahringer.carley@example.com','+14584548928','685 Ernesto Throughway','EG','South Carolina','Lake Ramon',3,'main/stores/3.png','Consequatur maiores similique dolorum. Autem quo aut asperiores rerum rerum inventore nulla qui. Esse nostrum rerum dolor nam. Enim sint recusandae blanditiis. Dolorem voluptatem voluptatem sunt labore provident. Enim consequatur quia sequi aut perferendis soluta harum. Illum voluptas sed numquam atque sit.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:00:06','2024-03-15 03:00:06',NULL,NULL),(4,'Global Store','blaise50@example.com','+18438410913','186 Effertz Coves Suite 307','MF','New York','West Destineemouth',4,'main/stores/4.png','Quidem aperiam minus porro. Est possimus deserunt ducimus neque dolores. Voluptate totam sed quia doloremque quam. Voluptatem quaerat quia blanditiis officiis inventore corporis amet. Odio ipsa labore modi beatae. Ut cupiditate dolores laboriosam veritatis ducimus suscipit doloremque ut.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:00:06','2024-03-15 03:00:06',NULL,NULL),(5,'Robert’s Store','yreichel@example.net','+17375041095','52214 Rowe Passage Suite 058','LT','New Mexico','East Crystel',5,'main/stores/5.png','Numquam aliquam sed minus et accusamus reiciendis dolores ut. Quibusdam qui labore quaerat possimus. Ipsam sint rerum excepturi dolor. Eum voluptas nihil nihil dolores soluta nemo laboriosam. Similique in sunt veritatis quam rerum ullam. Consequatur et asperiores quis dolor. Odit impedit at ipsam possimus et ut impedit. Aut hic magnam sit quisquam.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:00:06','2024-03-15 03:00:06',NULL,NULL),(6,'Stouffer','akeem.barton@example.com','+12178561754','9066 Mohr Ford','NC','Vermont','New Palmaport',6,'main/stores/6.png','Omnis eum et aut tenetur quae ea. Quia quod occaecati quibusdam dolores commodi aut nemo. Sit qui occaecati reprehenderit suscipit. Autem perferendis quos et laborum laborum iusto. Quia quis fuga eaque voluptas. Consequatur sint illum soluta quia. Rerum quia quas numquam voluptate.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:00:06','2024-03-15 03:00:06',NULL,NULL),(7,'StarKist','elizabeth.reinger@example.com','+12624358030','98668 Carter Prairie','AL','Ohio','West Princessville',7,'main/stores/7.png','Aut aut occaecati possimus minus qui. Quam atque quae et voluptate eos et. Aut repudiandae consequuntur est ducimus iste maiores. Dolor ratione delectus aut. Ea eaque corrupti ratione. Quia provident voluptatem velit earum. Magni incidunt tempora perferendis exercitationem. Et enim consequatur sed aut. Dolores repudiandae tempora dolor. Tempore id corrupti dolor autem.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:00:06','2024-03-15 03:00:06',NULL,NULL),(8,'Old El Paso','grady.leda@example.org','+19314968176','2965 Darrick Branch','LY','Connecticut','Kochstad',8,'main/stores/8.png','Dolorem distinctio vero sunt rerum repellendus nihil eveniet. Maxime quas maiores molestiae unde. Animi in cumque consectetur porro dicta eum soluta. Soluta quasi culpa necessitatibus. Tempore minus rerum quisquam. Atque molestiae laborum odit laudantium quidem dolorem qui.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:00:07','2024-03-15 03:00:07',NULL,NULL);
/*!40000 ALTER TABLE `mp_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores_translations`
--

DROP TABLE IF EXISTS `mp_stores_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mp_stores_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`mp_stores_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores_translations`
--

LOCK TABLES `mp_stores_translations` WRITE;
/*!40000 ALTER TABLE `mp_stores_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_stores_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_vendor_info`
--

DROP TABLE IF EXISTS `mp_vendor_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_vendor_info` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL DEFAULT '0',
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_fee` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_revenue` decimal(15,2) NOT NULL DEFAULT '0.00',
  `signature` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `payout_payment_method` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT 'bank_transfer',
  `tax_info` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_vendor_info`
--

LOCK TABLES `mp_vendor_info` WRITE;
/*!40000 ALTER TABLE `mp_vendor_info` DISABLE KEYS */;
INSERT INTO `mp_vendor_info` VALUES (1,1,2866.00,0.00,6806.00,'$2y$12$XXpu3VBTD489QYERFpTqTeUviOoCtGfaAOSsdmj0k1RiZOgIWrnji','{\"name\":\"Breanna Yost\",\"number\":\"+13323515949\",\"full_name\":\"Darius Jast\",\"description\":\"Rhiannon Kozey\"}','2024-03-15 03:00:04','2024-03-15 03:01:05','bank_transfer',NULL),(2,2,383.00,0.00,1087.00,'$2y$12$QmQiPuoDOBw2CP460Zmjeu1mRe8bo.xejr7TmBAC0ZzCBxur2Vnm.','{\"name\":\"Laverne Robel\",\"number\":\"+18473509511\",\"full_name\":\"Bethel Davis\",\"description\":\"Dr. Keon Gleason\"}','2024-03-15 03:00:04','2024-03-15 03:01:08','bank_transfer',NULL),(3,3,6682.00,0.00,7185.00,'$2y$12$qYPW9kntluUWVTBJb5eZMeOTfvZgjfgpfcgmnVu.P8xYtZnwRwbxe','{\"name\":\"Dr. Lauryn Mertz DDS\",\"number\":\"+16519893507\",\"full_name\":\"Ms. Assunta Macejkovic Jr.\",\"description\":\"Brannon Hagenes IV\"}','2024-03-15 03:00:05','2024-03-15 03:01:09','bank_transfer',NULL),(4,4,3059.00,0.00,6832.00,'$2y$12$op.02iNbH4JODbFSPf5PTeBnHCsowVVv/LdgdgU4pbcZtpr548sAW','{\"name\":\"Abbigail Bahringer II\",\"number\":\"+17349772961\",\"full_name\":\"Jaylan Hodkiewicz\",\"description\":\"Herminia Raynor\"}','2024-03-15 03:00:05','2024-03-15 03:01:11','bank_transfer',NULL),(5,5,2072.00,0.00,3264.00,'$2y$12$5aAMXQtperQRQC2/OK6Kzu/UQ1CXr41YOUvSYSTn96L.31hypGEcO','{\"name\":\"Adelbert West\",\"number\":\"+12319302682\",\"full_name\":\"Monserrat Satterfield\",\"description\":\"Prof. Bridget Rutherford\"}','2024-03-15 03:00:05','2024-03-15 03:01:13','bank_transfer',NULL),(6,6,3085.00,0.00,6363.00,'$2y$12$0wkPd4vMpDj4AtM5XNT0HeEgtSj0ZYXl0N3HshdAAuZAeStyy3Tvi','{\"name\":\"Houston Connelly DDS\",\"number\":\"+14327753683\",\"full_name\":\"Norris Wyman\",\"description\":\"Prof. Era Schaefer DVM\"}','2024-03-15 03:00:06','2024-03-15 03:01:15','bank_transfer',NULL),(7,7,0.00,0.00,0.00,'$2y$12$Bt01tRqkRPHwxhrY4.rI2u1OD3kuTy9iX4zRJ7SrdeGz2K2OzK95W','{\"name\":\"Elsa Nolan\",\"number\":\"+12109928711\",\"full_name\":\"Myrtie King IV\",\"description\":\"Mrs. Vanessa Kling\"}','2024-03-15 03:00:06','2024-03-15 03:00:06','bank_transfer',NULL),(8,8,21783.00,0.00,23900.00,'$2y$12$kZ0WfnO4ndnKOlkpYcBQgucgLvaCypAyWmI3.d8hzfnhWqiTwxcYy','{\"name\":\"Elva Walker MD\",\"number\":\"+12835006830\",\"full_name\":\"Gianni Bogisich V\",\"description\":\"Miss Elinore Collins III\"}','2024-03-15 03:00:06','2024-03-15 03:01:17','bank_transfer',NULL);
/*!40000 ALTER TABLE `mp_vendor_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Home','[simple-slider style=\"1\" key=\"home-slider\" shape_1=\"main/sliders/shape-1.png\" shape_2=\"main/sliders/shape-2.png\" shape_3=\"main/sliders/shape-3.png\" shape_4=\"main/sliders/shape-4.png\"][/simple-slider][ecommerce-categories style=\"slider\" category_ids=\"6,10,13,16,30\"][/ecommerce-categories][site-features style=\"1\" quantity=\"4\" title_1=\"Free Delivery\" description_1=\"Orders from all item\" icon_1=\"ti ti-truck-delivery\" title_2=\"Return & Refund\" description_2=\"Money back guarantee\" icon_2=\"ti ti-currency-dollar\" title_3=\"Member Discount\" description_3=\"Every order over $140.00\" icon_3=\"ti ti-discount-2\" title_4=\"Support 24/7\" description_4=\"Contact us 24 hours a day\" icon_4=\"ti ti-headset\"][/site-features][ecommerce-product-groups title=\"Trending Products\" limit=\"8\" tabs=\"all,featured,on-sale,trending,top-rated\"][/ecommerce-product-groups][ads style=\"1\" key_1=\"UROL9F9ZZVAA\" key_2=\"B30VDBKO7SBF\"][/ads][ecommerce-flash-sale style=\"1\" title=\"Deal of The Day\" flash_sale_id=\"1\" limit=\"4\" button_label=\"View All Deals\" button_url=\"/products\"][/ecommerce-flash-sale][ecommerce-products style=\"grid\" category_ids=\"20\" limit=\"12\" with_sidebar=\"on\" image=\"main/gadgets/gadget-girl.png\" action_label=\"More Products\" ads_ids=\"3,4\"][/ecommerce-products][ads style=\"4\" key_1=\"B5ZA76ZWMWAE\" key_2=\"F1LTQS976YPY\" key_3=\"IHPZ2WBSYJUK\"][/ads][ecommerce-products style=\"slider\" title=\"New Arrivals\" by=\"collection\" collection_ids=\"1\" limit=\"12\"][/ecommerce-products][ecommerce-product-groups style=\"columns\" limit=\"3\" tabs=\"on-sale,trending,top-rated\"][/ecommerce-product-groups][blog-posts title=\"Latest news & articles\" type=\"latest\" limit=\"3\" button_label=\"View All\" button_url=\"/blog\"][/blog-posts][gallery style=\"1\" limit=\"5\"][/gallery]',1,NULL,'full-width',NULL,'published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(2,'Product Categories','[ads style=\"1\" key_1=\"UROL9F9ZZVAA\" key_2=\"B30VDBKO7SBF\"][/ads]<p>&nbsp;</p>[ecommerce-categories category_ids=\"11,14,17,18,21,22,23,25,38\" style=\"grid\"][/ecommerce-categories]<p>&nbsp;</p><p>&nbsp;</p>',1,NULL,'full-width',NULL,'published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(3,'Coupons','[ecommerce-coupons coupon_ids=\"1,2,3,4,5,6\"][/ecommerce-coupons]',1,NULL,'full-width',NULL,'published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(4,'Blog',NULL,1,NULL,'full-width',NULL,'published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(5,'Contact','[contact-form show_contact_form=&quot;1&quot; title=&quot;Sent A Message&quot; quantity=&quot;2&quot; icon_1=&quot;main/contact/icon-1.png&quot; content_1=&quot;contact@shofy.com &lt;br&gt; &lt;strong&gt;+670 413 90 762&lt;/strong&gt;&quot; icon_2=&quot;main/contact/icon-2.png&quot; content_2=&quot;502 New St, Brighton VIC 3186, Australia&quot; show_social_info=&quot;1&quot; social_info_label=&quot;Find on social media&quot; social_info_icon=&quot;main/contact/icon-3.png&quot;][/contact-form][google-map]502 New Street, Brighton VIC, Australia[/google-map]',1,NULL,'full-width',NULL,'published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(6,'Cookie Policy','<h3>EU Cookie Consent</h3><p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p><h4>Essential Data</h4><p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p><p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p><p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>',1,NULL,NULL,NULL,'published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(7,'Our Story','<h4>A passion for handcrafted coffee, brewed with love and community.</h4>\n\n<p>\n    We are a small, family-owned coffee roaster dedicated to bringing the finest, ethically sourced beans to your cup. Our story began in a cozy kitchen, fueled by a shared passion for the rich aroma and invigorating taste of freshly brewed coffee. We dreamt of creating a space where people could connect over a warm cup, share stories, and experience the joy of handcrafted coffee.\n</p>\n\n<h4>From Humble Beginnings to Roasting Success:</h4>\n\n<p>\n    Our journey started with a small coffee roaster nestled in our garage. We spent countless hours experimenting with different roasting profiles, meticulously cupping each batch to achieve the perfect balance of flavor and aroma. Driven by a desire to make a difference, we built relationships with sustainable coffee farms around the world, ensuring fair trade practices and the highest quality beans.\n</p>\n\n<h4>Milestones and More to Come:</h4>\n\n<p>\n    Our dedication to quality and community resonated with coffee lovers, and our small business quickly grew. We opened our first cafe, a warm and inviting space where people could gather, savor our freshly roasted coffee, and connect with friends and neighbors. We\'ve continued to expand, now offering a variety of handcrafted coffee beverages, alongside delicious pastries and light bites.\n</p>\n\n<h4>Values at Our Core:</h4>\n\n<p>\n    At the heart of everything we do lies our commitment to ethical sourcing, sustainable practices, and building meaningful connections. We believe in supporting the communities that cultivate our coffee beans, ensuring fair wages and responsible farming methods. Every cup you enjoy contributes to a positive impact, one sip at a time.\n</p>\n\n<h4>Join us on our journey!</h4>\n\n<p>\n    We invite you to explore our world of coffee, from the rich diversity of our bean origins to the unique flavors crafted through meticulous roasting. Visit our cafe, discover your perfect cup, and become part of our ever-growing coffee community. Let\'s connect over a cup, share stories, and celebrate the simple joy of a well-brewed coffee.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(8,'Careers','<h3>Careers: Be Part of Our Brewing Legacy</h3>\n\n<p>\n    At Shofy, we\'re not just brewing coffee, we\'re brewing a legacy. Since our humble beginnings in 2024, we\'ve grown from a small, family-owned roaster to a thriving coffee haven. But our passion for quality, community, and sustainability remains at the core of everything we do.\n</p>\n\n<h4>Why Join Our Team?</h4>\n\n<ul>\n    <li>\n        <p><strong>Become a Coffee Connoisseur</strong>: Immerse yourself in the world of coffee, learning from experienced roasters and baristas about bean origins, roasting techniques, and crafting the perfect cup.</p>\n    </li>\n    <li>\n        <p><strong>Fuel Your Passion</strong>: Contribute to our mission by sourcing ethically, promoting sustainable practices, and fostering positive relationships with coffee-growing communities around the globe.</p>\n    </li>\n    <li>\n        <p><strong>Grow with Us</strong>: We offer comprehensive training programs and opportunities for professional development, helping you refine your skills and advance your career in the coffee industry.</p>\n    </li>\n    <li>\n        <p><strong>Be Part of the Family</strong>: We cultivate a collaborative and supportive work environment where your unique talents and perspectives are valued.</p>\n    </li>\n</ul>\n\n<h4>Current Openings:</h4>\n\n<ul>\n    <li>\n        <p><strong>Coffee Roaster</strong>: Play a vital role in our roasting process, meticulously crafting unique flavor profiles and ensuring the highest quality beans reach our customers.</p>\n    </li>\n    <li>\n        <p><strong>Barista</strong>: Become a coffee ambassador, welcoming guests with a smile, crafting their perfect cup, and sharing your knowledge and passion for coffee.</p>\n    </li>\n    <li>\n        <p><strong>Cafe Manager</strong>: Lead your team in creating a warm and inviting atmosphere, overseeing daily operations, and ensuring exceptional customer service.</p>\n    </li>\n</ul>\n\n<h4>We are always looking for passionate individuals who share our values:</h4>\n\n<ul>\n    <li>\n        <p>A genuine love for coffee and a desire to learn everything there is to know about it.</p>\n    </li>\n    <li>\n        <p>A commitment to ethical sourcing, sustainability, and social responsibility.</p>\n    </li>\n    <li>\n        <p>Excellent communication and interpersonal skills to build rapport with colleagues and customers.</p>\n    </li>\n    <li>\n        <p>A positive attitude, a willingness to learn, and a collaborative spirit.</p>\n    </li>\n</ul>\n\n<p>Ready to join our brewing legacy?</p>\n\n<p>\n    Submit your resume and cover letter, telling us why you\'re a perfect fit for our team. We look forward to meeting passionate individuals who are ready to brew the future with us, one cup at a time.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-15 03:00:33','2024-03-15 03:00:33'),(9,'Shipping','<section>\n    <h2>Shipping Methods</h2>\n    <p>We offer several shipping methods to choose from:</p>\n    <ul>\n        <li>Standard Shipping - 3 to 5 business days</li>\n        <li>Express Shipping - 1 to 2 business days</li>\n        <li>International Shipping - 7 to 14 business days</li>\n    </ul>\n    <p>Please note that shipping times may vary depending on your location and other factors.</p>\n</section>\n\n<section>\n    <h2>Shipping Costs</h2>\n    <p>Shipping costs are calculated based on the weight of your order and the shipping method selected during checkout.</p>\n    <p>You can view the estimated shipping costs in your shopping cart before completing your purchase.</p>\n</section>\n\n<section>\n    <h2>Tracking Your Order</h2>\n    <p>Once your order has been shipped, you will receive a confirmation email with a tracking number.</p>\n    <p>You can use this tracking number to monitor the status of your delivery on our website or through the shipping carrier\'s website.</p>\n</section>\n\n<section>\n    <h2>Shipping Restrictions</h2>\n    <p>Some items may be subject to shipping restrictions due to size, weight, or destination.</p>\n    <p>If your order contains any restricted items, we will notify you during the checkout process.</p>\n</section>\n',1,NULL,NULL,NULL,'published','2024-03-15 03:00:33','2024-03-15 03:00:33');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'USD',0,'TFIFBCU3XS','cod',NULL,7272.00,1,'pending','confirm',10,NULL,NULL,'2024-03-15 03:00:34','2024-03-15 03:00:34','Botble\\Ecommerce\\Models\\Customer',NULL),(2,'USD',0,'LZQD6OVMYT','bank_transfer',NULL,2272.00,2,'pending','confirm',10,NULL,NULL,'2024-03-15 03:00:35','2024-03-15 03:00:35','Botble\\Ecommerce\\Models\\Customer',NULL),(3,'USD',0,'P0SDF3UWVV','razorpay',NULL,3261.00,3,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:35','2024-03-15 03:00:35','Botble\\Ecommerce\\Models\\Customer',NULL),(4,'USD',0,'IRQPIWOGFY','stripe',NULL,3264.00,4,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:35','2024-03-15 03:00:35','Botble\\Ecommerce\\Models\\Customer',NULL),(5,'USD',0,'C7IOK47SRC','paystack',NULL,3648.00,5,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:36','2024-03-15 03:00:36','Botble\\Ecommerce\\Models\\Customer',NULL),(6,'USD',0,'ZMQUHTWSDQ','paystack',NULL,4827.00,6,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:36','2024-03-15 03:00:36','Botble\\Ecommerce\\Models\\Customer',NULL),(7,'USD',0,'QMPCR3DG8S','paypal',NULL,2766.00,7,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:36','2024-03-15 03:00:36','Botble\\Ecommerce\\Models\\Customer',NULL),(8,'USD',0,'U76QRZLJZZ','sslcommerz',NULL,4159.00,8,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:37','2024-03-15 03:00:37','Botble\\Ecommerce\\Models\\Customer',NULL),(9,'USD',0,'YXY4G1PC61','bank_transfer',NULL,3036.00,9,'pending','confirm',10,NULL,NULL,'2024-03-15 03:00:37','2024-03-15 03:00:37','Botble\\Ecommerce\\Models\\Customer',NULL),(10,'USD',0,'LD9V4GL4HY','paypal',NULL,12217.00,10,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:37','2024-03-15 03:00:37','Botble\\Ecommerce\\Models\\Customer',NULL),(11,'USD',0,'AUHN3IVJJB','paystack',NULL,2202.00,11,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:38','2024-03-15 03:00:38','Botble\\Ecommerce\\Models\\Customer',NULL),(12,'USD',0,'3DYUFFFJYX','stripe',NULL,2358.00,12,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:38','2024-03-15 03:00:38','Botble\\Ecommerce\\Models\\Customer',NULL),(13,'USD',0,'UAN8G5RUUE','stripe',NULL,1087.00,13,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:38','2024-03-15 03:00:38','Botble\\Ecommerce\\Models\\Customer',NULL),(14,'USD',0,'IPAVNAY9IP','stripe',NULL,3944.00,14,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:39','2024-03-15 03:00:39','Botble\\Ecommerce\\Models\\Customer',NULL),(15,'USD',0,'MLJNC0CVB2','paystack',NULL,2496.00,15,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:39','2024-03-15 03:00:39','Botble\\Ecommerce\\Models\\Customer',NULL),(16,'USD',0,'CMJGXYIIOI','stripe',NULL,2049.00,16,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:39','2024-03-15 03:00:39','Botble\\Ecommerce\\Models\\Customer',NULL),(17,'USD',0,'CF9MWMJ9SQ','paystack',NULL,2040.00,17,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:40','2024-03-15 03:00:40','Botble\\Ecommerce\\Models\\Customer',NULL),(18,'USD',0,'FEO1TB6MSM','bank_transfer',NULL,3576.00,18,'pending','confirm',9,NULL,NULL,'2024-03-15 03:00:40','2024-03-15 03:00:40','Botble\\Ecommerce\\Models\\Customer',NULL),(19,'USD',0,'P1FOFALW3M','stripe',NULL,2176.00,19,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:40','2024-03-15 03:00:40','Botble\\Ecommerce\\Models\\Customer',NULL),(20,'USD',0,'WEHDRZZA6O','bank_transfer',NULL,4544.00,20,'pending','confirm',10,NULL,NULL,'2024-03-15 03:00:41','2024-03-15 03:00:41','Botble\\Ecommerce\\Models\\Customer',NULL),(21,'USD',0,'DNBMJUOBG0','razorpay',NULL,2202.00,21,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:41','2024-03-15 03:00:41','Botble\\Ecommerce\\Models\\Customer',NULL),(22,'USD',0,'FP8VWI20HS','razorpay',NULL,640.00,22,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:41','2024-03-15 03:00:41','Botble\\Ecommerce\\Models\\Customer',NULL),(23,'USD',0,'WAUIUZOW90','bank_transfer',NULL,2967.00,23,'pending','confirm',10,NULL,NULL,'2024-03-15 03:00:42','2024-03-15 03:00:42','Botble\\Ecommerce\\Models\\Customer',NULL),(24,'USD',0,'MOUBOIPBJS','stripe',NULL,2679.00,24,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:42','2024-03-15 03:00:42','Botble\\Ecommerce\\Models\\Customer',NULL),(25,'USD',0,'DJRWHCW42K','paystack',NULL,7068.00,25,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:42','2024-03-15 03:00:42','Botble\\Ecommerce\\Models\\Customer',NULL),(26,'USD',0,'PWOZPHVDSR','stripe',NULL,906.00,26,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:43','2024-03-15 03:00:43','Botble\\Ecommerce\\Models\\Customer',NULL),(27,'USD',0,'XI2AKEFPJH','paystack',NULL,3895.00,27,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:43','2024-03-15 03:00:43','Botble\\Ecommerce\\Models\\Customer',NULL),(28,'USD',0,'UWGOEY10GK','bank_transfer',NULL,1317.00,28,'pending','confirm',9,NULL,NULL,'2024-03-15 03:00:44','2024-03-15 03:00:44','Botble\\Ecommerce\\Models\\Customer',NULL),(29,'USD',0,'W9JR0GNKM9','paystack',NULL,6363.00,29,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:44','2024-03-15 03:00:44','Botble\\Ecommerce\\Models\\Customer',NULL),(30,'USD',0,'OGSBVIEAG9','bank_transfer',NULL,1020.00,30,'pending','confirm',9,NULL,NULL,'2024-03-15 03:00:44','2024-03-15 03:00:44','Botble\\Ecommerce\\Models\\Customer',NULL),(31,'USD',0,'HKAVNBB1GF','sslcommerz',NULL,1788.00,31,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:44','2024-03-15 03:00:44','Botble\\Ecommerce\\Models\\Customer',NULL),(32,'USD',0,'DGBPNL0JW6','razorpay',NULL,878.00,32,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45','Botble\\Ecommerce\\Models\\Customer',NULL),(33,'USD',0,'EH324KDQN7','stripe',NULL,1032.00,33,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45','Botble\\Ecommerce\\Models\\Customer',NULL),(34,'USD',0,'SIJGDKWWKE','razorpay',NULL,6816.00,34,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45','Botble\\Ecommerce\\Models\\Customer',NULL),(35,'USD',0,'OTGFFWKJVJ','stripe',NULL,878.00,35,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45','Botble\\Ecommerce\\Models\\Customer',NULL),(36,'USD',0,'NMEMJWCNHV','bank_transfer',NULL,4242.00,36,'pending','confirm',10,NULL,NULL,'2024-03-15 03:00:45','2024-03-15 03:00:45','Botble\\Ecommerce\\Models\\Customer',NULL),(37,'USD',0,'YW43WGCQKN','razorpay',NULL,3213.00,37,'completed','confirm',10,NULL,NULL,'2024-03-15 03:00:46','2024-03-15 03:00:46','Botble\\Ecommerce\\Models\\Customer',NULL),(38,'USD',0,'KQBMTXMX18','bank_transfer',NULL,1022.00,38,'pending','confirm',10,NULL,NULL,'2024-03-15 03:00:46','2024-03-15 03:00:46','Botble\\Ecommerce\\Models\\Customer',NULL),(39,'USD',0,'NDREO77WYY','razorpay',NULL,4265.00,39,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:46','2024-03-15 03:00:46','Botble\\Ecommerce\\Models\\Customer',NULL),(40,'USD',0,'OF3JRFKPBB','sslcommerz',NULL,4040.00,40,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47','Botble\\Ecommerce\\Models\\Customer',NULL),(41,'USD',0,'E9O56FNPQE','cod',NULL,1020.00,41,'pending','confirm',9,NULL,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47','Botble\\Ecommerce\\Models\\Customer',NULL),(42,'USD',0,'FIYH5FKYY8','cod',NULL,893.00,42,'pending','confirm',9,NULL,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47','Botble\\Ecommerce\\Models\\Customer',NULL),(43,'USD',0,'DJDLHTDF5R','paystack',NULL,2202.00,43,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47','Botble\\Ecommerce\\Models\\Customer',NULL),(44,'USD',0,'WQ5H992YIX','sslcommerz',NULL,2040.00,44,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:47','2024-03-15 03:00:47','Botble\\Ecommerce\\Models\\Customer',NULL),(45,'USD',0,'AGI2OUU7V3','cod',NULL,12278.00,45,'pending','confirm',10,NULL,NULL,'2024-03-15 03:00:48','2024-03-15 03:00:48','Botble\\Ecommerce\\Models\\Customer',NULL),(46,'USD',0,'D6ZAFMZEG4','cod',NULL,4296.00,46,'pending','confirm',10,NULL,NULL,'2024-03-15 03:00:48','2024-03-15 03:00:48','Botble\\Ecommerce\\Models\\Customer',NULL),(47,'USD',0,'TLYOEZCCXU','razorpay',NULL,7080.00,47,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:48','2024-03-15 03:00:48','Botble\\Ecommerce\\Models\\Customer',NULL),(48,'USD',0,'DHQENKKWHM','stripe',NULL,4362.00,48,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:48','2024-03-15 03:00:48','Botble\\Ecommerce\\Models\\Customer',NULL),(49,'USD',0,'HCA50061FC','cod',NULL,2886.00,49,'pending','confirm',9,NULL,NULL,'2024-03-15 03:00:49','2024-03-15 03:00:49','Botble\\Ecommerce\\Models\\Customer',NULL),(50,'USD',0,'2GS89WGQRC','paystack',NULL,798.00,50,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:49','2024-03-15 03:00:49','Botble\\Ecommerce\\Models\\Customer',NULL),(51,'USD',0,'NGIISN5XVH','stripe',NULL,1088.00,51,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:49','2024-03-15 03:00:49','Botble\\Ecommerce\\Models\\Customer',NULL),(52,'USD',0,'TZDHBQFBJS','sslcommerz',NULL,5784.00,52,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:49','2024-03-15 03:00:49','Botble\\Ecommerce\\Models\\Customer',NULL),(53,'USD',0,'Y4IZFRY93P','bank_transfer',NULL,2832.00,53,'pending','confirm',9,NULL,NULL,'2024-03-15 03:00:50','2024-03-15 03:00:50','Botble\\Ecommerce\\Models\\Customer',NULL),(54,'USD',0,'VXMNYQH3U3','cod',NULL,2679.00,54,'pending','confirm',9,NULL,NULL,'2024-03-15 03:00:50','2024-03-15 03:00:50','Botble\\Ecommerce\\Models\\Customer',NULL),(55,'USD',0,'HVVQ3ZR4J4','stripe',NULL,1788.00,55,'completed','confirm',9,NULL,NULL,'2024-03-15 03:00:50','2024-03-15 03:00:50','Botble\\Ecommerce\\Models\\Customer',NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (1,1),(3,1),(6,2),(3,2),(2,3),(4,3),(2,4),(6,4),(2,5),(3,5),(5,6),(3,6),(4,7),(5,7),(1,8),(5,8),(3,9),(5,9),(5,10),(6,10),(6,11),(3,11),(2,12),(1,12),(3,13),(4,13),(3,14),(6,14),(1,15),(2,15),(4,16),(3,16),(5,17),(6,18),(5,18);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (8,1),(1,1),(5,2),(8,2),(2,3),(7,3),(5,3),(1,4),(4,4),(2,5),(1,5),(4,5),(7,6),(2,6),(8,6),(7,7),(4,7),(3,8),(5,8),(7,8),(1,9),(6,9),(5,10),(6,10),(3,10),(4,11),(8,11),(2,11),(7,12),(8,12),(1,12),(5,13),(4,13),(2,13),(1,14),(4,14),(2,14),(6,15),(4,15),(1,16),(6,16),(5,16),(7,17),(5,17),(2,17),(3,18),(7,18),(8,18);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'4 Expert Tips On How To Choose The Right Men’s Wallet','Mock Turtle, \'they--you\'ve seen them, of course?\' \'Yes,\' said Alice in a trembling voice to its children, \'Come away, my dears! It\'s high time to be sure! However, everything is queer to-day.\' Just.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-9.jpg',1525,NULL,'2024-03-15 03:00:01','2024-03-15 03:00:01'),(2,'Sexy Clutches: How to Buy &amp; Wear a Designer Clutch Bag','Antipathies, I think--\' (for, you see, Miss, we\'re doing our best, afore she comes, to--\' At this the whole party look so grave that she did not like the look of the doors of the Shark, But, when.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-7.jpg',2008,NULL,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(3,'The Top 2020 Handbag Trends to Know','March Hare, who had spoken first. \'That\'s none of them bowed low. \'Would you like the look of the game, feeling very glad to find her way into a large arm-chair at one end to the three gardeners.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-7.jpg',1023,NULL,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(4,'How to Match the Color of Your Handbag With an Outfit','Like a tea-tray in the sun. (IF you don\'t like it, yer honour, at all, as the doubled-up soldiers were silent, and looked at poor Alice, who always took a great many more than that, if you don\'t.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-4.jpg',2165,NULL,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(5,'How to Care for Leather Bags','Footman remarked, \'till tomorrow--\' At this moment Alice appeared, she was now the right words,\' said poor Alice, \'it would be worth the trouble of getting her hands on her hand, and Alice looked at.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-6.jpg',129,NULL,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(6,'We\'re Crushing Hard on Summer\'s 10 Biggest Bag Trends','THE KING AND QUEEN OF HEARTS. Alice was very glad to get out again. Suddenly she came rather late, and the whole party look so grave and anxious.) Alice could think of nothing better to say than his.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-7.jpg',739,NULL,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(7,'Essential Qualities of Highly Successful Music','I\'ve fallen by this time?\' she said these words her foot slipped, and in a very difficult game indeed. The players all played at once crowded round it, panting, and asking, \'But who is Dinah, if I.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-3.jpg',999,NULL,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(8,'9 Things I Love About Shaving My Head','The Mouse looked at poor Alice, who was gently brushing away some dead leaves that had fluttered down from the shock of being all alone here!\' As she said to the confused clamour of the sense, and.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-10.jpg',757,NULL,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(9,'Why Teamwork Really Makes The Dream Work','Presently she began thinking over other children she knew the meaning of half an hour or so there were three gardeners at it, and talking over its head. \'Very uncomfortable for the first really.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-7.jpg',786,NULL,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(10,'The World Caters to Average People','Lobster Quadrille The Mock Turtle yawned and shut his eyes.--\'Tell her about the temper of your flamingo. Shall I try the effect: the next verse,\' the Gryphon remarked: \'because they lessen from day.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-2.jpg',1114,NULL,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(11,'The litigants on the screen are not actors','Alice, who always took a great hurry, muttering to himself as he spoke. \'A cat may look at all a pity. I said \"What for?\"\' \'She boxed the Queen\'s shrill cries to the Dormouse, without considering at.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-6.jpg',2171,NULL,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(12,'Hiring the Right Sales Team at the Right Time','Hardly knowing what she did, she picked up a little faster?\" said a sleepy voice behind her. \'Collar that Dormouse,\' the Queen in front of the month, and doesn\'t tell what o\'clock it is!\' As she.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-6.jpg',2372,NULL,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(13,'Fully Embrace the Return of 90s fashion','I suppose?\' said Alice. \'Why, there they are!\' said the Lory. Alice replied very politely, \'for I never understood what it was: she was ready to make out that one of them can explain it,\' said the.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-7.jpg',1822,NULL,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(14,'Exploring the English Countryside','Queen. \'Never!\' said the Mock Turtle would be very likely to eat or drink anything; so I\'ll just see what the name of the Gryphon, \'she wants for to know your history, she do.\' \'I\'ll tell it her,\'.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-9.jpg',2409,NULL,'2024-03-15 03:00:02','2024-03-15 03:00:02'),(15,'Here’s the First Valentino’s New Makeup Collection','Alice \'without pictures or conversations in it, \'and what is the same year for such dainties would not give all else for two reasons. First, because I\'m on the other paw, \'lives a March Hare. Visit.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneat