-- MySQL dump 10.13  Distrib 8.3.0, for macos14.2 (arm64)
--
-- Host: 127.0.0.1    Database: shofy
-- ------------------------------------------------------
-- Server version	8.3.0

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'puPRWsIbz1AvLAp6DNjgG3dsTT4F36bg',1,'2024-03-05 00:56:37','2024-03-05 00:56:37','2024-03-05 00:56:37');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','Enjoy free shipping on all orders over $99! Shop now and save on delivery costs.',0,NULL,NULL,0,1,'2024-03-05 07:56:45',NULL,1,'2024-03-05 00:56:45','2024-03-05 00:56:45'),(2,'Announcement 2','Need assistance? Our customer support is available 24/7 to help you with any questions or concerns.',0,NULL,NULL,0,1,'2024-03-05 07:56:45',NULL,1,'2024-03-05 00:56:45','2024-03-05 00:56:45'),(3,'Announcement 3','Shop with confidence! We offer a hassle-free 30 days return service for your peace of mind.',0,NULL,NULL,0,1,'2024-03-05 07:56:45',NULL,1,'2024-03-05 00:56:45','2024-03-05 00:56:45');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_user` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Crisp Bread &amp; Cake',0,'Et et ab quaerat deserunt corporis odit eos. Nulla omnis facilis rerum. Soluta tenetur nostrum repellat aut eveniet non. Quia repellat quis aliquam laborum quo nihil.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(2,'Fashion',0,'Quisquam sed perspiciatis qui optio sint enim. Occaecati voluptatem sed sunt doloribus quia rem. Magnam doloremque ad eos nisi velit.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(3,'Electronic',0,'Omnis quae ab quod qui tenetur consequuntur. Omnis magnam natus inventore nostrum. Quo aliquid unde ad velit quo porro animi. Non blanditiis sint iure ab et iusto.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(4,'Commercial',0,'Repellendus iste provident quis deserunt vel rerum excepturi. Et quaerat qui dignissimos. Natus a fuga ut cumque fugit. Est sint consequuntur placeat iste rerum est velit.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(5,'Organic Fruits',0,'Provident delectus facere nisi a dolore libero nam. Veritatis praesentium libero amet quis illum distinctio harum quia. Doloribus consequuntur mollitia tenetur tenetur debitis ut.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(6,'Ecological',0,'Fuga ut aut non nihil eos reprehenderit eveniet. Ipsa perspiciatis alias ducimus quam natus possimus aut. Numquam voluptatem necessitatibus esse fugit et.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:56:42','2024-03-05 00:56:42');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Abdul Larson','dietrich.cristian@example.org','(972) 404-8335','198 Osinski Gateway Suite 948\nLexushaven, MI 95059','Enim sed molestiae quo et quae.','Ea est et et. Magni odit et blanditiis fugit et nobis eos sequi. Dolores consequatur deserunt reprehenderit aut repellendus dolore mollitia. Non consequatur laboriosam explicabo perspiciatis libero libero eos. Unde quaerat aut exercitationem. Quo aut quo veritatis fugiat necessitatibus est. Illo et saepe amet vel veniam. Doloribus nihil occaecati totam suscipit. Accusamus ipsam quis tempora modi nihil in libero amet.','unread','2024-03-05 00:56:41','2024-03-05 00:56:41'),(2,'Shania Stokes','dkoepp@example.net','+13035457463','15133 Stracke Highway\nEast Mabel, UT 72881-2074','Repellendus quia dicta est vitae sint sed.','Rerum qui quia assumenda minus perferendis quos. Est labore praesentium nihil incidunt quo dolorem qui cupiditate. Consequatur voluptatem vero libero unde quam deserunt. Illum aperiam enim quo est atque. Enim officia inventore non non magni. Exercitationem delectus natus est qui provident. Consequatur sed magnam non sit omnis nihil.','read','2024-03-05 00:56:41','2024-03-05 00:56:41'),(3,'Saul Kerluke','eoconner@example.com','970.249.6970','55941 Bins Centers Suite 539\nWest Jarod, NY 41767-2909','Qui non porro et in.','Unde et temporibus pariatur et ut qui deserunt. Sit enim consequatur aliquam alias. Quia ut ab corporis et. Quia deserunt dolores cumque non. Eaque omnis est aut nam sit. Dolor nulla laudantium velit natus nulla officia dignissimos cupiditate. Aut id consequatur neque veniam aut ea qui. Magni aut enim animi. Nesciunt rerum magni quia. Animi in doloribus sint.','read','2024-03-05 00:56:41','2024-03-05 00:56:41'),(4,'Emiliano Klein','darron.metz@example.net','+1.325.925.5552','8880 Gabe Greens Apt. 280\nBlickport, PA 42168','Ea est blanditiis error ab et.','Quia occaecati corrupti nemo dignissimos sunt velit repudiandae. Voluptas est vero eum adipisci. Ducimus voluptas sit nemo. Ut voluptatem nemo nihil natus iste. Maiores sed perferendis illo assumenda. Expedita et quia ea vitae atque perferendis odio. Error dolorem ut quia ut id hic. Accusamus illo nemo voluptatum.','unread','2024-03-05 00:56:41','2024-03-05 00:56:41'),(5,'Abagail Howell','zaria63@example.net','(848) 933-8056','28612 Lenora Light Suite 142\nNew Khalid, VA 59752','Accusamus eveniet quod numquam illo.','Dolor laudantium distinctio quo delectus ab et placeat. Atque rerum rerum eaque quidem illo minima in earum. Et libero vel perferendis soluta et omnis ab. Velit debitis et est alias animi qui nulla similique. Quas magni tempore in voluptatibus ipsam voluptate. Quod unde ad omnis iste porro magnam provident. Qui consequatur quisquam placeat architecto dolorum molestias. Voluptatem animi et omnis ad consequatur.','read','2024-03-05 00:56:41','2024-03-05 00:56:41'),(6,'Rylee Schultz PhD','shayne87@example.com','+1.503.747.5778','9676 Loraine Branch\nEast Okeyport, TN 60235-0037','Et animi quia dolore itaque illo quia.','Est eveniet debitis optio eaque qui non. Voluptates quo voluptas minima ipsum. Aut deleniti perferendis commodi consequatur quos et et. Natus tempora eos voluptas eaque. Consequatur distinctio distinctio velit nihil perferendis recusandae non et. Veniam asperiores mollitia sit recusandae non. Qui fugiat explicabo autem fugit sequi esse. Velit reprehenderit voluptatem aliquam enim placeat repellat.','read','2024-03-05 00:56:41','2024-03-05 00:56:41'),(7,'Rubie Johns','shawna.cremin@example.com','352.630.5657','24571 Leonor Roads\nJoseburgh, NC 74077-3904','Quae nam officia quae.','Vero nisi adipisci magnam sapiente. Ad corrupti est veniam omnis qui quos nemo. Fuga fugiat sunt et. Aperiam velit totam iure architecto doloribus voluptatem. Facere cupiditate assumenda vel sed voluptas sit. Qui expedita perferendis repellat rem atque. Voluptas consequatur reprehenderit fugiat aliquam. Vero unde saepe a optio sunt. Quo numquam iusto consequatur consequuntur. Ad neque voluptatem deleniti incidunt qui. Dignissimos dignissimos et quia qui labore. Ad vitae rerum nemo.','read','2024-03-05 00:56:41','2024-03-05 00:56:41'),(8,'Elisha Sanford IV','hiram.haag@example.com','(561) 483-3174','2543 Kaycee Green\nPhyllisport, PA 21245','Tempore omnis sed sequi voluptatem.','Odio minima et totam ea distinctio asperiores similique. Omnis architecto reprehenderit corrupti voluptas omnis omnis omnis. Nisi ad nulla aut placeat doloremque sequi. Perferendis laboriosam voluptas qui et inventore dignissimos soluta. Id enim quia quod necessitatibus et. Ea architecto architecto est blanditiis enim. Quo quia neque neque iste rerum quo voluptatum. Delectus expedita nemo quaerat adipisci maxime velit maiores.','read','2024-03-05 00:56:41','2024-03-05 00:56:41'),(9,'Prof. Miller Flatley PhD','elijah38@example.org','832.333.2577','44365 Hills Forks Suite 356\nHermanborough, MA 41343','Rerum porro illum et saepe.','Sed voluptatem et iure sequi ea voluptatum. Laudantium molestiae asperiores quia velit deserunt necessitatibus et. Qui sint accusantium occaecati quidem et. Reprehenderit aut laudantium sed aut consequatur. Odio sint est totam et harum aliquid. Est eveniet quos repellat eius ducimus. Facere molestiae aut culpa et consectetur unde. Ea assumenda ipsam fuga itaque officia cumque. Suscipit nam sit voluptate dolores aut aliquam voluptas quae.','read','2024-03-05 00:56:41','2024-03-05 00:56:41'),(10,'Coralie Windler','harris.kathryne@example.com','(973) 912-6981','9893 Alberta Crest\nRafaelaton, ND 88063','Eum sed voluptatem est ut a sit.','Ipsum sunt eum delectus rerum. Et unde rerum quo voluptatibus molestiae ut. Aspernatur odio temporibus tempore sit provident voluptatem aut voluptas. Ut et in debitis cupiditate et. Quia nisi dolore harum nobis. Sunt totam iste aspernatur et sint nobis voluptatem. Fuga facilis rerum omnis iste expedita. Et sint temporibus ullam nulla aut aliquam omnis.','read','2024-03-05 00:56:41','2024-03-05 00:56:41');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands`
--

DROP TABLE IF EXISTS `ec_brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `website` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands`
--

LOCK TABLES `ec_brands` WRITE;
/*!40000 ALTER TABLE `ec_brands` DISABLE KEYS */;
INSERT INTO `ec_brands` VALUES (1,'FoodPound','New Snacks Release',NULL,NULL,'published',0,1,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(2,'iTea JSC','Happy Tea 100% Organic. From $29.9',NULL,NULL,'published',1,1,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(3,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',2,1,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(4,'Shofy','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',3,1,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(5,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',4,1,'2024-03-05 00:56:38','2024-03-05 00:56:38');
/*!40000 ALTER TABLE `ec_brands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands_translations`
--

DROP TABLE IF EXISTS `ec_brands_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_brands_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_brands_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands_translations`
--

LOCK TABLES `ec_brands_translations` WRITE;
/*!40000 ALTER TABLE `ec_brands_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_brands_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_cart`
--

DROP TABLE IF EXISTS `ec_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_cart` (
  `identifier` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `instance` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`identifier`,`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_cart`
--

LOCK TABLES `ec_cart` WRITE;
/*!40000 ALTER TABLE `ec_cart` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_currencies`
--

DROP TABLE IF EXISTS `ec_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned DEFAULT '0',
  `order` int unsigned DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_currencies`
--

LOCK TABLES `ec_currencies` WRITE;
/*!40000 ALTER TABLE `ec_currencies` DISABLE KEYS */;
INSERT INTO `ec_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(2,'EUR','€',0,2,1,0,0.84,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(3,'VND','₫',0,0,2,0,23203,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(4,'NGN','₦',1,2,2,0,895.52,'2024-03-05 00:56:38','2024-03-05 00:56:38');
/*!40000 ALTER TABLE `ec_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_addresses`
--

DROP TABLE IF EXISTS `ec_customer_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_addresses`
--

LOCK TABLES `ec_customer_addresses` WRITE;
/*!40000 ALTER TABLE `ec_customer_addresses` DISABLE KEYS */;
INSERT INTO `ec_customer_addresses` VALUES (1,'Laverna Mayer','customer@botble.com','+13093527238','KP','Alabama','New Antonioville','1265 Lauren Gateway Apt. 775',1,1,'2024-03-05 00:56:38','2024-03-05 00:56:38','66291-2070'),(2,'Laverna Mayer','customer@botble.com','+16609184571','GE','West Virginia','South Earl','22626 Watsica Meadow',1,0,'2024-03-05 00:56:38','2024-03-05 00:56:38','14717'),(3,'Vince Osinski','vendor@botble.com','+15802645827','AR','Colorado','Loyalstad','8140 Murazik Loaf Apt. 233',2,1,'2024-03-05 00:56:39','2024-03-05 00:56:39','54593'),(4,'Vince Osinski','vendor@botble.com','+17799362992','BE','New Mexico','North Eusebio','405 Antonia Springs Suite 960',2,0,'2024-03-05 00:56:39','2024-03-05 00:56:39','56560'),(5,'Orion Casper','nels.oreilly@example.net','+17627394642','SL','Idaho','Kilbackfurt','159 Padberg Trail Suite 163',3,1,'2024-03-05 00:56:39','2024-03-05 00:56:39','37819-4307'),(6,'Rocio Eichmann','osinski.tiara@example.com','+12165393544','MV','Idaho','South Afton','746 Julio Grove Apt. 183',4,1,'2024-03-05 00:56:39','2024-03-05 00:56:39','95279'),(7,'Miss Lori Ullrich DDS','bode.ila@example.net','+13144452052','TF','Nebraska','Fritschville','928 Bogisich Lodge Apt. 159',5,1,'2024-03-05 00:56:39','2024-03-05 00:56:39','65669-3318'),(8,'Luciano Quigley','thelma.corwin@example.net','+18204926454','KY','Ohio','Jenniferville','236 Casandra Ferry Suite 275',6,1,'2024-03-05 00:56:40','2024-03-05 00:56:40','19152'),(9,'Herminio Hudson','kurtis.sporer@example.net','+16784959730','KP','Tennessee','Port Adriennefurt','22226 Bruce Plain Suite 224',7,1,'2024-03-05 00:56:40','2024-03-05 00:56:40','59724-9283'),(10,'Jameson Rice II','raymundo33@example.com','+19524273263','RS','Arkansas','Port Augustafurt','278 Gorczany Square',8,1,'2024-03-05 00:56:40','2024-03-05 00:56:40','68466-9798'),(11,'Marjolaine Muller','lester70@example.org','+16784291565','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',9,1,'2024-03-05 00:56:40','2024-03-05 00:56:40','14941-6470'),(12,'Prof. Remington Koelpin V','melyssa.block@example.com','+16819021081','GR','Alaska','Port Cooper','75259 Wilderman Via',10,1,'2024-03-05 00:56:41','2024-03-05 00:56:41','15623-3015');
/*!40000 ALTER TABLE `ec_customer_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_password_resets`
--

DROP TABLE IF EXISTS `ec_customer_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_password_resets` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `ec_customer_password_resets_email_index` (`email`),
  KEY `ec_customer_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_password_resets`
--

LOCK TABLES `ec_customer_password_resets` WRITE;
/*!40000 ALTER TABLE `ec_customer_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_recently_viewed_products`
--

DROP TABLE IF EXISTS `ec_customer_recently_viewed_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_recently_viewed_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_recently_viewed_products`
--

LOCK TABLES `ec_customer_recently_viewed_products` WRITE;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_used_coupons`
--

DROP TABLE IF EXISTS `ec_customer_used_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_used_coupons` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_used_coupons`
--

LOCK TABLES `ec_customer_used_coupons` WRITE;
/*!40000 ALTER TABLE `ec_customer_used_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_used_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customers`
--

DROP TABLE IF EXISTS `ec_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_vendor` tinyint(1) NOT NULL DEFAULT '0',
  `vendor_verified_at` datetime DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `private_notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_customers_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customers`
--

LOCK TABLES `ec_customers` WRITE;
/*!40000 ALTER TABLE `ec_customers` DISABLE KEYS */;
INSERT INTO `ec_customers` VALUES (1,'Laverna Mayer','customer@botble.com','$2y$12$XqKWBVVm0lItKpYWphQtoOknceE1HI6A6H2cDjKpdLpf2EVLtv6B2','main/customers/2.jpg','1975-02-14','+12398927548',NULL,'2024-03-05 00:56:38','2024-03-05 00:56:43','2024-03-05 07:56:38',NULL,1,'2024-03-05 07:56:43','activated',NULL),(2,'Vince Osinski','vendor@botble.com','$2y$12$C1hQPjtVmW5/1e.DR5ypTuOAyLJv4hQPGB96SgWWyasbV.AUp9BKi','main/customers/9.jpg','2001-02-21','+14697286317',NULL,'2024-03-05 00:56:39','2024-03-05 00:56:43','2024-03-05 07:56:38',NULL,1,'2024-03-05 07:56:43','activated',NULL),(3,'Orion Casper','nels.oreilly@example.net','$2y$12$7lF.CkulW0Z8CntOhPwkmees0fg3MFp8heIpDrHXLhci/ZNu4zozC','main/customers/1.jpg','2003-02-14','+17133905556',NULL,'2024-03-05 00:56:39','2024-03-05 00:56:43','2024-03-05 07:56:38',NULL,1,'2024-03-05 07:56:43','activated',NULL),(4,'Rocio Eichmann','osinski.tiara@example.com','$2y$12$BLF9dqM9e/WoeRJjO8LTMu9BZcyibV9XygCu/Nagw.NCUrhzFHYo2','main/customers/2.jpg','1977-03-02','+18208714796',NULL,'2024-03-05 00:56:39','2024-03-05 00:56:44','2024-03-05 07:56:38',NULL,1,'2024-03-05 07:56:43','activated',NULL),(5,'Miss Lori Ullrich DDS','bode.ila@example.net','$2y$12$Npwacl3I4T5iTnYHoQi0Qu946xG3bw5e9CZq0yzmGbjnPxCflhg1C','main/customers/3.jpg','1998-02-10','+14455369240',NULL,'2024-03-05 00:56:39','2024-03-05 00:56:44','2024-03-05 07:56:38',NULL,1,'2024-03-05 07:56:43','activated',NULL),(6,'Luciano Quigley','thelma.corwin@example.net','$2y$12$vnIl9QX71U7lk/9.NA6nMOea/gm3FAbCw0CAHgeTviv4jCSSY7gda','main/customers/4.jpg','1982-02-16','+16788107302',NULL,'2024-03-05 00:56:40','2024-03-05 00:56:44','2024-03-05 07:56:38',NULL,1,'2024-03-05 07:56:43','activated',NULL),(7,'Herminio Hudson','kurtis.sporer@example.net','$2y$12$LLAhczseq.Wfo1b.j3whf.guavGPJif2NS5PCBSBq0GvWjsmAP4CW','main/customers/5.jpg','1990-02-10','+19369280200',NULL,'2024-03-05 00:56:40','2024-03-05 00:56:44','2024-03-05 07:56:38',NULL,1,'2024-03-05 07:56:43','activated',NULL),(8,'Jameson Rice II','raymundo33@example.com','$2y$12$tv53r.iDD.pbQcu2rRJnvOSqsvBxkm5vFJDzbYPTsa8QbT9AyBZ5S','main/customers/6.jpg','1995-02-09','+12108170514',NULL,'2024-03-05 00:56:40','2024-03-05 00:56:45','2024-03-05 07:56:38',NULL,1,'2024-03-05 07:56:43','activated',NULL),(9,'Marjolaine Muller','lester70@example.org','$2y$12$sph4cpPnoeSLhDeuB9Mfw.cpouUrM1Fb/J2okqtEpnTPE25IGPT5y','main/customers/7.jpg','1977-02-03','+18185205547',NULL,'2024-03-05 00:56:40','2024-03-05 00:56:45','2024-03-05 07:56:38',NULL,0,NULL,'activated',NULL),(10,'Prof. Remington Koelpin V','melyssa.block@example.com','$2y$12$icfVh8qlAhR2ILcW6WPo5uzqHLZ07SK/5zE8J5kwIT281raJvooli','main/customers/8.jpg','1976-03-02','+18106901445',NULL,'2024-03-05 00:56:41','2024-03-05 00:56:45','2024-03-05 07:56:38',NULL,0,NULL,'activated',NULL);
/*!40000 ALTER TABLE `ec_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_customers`
--

DROP TABLE IF EXISTS `ec_discount_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_customers` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_customers`
--

LOCK TABLES `ec_discount_customers` WRITE;
/*!40000 ALTER TABLE `ec_discount_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_categories`
--

DROP TABLE IF EXISTS `ec_discount_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_categories` (
  `discount_id` bigint unsigned NOT NULL,
  `product_category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_categories`
--

LOCK TABLES `ec_discount_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_collections`
--

DROP TABLE IF EXISTS `ec_discount_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_collections` (
  `discount_id` bigint unsigned NOT NULL,
  `product_collection_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_collections`
--

LOCK TABLES `ec_discount_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_collections` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_products`
--

DROP TABLE IF EXISTS `ec_discount_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_products` (
  `discount_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_products`
--

LOCK TABLES `ec_discount_products` WRITE;
/*!40000 ALTER TABLE `ec_discount_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discounts`
--

DROP TABLE IF EXISTS `ec_discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `value` double DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'coupon',
  `can_use_with_promotion` tinyint(1) NOT NULL DEFAULT '0',
  `discount_on` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_quantity` int unsigned DEFAULT NULL,
  `type_option` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'amount',
  `target` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'all-orders',
  `min_order_price` decimal(15,2) DEFAULT NULL,
  `apply_via_url` tinyint(1) NOT NULL DEFAULT '0',
  `display_at_checkout` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_discounts_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discounts`
--

LOCK TABLES `ec_discounts` WRITE;
/*!40000 ALTER TABLE `ec_discounts` DISABLE KEYS */;
INSERT INTO `ec_discounts` VALUES (1,'Discount 1','2PQ42EKJ1QW7','2024-03-04 07:56:42',NULL,NULL,0,724,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-05 00:56:42','2024-03-05 00:56:42',NULL,NULL),(2,'Discount 2','NG1GYNYMPQVQ','2024-03-04 07:56:42','2024-03-14 07:56:42',NULL,0,873,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-05 00:56:42','2024-03-05 00:56:42',NULL,NULL),(3,'Discount 3','1R29ADE5YIJ3','2024-03-04 07:56:42',NULL,NULL,0,758,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-05 00:56:42','2024-03-05 00:56:42',NULL,NULL),(4,'Discount 4','WTODKJIFXQTB','2024-03-04 07:56:42','2024-03-13 07:56:42',NULL,0,744,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-05 00:56:42','2024-03-05 00:56:42',NULL,NULL),(5,'Discount 5','U9VZPA7UBRRX','2024-03-04 07:56:42','2024-03-24 07:56:42',NULL,0,84,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-05 00:56:42','2024-03-05 00:56:42',NULL,NULL),(6,'Discount 6','KGMEB4JK419P','2024-03-04 07:56:42','2024-03-10 07:56:42',NULL,0,215,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-05 00:56:42','2024-03-05 00:56:42',NULL,NULL),(7,'Discount 7','VZS5AMYRBNQT','2024-03-04 07:56:42',NULL,NULL,0,947,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-05 00:56:42','2024-03-05 00:56:42',NULL,NULL),(8,'Discount 8','VOG7CA3NO8QE','2024-03-04 07:56:42','2024-03-30 07:56:42',NULL,0,409,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-05 00:56:42','2024-03-05 00:56:42',NULL,NULL),(9,'Discount 9','HLZZEZBLIUDL','2024-03-04 07:56:42','2024-03-31 07:56:42',NULL,0,36,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-05 00:56:42','2024-03-05 00:56:42',NULL,NULL),(10,'Discount 10','6LNHIWKOUE7C','2024-03-04 07:56:42','2024-03-22 07:56:42',NULL,0,276,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-05 00:56:42','2024-03-05 00:56:42',NULL,NULL);
/*!40000 ALTER TABLE `ec_discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sale_products`
--

DROP TABLE IF EXISTS `ec_flash_sale_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sale_products` (
  `flash_sale_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `price` double unsigned DEFAULT NULL,
  `quantity` int unsigned DEFAULT NULL,
  `sold` int unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sale_products`
--

LOCK TABLES `ec_flash_sale_products` WRITE;
/*!40000 ALTER TABLE `ec_flash_sale_products` DISABLE KEYS */;
INSERT INTO `ec_flash_sale_products` VALUES (1,1,993.96,13,2),(1,2,225,18,5),(1,3,1698.48,6,3),(1,4,668.8416,18,3),(1,5,1452,12,2),(1,6,1250.01,13,4),(1,7,437,11,5),(1,8,805.8138,12,5),(1,9,481.4,13,4),(1,10,396,14,5);
/*!40000 ALTER TABLE `ec_flash_sale_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales`
--

DROP TABLE IF EXISTS `ec_flash_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date` datetime NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales`
--

LOCK TABLES `ec_flash_sales` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales` DISABLE KEYS */;
INSERT INTO `ec_flash_sales` VALUES (1,'Winter Sale','2024-03-24 00:00:00','published','2024-03-05 00:56:51','2024-03-05 00:56:51');
/*!40000 ALTER TABLE `ec_flash_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales_translations`
--

DROP TABLE IF EXISTS `ec_flash_sales_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_flash_sales_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_flash_sales_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales_translations`
--

LOCK TABLES `ec_flash_sales_translations` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_flash_sales_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value`
--

DROP TABLE IF EXISTS `ec_global_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value`
--

LOCK TABLES `ec_global_option_value` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value` DISABLE KEYS */;
INSERT INTO `ec_global_option_value` VALUES (1,1,'1 Year',0,9999,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(1,2,'2 Year',10,9999,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(1,3,'3 Year',20,9999,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(2,4,'4GB',0,9999,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(2,5,'8GB',10,9999,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(2,6,'16GB',20,9999,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(3,7,'Core i5',0,9999,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(3,8,'Core i7',10,9999,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(3,9,'Core i9',20,9999,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(4,10,'128GB',0,9999,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(4,11,'256GB',10,9999,0,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(4,12,'512GB',20,9999,0,'2024-03-05 00:56:42','2024-03-05 00:56:42');
/*!40000 ALTER TABLE `ec_global_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value_translations`
--

DROP TABLE IF EXISTS `ec_global_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value_translations`
--

LOCK TABLES `ec_global_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options`
--

DROP TABLE IF EXISTS `ec_global_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'option type',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options`
--

LOCK TABLES `ec_global_options` WRITE;
/*!40000 ALTER TABLE `ec_global_options` DISABLE KEYS */;
INSERT INTO `ec_global_options` VALUES (1,'Warranty','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(2,'RAM','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(3,'CPU','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(4,'HDD','Botble\\Ecommerce\\Option\\OptionType\\Dropdown',0,'2024-03-05 00:56:42','2024-03-05 00:56:42');
/*!40000 ALTER TABLE `ec_global_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options_translations`
--

DROP TABLE IF EXISTS `ec_global_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_options_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options_translations`
--

LOCK TABLES `ec_global_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_grouped_products`
--

DROP TABLE IF EXISTS `ec_grouped_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_grouped_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_product_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `fixed_qty` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_grouped_products`
--

LOCK TABLES `ec_grouped_products` WRITE;
/*!40000 ALTER TABLE `ec_grouped_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_grouped_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoice_items`
--

DROP TABLE IF EXISTS `ec_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoice_items`
--

LOCK TABLES `ec_invoice_items` WRITE;
/*!40000 ALTER TABLE `ec_invoice_items` DISABLE KEYS */;
INSERT INTO `ec_invoice_items` VALUES (1,1,'Botble\\Ecommerce\\Models\\Product',52,'Classic Aviator Sunglasses',NULL,'beauty/products/product-2.png',1,2420.00,2420.00,0.00,0.00,2420.00,'{\"sku\":\"1H-104-A0\",\"attributes\":\"(Size: S, Color: Blue)\"}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(2,2,'Botble\\Ecommerce\\Models\\Product',134,'Cowl Neck Knit Poncho',NULL,'beauty/products/product-6.png',3,1870.00,5610.00,0.00,0.00,5610.00,'{\"sku\":\"FY-154-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(3,3,'Botble\\Ecommerce\\Models\\Product',77,'Velvet Evening Gown',NULL,'beauty/products/product-2.png',2,2341.00,4682.00,0.00,0.00,4682.00,'{\"sku\":\"MT-175-A0-A3\",\"attributes\":\"(Color: Blue, Size: XXL)\"}','2024-03-05 00:56:53','2024-03-05 00:56:53'),(4,4,'Botble\\Ecommerce\\Models\\Product',109,'Ruffled Wrap Dress',NULL,'beauty/products/product-2.png',3,2446.00,7338.00,0.00,0.00,7338.00,'{\"sku\":\"9T-114-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}','2024-03-05 00:56:53','2024-03-05 00:56:53'),(5,5,'Botble\\Ecommerce\\Models\\Product',118,'Embellished Ballet Flats',NULL,'beauty/products/product-2.png',2,1927.00,3854.00,0.00,0.00,3854.00,'{\"sku\":\"DN-124-A0\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 5KG)\"}','2024-03-05 00:56:53','2024-03-05 00:56:53'),(6,6,'Botble\\Ecommerce\\Models\\Product',106,'Boho Fringed Kimono (Digital)',NULL,'beauty/products/product-4.png',3,610.00,1830.00,0.00,0.00,1830.00,'{\"sku\":\"EE-179-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}','2024-03-05 00:56:53','2024-03-05 00:56:53'),(7,7,'Botble\\Ecommerce\\Models\\Product',142,'Metallic Pleated Maxi Skirt',NULL,'beauty/products/product-3.png',1,538.00,538.00,0.00,0.00,538.00,'{\"sku\":\"6E-102-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-05 00:56:53','2024-03-05 00:56:53'),(8,8,'Botble\\Ecommerce\\Models\\Product',122,'Pleated Midi Skirt',NULL,'beauty/products/product-6.png',3,1086.00,3258.00,0.00,0.00,3258.00,'{\"sku\":\"SS-142-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}','2024-03-05 00:56:53','2024-03-05 00:56:53'),(9,9,'Botble\\Ecommerce\\Models\\Product',125,'Velour Tracksuit Set',NULL,'beauty/products/product-8.png',1,1047.00,1047.00,0.00,0.00,1047.00,'{\"sku\":\"YV-124-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}','2024-03-05 00:56:54','2024-03-05 00:56:54'),(10,9,'Botble\\Ecommerce\\Models\\Product',134,'Cowl Neck Knit Poncho',NULL,'beauty/products/product-6.png',3,1870.00,5610.00,0.00,0.00,5610.00,'{\"sku\":\"FY-154-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}','2024-03-05 00:56:54','2024-03-05 00:56:54'),(11,10,'Botble\\Ecommerce\\Models\\Product',129,'Geometric Patterned Cardigan (Digital)',NULL,'beauty/products/product-2.png',2,1531.00,3062.00,0.00,0.00,3062.00,'{\"sku\":\"GR-168-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-05 00:56:54','2024-03-05 00:56:54'),(12,11,'Botble\\Ecommerce\\Models\\Product',65,'Embroidered Boho Blouse',NULL,'beauty/products/product-3.png',1,880.00,880.00,0.00,0.00,880.00,'{\"sku\":\"XL-132-A0-A2\",\"attributes\":\"(Color: Green, Size: L)\"}','2024-03-05 00:56:54','2024-03-05 00:56:54'),(13,12,'Botble\\Ecommerce\\Models\\Product',93,'Suede Pointed-Toe Pumps',NULL,'beauty/products/product-2.png',1,323.00,323.00,0.00,0.00,323.00,'{\"sku\":\"DZ-109-A0-A2\",\"attributes\":\"(Size: S, Color: Blue)\"}','2024-03-05 00:56:54','2024-03-05 00:56:54'),(14,13,'Botble\\Ecommerce\\Models\\Product',124,'Velour Tracksuit Set',NULL,'beauty/products/product-4.png',2,1047.00,2094.00,0.00,0.00,2094.00,'{\"sku\":\"YV-124-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}','2024-03-05 00:56:54','2024-03-05 00:56:54'),(15,14,'Botble\\Ecommerce\\Models\\Product',138,'Faux Leather Leggings',NULL,'beauty/products/product-5.png',2,1928.00,3856.00,0.00,0.00,3856.00,'{\"sku\":\"0X-110-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 3KG)\"}','2024-03-05 00:56:55','2024-03-05 00:56:55'),(16,15,'Botble\\Ecommerce\\Models\\Product',65,'Embroidered Boho Blouse',NULL,'beauty/products/product-3.png',1,880.00,880.00,0.00,0.00,880.00,'{\"sku\":\"XL-132-A0-A2\",\"attributes\":\"(Color: Green, Size: L)\"}','2024-03-05 00:56:55','2024-03-05 00:56:55'),(17,16,'Botble\\Ecommerce\\Models\\Product',96,'Athleisure Jogger Pants (Digital)',NULL,'beauty/products/product-5.png',1,325.00,325.00,0.00,0.00,325.00,'{\"sku\":\"NK-152-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}','2024-03-05 00:56:55','2024-03-05 00:56:55'),(18,17,'Botble\\Ecommerce\\Models\\Product',128,'Geometric Patterned Cardigan (Digital)',NULL,'beauty/products/product-8.png',3,1531.00,4593.00,0.00,0.00,4593.00,'{\"sku\":\"GR-168-A0-A1\",\"attributes\":\"(Boxes: 1 Box, Weight: 3KG)\"}','2024-03-05 00:56:55','2024-03-05 00:56:55'),(19,18,'Botble\\Ecommerce\\Models\\Product',61,'High-Waisted Wide Leg Trousers',NULL,'beauty/products/product-3.png',1,830.00,830.00,0.00,0.00,830.00,'{\"sku\":\"HI-168-A0\",\"attributes\":\"(Size: M, Color: Brown)\"}','2024-03-05 00:56:55','2024-03-05 00:56:55'),(20,19,'Botble\\Ecommerce\\Models\\Product',84,'Printed Palazzo Pants',NULL,'beauty/products/product-1.png',3,904.00,2712.00,0.00,0.00,2712.00,'{\"sku\":\"HG-162-A0\",\"attributes\":\"(Color: Red, Size: XXL)\"}','2024-03-05 00:56:55','2024-03-05 00:56:55'),(21,19,'Botble\\Ecommerce\\Models\\Product',105,'Boho Fringed Kimono (Digital)',NULL,'beauty/products/product-3.png',1,610.00,610.00,0.00,0.00,610.00,'{\"sku\":\"EE-179-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}','2024-03-05 00:56:55','2024-03-05 00:56:55'),(22,20,'Botble\\Ecommerce\\Models\\Product',142,'Metallic Pleated Maxi Skirt',NULL,'beauty/products/product-3.png',3,538.00,1614.00,0.00,0.00,1614.00,'{\"sku\":\"6E-102-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-05 00:56:56','2024-03-05 00:56:56'),(23,21,'Botble\\Ecommerce\\Models\\Product',70,'Statement Chunky Necklace',NULL,'beauty/products/product-3.png',3,2364.00,7092.00,0.00,0.00,7092.00,'{\"sku\":\"YC-187-A0-A2\",\"attributes\":\"(Color: Brown, Size: XXL)\"}','2024-03-05 00:56:56','2024-03-05 00:56:56'),(24,22,'Botble\\Ecommerce\\Models\\Product',74,'Velvet Evening Gown',NULL,'beauty/products/product-6.png',2,2341.00,4682.00,0.00,0.00,4682.00,'{\"sku\":\"MT-175-A0\",\"attributes\":\"(Color: Blue, Size: XXL)\"}','2024-03-05 00:56:56','2024-03-05 00:56:56'),(25,22,'Botble\\Ecommerce\\Models\\Product',78,'Velvet Evening Gown',NULL,'beauty/products/product-1.png',3,2341.00,7023.00,0.00,0.00,7023.00,'{\"sku\":\"MT-175-A0-A4\",\"attributes\":\"(Color: Brown, Size: XXL)\"}','2024-03-05 00:56:56','2024-03-05 00:56:56'),(26,23,'Botble\\Ecommerce\\Models\\Product',95,'Cropped Cable Knit Sweater',NULL,'beauty/products/product-1.png',3,2066.00,6198.00,0.00,0.00,6198.00,'{\"sku\":\"UO-147-A0\",\"attributes\":\"(Size: S, Color: Brown)\"}','2024-03-05 00:56:56','2024-03-05 00:56:56'),(27,24,'Botble\\Ecommerce\\Models\\Product',55,'Tailored Wool Blazer',NULL,'beauty/products/product-7.png',2,2193.00,4386.00,0.00,0.00,4386.00,'{\"sku\":\"HO-130-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}','2024-03-05 00:56:56','2024-03-05 00:56:56'),(28,25,'Botble\\Ecommerce\\Models\\Product',62,'High-Waisted Wide Leg Trousers',NULL,'beauty/products/product-1.png',2,830.00,1660.00,0.00,0.00,1660.00,'{\"sku\":\"HI-168-A0-A1\",\"attributes\":\"(Color: Blue, Size: XXL)\"}','2024-03-05 00:56:57','2024-03-05 00:56:57'),(29,26,'Botble\\Ecommerce\\Models\\Product',61,'High-Waisted Wide Leg Trousers',NULL,'beauty/products/product-3.png',2,830.00,1660.00,0.00,0.00,1660.00,'{\"sku\":\"HI-168-A0\",\"attributes\":\"(Size: M, Color: Brown)\"}','2024-03-05 00:56:57','2024-03-05 00:56:57'),(30,27,'Botble\\Ecommerce\\Models\\Product',80,'Distressed Skinny Jeans (Digital)',NULL,'beauty/products/product-3.png',3,559.00,1677.00,0.00,0.00,1677.00,'{\"sku\":\"3D-180-A0\",\"attributes\":\"(Color: Blue, Size: M)\"}','2024-03-05 00:56:57','2024-03-05 00:56:57'),(31,28,'Botble\\Ecommerce\\Models\\Product',94,'Suede Pointed-Toe Pumps',NULL,'beauty/products/product-8.png',2,323.00,646.00,0.00,0.00,646.00,'{\"sku\":\"DZ-109-A0-A3\",\"attributes\":\"(Color: Black, Size: XXL)\"}','2024-03-05 00:56:57','2024-03-05 00:56:57'),(32,28,'Botble\\Ecommerce\\Models\\Product',117,'Denim Overall Jumpsuit (Digital)',NULL,'beauty/products/product-2.png',2,1580.00,3160.00,0.00,0.00,3160.00,'{\"sku\":\"MH-188-A0-A2\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}','2024-03-05 00:56:57','2024-03-05 00:56:57'),(33,29,'Botble\\Ecommerce\\Models\\Product',54,'Tailored Wool Blazer',NULL,'beauty/products/product-8.png',2,2193.00,4386.00,0.00,0.00,4386.00,'{\"sku\":\"HO-130-A0\",\"attributes\":\"(Color: Red, Size: L)\"}','2024-03-05 00:56:57','2024-03-05 00:56:57'),(34,30,'Botble\\Ecommerce\\Models\\Product',77,'Velvet Evening Gown',NULL,'beauty/products/product-2.png',1,2341.00,2341.00,0.00,0.00,2341.00,'{\"sku\":\"MT-175-A0-A3\",\"attributes\":\"(Color: Blue, Size: XXL)\"}','2024-03-05 00:56:58','2024-03-05 00:56:58'),(35,31,'Botble\\Ecommerce\\Models\\Product',54,'Tailored Wool Blazer',NULL,'beauty/products/product-8.png',1,2193.00,2193.00,0.00,0.00,2193.00,'{\"sku\":\"HO-130-A0\",\"attributes\":\"(Color: Red, Size: L)\"}','2024-03-05 00:56:58','2024-03-05 00:56:58'),(36,32,'Botble\\Ecommerce\\Models\\Product',100,'Leopard Print Midi Skirt',NULL,'beauty/products/product-5.png',2,1696.00,3392.00,0.00,0.00,3392.00,'{\"sku\":\"HU-159-A0-A2\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-05 00:56:58','2024-03-05 00:56:58'),(37,33,'Botble\\Ecommerce\\Models\\Product',63,'Embroidered Boho Blouse',NULL,'beauty/products/product-4.png',1,880.00,880.00,0.00,0.00,880.00,'{\"sku\":\"XL-132-A0\",\"attributes\":\"(Color: Blue, Size: L)\"}','2024-03-05 00:56:58','2024-03-05 00:56:58'),(38,34,'Botble\\Ecommerce\\Models\\Product',89,'Off-Shoulder Ruffle Top',NULL,'beauty/products/product-8.png',3,988.00,2964.00,0.00,0.00,2964.00,'{\"sku\":\"BY-107-A0\",\"attributes\":\"(Color: Red, Size: L)\"}','2024-03-05 00:56:58','2024-03-05 00:56:58'),(39,35,'Botble\\Ecommerce\\Models\\Product',129,'Geometric Patterned Cardigan (Digital)',NULL,'beauty/products/product-2.png',2,1531.00,3062.00,0.00,0.00,3062.00,'{\"sku\":\"GR-168-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-05 00:56:59','2024-03-05 00:56:59'),(40,36,'Botble\\Ecommerce\\Models\\Product',141,'Faux Leather Leggings',NULL,'beauty/products/product-8.png',1,1928.00,1928.00,0.00,0.00,1928.00,'{\"sku\":\"0X-110-A0-A3\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}','2024-03-05 00:56:59','2024-03-05 00:56:59'),(41,37,'Botble\\Ecommerce\\Models\\Product',62,'High-Waisted Wide Leg Trousers',NULL,'beauty/products/product-1.png',2,830.00,1660.00,0.00,0.00,1660.00,'{\"sku\":\"HI-168-A0-A1\",\"attributes\":\"(Color: Blue, Size: XXL)\"}','2024-03-05 00:56:59','2024-03-05 00:56:59'),(42,38,'Botble\\Ecommerce\\Models\\Product',82,'Lace-Up Combat Boots',NULL,'beauty/products/product-1.png',3,1558.00,4674.00,0.00,0.00,4674.00,'{\"sku\":\"WL-196-A0-A1\",\"attributes\":\"(Color: Black, Size: XL)\"}','2024-03-05 00:56:59','2024-03-05 00:56:59'),(43,38,'Botble\\Ecommerce\\Models\\Product',104,'Faux Fur Trimmed Coat',NULL,'beauty/products/product-5.png',2,1274.00,2548.00,0.00,0.00,2548.00,'{\"sku\":\"GD-157-A0-A1\",\"attributes\":\"(Boxes: 1 Box, Weight: 3KG)\"}','2024-03-05 00:56:59','2024-03-05 00:56:59'),(44,39,'Botble\\Ecommerce\\Models\\Product',124,'Velour Tracksuit Set',NULL,'beauty/products/product-4.png',3,1047.00,3141.00,0.00,0.00,3141.00,'{\"sku\":\"YV-124-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}','2024-03-05 00:57:00','2024-03-05 00:57:00'),(45,40,'Botble\\Ecommerce\\Models\\Product',68,'Statement Chunky Necklace',NULL,'beauty/products/product-2.png',1,2364.00,2364.00,0.00,0.00,2364.00,'{\"sku\":\"YC-187-A0\",\"attributes\":\"(Size: M, Color: Red)\"}','2024-03-05 00:57:00','2024-03-05 00:57:00'),(46,40,'Botble\\Ecommerce\\Models\\Product',109,'Ruffled Wrap Dress',NULL,'beauty/products/product-2.png',1,2446.00,2446.00,0.00,0.00,2446.00,'{\"sku\":\"9T-114-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}','2024-03-05 00:57:00','2024-03-05 00:57:00'),(47,41,'Botble\\Ecommerce\\Models\\Product',85,'Printed Palazzo Pants',NULL,'beauty/products/product-7.png',1,904.00,904.00,0.00,0.00,904.00,'{\"sku\":\"HG-162-A0-A1\",\"attributes\":\"(Color: Red, Size: XXL)\"}','2024-03-05 00:57:00','2024-03-05 00:57:00'),(48,42,'Botble\\Ecommerce\\Models\\Product',89,'Off-Shoulder Ruffle Top',NULL,'beauty/products/product-8.png',2,988.00,1976.00,0.00,0.00,1976.00,'{\"sku\":\"BY-107-A0\",\"attributes\":\"(Color: Red, Size: L)\"}','2024-03-05 00:57:00','2024-03-05 00:57:00'),(49,43,'Botble\\Ecommerce\\Models\\Product',67,'Embroidered Boho Blouse',NULL,'beauty/products/product-7.png',2,880.00,1760.00,0.00,0.00,1760.00,'{\"sku\":\"XL-132-A0-A4\",\"attributes\":\"(Size: L, Color: Brown)\"}','2024-03-05 00:57:00','2024-03-05 00:57:00'),(50,44,'Botble\\Ecommerce\\Models\\Product',126,'Velour Tracksuit Set',NULL,'beauty/products/product-7.png',3,1047.00,3141.00,0.00,0.00,3141.00,'{\"sku\":\"YV-124-A0-A2\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-05 00:57:01','2024-03-05 00:57:01'),(51,45,'Botble\\Ecommerce\\Models\\Product',133,'Embroidered Bomber Jacket',NULL,'beauty/products/product-4.png',3,1876.00,5628.00,0.00,0.00,5628.00,'{\"sku\":\"CS-143-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}','2024-03-05 00:57:01','2024-03-05 00:57:01'),(52,46,'Botble\\Ecommerce\\Models\\Product',57,'Tailored Wool Blazer',NULL,'beauty/products/product-1.png',2,2193.00,4386.00,0.00,0.00,4386.00,'{\"sku\":\"HO-130-A0-A3\",\"attributes\":\"(Size: M, Color: Red)\"}','2024-03-05 00:57:01','2024-03-05 00:57:01'),(53,47,'Botble\\Ecommerce\\Models\\Product',68,'Statement Chunky Necklace',NULL,'beauty/products/product-2.png',2,2364.00,4728.00,0.00,0.00,4728.00,'{\"sku\":\"YC-187-A0\",\"attributes\":\"(Size: M, Color: Red)\"}','2024-03-05 00:57:01','2024-03-05 00:57:01'),(54,48,'Botble\\Ecommerce\\Models\\Product',65,'Embroidered Boho Blouse',NULL,'beauty/products/product-3.png',3,880.00,2640.00,0.00,0.00,2640.00,'{\"sku\":\"XL-132-A0-A2\",\"attributes\":\"(Color: Green, Size: L)\"}','2024-03-05 00:57:01','2024-03-05 00:57:01'),(55,49,'Botble\\Ecommerce\\Models\\Product',111,'Beaded Evening Clutch',NULL,'beauty/products/product-4.png',2,1236.00,2472.00,0.00,0.00,2472.00,'{\"sku\":\"KI-116-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}','2024-03-05 00:57:02','2024-03-05 00:57:02'),(56,50,'Botble\\Ecommerce\\Models\\Product',133,'Embroidered Bomber Jacket',NULL,'beauty/products/product-4.png',1,1876.00,1876.00,0.00,0.00,1876.00,'{\"sku\":\"CS-143-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}','2024-03-05 00:57:02','2024-03-05 00:57:02'),(57,51,'Botble\\Ecommerce\\Models\\Product',71,'Chic Fedora Hat (Digital)',NULL,'beauty/products/product-3.png',2,359.00,718.00,0.00,0.00,718.00,'{\"sku\":\"JH-172-A0\",\"attributes\":\"(Color: Blue, Size: M)\"}','2024-03-05 00:57:02','2024-03-05 00:57:02'),(58,51,'Botble\\Ecommerce\\Models\\Product',73,'Strappy Block Heel Sandals',NULL,'beauty/products/product-7.png',3,983.00,2949.00,0.00,0.00,2949.00,'{\"sku\":\"LX-136-A0\",\"attributes\":\"(Color: Green, Size: M)\"}','2024-03-05 00:57:02','2024-03-05 00:57:02'),(59,51,'Botble\\Ecommerce\\Models\\Product',99,'Leopard Print Midi Skirt',NULL,'beauty/products/product-4.png',3,1696.00,5088.00,0.00,0.00,5088.00,'{\"sku\":\"HU-159-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-05 00:57:02','2024-03-05 00:57:02'),(60,52,'Botble\\Ecommerce\\Models\\Product',127,'Geometric Patterned Cardigan (Digital)',NULL,'beauty/products/product-6.png',3,1531.00,4593.00,0.00,0.00,4593.00,'{\"sku\":\"GR-168-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}','2024-03-05 00:57:02','2024-03-05 00:57:02'),(61,53,'Botble\\Ecommerce\\Models\\Product',46,'Vintage Denim Jacket',NULL,'beauty/products/product-6.png',3,2259.00,6777.00,0.00,0.00,6777.00,'{\"sku\":\"6C-105-A0-A2\",\"attributes\":\"(Color: Green, Size: XXL)\"}','2024-03-05 00:57:02','2024-03-05 00:57:02'),(62,53,'Botble\\Ecommerce\\Models\\Product',134,'Cowl Neck Knit Poncho',NULL,'beauty/products/product-6.png',1,1870.00,1870.00,0.00,0.00,1870.00,'{\"sku\":\"FY-154-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}','2024-03-05 00:57:02','2024-03-05 00:57:02'),(63,54,'Botble\\Ecommerce\\Models\\Product',119,'Embellished Ballet Flats',NULL,'beauty/products/product-1.png',2,1927.00,3854.00,0.00,0.00,3854.00,'{\"sku\":\"DN-124-A0-A1\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}','2024-03-05 00:57:03','2024-03-05 00:57:03');
/*!40000 ALTER TABLE `ec_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoices`
--

DROP TABLE IF EXISTS `ec_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_tax_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_invoices_code_unique` (`code`),
  KEY `ec_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `ec_invoices_payment_id_index` (`payment_id`),
  KEY `ec_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoices`
--

LOCK TABLES `ec_invoices` WRITE;
/*!40000 ALTER TABLE `ec_invoices` DISABLE KEYS */;
INSERT INTO `ec_invoices` VALUES (1,'Botble\\Ecommerce\\Models\\Order',1,'INV-1','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,2420.00,0.00,0.00,0.00,'1','default',NULL,NULL,2420.00,NULL,1,'completed','2024-03-05 00:56:52','2024-02-20 16:56:52','2024-03-05 00:56:52'),(2,'Botble\\Ecommerce\\Models\\Order',2,'INV-2','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,5610.00,0.00,0.00,0.00,'1','default',NULL,NULL,5610.00,NULL,2,'pending',NULL,'2024-02-17 08:56:52','2024-03-05 00:56:52'),(3,'Botble\\Ecommerce\\Models\\Order',3,'INV-3','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,4682.00,0.00,0.00,0.00,'1','default',NULL,NULL,4682.00,NULL,3,'completed','2024-03-05 00:56:53','2024-03-03 10:56:53','2024-03-05 00:56:53'),(4,'Botble\\Ecommerce\\Models\\Order',4,'INV-4','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,7338.00,0.00,0.00,0.00,'1','default',NULL,NULL,7338.00,NULL,4,'completed','2024-03-05 00:56:53','2024-02-22 22:56:53','2024-03-05 00:56:53'),(5,'Botble\\Ecommerce\\Models\\Order',5,'INV-5','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,3854.00,0.00,0.00,0.00,'1','default',NULL,NULL,3854.00,NULL,5,'pending',NULL,'2024-02-18 04:56:53','2024-03-05 00:56:53'),(6,'Botble\\Ecommerce\\Models\\Order',6,'INV-6','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,1830.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1830.00,NULL,6,'pending',NULL,'2024-02-20 12:56:53','2024-03-05 00:56:53'),(7,'Botble\\Ecommerce\\Models\\Order',7,'INV-7','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,538.00,0.00,0.00,0.00,'1','default',NULL,NULL,538.00,NULL,7,'completed','2024-03-05 00:56:53','2024-02-25 00:56:53','2024-03-05 00:56:53'),(8,'Botble\\Ecommerce\\Models\\Order',8,'INV-8','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,3258.00,0.00,0.00,0.00,'1','default',NULL,NULL,3258.00,NULL,8,'completed','2024-03-05 00:56:53','2024-03-02 04:56:53','2024-03-05 00:56:53'),(9,'Botble\\Ecommerce\\Models\\Order',9,'INV-9','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,6657.00,0.00,0.00,0.00,'1','default',NULL,NULL,6657.00,NULL,9,'completed','2024-03-05 00:56:54','2024-03-03 14:56:54','2024-03-05 00:56:54'),(10,'Botble\\Ecommerce\\Models\\Order',10,'INV-10','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,3062.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3062.00,NULL,10,'completed','2024-03-05 00:56:54','2024-02-28 08:56:54','2024-03-05 00:56:54'),(11,'Botble\\Ecommerce\\Models\\Order',11,'INV-11','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,880.00,0.00,0.00,0.00,'1','default',NULL,NULL,880.00,NULL,11,'completed','2024-03-05 00:56:54','2024-03-03 16:56:54','2024-03-05 00:56:54'),(12,'Botble\\Ecommerce\\Models\\Order',12,'INV-12','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,323.00,0.00,0.00,0.00,'1','default',NULL,NULL,323.00,NULL,12,'completed','2024-03-05 00:56:54','2024-03-01 00:56:54','2024-03-05 00:56:54'),(13,'Botble\\Ecommerce\\Models\\Order',13,'INV-13','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,2094.00,0.00,0.00,0.00,'1','default',NULL,NULL,2094.00,NULL,13,'pending',NULL,'2024-03-02 08:56:54','2024-03-05 00:56:54'),(14,'Botble\\Ecommerce\\Models\\Order',14,'INV-14','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,3856.00,0.00,0.00,0.00,'1','default',NULL,NULL,3856.00,NULL,14,'pending',NULL,'2024-02-24 16:56:55','2024-03-05 00:56:55'),(15,'Botble\\Ecommerce\\Models\\Order',15,'INV-15','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,880.00,0.00,0.00,0.00,'1','default',NULL,NULL,880.00,NULL,15,'completed','2024-03-05 00:56:55','2024-02-26 12:56:55','2024-03-05 00:56:55'),(16,'Botble\\Ecommerce\\Models\\Order',16,'INV-16','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,325.00,0.00,0.00,0.00,NULL,'',NULL,NULL,325.00,NULL,16,'pending',NULL,'2024-02-24 00:56:55','2024-03-05 00:56:55'),(17,'Botble\\Ecommerce\\Models\\Order',17,'INV-17','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,4593.00,0.00,0.00,0.00,NULL,'',NULL,NULL,4593.00,NULL,17,'completed','2024-03-05 00:56:55','2024-02-24 00:56:55','2024-03-05 00:56:55'),(18,'Botble\\Ecommerce\\Models\\Order',18,'INV-18','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,830.00,0.00,0.00,0.00,'1','default',NULL,NULL,830.00,NULL,18,'completed','2024-03-05 00:56:55','2024-03-02 16:56:55','2024-03-05 00:56:55'),(19,'Botble\\Ecommerce\\Models\\Order',19,'INV-19','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,3322.00,0.00,0.00,0.00,'1','default',NULL,NULL,3322.00,NULL,19,'completed','2024-03-05 00:56:55','2024-02-25 20:56:55','2024-03-05 00:56:55'),(20,'Botble\\Ecommerce\\Models\\Order',20,'INV-20','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,1614.00,0.00,0.00,0.00,'1','default',NULL,NULL,1614.00,NULL,20,'completed','2024-03-05 00:56:56','2024-03-02 16:56:56','2024-03-05 00:56:56'),(21,'Botble\\Ecommerce\\Models\\Order',21,'INV-21','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,7092.00,0.00,0.00,0.00,'1','default',NULL,NULL,7092.00,NULL,21,'completed','2024-03-05 00:56:56','2024-02-28 14:56:56','2024-03-05 00:56:56'),(22,'Botble\\Ecommerce\\Models\\Order',22,'INV-22','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,11705.00,0.00,0.00,0.00,'1','default',NULL,NULL,11705.00,NULL,22,'pending',NULL,'2024-02-29 16:56:56','2024-03-05 00:56:56'),(23,'Botble\\Ecommerce\\Models\\Order',23,'INV-23','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,6198.00,0.00,0.00,0.00,'1','default',NULL,NULL,6198.00,NULL,23,'completed','2024-03-05 00:56:56','2024-02-26 10:56:56','2024-03-05 00:56:56'),(24,'Botble\\Ecommerce\\Models\\Order',24,'INV-24','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,4386.00,0.00,0.00,0.00,'1','default',NULL,NULL,4386.00,NULL,24,'completed','2024-03-05 00:56:56','2024-02-24 00:56:56','2024-03-05 00:56:56'),(25,'Botble\\Ecommerce\\Models\\Order',25,'INV-25','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,1660.00,0.00,0.00,0.00,'1','default',NULL,NULL,1660.00,NULL,25,'completed','2024-03-05 00:56:57','2024-02-28 00:56:57','2024-03-05 00:56:57'),(26,'Botble\\Ecommerce\\Models\\Order',26,'INV-26','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,1660.00,0.00,0.00,0.00,'1','default',NULL,NULL,1660.00,NULL,26,'pending',NULL,'2024-02-28 12:56:57','2024-03-05 00:56:57'),(27,'Botble\\Ecommerce\\Models\\Order',27,'INV-27','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,1677.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1677.00,NULL,27,'completed','2024-03-05 00:56:57','2024-02-27 14:56:57','2024-03-05 00:56:57'),(28,'Botble\\Ecommerce\\Models\\Order',28,'INV-28','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,3806.00,0.00,0.00,0.00,'1','default',NULL,NULL,3806.00,NULL,28,'completed','2024-03-05 00:56:57','2024-02-26 16:56:57','2024-03-05 00:56:57'),(29,'Botble\\Ecommerce\\Models\\Order',29,'INV-29','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,4386.00,0.00,0.00,0.00,'1','default',NULL,NULL,4386.00,NULL,29,'completed','2024-03-05 00:56:57','2024-02-29 00:56:57','2024-03-05 00:56:57'),(30,'Botble\\Ecommerce\\Models\\Order',30,'INV-30','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,2341.00,0.00,0.00,0.00,'1','default',NULL,NULL,2341.00,NULL,30,'completed','2024-03-05 00:56:58','2024-03-02 12:56:57','2024-03-05 00:56:58'),(31,'Botble\\Ecommerce\\Models\\Order',31,'INV-31','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,2193.00,0.00,0.00,0.00,'1','default',NULL,NULL,2193.00,NULL,31,'completed','2024-03-05 00:56:58','2024-02-26 12:56:58','2024-03-05 00:56:58'),(32,'Botble\\Ecommerce\\Models\\Order',32,'INV-32','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,3392.00,0.00,0.00,0.00,'1','default',NULL,NULL,3392.00,NULL,32,'pending',NULL,'2024-03-02 18:56:58','2024-03-05 00:56:58'),(33,'Botble\\Ecommerce\\Models\\Order',33,'INV-33','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,880.00,0.00,0.00,0.00,'1','default',NULL,NULL,880.00,NULL,33,'completed','2024-03-05 00:56:58','2024-03-04 08:56:58','2024-03-05 00:56:58'),(34,'Botble\\Ecommerce\\Models\\Order',34,'INV-34','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,2964.00,0.00,0.00,0.00,'1','default',NULL,NULL,2964.00,NULL,34,'completed','2024-03-05 00:56:58','2024-03-03 00:56:58','2024-03-05 00:56:58'),(35,'Botble\\Ecommerce\\Models\\Order',35,'INV-35','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,3062.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3062.00,NULL,35,'completed','2024-03-05 00:56:59','2024-02-28 16:56:59','2024-03-05 00:56:59'),(36,'Botble\\Ecommerce\\Models\\Order',36,'INV-36','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,1928.00,0.00,0.00,0.00,'1','default',NULL,NULL,1928.00,NULL,36,'pending',NULL,'2024-03-04 08:56:59','2024-03-05 00:56:59'),(37,'Botble\\Ecommerce\\Models\\Order',37,'INV-37','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,1660.00,0.00,0.00,0.00,'1','default',NULL,NULL,1660.00,NULL,37,'pending',NULL,'2024-03-01 12:56:59','2024-03-05 00:56:59'),(38,'Botble\\Ecommerce\\Models\\Order',38,'INV-38','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,7222.00,0.00,0.00,0.00,'1','default',NULL,NULL,7222.00,NULL,38,'completed','2024-03-05 00:56:59','2024-03-03 06:56:59','2024-03-05 00:56:59'),(39,'Botble\\Ecommerce\\Models\\Order',39,'INV-39','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,3141.00,0.00,0.00,0.00,'1','default',NULL,NULL,3141.00,NULL,39,'completed','2024-03-05 00:57:00','2024-02-29 08:57:00','2024-03-05 00:57:00'),(40,'Botble\\Ecommerce\\Models\\Order',40,'INV-40','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,4810.00,0.00,0.00,0.00,'1','default',NULL,NULL,4810.00,NULL,40,'pending',NULL,'2024-03-02 00:57:00','2024-03-05 00:57:00'),(41,'Botble\\Ecommerce\\Models\\Order',41,'INV-41','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,904.00,0.00,0.00,0.00,'1','default',NULL,NULL,904.00,NULL,41,'completed','2024-03-05 00:57:00','2024-03-03 00:57:00','2024-03-05 00:57:00'),(42,'Botble\\Ecommerce\\Models\\Order',42,'INV-42','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,1976.00,0.00,0.00,0.00,'1','default',NULL,NULL,1976.00,NULL,42,'completed','2024-03-05 00:57:00','2024-03-02 12:57:00','2024-03-05 00:57:00'),(43,'Botble\\Ecommerce\\Models\\Order',43,'INV-43','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,1760.00,0.00,0.00,0.00,'1','default',NULL,NULL,1760.00,NULL,43,'pending',NULL,'2024-03-03 08:57:00','2024-03-05 00:57:00'),(44,'Botble\\Ecommerce\\Models\\Order',44,'INV-44','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,3141.00,0.00,0.00,0.00,'1','default',NULL,NULL,3141.00,NULL,44,'completed','2024-03-05 00:57:01','2024-03-02 02:57:01','2024-03-05 00:57:01'),(45,'Botble\\Ecommerce\\Models\\Order',45,'INV-45','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,5628.00,0.00,0.00,0.00,'1','default',NULL,NULL,5628.00,NULL,45,'completed','2024-03-05 00:57:01','2024-02-29 20:57:01','2024-03-05 00:57:01'),(46,'Botble\\Ecommerce\\Models\\Order',46,'INV-46','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,4386.00,0.00,0.00,0.00,'1','default',NULL,NULL,4386.00,NULL,46,'pending',NULL,'2024-03-02 16:57:01','2024-03-05 00:57:01'),(47,'Botble\\Ecommerce\\Models\\Order',47,'INV-47','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,4728.00,0.00,0.00,0.00,'1','default',NULL,NULL,4728.00,NULL,47,'completed','2024-03-05 00:57:01','2024-03-03 00:57:01','2024-03-05 00:57:01'),(48,'Botble\\Ecommerce\\Models\\Order',48,'INV-48','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,2640.00,0.00,0.00,0.00,'1','default',NULL,NULL,2640.00,NULL,48,'completed','2024-03-05 00:57:01','2024-03-04 18:57:01','2024-03-05 00:57:01'),(49,'Botble\\Ecommerce\\Models\\Order',49,'INV-49','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,2472.00,0.00,0.00,0.00,'1','default',NULL,NULL,2472.00,NULL,49,'pending',NULL,'2024-03-03 18:57:02','2024-03-05 00:57:02'),(50,'Botble\\Ecommerce\\Models\\Order',50,'INV-50','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,1876.00,0.00,0.00,0.00,'1','default',NULL,NULL,1876.00,NULL,50,'completed','2024-03-05 00:57:02','2024-03-04 18:57:02','2024-03-05 00:57:02'),(51,'Botble\\Ecommerce\\Models\\Order',51,'INV-51','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,8755.00,0.00,0.00,0.00,'1','default',NULL,NULL,8755.00,NULL,51,'completed','2024-03-05 00:57:02','2024-03-04 20:57:02','2024-03-05 00:57:02'),(52,'Botble\\Ecommerce\\Models\\Order',52,'INV-52','Marjolaine Muller','',NULL,'lester70@example.org','+16784291565','2850 Hettinger Fords Suite 783, Runolfsdottirmouth, Maine, BL',NULL,4593.00,0.00,0.00,0.00,NULL,'',NULL,NULL,4593.00,NULL,52,'completed','2024-03-05 00:57:02','2024-03-04 04:57:02','2024-03-05 00:57:02'),(53,'Botble\\Ecommerce\\Models\\Order',53,'INV-53','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,8647.00,0.00,0.00,0.00,'1','default',NULL,NULL,8647.00,NULL,53,'completed','2024-03-05 00:57:02','2024-03-04 14:57:02','2024-03-05 00:57:02'),(54,'Botble\\Ecommerce\\Models\\Order',54,'INV-54','Prof. Remington Koelpin V','',NULL,'melyssa.block@example.com','+16819021081','75259 Wilderman Via, Port Cooper, Alaska, GR',NULL,3854.00,0.00,0.00,0.00,'1','default',NULL,NULL,3854.00,NULL,54,'completed','2024-03-05 00:57:03','2024-03-04 10:57:03','2024-03-05 00:57:03');
/*!40000 ALTER TABLE `ec_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value`
--

DROP TABLE IF EXISTS `ec_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value`
--

LOCK TABLES `ec_option_value` WRITE;
/*!40000 ALTER TABLE `ec_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value_translations`
--

DROP TABLE IF EXISTS `ec_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value_translations`
--

LOCK TABLES `ec_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options`
--

DROP TABLE IF EXISTS `ec_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'option type',
  `product_id` bigint unsigned NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '9999',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options`
--

LOCK TABLES `ec_options` WRITE;
/*!40000 ALTER TABLE `ec_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options_translations`
--

DROP TABLE IF EXISTS `ec_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_options_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options_translations`
--

LOCK TABLES `ec_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_addresses`
--

DROP TABLE IF EXISTS `ec_order_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'shipping_address',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_addresses`
--

LOCK TABLES `ec_order_addresses` WRITE;
/*!40000 ALTER TABLE `ec_order_addresses` DISABLE KEYS */;
INSERT INTO `ec_order_addresses` VALUES (1,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',1,'15623-3015','shipping_address'),(2,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',2,'15623-3015','shipping_address'),(3,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',3,'15623-3015','shipping_address'),(4,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',4,'15623-3015','shipping_address'),(5,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',5,'15623-3015','shipping_address'),(6,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',6,'14941-6470','shipping_address'),(7,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',7,'14941-6470','shipping_address'),(8,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',8,'14941-6470','shipping_address'),(9,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',9,'14941-6470','shipping_address'),(10,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',10,'14941-6470','shipping_address'),(11,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',11,'15623-3015','shipping_address'),(12,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',12,'15623-3015','shipping_address'),(13,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',13,'15623-3015','shipping_address'),(14,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',14,'15623-3015','shipping_address'),(15,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',15,'14941-6470','shipping_address'),(16,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',16,'14941-6470','shipping_address'),(17,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',17,'14941-6470','shipping_address'),(18,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',18,'15623-3015','shipping_address'),(19,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',19,'15623-3015','shipping_address'),(20,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',20,'15623-3015','shipping_address'),(21,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',21,'14941-6470','shipping_address'),(22,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',22,'14941-6470','shipping_address'),(23,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',23,'14941-6470','shipping_address'),(24,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',24,'15623-3015','shipping_address'),(25,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',25,'15623-3015','shipping_address'),(26,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',26,'14941-6470','shipping_address'),(27,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',27,'14941-6470','shipping_address'),(28,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',28,'14941-6470','shipping_address'),(29,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',29,'14941-6470','shipping_address'),(30,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',30,'14941-6470','shipping_address'),(31,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',31,'14941-6470','shipping_address'),(32,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',32,'14941-6470','shipping_address'),(33,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',33,'15623-3015','shipping_address'),(34,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',34,'15623-3015','shipping_address'),(35,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',35,'15623-3015','shipping_address'),(36,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',36,'15623-3015','shipping_address'),(37,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',37,'15623-3015','shipping_address'),(38,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',38,'15623-3015','shipping_address'),(39,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',39,'15623-3015','shipping_address'),(40,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',40,'14941-6470','shipping_address'),(41,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',41,'14941-6470','shipping_address'),(42,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',42,'14941-6470','shipping_address'),(43,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',43,'15623-3015','shipping_address'),(44,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',44,'15623-3015','shipping_address'),(45,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',45,'15623-3015','shipping_address'),(46,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',46,'14941-6470','shipping_address'),(47,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',47,'14941-6470','shipping_address'),(48,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',48,'14941-6470','shipping_address'),(49,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',49,'14941-6470','shipping_address'),(50,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',50,'14941-6470','shipping_address'),(51,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',51,'14941-6470','shipping_address'),(52,'Marjolaine Muller','+16784291565','lester70@example.org','BL','Maine','Runolfsdottirmouth','2850 Hettinger Fords Suite 783',52,'14941-6470','shipping_address'),(53,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',53,'15623-3015','shipping_address'),(54,'Prof. Remington Koelpin V','+16819021081','melyssa.block@example.com','GR','Alaska','Port Cooper','75259 Wilderman Via',54,'15623-3015','shipping_address');
/*!40000 ALTER TABLE `ec_order_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_histories`
--

DROP TABLE IF EXISTS `ec_order_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `extras` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=243 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_histories`
--

LOCK TABLES `ec_order_histories` WRITE;
/*!40000 ALTER TABLE `ec_order_histories` DISABLE KEYS */;
INSERT INTO `ec_order_histories` VALUES (1,'create_order_from_seeder','Order is created from the checkout page',NULL,1,NULL,'2024-02-20 16:56:52','2024-02-20 16:56:52'),(2,'confirm_order','Order was verified by %user_name%',0,1,NULL,'2024-02-20 16:56:52','2024-02-20 16:56:52'),(3,'confirm_payment','Payment was confirmed (amount $2,420.00) by %user_name%',0,1,NULL,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(4,'create_shipment','Created shipment for order',0,1,NULL,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(5,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,1,NULL,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(6,'create_order_from_seeder','Order is created from the checkout page',NULL,2,NULL,'2024-02-17 08:56:52','2024-02-17 08:56:52'),(7,'confirm_order','Order was verified by %user_name%',0,2,NULL,'2024-02-17 08:56:52','2024-02-17 08:56:52'),(8,'create_shipment','Created shipment for order',0,2,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53'),(9,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,2,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53'),(10,'create_order_from_seeder','Order is created from the checkout page',NULL,3,NULL,'2024-03-03 10:56:53','2024-03-03 10:56:53'),(11,'confirm_order','Order was verified by %user_name%',0,3,NULL,'2024-03-03 10:56:53','2024-03-03 10:56:53'),(12,'confirm_payment','Payment was confirmed (amount $4,682.00) by %user_name%',0,3,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53'),(13,'create_shipment','Created shipment for order',0,3,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53'),(14,'create_order_from_seeder','Order is created from the checkout page',NULL,4,NULL,'2024-02-22 22:56:53','2024-02-22 22:56:53'),(15,'confirm_order','Order was verified by %user_name%',0,4,NULL,'2024-02-22 22:56:53','2024-02-22 22:56:53'),(16,'confirm_payment','Payment was confirmed (amount $7,338.00) by %user_name%',0,4,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53'),(17,'create_shipment','Created shipment for order',0,4,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53'),(18,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,4,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53'),(19,'create_order_from_seeder','Order is created from the checkout page',NULL,5,NULL,'2024-02-18 04:56:53','2024-02-18 04:56:53'),(20,'confirm_order','Order was verified by %user_name%',0,5,NULL,'2024-02-18 04:56:53','2024-02-18 04:56:53'),(21,'create_shipment','Created shipment for order',0,5,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53'),(22,'create_order_from_seeder','Order is created from the checkout page',NULL,6,NULL,'2024-02-20 12:56:53','2024-02-20 12:56:53'),(23,'confirm_order','Order was verified by %user_name%',0,6,NULL,'2024-02-20 12:56:53','2024-02-20 12:56:53'),(24,'create_order_from_seeder','Order is created from the checkout page',NULL,7,NULL,'2024-02-25 00:56:53','2024-02-25 00:56:53'),(25,'confirm_order','Order was verified by %user_name%',0,7,NULL,'2024-02-25 00:56:53','2024-02-25 00:56:53'),(26,'confirm_payment','Payment was confirmed (amount $538.00) by %user_name%',0,7,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53'),(27,'create_shipment','Created shipment for order',0,7,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53'),(28,'create_order_from_seeder','Order is created from the checkout page',NULL,8,NULL,'2024-03-02 04:56:53','2024-03-02 04:56:53'),(29,'confirm_order','Order was verified by %user_name%',0,8,NULL,'2024-03-02 04:56:53','2024-03-02 04:56:53'),(30,'confirm_payment','Payment was confirmed (amount $3,258.00) by %user_name%',0,8,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53'),(31,'create_shipment','Created shipment for order',0,8,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54'),(32,'create_order_from_seeder','Order is created from the checkout page',NULL,9,NULL,'2024-03-03 14:56:54','2024-03-03 14:56:54'),(33,'confirm_order','Order was verified by %user_name%',0,9,NULL,'2024-03-03 14:56:54','2024-03-03 14:56:54'),(34,'confirm_payment','Payment was confirmed (amount $6,657.00) by %user_name%',0,9,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54'),(35,'create_shipment','Created shipment for order',0,9,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54'),(36,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,9,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54'),(37,'create_order_from_seeder','Order is created from the checkout page',NULL,10,NULL,'2024-02-28 08:56:54','2024-02-28 08:56:54'),(38,'confirm_order','Order was verified by %user_name%',0,10,NULL,'2024-02-28 08:56:54','2024-02-28 08:56:54'),(39,'confirm_payment','Payment was confirmed (amount $3,062.00) by %user_name%',0,10,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54'),(40,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,10,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54'),(41,'create_order_from_seeder','Order is created from the checkout page',NULL,11,NULL,'2024-03-03 16:56:54','2024-03-03 16:56:54'),(42,'confirm_order','Order was verified by %user_name%',0,11,NULL,'2024-03-03 16:56:54','2024-03-03 16:56:54'),(43,'confirm_payment','Payment was confirmed (amount $880.00) by %user_name%',0,11,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54'),(44,'create_shipment','Created shipment for order',0,11,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54'),(45,'create_order_from_seeder','Order is created from the checkout page',NULL,12,NULL,'2024-03-01 00:56:54','2024-03-01 00:56:54'),(46,'confirm_order','Order was verified by %user_name%',0,12,NULL,'2024-03-01 00:56:54','2024-03-01 00:56:54'),(47,'confirm_payment','Payment was confirmed (amount $323.00) by %user_name%',0,12,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54'),(48,'create_shipment','Created shipment for order',0,12,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54'),(49,'create_order_from_seeder','Order is created from the checkout page',NULL,13,NULL,'2024-03-02 08:56:54','2024-03-02 08:56:54'),(50,'confirm_order','Order was verified by %user_name%',0,13,NULL,'2024-03-02 08:56:54','2024-03-02 08:56:54'),(51,'create_shipment','Created shipment for order',0,13,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55'),(52,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,13,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55'),(53,'create_order_from_seeder','Order is created from the checkout page',NULL,14,NULL,'2024-02-24 16:56:55','2024-02-24 16:56:55'),(54,'confirm_order','Order was verified by %user_name%',0,14,NULL,'2024-02-24 16:56:55','2024-02-24 16:56:55'),(55,'create_shipment','Created shipment for order',0,14,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55'),(56,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,14,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55'),(57,'create_order_from_seeder','Order is created from the checkout page',NULL,15,NULL,'2024-02-26 12:56:55','2024-02-26 12:56:55'),(58,'confirm_order','Order was verified by %user_name%',0,15,NULL,'2024-02-26 12:56:55','2024-02-26 12:56:55'),(59,'confirm_payment','Payment was confirmed (amount $880.00) by %user_name%',0,15,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55'),(60,'create_shipment','Created shipment for order',0,15,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55'),(61,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,15,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55'),(62,'create_order_from_seeder','Order is created from the checkout page',NULL,16,NULL,'2024-02-24 00:56:55','2024-02-24 00:56:55'),(63,'confirm_order','Order was verified by %user_name%',0,16,NULL,'2024-02-24 00:56:55','2024-02-24 00:56:55'),(64,'create_order_from_seeder','Order is created from the checkout page',NULL,17,NULL,'2024-02-24 00:56:55','2024-02-24 00:56:55'),(65,'confirm_order','Order was verified by %user_name%',0,17,NULL,'2024-02-24 00:56:55','2024-02-24 00:56:55'),(66,'confirm_payment','Payment was confirmed (amount $4,593.00) by %user_name%',0,17,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55'),(67,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,17,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55'),(68,'create_order_from_seeder','Order is created from the checkout page',NULL,18,NULL,'2024-03-02 16:56:55','2024-03-02 16:56:55'),(69,'confirm_order','Order was verified by %user_name%',0,18,NULL,'2024-03-02 16:56:55','2024-03-02 16:56:55'),(70,'confirm_payment','Payment was confirmed (amount $830.00) by %user_name%',0,18,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55'),(71,'create_shipment','Created shipment for order',0,18,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55'),(72,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55'),(73,'create_order_from_seeder','Order is created from the checkout page',NULL,19,NULL,'2024-02-25 20:56:55','2024-02-25 20:56:55'),(74,'confirm_order','Order was verified by %user_name%',0,19,NULL,'2024-02-25 20:56:55','2024-02-25 20:56:55'),(75,'confirm_payment','Payment was confirmed (amount $3,322.00) by %user_name%',0,19,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55'),(76,'create_shipment','Created shipment for order',0,19,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56'),(77,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,19,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56'),(78,'create_order_from_seeder','Order is created from the checkout page',NULL,20,NULL,'2024-03-02 16:56:56','2024-03-02 16:56:56'),(79,'confirm_order','Order was verified by %user_name%',0,20,NULL,'2024-03-02 16:56:56','2024-03-02 16:56:56'),(80,'confirm_payment','Payment was confirmed (amount $1,614.00) by %user_name%',0,20,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56'),(81,'create_shipment','Created shipment for order',0,20,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56'),(82,'create_order_from_seeder','Order is created from the checkout page',NULL,21,NULL,'2024-02-28 14:56:56','2024-02-28 14:56:56'),(83,'confirm_order','Order was verified by %user_name%',0,21,NULL,'2024-02-28 14:56:56','2024-02-28 14:56:56'),(84,'confirm_payment','Payment was confirmed (amount $7,092.00) by %user_name%',0,21,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56'),(85,'create_shipment','Created shipment for order',0,21,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56'),(86,'create_order_from_seeder','Order is created from the checkout page',NULL,22,NULL,'2024-02-29 16:56:56','2024-02-29 16:56:56'),(87,'confirm_order','Order was verified by %user_name%',0,22,NULL,'2024-02-29 16:56:56','2024-02-29 16:56:56'),(88,'create_shipment','Created shipment for order',0,22,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56'),(89,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,22,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56'),(90,'create_order_from_seeder','Order is created from the checkout page',NULL,23,NULL,'2024-02-26 10:56:56','2024-02-26 10:56:56'),(91,'confirm_order','Order was verified by %user_name%',0,23,NULL,'2024-02-26 10:56:56','2024-02-26 10:56:56'),(92,'confirm_payment','Payment was confirmed (amount $6,198.00) by %user_name%',0,23,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56'),(93,'create_shipment','Created shipment for order',0,23,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56'),(94,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,23,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56'),(95,'create_order_from_seeder','Order is created from the checkout page',NULL,24,NULL,'2024-02-24 00:56:56','2024-02-24 00:56:56'),(96,'confirm_order','Order was verified by %user_name%',0,24,NULL,'2024-02-24 00:56:56','2024-02-24 00:56:56'),(97,'confirm_payment','Payment was confirmed (amount $4,386.00) by %user_name%',0,24,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56'),(98,'create_shipment','Created shipment for order',0,24,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57'),(99,'create_order_from_seeder','Order is created from the checkout page',NULL,25,NULL,'2024-02-28 00:56:57','2024-02-28 00:56:57'),(100,'confirm_order','Order was verified by %user_name%',0,25,NULL,'2024-02-28 00:56:57','2024-02-28 00:56:57'),(101,'confirm_payment','Payment was confirmed (amount $1,660.00) by %user_name%',0,25,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57'),(102,'create_shipment','Created shipment for order',0,25,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57'),(103,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,25,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57'),(104,'create_order_from_seeder','Order is created from the checkout page',NULL,26,NULL,'2024-02-28 12:56:57','2024-02-28 12:56:57'),(105,'confirm_order','Order was verified by %user_name%',0,26,NULL,'2024-02-28 12:56:57','2024-02-28 12:56:57'),(106,'create_shipment','Created shipment for order',0,26,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57'),(107,'create_order_from_seeder','Order is created from the checkout page',NULL,27,NULL,'2024-02-27 14:56:57','2024-02-27 14:56:57'),(108,'confirm_order','Order was verified by %user_name%',0,27,NULL,'2024-02-27 14:56:57','2024-02-27 14:56:57'),(109,'confirm_payment','Payment was confirmed (amount $1,677.00) by %user_name%',0,27,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57'),(110,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,27,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57'),(111,'create_order_from_seeder','Order is created from the checkout page',NULL,28,NULL,'2024-02-26 16:56:57','2024-02-26 16:56:57'),(112,'confirm_order','Order was verified by %user_name%',0,28,NULL,'2024-02-26 16:56:57','2024-02-26 16:56:57'),(113,'confirm_payment','Payment was confirmed (amount $3,806.00) by %user_name%',0,28,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57'),(114,'create_shipment','Created shipment for order',0,28,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57'),(115,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,28,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57'),(116,'create_order_from_seeder','Order is created from the checkout page',NULL,29,NULL,'2024-02-29 00:56:57','2024-02-29 00:56:57'),(117,'confirm_order','Order was verified by %user_name%',0,29,NULL,'2024-02-29 00:56:57','2024-02-29 00:56:57'),(118,'confirm_payment','Payment was confirmed (amount $4,386.00) by %user_name%',0,29,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57'),(119,'create_shipment','Created shipment for order',0,29,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57'),(120,'create_order_from_seeder','Order is created from the checkout page',NULL,30,NULL,'2024-03-02 12:56:57','2024-03-02 12:56:57'),(121,'confirm_order','Order was verified by %user_name%',0,30,NULL,'2024-03-02 12:56:57','2024-03-02 12:56:57'),(122,'confirm_payment','Payment was confirmed (amount $2,341.00) by %user_name%',0,30,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58'),(123,'create_shipment','Created shipment for order',0,30,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58'),(124,'create_order_from_seeder','Order is created from the checkout page',NULL,31,NULL,'2024-02-26 12:56:58','2024-02-26 12:56:58'),(125,'confirm_order','Order was verified by %user_name%',0,31,NULL,'2024-02-26 12:56:58','2024-02-26 12:56:58'),(126,'confirm_payment','Payment was confirmed (amount $2,193.00) by %user_name%',0,31,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58'),(127,'create_shipment','Created shipment for order',0,31,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58'),(128,'create_order_from_seeder','Order is created from the checkout page',NULL,32,NULL,'2024-03-02 18:56:58','2024-03-02 18:56:58'),(129,'confirm_order','Order was verified by %user_name%',0,32,NULL,'2024-03-02 18:56:58','2024-03-02 18:56:58'),(130,'create_shipment','Created shipment for order',0,32,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58'),(131,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,32,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58'),(132,'create_order_from_seeder','Order is created from the checkout page',NULL,33,NULL,'2024-03-04 08:56:58','2024-03-04 08:56:58'),(133,'confirm_order','Order was verified by %user_name%',0,33,NULL,'2024-03-04 08:56:58','2024-03-04 08:56:58'),(134,'confirm_payment','Payment was confirmed (amount $880.00) by %user_name%',0,33,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58'),(135,'create_shipment','Created shipment for order',0,33,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58'),(136,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,33,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58'),(137,'create_order_from_seeder','Order is created from the checkout page',NULL,34,NULL,'2024-03-03 00:56:58','2024-03-03 00:56:58'),(138,'confirm_order','Order was verified by %user_name%',0,34,NULL,'2024-03-03 00:56:58','2024-03-03 00:56:58'),(139,'confirm_payment','Payment was confirmed (amount $2,964.00) by %user_name%',0,34,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58'),(140,'create_shipment','Created shipment for order',0,34,NULL,'2024-03-05 00:56:59','2024-03-05 00:56:59'),(141,'create_order_from_seeder','Order is created from the checkout page',NULL,35,NULL,'2024-02-28 16:56:59','2024-02-28 16:56:59'),(142,'confirm_order','Order was verified by %user_name%',0,35,NULL,'2024-02-28 16:56:59','2024-02-28 16:56:59'),(143,'confirm_payment','Payment was confirmed (amount $3,062.00) by %user_name%',0,35,NULL,'2024-03-05 00:56:59','2024-03-05 00:56:59'),(144,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,35,NULL,'2024-03-05 00:56:59','2024-03-05 00:56:59'),(145,'create_order_from_seeder','Order is created from the checkout page',NULL,36,NULL,'2024-03-04 08:56:59','2024-03-04 08:56:59'),(146,'confirm_order','Order was verified by %user_name%',0,36,NULL,'2024-03-04 08:56:59','2024-03-04 08:56:59'),(147,'create_shipment','Created shipment for order',0,36,NULL,'2024-03-05 00:56:59','2024-03-05 00:56:59'),(148,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,36,NULL,'2024-03-05 00:56:59','2024-03-05 00:56:59'),(149,'create_order_from_seeder','Order is created from the checkout page',NULL,37,NULL,'2024-03-01 12:56:59','2024-03-01 12:56:59'),(150,'confirm_order','Order was verified by %user_name%',0,37,NULL,'2024-03-01 12:56:59','2024-03-01 12:56:59'),(151,'create_shipment','Created shipment for order',0,37,NULL,'2024-03-05 00:56:59','2024-03-05 00:56:59'),(152,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,37,NULL,'2024-03-05 00:56:59','2024-03-05 00:56:59'),(153,'create_order_from_seeder','Order is created from the checkout page',NULL,38,NULL,'2024-03-03 06:56:59','2024-03-03 06:56:59'),(154,'confirm_order','Order was verified by %user_name%',0,38,NULL,'2024-03-03 06:56:59','2024-03-03 06:56:59'),(155,'confirm_payment','Payment was confirmed (amount $7,222.00) by %user_name%',0,38,NULL,'2024-03-05 00:56:59','2024-03-05 00:56:59'),(156,'create_shipment','Created shipment for order',0,38,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00'),(157,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,38,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00'),(158,'create_order_from_seeder','Order is created from the checkout page',NULL,39,NULL,'2024-02-29 08:57:00','2024-02-29 08:57:00'),(159,'confirm_order','Order was verified by %user_name%',0,39,NULL,'2024-02-29 08:57:00','2024-02-29 08:57:00'),(160,'confirm_payment','Payment was confirmed (amount $3,141.00) by %user_name%',0,39,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00'),(161,'create_shipment','Created shipment for order',0,39,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00'),(162,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,39,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00'),(163,'create_order_from_seeder','Order is created from the checkout page',NULL,40,NULL,'2024-03-02 00:57:00','2024-03-02 00:57:00'),(164,'confirm_order','Order was verified by %user_name%',0,40,NULL,'2024-03-02 00:57:00','2024-03-02 00:57:00'),(165,'create_shipment','Created shipment for order',0,40,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00'),(166,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,40,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00'),(167,'create_order_from_seeder','Order is created from the checkout page',NULL,41,NULL,'2024-03-03 00:57:00','2024-03-03 00:57:00'),(168,'confirm_order','Order was verified by %user_name%',0,41,NULL,'2024-03-03 00:57:00','2024-03-03 00:57:00'),(169,'confirm_payment','Payment was confirmed (amount $904.00) by %user_name%',0,41,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00'),(170,'create_shipment','Created shipment for order',0,41,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00'),(171,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,41,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00'),(172,'create_order_from_seeder','Order is created from the checkout page',NULL,42,NULL,'2024-03-02 12:57:00','2024-03-02 12:57:00'),(173,'confirm_order','Order was verified by %user_name%',0,42,NULL,'2024-03-02 12:57:00','2024-03-02 12:57:00'),(174,'confirm_payment','Payment was confirmed (amount $1,976.00) by %user_name%',0,42,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00'),(175,'create_shipment','Created shipment for order',0,42,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00'),(176,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,42,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00'),(177,'create_order_from_seeder','Order is created from the checkout page',NULL,43,NULL,'2024-03-03 08:57:00','2024-03-03 08:57:00'),(178,'confirm_order','Order was verified by %user_name%',0,43,NULL,'2024-03-03 08:57:00','2024-03-03 08:57:00'),(179,'create_shipment','Created shipment for order',0,43,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01'),(180,'create_order_from_seeder','Order is created from the checkout page',NULL,44,NULL,'2024-03-02 02:57:01','2024-03-02 02:57:01'),(181,'confirm_order','Order was verified by %user_name%',0,44,NULL,'2024-03-02 02:57:01','2024-03-02 02:57:01'),(182,'confirm_payment','Payment was confirmed (amount $3,141.00) by %user_name%',0,44,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01'),(183,'create_shipment','Created shipment for order',0,44,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01'),(184,'create_order_from_seeder','Order is created from the checkout page',NULL,45,NULL,'2024-02-29 20:57:01','2024-02-29 20:57:01'),(185,'confirm_order','Order was verified by %user_name%',0,45,NULL,'2024-02-29 20:57:01','2024-02-29 20:57:01'),(186,'confirm_payment','Payment was confirmed (amount $5,628.00) by %user_name%',0,45,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01'),(187,'create_shipment','Created shipment for order',0,45,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01'),(188,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,45,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01'),(189,'create_order_from_seeder','Order is created from the checkout page',NULL,46,NULL,'2024-03-02 16:57:01','2024-03-02 16:57:01'),(190,'confirm_order','Order was verified by %user_name%',0,46,NULL,'2024-03-02 16:57:01','2024-03-02 16:57:01'),(191,'create_shipment','Created shipment for order',0,46,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01'),(192,'create_order_from_seeder','Order is created from the checkout page',NULL,47,NULL,'2024-03-03 00:57:01','2024-03-03 00:57:01'),(193,'confirm_order','Order was verified by %user_name%',0,47,NULL,'2024-03-03 00:57:01','2024-03-03 00:57:01'),(194,'confirm_payment','Payment was confirmed (amount $4,728.00) by %user_name%',0,47,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01'),(195,'create_shipment','Created shipment for order',0,47,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01'),(196,'create_order_from_seeder','Order is created from the checkout page',NULL,48,NULL,'2024-03-04 18:57:01','2024-03-04 18:57:01'),(197,'confirm_order','Order was verified by %user_name%',0,48,NULL,'2024-03-04 18:57:01','2024-03-04 18:57:01'),(198,'confirm_payment','Payment was confirmed (amount $2,640.00) by %user_name%',0,48,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01'),(199,'create_shipment','Created shipment for order',0,48,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02'),(200,'create_order_from_seeder','Order is created from the checkout page',NULL,49,NULL,'2024-03-03 18:57:02','2024-03-03 18:57:02'),(201,'confirm_order','Order was verified by %user_name%',0,49,NULL,'2024-03-03 18:57:02','2024-03-03 18:57:02'),(202,'create_shipment','Created shipment for order',0,49,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02'),(203,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,49,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02'),(204,'create_order_from_seeder','Order is created from the checkout page',NULL,50,NULL,'2024-03-04 18:57:02','2024-03-04 18:57:02'),(205,'confirm_order','Order was verified by %user_name%',0,50,NULL,'2024-03-04 18:57:02','2024-03-04 18:57:02'),(206,'confirm_payment','Payment was confirmed (amount $1,876.00) by %user_name%',0,50,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02'),(207,'create_shipment','Created shipment for order',0,50,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02'),(208,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,50,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02'),(209,'create_order_from_seeder','Order is created from the checkout page',NULL,51,NULL,'2024-03-04 20:57:02','2024-03-04 20:57:02'),(210,'confirm_order','Order was verified by %user_name%',0,51,NULL,'2024-03-04 20:57:02','2024-03-04 20:57:02'),(211,'confirm_payment','Payment was confirmed (amount $8,755.00) by %user_name%',0,51,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02'),(212,'create_shipment','Created shipment for order',0,51,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02'),(213,'create_order_from_seeder','Order is created from the checkout page',NULL,52,NULL,'2024-03-04 04:57:02','2024-03-04 04:57:02'),(214,'confirm_order','Order was verified by %user_name%',0,52,NULL,'2024-03-04 04:57:02','2024-03-04 04:57:02'),(215,'confirm_payment','Payment was confirmed (amount $4,593.00) by %user_name%',0,52,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02'),(216,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,52,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02'),(217,'create_order_from_seeder','Order is created from the checkout page',NULL,53,NULL,'2024-03-04 14:57:02','2024-03-04 14:57:02'),(218,'confirm_order','Order was verified by %user_name%',0,53,NULL,'2024-03-04 14:57:02','2024-03-04 14:57:02'),(219,'confirm_payment','Payment was confirmed (amount $8,647.00) by %user_name%',0,53,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02'),(220,'create_shipment','Created shipment for order',0,53,NULL,'2024-03-05 00:57:03','2024-03-05 00:57:03'),(221,'create_order_from_seeder','Order is created from the checkout page',NULL,54,NULL,'2024-03-04 10:57:03','2024-03-04 10:57:03'),(222,'confirm_order','Order was verified by %user_name%',0,54,NULL,'2024-03-04 10:57:03','2024-03-04 10:57:03'),(223,'confirm_payment','Payment was confirmed (amount $3,854.00) by %user_name%',0,54,NULL,'2024-03-05 00:57:03','2024-03-05 00:57:03'),(224,'create_shipment','Created shipment for order',0,54,NULL,'2024-03-05 00:57:03','2024-03-05 00:57:03'),(225,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,54,NULL,'2024-03-05 00:57:03','2024-03-05 00:57:03'),(226,'update_status','Order confirmed by %user_name%',0,1,NULL,'2024-03-05 00:57:03','2024-03-05 00:57:03'),(227,'update_status','Order confirmed by %user_name%',0,4,NULL,'2024-03-05 00:57:03','2024-03-05 00:57:03'),(228,'update_status','Order confirmed by %user_name%',0,9,NULL,'2024-03-05 00:57:04','2024-03-05 00:57:04'),(229,'update_status','Order confirmed by %user_name%',0,15,NULL,'2024-03-05 00:57:04','2024-03-05 00:57:04'),(230,'update_status','Order confirmed by %user_name%',0,18,NULL,'2024-03-05 00:57:05','2024-03-05 00:57:05'),(231,'update_status','Order confirmed by %user_name%',0,19,NULL,'2024-03-05 00:57:05','2024-03-05 00:57:05'),(232,'update_status','Order confirmed by %user_name%',0,23,NULL,'2024-03-05 00:57:06','2024-03-05 00:57:06'),(233,'update_status','Order confirmed by %user_name%',0,25,NULL,'2024-03-05 00:57:06','2024-03-05 00:57:06'),(234,'update_status','Order confirmed by %user_name%',0,28,NULL,'2024-03-05 00:57:07','2024-03-05 00:57:07'),(235,'update_status','Order confirmed by %user_name%',0,33,NULL,'2024-03-05 00:57:07','2024-03-05 00:57:07'),(236,'update_status','Order confirmed by %user_name%',0,38,NULL,'2024-03-05 00:57:08','2024-03-05 00:57:08'),(237,'update_status','Order confirmed by %user_name%',0,39,NULL,'2024-03-05 00:57:09','2024-03-05 00:57:09'),(238,'update_status','Order confirmed by %user_name%',0,41,NULL,'2024-03-05 00:57:09','2024-03-05 00:57:09'),(239,'update_status','Order confirmed by %user_name%',0,42,NULL,'2024-03-05 00:57:10','2024-03-05 00:57:10'),(240,'update_status','Order confirmed by %user_name%',0,45,NULL,'2024-03-05 00:57:10','2024-03-05 00:57:10'),(241,'update_status','Order confirmed by %user_name%',0,50,NULL,'2024-03-05 00:57:11','2024-03-05 00:57:11'),(242,'update_status','Order confirmed by %user_name%',0,54,NULL,'2024-03-05 00:57:11','2024-03-05 00:57:11');
/*!40000 ALTER TABLE `ec_order_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_product`
--

DROP TABLE IF EXISTS `ec_order_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_product` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `qty` int NOT NULL,
  `price` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `product_options` text COLLATE utf8mb4_unicode_ci COMMENT 'product option data',
  `product_id` bigint unsigned DEFAULT NULL,
  `product_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `restock_quantity` int unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'physical',
  `times_downloaded` int NOT NULL DEFAULT '0',
  `license_code` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_product`
--

LOCK TABLES `ec_order_product` WRITE;
/*!40000 ALTER TABLE `ec_order_product` DISABLE KEYS */;
INSERT INTO `ec_order_product` VALUES (1,1,1,2420.00,0.00,'{\"sku\":\"1H-104-A0\",\"attributes\":\"(Size: S, Color: Blue)\"}',NULL,52,'Classic Aviator Sunglasses','beauty/products/product-2.png',630.00,0,'2024-03-05 00:56:52','2024-03-05 00:56:52','physical',0,NULL),(2,2,3,1870.00,0.00,'{\"sku\":\"FY-154-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}',NULL,134,'Cowl Neck Knit Poncho','beauty/products/product-6.png',2541.00,0,'2024-03-05 00:56:52','2024-03-05 00:56:52','physical',0,NULL),(3,3,2,2341.00,0.00,'{\"sku\":\"MT-175-A0-A3\",\"attributes\":\"(Color: Blue, Size: XXL)\"}',NULL,77,'Velvet Evening Gown','beauty/products/product-2.png',1012.00,0,'2024-03-05 00:56:53','2024-03-05 00:56:53','physical',0,NULL),(4,4,3,2446.00,0.00,'{\"sku\":\"9T-114-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}',NULL,109,'Ruffled Wrap Dress','beauty/products/product-2.png',2697.00,0,'2024-03-05 00:56:53','2024-03-05 00:56:53','physical',0,NULL),(5,5,2,1927.00,0.00,'{\"sku\":\"DN-124-A0\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 5KG)\"}',NULL,118,'Embellished Ballet Flats','beauty/products/product-2.png',1562.00,0,'2024-03-05 00:56:53','2024-03-05 00:56:53','physical',0,NULL),(6,6,3,610.00,0.00,'{\"sku\":\"EE-179-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}',NULL,106,'Boho Fringed Kimono (Digital)','beauty/products/product-4.png',1929.00,0,'2024-03-05 00:56:53','2024-03-05 00:56:53','digital',6,NULL),(7,7,1,538.00,0.00,'{\"sku\":\"6E-102-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,142,'Metallic Pleated Maxi Skirt','beauty/products/product-3.png',690.00,0,'2024-03-05 00:56:53','2024-03-05 00:56:53','physical',0,NULL),(8,8,3,1086.00,0.00,'{\"sku\":\"SS-142-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}',NULL,122,'Pleated Midi Skirt','beauty/products/product-6.png',1893.00,0,'2024-03-05 00:56:53','2024-03-05 00:56:53','physical',0,NULL),(9,9,1,1047.00,0.00,'{\"sku\":\"YV-124-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}',NULL,125,'Velour Tracksuit Set','beauty/products/product-8.png',833.00,0,'2024-03-05 00:56:54','2024-03-05 00:56:54','physical',0,NULL),(10,9,3,1870.00,0.00,'{\"sku\":\"FY-154-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}',NULL,134,'Cowl Neck Knit Poncho','beauty/products/product-6.png',2541.00,0,'2024-03-05 00:56:54','2024-03-05 00:56:54','physical',0,NULL),(11,10,2,1531.00,0.00,'{\"sku\":\"GR-168-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,129,'Geometric Patterned Cardigan (Digital)','beauty/products/product-2.png',1792.00,0,'2024-03-05 00:56:54','2024-03-05 00:56:54','digital',10,NULL),(12,11,1,880.00,0.00,'{\"sku\":\"XL-132-A0-A2\",\"attributes\":\"(Color: Green, Size: L)\"}',NULL,65,'Embroidered Boho Blouse','beauty/products/product-3.png',769.00,0,'2024-03-05 00:56:54','2024-03-05 00:56:54','physical',0,NULL),(13,12,1,323.00,0.00,'{\"sku\":\"DZ-109-A0-A2\",\"attributes\":\"(Size: S, Color: Blue)\"}',NULL,93,'Suede Pointed-Toe Pumps','beauty/products/product-2.png',759.00,0,'2024-03-05 00:56:54','2024-03-05 00:56:54','physical',0,NULL),(14,13,2,1047.00,0.00,'{\"sku\":\"YV-124-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}',NULL,124,'Velour Tracksuit Set','beauty/products/product-4.png',1666.00,0,'2024-03-05 00:56:54','2024-03-05 00:56:54','physical',0,NULL),(15,14,2,1928.00,0.00,'{\"sku\":\"0X-110-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 3KG)\"}',NULL,138,'Faux Leather Leggings','beauty/products/product-5.png',1164.00,0,'2024-03-05 00:56:55','2024-03-05 00:56:55','physical',0,NULL),(16,15,1,880.00,0.00,'{\"sku\":\"XL-132-A0-A2\",\"attributes\":\"(Color: Green, Size: L)\"}',NULL,65,'Embroidered Boho Blouse','beauty/products/product-3.png',769.00,0,'2024-03-05 00:56:55','2024-03-05 00:56:55','physical',0,NULL),(17,16,1,325.00,0.00,'{\"sku\":\"NK-152-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}',NULL,96,'Athleisure Jogger Pants (Digital)','beauty/products/product-5.png',643.00,0,'2024-03-05 00:56:55','2024-03-05 00:56:55','digital',9,NULL),(18,17,3,1531.00,0.00,'{\"sku\":\"GR-168-A0-A1\",\"attributes\":\"(Boxes: 1 Box, Weight: 3KG)\"}',NULL,128,'Geometric Patterned Cardigan (Digital)','beauty/products/product-8.png',2688.00,0,'2024-03-05 00:56:55','2024-03-05 00:56:55','digital',8,NULL),(19,18,1,830.00,0.00,'{\"sku\":\"HI-168-A0\",\"attributes\":\"(Size: M, Color: Brown)\"}',NULL,61,'High-Waisted Wide Leg Trousers','beauty/products/product-3.png',656.00,0,'2024-03-05 00:56:55','2024-03-05 00:56:55','physical',0,NULL),(20,19,3,904.00,0.00,'{\"sku\":\"HG-162-A0\",\"attributes\":\"(Color: Red, Size: XXL)\"}',NULL,84,'Printed Palazzo Pants','beauty/products/product-1.png',1977.00,0,'2024-03-05 00:56:55','2024-03-05 00:56:55','physical',0,NULL),(21,19,1,610.00,0.00,'{\"sku\":\"EE-179-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}',NULL,105,'Boho Fringed Kimono (Digital)','beauty/products/product-3.png',643.00,0,'2024-03-05 00:56:55','2024-03-05 00:56:55','digital',7,NULL),(22,20,3,538.00,0.00,'{\"sku\":\"6E-102-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,142,'Metallic Pleated Maxi Skirt','beauty/products/product-3.png',2070.00,0,'2024-03-05 00:56:56','2024-03-05 00:56:56','physical',0,NULL),(23,21,3,2364.00,0.00,'{\"sku\":\"YC-187-A0-A2\",\"attributes\":\"(Color: Brown, Size: XXL)\"}',NULL,70,'Statement Chunky Necklace','beauty/products/product-3.png',2328.00,0,'2024-03-05 00:56:56','2024-03-05 00:56:56','physical',0,NULL),(24,22,2,2341.00,0.00,'{\"sku\":\"MT-175-A0\",\"attributes\":\"(Color: Blue, Size: XXL)\"}',NULL,74,'Velvet Evening Gown','beauty/products/product-6.png',1012.00,0,'2024-03-05 00:56:56','2024-03-05 00:56:56','physical',0,NULL),(25,22,3,2341.00,0.00,'{\"sku\":\"MT-175-A0-A4\",\"attributes\":\"(Color: Brown, Size: XXL)\"}',NULL,78,'Velvet Evening Gown','beauty/products/product-1.png',1518.00,0,'2024-03-05 00:56:56','2024-03-05 00:56:56','physical',0,NULL),(26,23,3,2066.00,0.00,'{\"sku\":\"UO-147-A0\",\"attributes\":\"(Size: S, Color: Brown)\"}',NULL,95,'Cropped Cable Knit Sweater','beauty/products/product-1.png',2661.00,0,'2024-03-05 00:56:56','2024-03-05 00:56:56','physical',0,NULL),(27,24,2,2193.00,0.00,'{\"sku\":\"HO-130-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}',NULL,55,'Tailored Wool Blazer','beauty/products/product-7.png',1414.00,0,'2024-03-05 00:56:56','2024-03-05 00:56:56','physical',0,NULL),(28,25,2,830.00,0.00,'{\"sku\":\"HI-168-A0-A1\",\"attributes\":\"(Color: Blue, Size: XXL)\"}',NULL,62,'High-Waisted Wide Leg Trousers','beauty/products/product-1.png',1312.00,0,'2024-03-05 00:56:57','2024-03-05 00:56:57','physical',0,NULL),(29,26,2,830.00,0.00,'{\"sku\":\"HI-168-A0\",\"attributes\":\"(Size: M, Color: Brown)\"}',NULL,61,'High-Waisted Wide Leg Trousers','beauty/products/product-3.png',1312.00,0,'2024-03-05 00:56:57','2024-03-05 00:56:57','physical',0,NULL),(30,27,3,559.00,0.00,'{\"sku\":\"3D-180-A0\",\"attributes\":\"(Color: Blue, Size: M)\"}',NULL,80,'Distressed Skinny Jeans (Digital)','beauty/products/product-3.png',2559.00,0,'2024-03-05 00:56:57','2024-03-05 00:56:57','digital',10,NULL),(31,28,2,323.00,0.00,'{\"sku\":\"DZ-109-A0-A3\",\"attributes\":\"(Color: Black, Size: XXL)\"}',NULL,94,'Suede Pointed-Toe Pumps','beauty/products/product-8.png',1518.00,0,'2024-03-05 00:56:57','2024-03-05 00:56:57','physical',0,NULL),(32,28,2,1580.00,0.00,'{\"sku\":\"MH-188-A0-A2\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}',NULL,117,'Denim Overall Jumpsuit (Digital)','beauty/products/product-2.png',1142.00,0,'2024-03-05 00:56:57','2024-03-05 00:56:57','digital',3,NULL),(33,29,2,2193.00,0.00,'{\"sku\":\"HO-130-A0\",\"attributes\":\"(Color: Red, Size: L)\"}',NULL,54,'Tailored Wool Blazer','beauty/products/product-8.png',1414.00,0,'2024-03-05 00:56:57','2024-03-05 00:56:57','physical',0,NULL),(34,30,1,2341.00,0.00,'{\"sku\":\"MT-175-A0-A3\",\"attributes\":\"(Color: Blue, Size: XXL)\"}',NULL,77,'Velvet Evening Gown','beauty/products/product-2.png',506.00,0,'2024-03-05 00:56:57','2024-03-05 00:56:57','physical',0,NULL),(35,31,1,2193.00,0.00,'{\"sku\":\"HO-130-A0\",\"attributes\":\"(Color: Red, Size: L)\"}',NULL,54,'Tailored Wool Blazer','beauty/products/product-8.png',707.00,0,'2024-03-05 00:56:58','2024-03-05 00:56:58','physical',0,NULL),(36,32,2,1696.00,0.00,'{\"sku\":\"HU-159-A0-A2\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,100,'Leopard Print Midi Skirt','beauty/products/product-5.png',1588.00,0,'2024-03-05 00:56:58','2024-03-05 00:56:58','physical',0,NULL),(37,33,1,880.00,0.00,'{\"sku\":\"XL-132-A0\",\"attributes\":\"(Color: Blue, Size: L)\"}',NULL,63,'Embroidered Boho Blouse','beauty/products/product-4.png',769.00,0,'2024-03-05 00:56:58','2024-03-05 00:56:58','physical',0,NULL),(38,34,3,988.00,0.00,'{\"sku\":\"BY-107-A0\",\"attributes\":\"(Color: Red, Size: L)\"}',NULL,89,'Off-Shoulder Ruffle Top','beauty/products/product-8.png',2628.00,0,'2024-03-05 00:56:58','2024-03-05 00:56:58','physical',0,NULL),(39,35,2,1531.00,0.00,'{\"sku\":\"GR-168-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,129,'Geometric Patterned Cardigan (Digital)','beauty/products/product-2.png',1792.00,0,'2024-03-05 00:56:59','2024-03-05 00:56:59','digital',0,NULL),(40,36,1,1928.00,0.00,'{\"sku\":\"0X-110-A0-A3\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}',NULL,141,'Faux Leather Leggings','beauty/products/product-8.png',582.00,0,'2024-03-05 00:56:59','2024-03-05 00:56:59','physical',0,NULL),(41,37,2,830.00,0.00,'{\"sku\":\"HI-168-A0-A1\",\"attributes\":\"(Color: Blue, Size: XXL)\"}',NULL,62,'High-Waisted Wide Leg Trousers','beauty/products/product-1.png',1312.00,0,'2024-03-05 00:56:59','2024-03-05 00:56:59','physical',0,NULL),(42,38,3,1558.00,0.00,'{\"sku\":\"WL-196-A0-A1\",\"attributes\":\"(Color: Black, Size: XL)\"}',NULL,82,'Lace-Up Combat Boots','beauty/products/product-1.png',2568.00,0,'2024-03-05 00:56:59','2024-03-05 00:56:59','physical',0,NULL),(43,38,2,1274.00,0.00,'{\"sku\":\"GD-157-A0-A1\",\"attributes\":\"(Boxes: 1 Box, Weight: 3KG)\"}',NULL,104,'Faux Fur Trimmed Coat','beauty/products/product-5.png',1754.00,0,'2024-03-05 00:56:59','2024-03-05 00:56:59','physical',0,NULL),(44,39,3,1047.00,0.00,'{\"sku\":\"YV-124-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}',NULL,124,'Velour Tracksuit Set','beauty/products/product-4.png',2499.00,0,'2024-03-05 00:57:00','2024-03-05 00:57:00','physical',0,NULL),(45,40,1,2364.00,0.00,'{\"sku\":\"YC-187-A0\",\"attributes\":\"(Size: M, Color: Red)\"}',NULL,68,'Statement Chunky Necklace','beauty/products/product-2.png',776.00,0,'2024-03-05 00:57:00','2024-03-05 00:57:00','physical',0,NULL),(46,40,1,2446.00,0.00,'{\"sku\":\"9T-114-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}',NULL,109,'Ruffled Wrap Dress','beauty/products/product-2.png',899.00,0,'2024-03-05 00:57:00','2024-03-05 00:57:00','physical',0,NULL),(47,41,1,904.00,0.00,'{\"sku\":\"HG-162-A0-A1\",\"attributes\":\"(Color: Red, Size: XXL)\"}',NULL,85,'Printed Palazzo Pants','beauty/products/product-7.png',659.00,0,'2024-03-05 00:57:00','2024-03-05 00:57:00','physical',0,NULL),(48,42,2,988.00,0.00,'{\"sku\":\"BY-107-A0\",\"attributes\":\"(Color: Red, Size: L)\"}',NULL,89,'Off-Shoulder Ruffle Top','beauty/products/product-8.png',1752.00,0,'2024-03-05 00:57:00','2024-03-05 00:57:00','physical',0,NULL),(49,43,2,880.00,0.00,'{\"sku\":\"XL-132-A0-A4\",\"attributes\":\"(Size: L, Color: Brown)\"}',NULL,67,'Embroidered Boho Blouse','beauty/products/product-7.png',1538.00,0,'2024-03-05 00:57:00','2024-03-05 00:57:00','physical',0,NULL),(50,44,3,1047.00,0.00,'{\"sku\":\"YV-124-A0-A2\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,126,'Velour Tracksuit Set','beauty/products/product-7.png',2499.00,0,'2024-03-05 00:57:01','2024-03-05 00:57:01','physical',0,NULL),(51,45,3,1876.00,0.00,'{\"sku\":\"CS-143-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}',NULL,133,'Embroidered Bomber Jacket','beauty/products/product-4.png',2052.00,0,'2024-03-05 00:57:01','2024-03-05 00:57:01','physical',0,NULL),(52,46,2,2193.00,0.00,'{\"sku\":\"HO-130-A0-A3\",\"attributes\":\"(Size: M, Color: Red)\"}',NULL,57,'Tailored Wool Blazer','beauty/products/product-1.png',1414.00,0,'2024-03-05 00:57:01','2024-03-05 00:57:01','physical',0,NULL),(53,47,2,2364.00,0.00,'{\"sku\":\"YC-187-A0\",\"attributes\":\"(Size: M, Color: Red)\"}',NULL,68,'Statement Chunky Necklace','beauty/products/product-2.png',1552.00,0,'2024-03-05 00:57:01','2024-03-05 00:57:01','physical',0,NULL),(54,48,3,880.00,0.00,'{\"sku\":\"XL-132-A0-A2\",\"attributes\":\"(Color: Green, Size: L)\"}',NULL,65,'Embroidered Boho Blouse','beauty/products/product-3.png',2307.00,0,'2024-03-05 00:57:01','2024-03-05 00:57:01','physical',0,NULL),(55,49,2,1236.00,0.00,'{\"sku\":\"KI-116-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}',NULL,111,'Beaded Evening Clutch','beauty/products/product-4.png',1086.00,0,'2024-03-05 00:57:02','2024-03-05 00:57:02','physical',0,NULL),(56,50,1,1876.00,0.00,'{\"sku\":\"CS-143-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}',NULL,133,'Embroidered Bomber Jacket','beauty/products/product-4.png',684.00,0,'2024-03-05 00:57:02','2024-03-05 00:57:02','physical',0,NULL),(57,51,2,359.00,0.00,'{\"sku\":\"JH-172-A0\",\"attributes\":\"(Color: Blue, Size: M)\"}',NULL,71,'Chic Fedora Hat (Digital)','beauty/products/product-3.png',1754.00,0,'2024-03-05 00:57:02','2024-03-05 00:57:02','digital',6,NULL),(58,51,3,983.00,0.00,'{\"sku\":\"LX-136-A0\",\"attributes\":\"(Color: Green, Size: M)\"}',NULL,73,'Strappy Block Heel Sandals','beauty/products/product-7.png',2610.00,0,'2024-03-05 00:57:02','2024-03-05 00:57:02','physical',0,NULL),(59,51,3,1696.00,0.00,'{\"sku\":\"HU-159-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,99,'Leopard Print Midi Skirt','beauty/products/product-4.png',2382.00,0,'2024-03-05 00:57:02','2024-03-05 00:57:02','physical',0,NULL),(60,52,3,1531.00,0.00,'{\"sku\":\"GR-168-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}',NULL,127,'Geometric Patterned Cardigan (Digital)','beauty/products/product-6.png',2688.00,0,'2024-03-05 00:57:02','2024-03-05 00:57:02','digital',9,NULL),(61,53,3,2259.00,0.00,'{\"sku\":\"6C-105-A0-A2\",\"attributes\":\"(Color: Green, Size: XXL)\"}',NULL,46,'Vintage Denim Jacket','beauty/products/product-6.png',2106.00,0,'2024-03-05 00:57:02','2024-03-05 00:57:02','physical',0,NULL),(62,53,1,1870.00,0.00,'{\"sku\":\"FY-154-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}',NULL,134,'Cowl Neck Knit Poncho','beauty/products/product-6.png',847.00,0,'2024-03-05 00:57:02','2024-03-05 00:57:02','physical',0,NULL),(63,54,2,1927.00,0.00,'{\"sku\":\"DN-124-A0-A1\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}',NULL,119,'Embellished Ballet Flats','beauty/products/product-1.png',1562.00,0,'2024-03-05 00:57:03','2024-03-05 00:57:03','physical',0,NULL);
/*!40000 ALTER TABLE `ec_order_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_referrals`
--

DROP TABLE IF EXISTS `ec_order_referrals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_referrals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_domain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_page` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_params` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referral` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gclid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fclid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_campaign` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_medium` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_term` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_content` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer_url` text COLLATE utf8mb4_unicode_ci,
  `referrer_domain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_referrals_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_referrals`
--

LOCK TABLES `ec_order_referrals` WRITE;
/*!40000 ALTER TABLE `ec_order_referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_referrals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_return_items`
--

DROP TABLE IF EXISTS `ec_order_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_return_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_return_id` bigint unsigned NOT NULL COMMENT 'Order return id',
  `order_product_id` bigint unsigned NOT NULL COMMENT 'Order product id',
  `product_id` bigint unsigned NOT NULL COMMENT 'Product id',
  `product_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int NOT NULL COMMENT 'Quantity return',
  `price` decimal(15,2) NOT NULL COMMENT 'Price Product',
  `reason` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `refund_amount` decimal(12,2) DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_return_items`
--

LOCK TABLES `ec_order_return_items` WRITE;
/*!40000 ALTER TABLE `ec_order_return_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_return_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_returns`
--

DROP TABLE IF EXISTS `ec_order_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_returns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL COMMENT 'Order ID',
  `store_id` bigint unsigned DEFAULT NULL COMMENT 'Store ID',
  `user_id` bigint unsigned NOT NULL COMMENT 'Customer ID',
  `reason` text COLLATE utf8mb4_unicode_ci COMMENT 'Reason return order',
  `order_status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Order current status',
  `return_status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Return status',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_order_returns_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_returns`
--

LOCK TABLES `ec_order_returns` WRITE;
/*!40000 ALTER TABLE `ec_order_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_tax_information`
--

DROP TABLE IF EXISTS `ec_order_tax_information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_tax_information` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `company_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_tax_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_tax_information_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_tax_information`
--

LOCK TABLES `ec_order_tax_information` WRITE;
/*!40000 ALTER TABLE `ec_order_tax_information` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_tax_information` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_orders`
--

DROP TABLE IF EXISTS `ec_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT NULL,
  `shipping_amount` decimal(15,2) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(15,2) DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `is_confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `discount_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_finished` tinyint(1) DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `proof_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_orders_code_unique` (`code`),
  KEY `ec_orders_user_id_status_created_at_index` (`user_id`,`status`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_orders`
--

LOCK TABLES `ec_orders` WRITE;
/*!40000 ALTER TABLE `ec_orders` DISABLE KEYS */;
INSERT INTO `ec_orders` VALUES (1,'#10000001',10,'1','default','completed',2420.00,0.00,0.00,NULL,NULL,0.00,2420.00,1,NULL,1,'2024-03-05 00:57:03','Q4CB20cHUxyTsDIdhHZhuja90sgxl',1,'2024-02-20 16:56:52','2024-03-05 00:57:03',3,NULL),(2,'#10000002',10,'1','default','completed',5610.00,0.00,0.00,NULL,NULL,0.00,5610.00,1,NULL,1,'2024-03-05 00:56:53','vxxVwaNrhQIlK31ry0wqtUwYK9fmx',2,'2024-02-17 08:56:52','2024-03-05 00:56:53',1,NULL),(3,'#10000003',10,'1','default','pending',4682.00,0.00,0.00,NULL,NULL,0.00,4682.00,1,NULL,1,NULL,'EEKyr1oKtUembNZupXJWF4pw6sCAK',3,'2024-03-03 10:56:53','2024-03-05 00:56:53',7,NULL),(4,'#10000004',10,'1','default','completed',7338.00,0.00,0.00,NULL,NULL,0.00,7338.00,1,NULL,1,'2024-03-05 00:57:03','PIRDJkEDMnRfRRhixbahsKt5vj40Q',4,'2024-02-22 22:56:53','2024-03-05 00:57:03',1,NULL),(5,'#10000005',10,'1','default','pending',3854.00,0.00,0.00,NULL,NULL,0.00,3854.00,1,NULL,1,NULL,'NCp3HFLEjN6etwFLcYM6xor81taJz',5,'2024-02-18 04:56:53','2024-03-05 00:56:53',2,NULL),(6,'#10000006',9,NULL,'','pending',1830.00,0.00,0.00,NULL,NULL,0.00,1830.00,1,NULL,1,NULL,'DQN6SfLTcc9DmollJFbHLH20GVQdM',6,'2024-02-20 12:56:53','2024-03-05 00:56:53',6,NULL),(7,'#10000007',9,'1','default','pending',538.00,0.00,0.00,NULL,NULL,0.00,538.00,1,NULL,1,NULL,'KFdMIn2hNKsgMj6fNFg4nZUYJecx1',7,'2024-02-25 00:56:53','2024-03-05 00:56:53',8,NULL),(8,'#10000008',9,'1','default','pending',3258.00,0.00,0.00,NULL,NULL,0.00,3258.00,1,NULL,1,NULL,'1GzdBzZ2SuZtHvce8HrKv3F97VKzp',8,'2024-03-02 04:56:53','2024-03-05 00:56:53',3,NULL),(9,'#10000009',9,'1','default','completed',6657.00,0.00,0.00,NULL,NULL,0.00,6657.00,1,NULL,1,'2024-03-05 00:57:04','jmZ1otw0CLUNrH2U32CDJ2dAsXPF8',9,'2024-03-03 14:56:54','2024-03-05 00:57:04',1,NULL),(10,'#10000010',9,NULL,'','completed',3062.00,0.00,0.00,NULL,NULL,0.00,3062.00,1,NULL,1,'2024-03-05 00:56:54','YUPvmSYXVVTHCdvrS42Znwnawamus',10,'2024-02-28 08:56:54','2024-03-05 00:56:54',7,NULL),(11,'#10000011',10,'1','default','pending',880.00,0.00,0.00,NULL,NULL,0.00,880.00,1,NULL,1,NULL,'A72NS85QMSbTju4nRTEHj7ITY3jFO',11,'2024-03-03 16:56:54','2024-03-05 00:56:54',2,NULL),(12,'#10000012',10,'1','default','pending',323.00,0.00,0.00,NULL,NULL,0.00,323.00,1,NULL,1,NULL,'7qiLEtTLEUqTj0G6FPRUvbZxpi6xE',12,'2024-03-01 00:56:54','2024-03-05 00:56:54',6,NULL),(13,'#10000013',10,'1','default','completed',2094.00,0.00,0.00,NULL,NULL,0.00,2094.00,1,NULL,1,'2024-03-05 00:56:55','dijfl01j91LBLH64gM3XVaYvRUUfJ',13,'2024-03-02 08:56:54','2024-03-05 00:56:55',1,NULL),(14,'#10000014',10,'1','default','completed',3856.00,0.00,0.00,NULL,NULL,0.00,3856.00,1,NULL,1,'2024-03-05 00:56:55','6kYoLwLbNYDSvAGxEcF6smO7Hekxo',14,'2024-02-24 16:56:55','2024-03-05 00:56:55',3,NULL),(15,'#10000015',9,'1','default','completed',880.00,0.00,0.00,NULL,NULL,0.00,880.00,1,NULL,1,'2024-03-05 00:57:04','fdqBYZON5R7Akp3cSr3LYM0Ti92cq',15,'2024-02-26 12:56:55','2024-03-05 00:57:04',2,NULL),(16,'#10000016',9,NULL,'','pending',325.00,0.00,0.00,NULL,NULL,0.00,325.00,1,NULL,1,NULL,'v7MLWHnXw0L9qRorRGM8vCWCPUkGs',16,'2024-02-24 00:56:55','2024-03-05 00:56:55',3,NULL),(17,'#10000017',9,NULL,'','completed',4593.00,0.00,0.00,NULL,NULL,0.00,4593.00,1,NULL,1,'2024-03-05 00:56:55','Ozf5EbbIEdKj0KkP96c0crayMHb9Z',17,'2024-02-24 00:56:55','2024-03-05 00:56:55',7,NULL),(18,'#10000018',10,'1','default','completed',830.00,0.00,0.00,NULL,NULL,0.00,830.00,1,NULL,1,'2024-03-05 00:57:05','IvFw59SuDoNWK7kwFdSYjxBtQMeYF',18,'2024-03-02 16:56:55','2024-03-05 00:57:05',4,NULL),(19,'#10000019',10,'1','default','completed',3322.00,0.00,0.00,NULL,NULL,0.00,3322.00,1,NULL,1,'2024-03-05 00:57:05','PP6C3IHtC1AjBWWkHvKf4ID20mpbT',19,'2024-02-25 20:56:55','2024-03-05 00:57:05',6,NULL),(20,'#10000020',10,'1','default','pending',1614.00,0.00,0.00,NULL,NULL,0.00,1614.00,1,NULL,1,NULL,'XKsFmnCnepoWtgSKYtSgSAxClQwya',20,'2024-03-02 16:56:56','2024-03-05 00:56:56',8,NULL),(21,'#10000021',9,'1','default','pending',7092.00,0.00,0.00,NULL,NULL,0.00,7092.00,1,NULL,1,NULL,'5fUUhDqlT9ZE4tylnMn1YHEc7hUUV',21,'2024-02-28 14:56:56','2024-03-05 00:56:56',1,NULL),(22,'#10000022',9,'1','default','completed',11705.00,0.00,0.00,NULL,NULL,0.00,11705.00,1,NULL,1,'2024-03-05 00:56:56','voGDtQ50ejc0op35mOAW1G9LCLNP5',22,'2024-02-29 16:56:56','2024-03-05 00:56:56',7,NULL),(23,'#10000023',9,'1','default','completed',6198.00,0.00,0.00,NULL,NULL,0.00,6198.00,1,NULL,1,'2024-03-05 00:57:06','mvDkP5KS9ZBFqP12f9aNhyooMf8rw',23,'2024-02-26 10:56:56','2024-03-05 00:57:06',4,NULL),(24,'#10000024',10,'1','default','pending',4386.00,0.00,0.00,NULL,NULL,0.00,4386.00,1,NULL,1,NULL,'zduzD89ripSMshCL0pCOf6SDQ0kM0',24,'2024-02-24 00:56:56','2024-03-05 00:56:56',8,NULL),(25,'#10000025',10,'1','default','completed',1660.00,0.00,0.00,NULL,NULL,0.00,1660.00,1,NULL,1,'2024-03-05 00:57:06','249C6vynwwwYdiCYJ7hbUOHDsxsdL',25,'2024-02-28 00:56:57','2024-03-05 00:57:06',4,NULL),(26,'#10000026',9,'1','default','pending',1660.00,0.00,0.00,NULL,NULL,0.00,1660.00,1,NULL,1,NULL,'j5hXHPpDVcyKKUg6Tl5JXa92vDRhT',26,'2024-02-28 12:56:57','2024-03-05 00:56:57',4,NULL),(27,'#10000027',9,NULL,'','completed',1677.00,0.00,0.00,NULL,NULL,0.00,1677.00,1,NULL,1,'2024-03-05 00:56:57','LzLccEWDpulfL1J2peISAE9R3cUFe',27,'2024-02-27 14:56:57','2024-03-05 00:56:57',8,NULL),(28,'#10000028',9,'1','default','completed',3806.00,0.00,0.00,NULL,NULL,0.00,3806.00,1,NULL,1,'2024-03-05 00:57:07','7X13GrwYJKAeZcbMy4810EU3C7eGL',28,'2024-02-26 16:56:57','2024-03-05 00:57:07',6,NULL),(29,'#10000029',9,'1','default','pending',4386.00,0.00,0.00,NULL,NULL,0.00,4386.00,1,NULL,1,NULL,'ZrvaGS5BNAadn8iDAFLSs46v6Mgud',29,'2024-02-29 00:56:57','2024-03-05 00:56:57',8,NULL),(30,'#10000030',9,'1','default','pending',2341.00,0.00,0.00,NULL,NULL,0.00,2341.00,1,NULL,1,NULL,'NPJbHTgZEBdfYbHfI6HRtWAA4uMG4',30,'2024-03-02 12:56:57','2024-03-05 00:56:58',7,NULL),(31,'#10000031',9,'1','default','pending',2193.00,0.00,0.00,NULL,NULL,0.00,2193.00,1,NULL,1,NULL,'TiUzMPBBajWSBpusk2khQPPI3QSo7',31,'2024-02-26 12:56:58','2024-03-05 00:56:58',8,NULL),(32,'#10000032',9,'1','default','completed',3392.00,0.00,0.00,NULL,NULL,0.00,3392.00,1,NULL,1,'2024-03-05 00:56:58','UW1zl1n02TasNX7tSz0N7ymc3ZuvK',32,'2024-03-02 18:56:58','2024-03-05 00:56:58',1,NULL),(33,'#10000033',10,'1','default','completed',880.00,0.00,0.00,NULL,NULL,0.00,880.00,1,NULL,1,'2024-03-05 00:57:07','avByhy2Mgta14Gw96P6UnevRBf2CA',33,'2024-03-04 08:56:58','2024-03-05 00:57:07',2,NULL),(34,'#10000034',10,'1','default','pending',2964.00,0.00,0.00,NULL,NULL,0.00,2964.00,1,NULL,1,NULL,'gS2aqB5VZnfD7ycvJVES4IqrpQmup',34,'2024-03-03 00:56:58','2024-03-05 00:56:58',8,NULL),(35,'#10000035',10,NULL,'','completed',3062.00,0.00,0.00,NULL,NULL,0.00,3062.00,1,NULL,1,'2024-03-05 00:56:59','VRLHTYTYDTm5Tl0LphkhlC6INWuNI',35,'2024-02-28 16:56:59','2024-03-05 00:56:59',7,NULL),(36,'#10000036',10,'1','default','completed',1928.00,0.00,0.00,NULL,NULL,0.00,1928.00,1,NULL,1,'2024-03-05 00:56:59','aZ8NDct408yeCuj2LuJOjw70Z51jW',36,'2024-03-04 08:56:59','2024-03-05 00:56:59',3,NULL),(37,'#10000037',10,'1','default','completed',1660.00,0.00,0.00,NULL,NULL,0.00,1660.00,1,NULL,1,'2024-03-05 00:56:59','ROv2nu8COZE4SMiRZYX2ySGW8K3ij',37,'2024-03-01 12:56:59','2024-03-05 00:56:59',4,NULL),(38,'#10000038',10,'1','default','completed',7222.00,0.00,0.00,NULL,NULL,0.00,7222.00,1,NULL,1,'2024-03-05 00:57:08','80OGkS5v8KaCXmXRi9MwU2FGKeMjN',38,'2024-03-03 06:56:59','2024-03-05 00:57:08',2,NULL),(39,'#10000039',10,'1','default','completed',3141.00,0.00,0.00,NULL,NULL,0.00,3141.00,1,NULL,1,'2024-03-05 00:57:09','p6AaYABUMzeYdA3X1rX1bfRuPY50l',39,'2024-02-29 08:57:00','2024-03-05 00:57:09',1,NULL),(40,'#10000040',9,'1','default','completed',4810.00,0.00,0.00,NULL,NULL,0.00,4810.00,1,NULL,1,'2024-03-05 00:57:00','2s2W8Ye4szPBqbfiqe66xmrZkGWXu',40,'2024-03-02 00:57:00','2024-03-05 00:57:00',1,NULL),(41,'#10000041',9,'1','default','completed',904.00,0.00,0.00,NULL,NULL,0.00,904.00,1,NULL,1,'2024-03-05 00:57:09','xK5Cf1inolr6kkcfTDH2mxXzRcsFe',41,'2024-03-03 00:57:00','2024-03-05 00:57:09',6,NULL),(42,'#10000042',9,'1','default','completed',1976.00,0.00,0.00,NULL,NULL,0.00,1976.00,1,NULL,1,'2024-03-05 00:57:10','MS4MxFyyLKe0XkZQx1N2XkG6vlR4o',42,'2024-03-02 12:57:00','2024-03-05 00:57:10',8,NULL),(43,'#10000043',10,'1','default','pending',1760.00,0.00,0.00,NULL,NULL,0.00,1760.00,1,NULL,1,NULL,'o0vJLnSEnNrNVAXNDr9ldfu0nJi7A',43,'2024-03-03 08:57:00','2024-03-05 00:57:00',2,NULL),(44,'#10000044',10,'1','default','pending',3141.00,0.00,0.00,NULL,NULL,0.00,3141.00,1,NULL,1,NULL,'FhPUxB14UZiK2ah9j8mllBD1YdkXD',44,'2024-03-02 02:57:01','2024-03-05 00:57:01',1,NULL),(45,'#10000045',10,'1','default','completed',5628.00,0.00,0.00,NULL,NULL,0.00,5628.00,1,NULL,1,'2024-03-05 00:57:10','stvnp22wc5xbXXUQeyj43zDLtacD2',45,'2024-02-29 20:57:01','2024-03-05 00:57:10',7,NULL),(46,'#10000046',9,'1','default','pending',4386.00,0.00,0.00,NULL,NULL,0.00,4386.00,1,NULL,1,NULL,'xzzMLxvx95ZbraivPTpcqczd5N4mG',46,'2024-03-02 16:57:01','2024-03-05 00:57:01',8,NULL),(47,'#10000047',9,'1','default','pending',4728.00,0.00,0.00,NULL,NULL,0.00,4728.00,1,NULL,1,NULL,'PaVgPg8wax3Jhh3rSHIWBzpnPhx7U',47,'2024-03-03 00:57:01','2024-03-05 00:57:01',1,NULL),(48,'#10000048',9,'1','default','pending',2640.00,0.00,0.00,NULL,NULL,0.00,2640.00,1,NULL,1,NULL,'GqqTuAWIXYmzNQktBXrkhyMvPpcb7',48,'2024-03-04 18:57:01','2024-03-05 00:57:01',2,NULL),(49,'#10000049',9,'1','default','completed',2472.00,0.00,0.00,NULL,NULL,0.00,2472.00,1,NULL,1,'2024-03-05 00:57:02','GOI0pMdjycfI6VVfRslzJ1Ib6UR60',49,'2024-03-03 18:57:02','2024-03-05 00:57:02',8,NULL),(50,'#10000050',9,'1','default','completed',1876.00,0.00,0.00,NULL,NULL,0.00,1876.00,1,NULL,1,'2024-03-05 00:57:11','TKJs7KaX2WFOHTzvAOKOsRTxnWQRu',50,'2024-03-04 18:57:02','2024-03-05 00:57:11',7,NULL),(51,'#10000051',9,'1','default','pending',8755.00,0.00,0.00,NULL,NULL,0.00,8755.00,1,NULL,1,NULL,'tPyWe5UQtUEbhkXxZMNgbGDLNKeYz',51,'2024-03-04 20:57:02','2024-03-05 00:57:02',1,NULL),(52,'#10000052',9,NULL,'','completed',4593.00,0.00,0.00,NULL,NULL,0.00,4593.00,1,NULL,1,'2024-03-05 00:57:02','FMP3K7fKpK3Rv6NJzVCBJdXaIvjVb',52,'2024-03-04 04:57:02','2024-03-05 00:57:02',7,NULL),(53,'#10000053',10,'1','default','pending',8647.00,0.00,0.00,NULL,NULL,0.00,8647.00,1,NULL,1,NULL,'T3DX8AfLODc7q3dyP9tz7VcI0qohO',53,'2024-03-04 14:57:02','2024-03-05 00:57:02',1,NULL),(54,'#10000054',10,'1','default','completed',3854.00,0.00,0.00,NULL,NULL,0.00,3854.00,1,NULL,1,'2024-03-05 00:57:11','AmX4K4QjWDyZatdflt1uTdprHNpC6',54,'2024-03-04 10:57:03','2024-03-05 00:57:11',2,NULL);
/*!40000 ALTER TABLE `ec_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_layout` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'swatch_dropdown',
  `is_searchable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_comparable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_use_in_product_listing` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `use_image_from_product_variation` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets`
--

LOCK TABLES `ec_product_attribute_sets` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets` DISABLE KEYS */;
INSERT INTO `ec_product_attribute_sets` VALUES (1,'Color','color','visual',1,1,1,'published',0,'2024-03-05 00:56:38','2024-03-05 00:56:38',0),(2,'Size','size','text',1,1,1,'published',1,'2024-03-05 00:56:38','2024-03-05 00:56:38',0),(3,'Weight','weight','text',1,1,1,'published',0,'2024-03-05 00:56:38','2024-03-05 00:56:38',0),(4,'Boxes','boxes','text',1,1,1,'published',1,'2024-03-05 00:56:38','2024-03-05 00:56:38',0);
/*!40000 ALTER TABLE `ec_product_attribute_sets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets_translations`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attribute_sets_id` bigint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attribute_sets_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets_translations`
--

LOCK TABLES `ec_product_attribute_sets_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes`
--

DROP TABLE IF EXISTS `ec_product_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` bigint unsigned NOT NULL,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_set_status_index` (`attribute_set_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes`
--

LOCK TABLES `ec_product_attributes` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes` DISABLE KEYS */;
INSERT INTO `ec_product_attributes` VALUES (1,1,'Green','green','#5FB7D4',NULL,1,1,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(2,1,'Blue','blue','#333333',NULL,0,2,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(3,1,'Red','red','#DA323F',NULL,0,3,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(4,1,'Black','black','#2F366C',NULL,0,4,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(5,1,'Brown','brown','#87554B',NULL,0,5,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(6,2,'S','s',NULL,NULL,1,1,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(7,2,'M','m',NULL,NULL,0,2,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(8,2,'L','l',NULL,NULL,0,3,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(9,2,'XL','xl',NULL,NULL,0,4,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(10,2,'XXL','xxl',NULL,NULL,0,5,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(11,3,'1KG','1kg',NULL,NULL,1,1,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(12,3,'2KG','2kg',NULL,NULL,0,2,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(13,3,'3KG','3kg',NULL,NULL,0,3,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(14,3,'4KG','4kg',NULL,NULL,0,4,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(15,3,'5KG','5kg',NULL,NULL,0,5,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(16,4,'1 Box','1-box',NULL,NULL,1,1,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(17,4,'2 Boxes','2-boxes',NULL,NULL,0,2,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(18,4,'3 Boxes','3-boxes',NULL,NULL,0,3,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(19,4,'4 Boxes','4-boxes',NULL,NULL,0,4,'2024-03-05 00:56:38','2024-03-05 00:56:38'),(20,4,'5 Boxes','5-boxes',NULL,NULL,0,5,'2024-03-05 00:56:38','2024-03-05 00:56:38');
/*!40000 ALTER TABLE `ec_product_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes_translations`
--

DROP TABLE IF EXISTS `ec_product_attributes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attributes_id` bigint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes_translations`
--

LOCK TABLES `ec_product_attributes_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attributes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories`
--

DROP TABLE IF EXISTS `ec_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` int unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_categories_parent_id_status_created_at_index` (`parent_id`,`status`,`created_at`),
  KEY `ec_product_categories_parent_id_status_index` (`parent_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories`
--

LOCK TABLES `ec_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_product_categories` DISABLE KEYS */;
INSERT INTO `ec_product_categories` VALUES (1,'Discover Skincare',0,NULL,'published',0,'beauty/product-categories/1.jpg',0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(2,'Clothing',0,NULL,'published',1,'beauty/product-categories/4.jpg',0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(3,'Men\'s Clothing',2,NULL,'published',0,NULL,0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(4,'T-Shirts',3,NULL,'published',0,NULL,0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(5,'Jeans',3,NULL,'published',1,NULL,0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(6,'Suits',3,NULL,'published',2,NULL,0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(7,'Women\'s Clothing',2,NULL,'published',1,'beauty/product-categories/2.jpg',0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(8,'Dresses',7,NULL,'published',0,NULL,0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(9,'Blouses',7,NULL,'published',1,NULL,0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(10,'Pants',7,NULL,'published',2,NULL,0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(11,'Accessories',0,NULL,'published',2,NULL,0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(12,'Hats',11,NULL,'published',0,NULL,0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(13,'Scarves',11,NULL,'published',1,NULL,0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(14,'Jewelry',11,NULL,'published',2,NULL,0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(15,'Sportswear',0,NULL,'published',3,NULL,0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(16,'Activewear',15,NULL,'published',0,NULL,0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL),(17,'Running Shoes',15,NULL,'published',1,'beauty/product-categories/3.jpg',0,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL,NULL);
/*!40000 ALTER TABLE `ec_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories_translations`
--

DROP TABLE IF EXISTS `ec_product_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_categories_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_product_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories_translations`
--

LOCK TABLES `ec_product_categories_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categorizables`
--

DROP TABLE IF EXISTS `ec_product_categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categorizables` (
  `category_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`category_id`,`reference_id`,`reference_type`),
  KEY `ec_product_categorizables_category_id_index` (`category_id`),
  KEY `ec_product_categorizables_reference_id_index` (`reference_id`),
  KEY `ec_product_categorizables_reference_type_index` (`reference_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categorizables`
--

LOCK TABLES `ec_product_categorizables` WRITE;
/*!40000 ALTER TABLE `ec_product_categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categorizables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_category_product`
--

DROP TABLE IF EXISTS `ec_product_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_category_product` (
  `category_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`category_id`),
  KEY `ec_product_category_product_category_id_index` (`category_id`),
  KEY `ec_product_category_product_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_category_product`
--

LOCK TABLES `ec_product_category_product` WRITE;
/*!40000 ALTER TABLE `ec_product_category_product` DISABLE KEYS */;
INSERT INTO `ec_product_category_product` VALUES (1,2),(1,5),(1,22),(1,23),(1,24),(1,27),(1,31),(1,33),(1,37),(1,39),(1,40),(2,9),(2,13),(2,22),(2,24),(2,31),(2,32),(2,33),(2,35),(2,36),(2,38),(3,9),(3,10),(3,11),(3,17),(3,18),(3,23),(3,25),(3,39),(3,40),(3,42),(4,4),(4,8),(4,11),(4,15),(4,21),(4,30),(4,33),(4,40),(4,43),(5,1),(5,3),(5,5),(5,13),(5,22),(5,27),(5,29),(5,31),(5,33),(5,36),(6,6),(6,12),(6,14),(6,18),(6,20),(6,35),(7,3),(7,4),(7,6),(7,10),(7,14),(7,15),(7,17),(7,24),(7,25),(7,28),(7,32),(7,35),(8,2),(8,4),(8,38),(8,41),(8,42),(9,1),(9,2),(9,6),(9,7),(9,20),(9,26),(9,30),(9,34),(9,36),(9,38),(10,3),(10,5),(10,8),(10,10),(10,11),(10,13),(10,19),(10,21),(10,23),(10,28),(10,34),(10,37),(10,39),(10,40),(11,7),(11,10),(11,20),(11,31),(11,32),(11,37),(11,41),(11,42),(12,3),(12,7),(12,8),(12,9),(12,11),(12,14),(12,16),(12,21),(12,27),(12,28),(12,30),(13,4),(13,12),(13,15),(13,17),(13,24),(13,25),(13,26),(13,34),(13,36),(13,38),(13,41),(13,43),(14,16),(14,19),(14,26),(14,29),(14,34),(14,37),(14,42),(14,43),(15,1),(15,2),(15,12),(15,13),(15,16),(15,17),(15,19),(15,25),(15,27),(15,28),(15,29),(15,30),(15,32),(16,5),(16,12),(16,15),(16,16),(16,18),(16,19),(16,22),(16,29),(16,41),(17,1),(17,6),(17,7),(17,8),(17,9),(17,14),(17,18),(17,20),(17,21),(17,23),(17,26),(17,35),(17,39),(17,43);
/*!40000 ALTER TABLE `ec_product_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collection_products`
--

DROP TABLE IF EXISTS `ec_product_collection_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collection_products` (
  `product_collection_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`product_collection_id`),
  KEY `ec_product_collection_products_product_collection_id_index` (`product_collection_id`),
  KEY `ec_product_collection_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collection_products`
--

LOCK TABLES `ec_product_collection_products` WRITE;
/*!40000 ALTER TABLE `ec_product_collection_products` DISABLE KEYS */;
INSERT INTO `ec_product_collection_products` VALUES (1,3),(1,9),(1,14),(1,16),(1,17),(1,18),(1,22),(1,31),(1,36),(1,39),(1,41),(1,42),(2,1),(2,10),(2,13),(2,19),(2,33),(2,34),(2,35),(2,40),(3,4),(3,5),(3,7),(3,8),(3,12),(3,20),(3,23),(3,24),(3,25),(3,28),(3,29),(3,32),(3,37),(3,38),(4,2),(4,6),(4,11),(4,15),(4,21),(4,26),(4,27),(4,30),(4,43);
/*!40000 ALTER TABLE `ec_product_collection_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections`
--

DROP TABLE IF EXISTS `ec_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections`
--

LOCK TABLES `ec_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_product_collections` DISABLE KEYS */;
INSERT INTO `ec_product_collections` VALUES (1,'Trendy Wardrobe Essentials','trendy-wardrobe-essentials',NULL,NULL,'published','2024-03-05 00:56:46','2024-03-05 00:56:46',0),(2,'Fashion Forward Finds','fashion-forward-finds',NULL,NULL,'published','2024-03-05 00:56:46','2024-03-05 00:56:46',0),(3,'Chic &amp; Stylish Collection','chic-stylish-collection',NULL,NULL,'published','2024-03-05 00:56:46','2024-03-05 00:56:46',0),(4,'Weekly Fashion Picks','weekly-fashion-picks',NULL,NULL,'published','2024-03-05 00:56:46','2024-03-05 00:56:46',0);
/*!40000 ALTER TABLE `ec_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections_translations`
--

DROP TABLE IF EXISTS `ec_product_collections_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_collections_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_collections_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections_translations`
--

LOCK TABLES `ec_product_collections_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_collections_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_collections_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_cross_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_cross_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_cross_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  `is_variant` tinyint(1) NOT NULL DEFAULT '0',
  `price` decimal(15,2) DEFAULT '0.00',
  `price_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed',
  `apply_to_all_variations` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_cross_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_cross_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_cross_sale_relations`
--

LOCK TABLES `ec_product_cross_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` DISABLE KEYS */;
INSERT INTO `ec_product_cross_sale_relations` VALUES (1,3,0,0.00,'fixed',1),(1,4,0,0.00,'fixed',1),(1,5,0,0.00,'fixed',1),(1,6,0,0.00,'fixed',1),(1,10,0,0.00,'fixed',1),(1,12,0,0.00,'fixed',1),(1,16,0,0.00,'fixed',1),(2,4,0,0.00,'fixed',1),(2,7,0,0.00,'fixed',1),(2,10,0,0.00,'fixed',1),(2,13,0,0.00,'fixed',1),(2,18,0,0.00,'fixed',1),(3,1,0,0.00,'fixed',1),(3,4,0,0.00,'fixed',1),(3,6,0,0.00,'fixed',1),(3,13,0,0.00,'fixed',1),(3,18,0,0.00,'fixed',1),(4,1,0,0.00,'fixed',1),(4,3,0,0.00,'fixed',1),(4,9,0,0.00,'fixed',1),(4,10,0,0.00,'fixed',1),(4,11,0,0.00,'fixed',1),(5,6,0,0.00,'fixed',1),(5,7,0,0.00,'fixed',1),(5,14,0,0.00,'fixed',1),(5,16,0,0.00,'fixed',1),(5,17,0,0.00,'fixed',1),(6,2,0,0.00,'fixed',1),(6,3,0,0.00,'fixed',1),(6,10,0,0.00,'fixed',1),(6,11,0,0.00,'fixed',1),(6,14,0,0.00,'fixed',1),(6,15,0,0.00,'fixed',1),(7,5,0,0.00,'fixed',1),(7,6,0,0.00,'fixed',1),(7,9,0,0.00,'fixed',1),(7,15,0,0.00,'fixed',1),(7,17,0,0.00,'fixed',1),(8,2,0,0.00,'fixed',1),(8,4,0,0.00,'fixed',1),(8,6,0,0.00,'fixed',1),(8,7,0,0.00,'fixed',1),(8,11,0,0.00,'fixed',1),(8,14,0,0.00,'fixed',1),(9,2,0,0.00,'fixed',1),(9,3,0,0.00,'fixed',1),(9,5,0,0.00,'fixed',1),(9,13,0,0.00,'fixed',1),(9,14,0,0.00,'fixed',1),(9,15,0,0.00,'fixed',1),(9,17,0,0.00,'fixed',1),(10,3,0,0.00,'fixed',1),(10,5,0,0.00,'fixed',1),(10,8,0,0.00,'fixed',1),(10,11,0,0.00,'fixed',1),(10,19,0,0.00,'fixed',1),(10,20,0,0.00,'fixed',1),(11,2,0,0.00,'fixed',1),(11,8,0,0.00,'fixed',1),(11,13,0,0.00,'fixed',1),(11,15,0,0.00,'fixed',1),(11,16,0,0.00,'fixed',1),(11,19,0,0.00,'fixed',1),(12,1,0,0.00,'fixed',1),(12,13,0,0.00,'fixed',1),(12,16,0,0.00,'fixed',1),(12,20,0,0.00,'fixed',1),(13,1,0,0.00,'fixed',1),(13,2,0,0.00,'fixed',1),(13,4,0,0.00,'fixed',1),(13,5,0,0.00,'fixed',1),(13,6,0,0.00,'fixed',1),(13,11,0,0.00,'fixed',1),(14,5,0,0.00,'fixed',1),(14,10,0,0.00,'fixed',1),(14,12,0,0.00,'fixed',1),(14,16,0,0.00,'fixed',1),(14,18,0,0.00,'fixed',1),(14,19,0,0.00,'fixed',1),(14,20,0,0.00,'fixed',1),(15,8,0,0.00,'fixed',1),(15,13,0,0.00,'fixed',1),(15,14,0,0.00,'fixed',1),(15,17,0,0.00,'fixed',1),(15,20,0,0.00,'fixed',1),(16,2,0,0.00,'fixed',1),(16,4,0,0.00,'fixed',1),(16,7,0,0.00,'fixed',1),(16,10,0,0.00,'fixed',1),(16,15,0,0.00,'fixed',1),(16,18,0,0.00,'fixed',1),(16,20,0,0.00,'fixed',1),(17,1,0,0.00,'fixed',1),(17,2,0,0.00,'fixed',1),(17,7,0,0.00,'fixed',1),(17,8,0,0.00,'fixed',1),(17,10,0,0.00,'fixed',1),(17,11,0,0.00,'fixed',1),(17,15,0,0.00,'fixed',1),(18,4,0,0.00,'fixed',1),(18,5,0,0.00,'fixed',1),(18,10,0,0.00,'fixed',1),(18,15,0,0.00,'fixed',1),(18,16,0,0.00,'fixed',1),(18,17,0,0.00,'fixed',1),(18,20,0,0.00,'fixed',1),(19,1,0,0.00,'fixed',1),(19,3,0,0.00,'fixed',1),(19,7,0,0.00,'fixed',1),(19,8,0,0.00,'fixed',1),(19,16,0,0.00,'fixed',1),(19,20,0,0.00,'fixed',1),(20,1,0,0.00,'fixed',1),(20,3,0,0.00,'fixed',1),(20,4,0,0.00,'fixed',1),(20,11,0,0.00,'fixed',1),(20,12,0,0.00,'fixed',1),(20,16,0,0.00,'fixed',1),(21,3,0,0.00,'fixed',1),(21,4,0,0.00,'fixed',1),(21,6,0,0.00,'fixed',1),(21,11,0,0.00,'fixed',1),(21,14,0,0.00,'fixed',1),(21,19,0,0.00,'fixed',1),(22,6,0,0.00,'fixed',1),(22,7,0,0.00,'fixed',1),(22,16,0,0.00,'fixed',1),(22,17,0,0.00,'fixed',1),(22,18,0,0.00,'fixed',1),(23,4,0,0.00,'fixed',1),(23,9,0,0.00,'fixed',1),(23,11,0,0.00,'fixed',1),(23,12,0,0.00,'fixed',1),(23,18,0,0.00,'fixed',1),(24,3,0,0.00,'fixed',1),(24,5,0,0.00,'fixed',1),(24,11,0,0.00,'fixed',1),(24,12,0,0.00,'fixed',1),(24,19,0,0.00,'fixed',1),(25,2,0,0.00,'fixed',1),(25,4,0,0.00,'fixed',1),(25,8,0,0.00,'fixed',1),(25,9,0,0.00,'fixed',1),(25,14,0,0.00,'fixed',1),(25,19,0,0.00,'fixed',1),(26,4,0,0.00,'fixed',1),(26,6,0,0.00,'fixed',1),(26,8,0,0.00,'fixed',1),(26,12,0,0.00,'fixed',1),(26,14,0,0.00,'fixed',1),(26,17,0,0.00,'fixed',1),(26,18,0,0.00,'fixed',1),(27,3,0,0.00,'fixed',1),(27,10,0,0.00,'fixed',1),(27,13,0,0.00,'fixed',1),(27,18,0,0.00,'fixed',1),(28,5,0,0.00,'fixed',1),(28,7,0,0.00,'fixed',1),(28,8,0,0.00,'fixed',1),(28,9,0,0.00,'fixed',1),(28,14,0,0.00,'fixed',1),(28,16,0,0.00,'fixed',1),(28,19,0,0.00,'fixed',1),(29,3,0,0.00,'fixed',1),(29,4,0,0.00,'fixed',1),(29,6,0,0.00,'fixed',1),(29,11,0,0.00,'fixed',1),(29,19,0,0.00,'fixed',1),(30,1,0,0.00,'fixed',1),(30,2,0,0.00,'fixed',1),(30,9,0,0.00,'fixed',1),(30,12,0,0.00,'fixed',1),(30,14,0,0.00,'fixed',1),(30,17,0,0.00,'fixed',1),(31,10,0,0.00,'fixed',1),(31,11,0,0.00,'fixed',1),(31,12,0,0.00,'fixed',1),(31,13,0,0.00,'fixed',1),(31,15,0,0.00,'fixed',1),(31,17,0,0.00,'fixed',1),(31,18,0,0.00,'fixed',1),(32,1,0,0.00,'fixed',1),(32,9,0,0.00,'fixed',1),(32,12,0,0.00,'fixed',1),(32,14,0,0.00,'fixed',1),(32,15,0,0.00,'fixed',1),(32,19,0,0.00,'fixed',1),(33,5,0,0.00,'fixed',1),(33,11,0,0.00,'fixed',1),(33,12,0,0.00,'fixed',1),(33,19,0,0.00,'fixed',1),(34,2,0,0.00,'fixed',1),(34,4,0,0.00,'fixed',1),(34,5,0,0.00,'fixed',1),(34,6,0,0.00,'fixed',1),(34,11,0,0.00,'fixed',1),(34,14,0,0.00,'fixed',1),(34,16,0,0.00,'fixed',1),(35,2,0,0.00,'fixed',1),(35,3,0,0.00,'fixed',1),(35,4,0,0.00,'fixed',1),(35,6,0,0.00,'fixed',1),(35,8,0,0.00,'fixed',1),(35,9,0,0.00,'fixed',1),(35,18,0,0.00,'fixed',1),(36,2,0,0.00,'fixed',1),(36,5,0,0.00,'fixed',1),(36,6,0,0.00,'fixed',1),(36,7,0,0.00,'fixed',1),(36,10,0,0.00,'fixed',1),(36,15,0,0.00,'fixed',1),(37,7,0,0.00,'fixed',1),(37,12,0,0.00,'fixed',1),(37,14,0,0.00,'fixed',1),(37,15,0,0.00,'fixed',1),(37,16,0,0.00,'fixed',1),(37,17,0,0.00,'fixed',1),(38,2,0,0.00,'fixed',1),(38,5,0,0.00,'fixed',1),(38,9,0,0.00,'fixed',1),(38,16,0,0.00,'fixed',1),(38,17,0,0.00,'fixed',1),(39,1,0,0.00,'fixed',1),(39,12,0,0.00,'fixed',1),(39,13,0,0.00,'fixed',1),(39,15,0,0.00,'fixed',1),(39,16,0,0.00,'fixed',1),(40,3,0,0.00,'fixed',1),(40,7,0,0.00,'fixed',1),(40,8,0,0.00,'fixed',1),(40,11,0,0.00,'fixed',1),(40,15,0,0.00,'fixed',1),(40,17,0,0.00,'fixed',1),(41,2,0,0.00,'fixed',1),(41,6,0,0.00,'fixed',1),(41,14,0,0.00,'fixed',1),(41,15,0,0.00,'fixed',1),(41,17,0,0.00,'fixed',1),(41,18,0,0.00,'fixed',1),(42,1,0,0.00,'fixed',1),(42,2,0,0.00,'fixed',1),(42,4,0,0.00,'fixed',1),(42,11,0,0.00,'fixed',1),(42,12,0,0.00,'fixed',1),(42,17,0,0.00,'fixed',1),(43,1,0,0.00,'fixed',1),(43,5,0,0.00,'fixed',1),(43,9,0,0.00,'fixed',1),(43,10,0,0.00,'fixed',1),(43,12,0,0.00,'fixed',1),(43,13,0,0.00,'fixed',1),(43,18,0,0.00,'fixed',1);
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_files`
--

DROP TABLE IF EXISTS `ec_product_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extras` mediumtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_files_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_files`
--

LOCK TABLES `ec_product_files` WRITE;
/*!40000 ALTER TABLE `ec_product_files` DISABLE KEYS */;
INSERT INTO `ec_product_files` VALUES (1,51,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(2,51,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(3,51,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(4,59,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(5,59,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(6,59,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(7,59,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(8,59,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(9,59,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(10,60,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(11,60,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(12,60,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(13,60,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(14,60,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(15,60,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(16,71,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(17,71,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(18,71,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(19,72,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(20,72,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(21,72,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:48\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:48','2024-03-05 00:56:48'),(22,80,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(23,80,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(24,80,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(25,80,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(26,80,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(27,80,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(28,87,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(29,87,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(30,87,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(31,88,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(32,88,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(33,88,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(34,96,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(35,96,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(36,96,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(37,96,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(38,96,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(39,96,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(40,97,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(41,97,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(42,97,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(43,97,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(44,97,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(45,97,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(46,105,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(47,105,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(48,105,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(49,105,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(50,105,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(51,105,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(52,105,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(53,105,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(54,106,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(55,106,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(56,106,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(57,106,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(58,106,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(59,106,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(60,106,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(61,106,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(62,107,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(63,107,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(64,107,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(65,107,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(66,107,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(67,107,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(68,107,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(69,107,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(70,108,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(71,108,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(72,108,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(73,108,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(74,108,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(75,108,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(76,108,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(77,108,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:49\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:49','2024-03-05 00:56:49'),(78,115,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(79,115,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(80,115,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(81,115,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(82,115,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(83,115,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(84,115,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(85,116,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(86,116,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(87,116,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(88,116,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(89,116,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(90,116,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(91,116,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(92,117,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(93,117,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(94,117,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(95,117,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(96,117,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(97,117,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(98,117,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(99,127,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(100,127,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(101,127,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(102,128,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(103,128,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(104,128,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(105,129,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(106,129,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(107,129,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(108,135,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(109,135,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(110,135,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50'),(111,135,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:50\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:50','2024-03-05 00:56:50');
/*!40000 ALTER TABLE `ec_product_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_label_products`
--

DROP TABLE IF EXISTS `ec_product_label_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_label_products` (
  `product_label_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_label_id`,`product_id`),
  KEY `ec_product_label_products_product_label_id_index` (`product_label_id`),
  KEY `ec_product_label_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_label_products`
--

LOCK TABLES `ec_product_label_products` WRITE;
/*!40000 ALTER TABLE `ec_product_label_products` DISABLE KEYS */;
INSERT INTO `ec_product_label_products` VALUES (1,12),(1,15),(1,18),(1,24),(1,27),(2,3),(2,9),(2,30),(2,33),(2,36),(2,39),(2,42),(3,6),(3,21);
/*!40000 ALTER TABLE `ec_product_label_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels`
--

DROP TABLE IF EXISTS `ec_product_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels`
--

LOCK TABLES `ec_product_labels` WRITE;
/*!40000 ALTER TABLE `ec_product_labels` DISABLE KEYS */;
INSERT INTO `ec_product_labels` VALUES (1,'Hot','#cb4321','published','2024-03-05 00:56:38','2024-03-05 00:56:38'),(2,'New','#00c9a7','published','2024-03-05 00:56:38','2024-03-05 00:56:38'),(3,'Sale','#ba591d','published','2024-03-05 00:56:38','2024-03-05 00:56:38');
/*!40000 ALTER TABLE `ec_product_labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels_translations`
--

DROP TABLE IF EXISTS `ec_product_labels_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_labels_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_labels_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels_translations`
--

LOCK TABLES `ec_product_labels_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_labels_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_labels_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_related_relations`
--

DROP TABLE IF EXISTS `ec_product_related_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_related_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_related_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_related_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_related_relations`
--

LOCK TABLES `ec_product_related_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_related_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_related_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tag_product`
--

DROP TABLE IF EXISTS `ec_product_tag_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tag_product` (
  `product_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tag_id`),
  KEY `ec_product_tag_product_product_id_index` (`product_id`),
  KEY `ec_product_tag_product_tag_id_index` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tag_product`
--

LOCK TABLES `ec_product_tag_product` WRITE;
/*!40000 ALTER TABLE `ec_product_tag_product` DISABLE KEYS */;
INSERT INTO `ec_product_tag_product` VALUES (1,1),(1,2),(1,3),(2,3),(2,5),(2,6),(3,1),(3,3),(3,4),(4,3),(4,5),(4,6),(5,3),(5,4),(5,6),(6,4),(6,5),(6,6),(7,1),(7,3),(7,5),(8,2),(8,5),(8,6),(9,1),(9,4),(9,5),(10,1),(10,4),(10,6),(11,1),(11,2),(11,4),(12,1),(12,4),(12,6),(13,3),(13,5),(13,6),(14,1),(14,2),(14,6),(15,1),(15,3),(15,5),(16,1),(16,2),(16,3),(17,1),(17,2),(17,5),(18,4),(18,5),(18,6),(19,4),(19,5),(19,6),(20,1),(20,2),(20,3),(21,3),(21,4),(21,6),(22,2),(22,4),(22,6),(23,3),(23,4),(23,5),(24,2),(24,3),(24,4),(25,2),(25,3),(25,5),(26,1),(26,2),(26,6),(27,1),(27,2),(27,6),(28,2),(28,5),(28,6),(29,1),(29,2),(29,6),(30,3),(30,4),(30,6),(31,2),(31,4),(31,5),(32,1),(32,2),(32,6),(33,1),(33,2),(33,3),(34,1),(34,3),(34,4),(35,1),(35,3),(35,4),(36,3),(36,4),(36,6),(37,2),(37,3),(37,5),(38,1),(38,3),(38,6),(39,1),(39,3),(39,4),(40,2),(40,3),(40,4),(41,1),(41,2),(41,6),(42,2),(42,4),(42,6),(43,2),(43,3),(43,4);
/*!40000 ALTER TABLE `ec_product_tag_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags`
--

DROP TABLE IF EXISTS `ec_product_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags`
--

LOCK TABLES `ec_product_tags` WRITE;
/*!40000 ALTER TABLE `ec_product_tags` DISABLE KEYS */;
INSERT INTO `ec_product_tags` VALUES (1,'Electronic',NULL,'published','2024-03-05 00:56:41','2024-03-05 00:56:41'),(2,'Mobile',NULL,'published','2024-03-05 00:56:41','2024-03-05 00:56:41'),(3,'Iphone',NULL,'published','2024-03-05 00:56:41','2024-03-05 00:56:41'),(4,'Printer',NULL,'published','2024-03-05 00:56:41','2024-03-05 00:56:41'),(5,'Office',NULL,'published','2024-03-05 00:56:41','2024-03-05 00:56:41'),(6,'IT',NULL,'published','2024-03-05 00:56:41','2024-03-05 00:56:41');
/*!40000 ALTER TABLE `ec_product_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags_translations`
--

DROP TABLE IF EXISTS `ec_product_tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_tags_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags_translations`
--

LOCK TABLES `ec_product_tags_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_up_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_up_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_up_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_up_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_up_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_up_sale_relations`
--

LOCK TABLES `ec_product_up_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variation_items`
--

DROP TABLE IF EXISTS `ec_product_variation_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variation_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_variation_index` (`attribute_id`,`variation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=203 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variation_items`
--

LOCK TABLES `ec_product_variation_items` WRITE;
/*!40000 ALTER TABLE `ec_product_variation_items` DISABLE KEYS */;
INSERT INTO `ec_product_variation_items` VALUES (5,1,3),(43,1,22),(45,1,23),(59,1,30),(65,1,33),(95,1,48),(11,2,6),(13,2,7),(17,2,9),(19,2,10),(25,2,13),(37,2,19),(39,2,20),(55,2,28),(61,2,31),(67,2,34),(71,2,36),(73,2,37),(99,2,50),(21,3,11),(27,3,14),(49,3,25),(63,3,32),(81,3,41),(83,3,42),(91,3,46),(3,4,2),(9,4,5),(15,4,8),(29,4,15),(41,4,21),(51,4,26),(57,4,29),(75,4,38),(77,4,39),(89,4,45),(101,4,51),(1,5,1),(7,5,4),(23,5,12),(31,5,16),(33,5,17),(35,5,18),(47,5,24),(53,5,27),(69,5,35),(79,5,40),(85,5,43),(87,5,44),(93,5,47),(97,5,49),(103,5,52),(18,6,9),(20,6,10),(24,6,12),(46,6,23),(66,6,33),(72,6,36),(80,6,40),(94,6,47),(100,6,50),(104,6,52),(28,7,14),(32,7,16),(34,7,17),(36,7,18),(50,7,25),(56,7,28),(60,7,30),(74,7,37),(96,7,48),(14,8,7),(16,8,8),(22,8,11),(40,8,20),(42,8,21),(44,8,22),(48,8,24),(58,8,29),(92,8,46),(4,9,2),(10,9,5),(12,9,6),(26,9,13),(64,9,32),(78,9,39),(86,9,43),(88,9,44),(90,9,45),(98,9,49),(2,10,1),(6,10,3),(8,10,4),(30,10,15),(38,10,19),(52,10,26),(54,10,27),(62,10,31),(68,10,34),(70,10,35),(76,10,38),(82,10,41),(84,10,42),(102,10,51),(109,11,55),(111,11,56),(129,11,65),(131,11,66),(141,11,71),(153,11,77),(161,11,81),(171,11,86),(175,11,88),(177,11,89),(179,11,90),(183,11,92),(197,11,99),(199,11,100),(105,12,53),(107,12,54),(119,12,60),(127,12,64),(139,12,70),(145,12,73),(157,12,79),(167,12,84),(181,12,91),(121,13,61),(123,13,62),(143,13,72),(147,13,74),(163,13,82),(169,13,85),(173,13,87),(185,13,93),(187,13,94),(189,13,95),(193,13,97),(201,13,101),(117,14,59),(125,14,63),(133,14,67),(135,14,68),(137,14,69),(155,14,78),(159,14,80),(191,14,96),(195,14,98),(113,15,57),(115,15,58),(149,15,75),(151,15,76),(165,15,83),(120,16,60),(122,16,61),(130,16,65),(144,16,72),(152,16,76),(154,16,77),(170,16,85),(188,16,94),(192,16,96),(106,17,53),(116,17,58),(142,17,71),(158,17,79),(178,17,89),(184,17,92),(190,17,95),(196,17,98),(198,17,99),(128,18,64),(138,18,69),(140,18,70),(146,18,73),(150,18,75),(164,18,82),(180,18,90),(200,18,100),(108,19,54),(110,19,55),(118,19,59),(132,19,66),(134,19,67),(136,19,68),(156,19,78),(162,19,81),(168,19,84),(176,19,88),(182,19,91),(194,19,97),(202,19,101),(112,20,56),(114,20,57),(124,20,62),(126,20,63),(148,20,74),(160,20,80),(166,20,83),(172,20,86),(174,20,87),(186,20,93);
/*!40000 ALTER TABLE `ec_product_variation_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variations`
--

DROP TABLE IF EXISTS `ec_product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `configurable_product_id` bigint unsigned NOT NULL,
  `is_default` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_variations_product_id_configurable_product_id_unique` (`product_id`,`configurable_product_id`),
  KEY `configurable_product_index` (`product_id`,`configurable_product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variations`
--

LOCK TABLES `ec_product_variations` WRITE;
/*!40000 ALTER TABLE `ec_product_variations` DISABLE KEYS */;
INSERT INTO `ec_product_variations` VALUES (1,44,1,1),(2,45,1,0),(3,46,1,0),(4,47,2,1),(5,48,3,1),(6,49,3,0),(7,50,3,0),(8,51,4,1),(9,52,5,1),(10,53,5,0),(11,54,6,1),(12,55,6,0),(13,56,6,0),(14,57,6,0),(15,58,7,1),(16,59,8,1),(17,60,8,0),(18,61,9,1),(19,62,9,0),(20,63,10,1),(21,64,10,0),(22,65,10,0),(23,66,10,0),(24,67,10,0),(25,68,11,1),(26,69,11,0),(27,70,11,0),(28,71,12,1),(29,72,12,0),(30,73,13,1),(31,74,14,1),(32,75,14,0),(33,76,14,0),(34,77,14,0),(35,78,14,0),(36,79,15,1),(37,80,16,1),(38,81,17,1),(39,82,17,0),(40,83,18,1),(41,84,19,1),(42,85,19,0),(43,86,19,0),(44,87,20,1),(45,88,20,0),(46,89,21,1),(47,90,21,0),(48,91,22,1),(49,92,22,0),(50,93,22,0),(51,94,22,0),(52,95,23,1),(53,96,24,1),(54,97,24,0),(55,98,25,1),(56,99,25,0),(57,100,25,0),(58,101,26,1),(59,102,26,0),(60,103,27,1),(61,104,27,0),(62,105,28,1),(63,106,28,0),(64,107,28,0),(65,108,28,0),(66,109,29,1),(67,110,29,0),(68,111,30,1),(69,112,30,0),(70,113,31,1),(71,114,31,0),(72,115,32,1),(73,116,32,0),(74,117,32,0),(75,118,33,1),(76,119,33,0),(77,120,33,0),(78,121,34,1),(79,122,34,0),(80,123,34,0),(81,124,35,1),(82,125,35,0),(83,126,35,0),(84,127,36,1),(85,128,36,0),(86,129,36,0),(87,130,37,1),(88,131,37,0),(89,132,38,1),(90,133,38,0),(91,134,39,1),(92,135,40,1),(93,136,41,1),(94,137,41,0),(95,138,42,1),(96,139,42,0),(97,140,42,0),(98,141,42,0),(99,142,43,1),(100,143,43,0),(101,144,43,0);
/*!40000 ALTER TABLE `ec_product_variations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_views`
--

DROP TABLE IF EXISTS `ec_product_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `views` int NOT NULL DEFAULT '1',
  `date` date NOT NULL DEFAULT '2024-03-05',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_views_product_id_date_unique` (`product_id`,`date`),
  KEY `ec_product_views_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_views`
--

LOCK TABLES `ec_product_views` WRITE;
/*!40000 ALTER TABLE `ec_product_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_with_attribute_set`
--

DROP TABLE IF EXISTS `ec_product_with_attribute_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_with_attribute_set` (
  `attribute_set_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`attribute_set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_with_attribute_set`
--

LOCK TABLES `ec_product_with_attribute_set` WRITE;
/*!40000 ALTER TABLE `ec_product_with_attribute_set` DISABLE KEYS */;
INSERT INTO `ec_product_with_attribute_set` VALUES (1,1,0),(2,1,0),(1,2,0),(2,2,0),(1,3,0),(2,3,0),(1,4,0),(2,4,0),(1,5,0),(2,5,0),(1,6,0),(2,6,0),(1,7,0),(2,7,0),(1,8,0),(2,8,0),(1,9,0),(2,9,0),(1,10,0),(2,10,0),(1,11,0),(2,11,0),(1,12,0),(2,12,0),(1,13,0),(2,13,0),(1,14,0),(2,14,0),(1,15,0),(2,15,0),(1,16,0),(2,16,0),(1,17,0),(2,17,0),(1,18,0),(2,18,0),(1,19,0),(2,19,0),(1,20,0),(2,20,0),(1,21,0),(2,21,0),(1,22,0),(2,22,0),(1,23,0),(2,23,0),(3,24,0),(4,24,0),(3,25,0),(4,25,0),(3,26,0),(4,26,0),(3,27,0),(4,27,0),(3,28,0),(4,28,0),(3,29,0),(4,29,0),(3,30,0),(4,30,0),(3,31,0),(4,31,0),(3,32,0),(4,32,0),(3,33,0),(4,33,0),(3,34,0),(4,34,0),(3,35,0),(4,35,0),(3,36,0),(4,36,0),(3,37,0),(4,37,0),(3,38,0),(4,38,0),(3,39,0),(4,39,0),(3,40,0),(4,40,0),(3,41,0),(4,41,0),(3,42,0),(4,42,0),(3,43,0),(4,43,0);
/*!40000 ALTER TABLE `ec_product_with_attribute_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products`
--

DROP TABLE IF EXISTS `ec_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `images` text COLLATE utf8mb4_unicode_ci,
  `sku` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `quantity` int unsigned DEFAULT NULL,
  `allow_checkout_when_out_of_stock` tinyint unsigned NOT NULL DEFAULT '0',
  `with_storehouse_management` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `brand_id` bigint unsigned DEFAULT NULL,
  `is_variation` tinyint NOT NULL DEFAULT '0',
  `sale_type` tinyint NOT NULL DEFAULT '0',
  `price` double unsigned DEFAULT NULL,
  `sale_price` double unsigned DEFAULT NULL,
  `start_date` timestamp NULL DEFAULT NULL,
  `end_date` timestamp NULL DEFAULT NULL,
  `length` double(8,2) DEFAULT NULL,
  `wide` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `weight` double(8,2) DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `views` bigint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `stock_status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'in_stock',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_by_id` bigint unsigned DEFAULT '0',
  `created_by_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `approved_by` bigint unsigned DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'physical',
  `barcode` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost_per_item` double DEFAULT NULL,
  `generate_license_code` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ec_products_brand_id_status_is_variation_created_at_index` (`brand_id`,`status`,`is_variation`,`created_at`),
  KEY `sale_type_index` (`sale_type`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `sale_price_index` (`sale_price`),
  KEY `is_variation_index` (`is_variation`),
  KEY `ec_products_sku_index` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products`
--

LOCK TABLES `ec_products` WRITE;
/*!40000 ALTER TABLE `ec_products` DISABLE KEYS */;
INSERT INTO `ec_products` VALUES (1,'Vintage Denim Jacket','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-2.png\"]','6C-105-A0',0,19,0,1,1,4,0,0,2259,NULL,NULL,NULL,19.00,12.00,19.00,702.00,NULL,146170,'2024-03-05 00:56:46','2024-03-05 00:56:47','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(2,'Floral Maxi Dress','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-8.png\"]','FG-115-A0',0,20,0,1,1,3,0,0,375,NULL,NULL,NULL,12.00,18.00,20.00,597.00,NULL,38575,'2024-03-05 00:56:46','2024-03-05 00:56:47','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(3,'Leather Ankle Boots','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-4.png\"]','8S-117-A0',0,11,0,1,1,3,0,0,2359,NULL,NULL,NULL,19.00,11.00,17.00,798.00,NULL,44504,'2024-03-05 00:56:46','2024-03-05 00:56:48','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(4,'Knit Turtleneck Sweater (Digital)','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-2.png\"]','NM-123-A0',0,17,0,1,0,1,0,0,1614,1194.36,NULL,NULL,13.00,18.00,14.00,879.00,NULL,122544,'2024-03-05 00:56:46','2024-03-05 00:56:48','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(5,'Classic Aviator Sunglasses','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-8.png\"]','1H-104-A0',0,18,0,1,0,5,0,0,2420,NULL,NULL,NULL,15.00,11.00,11.00,630.00,NULL,128274,'2024-03-05 00:56:46','2024-03-05 00:56:48','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(6,'Tailored Wool Blazer','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-2.png\"]','HO-130-A0',0,11,0,1,1,3,0,0,2193,NULL,NULL,NULL,10.00,13.00,10.00,707.00,NULL,151490,'2024-03-05 00:56:46','2024-03-05 00:56:48','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(7,'Bohemian Fringe Handbag','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-8.png\"]','W3-102-A0',0,20,0,1,0,2,0,0,950,NULL,NULL,NULL,19.00,17.00,16.00,763.00,NULL,138536,'2024-03-05 00:56:46','2024-03-05 00:56:48','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(8,'Silk Scarf with Geometric Print (Digital)','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-1.png\"]','HV-138-A0',0,10,0,1,1,1,0,0,1471,1220.93,NULL,NULL,19.00,17.00,11.00,581.00,NULL,5964,'2024-03-05 00:56:46','2024-03-05 00:56:48','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(9,'High-Waisted Wide Leg Trousers','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-4.png\"]','HI-168-A0',0,15,0,1,0,5,0,0,830,NULL,NULL,NULL,16.00,15.00,11.00,656.00,NULL,167590,'2024-03-05 00:56:46','2024-03-05 00:56:48','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(10,'Embroidered Boho Blouse','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-8.png\"]','XL-132-A0',0,18,0,1,1,2,0,0,880,NULL,NULL,NULL,20.00,15.00,11.00,769.00,NULL,167139,'2024-03-05 00:56:46','2024-03-05 00:56:48','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(11,'Statement Chunky Necklace','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-5.png\"]','YC-187-A0',0,20,0,1,1,3,0,0,2364,NULL,NULL,NULL,10.00,11.00,11.00,776.00,NULL,176878,'2024-03-05 00:56:46','2024-03-05 00:56:48','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(12,'Chic Fedora Hat (Digital)','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-6.png\"]','JH-172-A0',0,19,0,1,0,4,0,0,359,294.38,NULL,NULL,15.00,18.00,19.00,877.00,NULL,5833,'2024-03-05 00:56:46','2024-03-05 00:56:48','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(13,'Strappy Block Heel Sandals','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-5.png\"]','LX-136-A0',0,19,0,1,0,4,0,0,983,NULL,NULL,NULL,18.00,14.00,10.00,870.00,NULL,145889,'2024-03-05 00:56:46','2024-03-05 00:56:48','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(14,'Velvet Evening Gown','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-1.png\"]','MT-175-A0',0,13,0,1,0,5,0,0,2341,NULL,NULL,NULL,13.00,15.00,11.00,506.00,NULL,10118,'2024-03-05 00:56:46','2024-03-05 00:56:48','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(15,'Quilted Crossbody Bag','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-7.png\"]','LY-196-A0',0,11,0,1,0,2,0,0,1936,NULL,NULL,NULL,10.00,10.00,12.00,598.00,NULL,143873,'2024-03-05 00:56:46','2024-03-05 00:56:49','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(16,'Distressed Skinny Jeans (Digital)','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-2.png\"]','3D-180-A0',0,16,0,1,1,4,0,0,559,480.74,NULL,NULL,19.00,14.00,10.00,853.00,NULL,174188,'2024-03-05 00:56:46','2024-03-05 00:56:49','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(17,'Lace-Up Combat Boots','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-3.png\"]','WL-196-A0',0,18,0,1,1,3,0,0,1558,NULL,NULL,NULL,13.00,12.00,18.00,856.00,NULL,159581,'2024-03-05 00:56:46','2024-03-05 00:56:49','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(18,'Cotton Striped T-Shirt Dress','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-4.png\"]','OY-127-A0',0,16,0,1,0,5,0,0,889,NULL,NULL,NULL,10.00,15.00,19.00,652.00,NULL,56357,'2024-03-05 00:56:46','2024-03-05 00:56:49','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(19,'Printed Palazzo Pants','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-3.png\"]','HG-162-A0',0,15,0,1,1,5,0,0,904,NULL,NULL,NULL,15.00,14.00,16.00,659.00,NULL,142366,'2024-03-05 00:56:46','2024-03-05 00:56:49','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(20,'Structured Satchel Bag (Digital)','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-4.png\"]','83-105-A0',0,13,0,1,1,1,0,0,2429,2113.23,NULL,NULL,17.00,18.00,20.00,824.00,NULL,144676,'2024-03-05 00:56:46','2024-03-05 00:56:49','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(21,'Off-Shoulder Ruffle Top','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-2.png\"]','BY-107-A0',0,10,0,1,1,5,0,0,988,NULL,NULL,NULL,16.00,19.00,15.00,876.00,NULL,127336,'2024-03-05 00:56:46','2024-03-05 00:56:49','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(22,'Suede Pointed-Toe Pumps','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-8.png\"]','DZ-109-A0',0,13,0,1,1,5,0,0,323,NULL,NULL,NULL,20.00,19.00,19.00,759.00,NULL,106392,'2024-03-05 00:56:46','2024-03-05 00:56:49','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(23,'Cropped Cable Knit Sweater','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-5.png\"]','UO-147-A0',0,17,0,1,0,2,0,0,2066,NULL,NULL,NULL,12.00,11.00,19.00,887.00,NULL,82065,'2024-03-05 00:56:47','2024-03-05 00:56:49','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(24,'Athleisure Jogger Pants (Digital)','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-1.png\"]','NK-152-A0',0,20,0,1,0,3,0,0,325,292.5,NULL,NULL,17.00,12.00,18.00,643.00,NULL,187881,'2024-03-05 00:56:47','2024-03-05 00:56:49','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(25,'Leopard Print Midi Skirt','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-1.png\"]','HU-159-A0',0,10,0,1,0,5,0,0,1696,NULL,NULL,NULL,18.00,15.00,15.00,794.00,NULL,138188,'2024-03-05 00:56:47','2024-03-05 00:56:49','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(26,'Retro Cat-Eye Sunglasses','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-7.png\"]','LH-198-A0',0,10,0,1,1,2,0,0,1542,NULL,NULL,NULL,17.00,14.00,14.00,588.00,NULL,41913,'2024-03-05 00:56:47','2024-03-05 00:56:49','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(27,'Faux Fur Trimmed Coat','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-4.png\"]','GD-157-A0',0,14,0,1,1,5,0,0,1274,NULL,NULL,NULL,10.00,18.00,20.00,877.00,NULL,107135,'2024-03-05 00:56:47','2024-03-05 00:56:49','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(28,'Boho Fringed Kimono (Digital)','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-1.png\"]','EE-179-A0',0,15,0,1,0,5,0,0,610,469.7,NULL,NULL,17.00,18.00,14.00,643.00,NULL,22182,'2024-03-05 00:56:47','2024-03-05 00:56:49','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(29,'Ruffled Wrap Dress','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-3.png\"]','9T-114-A0',0,10,0,1,0,5,0,0,2446,NULL,NULL,NULL,13.00,17.00,10.00,899.00,NULL,58815,'2024-03-05 00:56:47','2024-03-05 00:56:50','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(30,'Beaded Evening Clutch','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-5.png\"]','KI-116-A0',0,12,0,1,1,1,0,0,1236,NULL,NULL,NULL,18.00,15.00,13.00,543.00,NULL,58949,'2024-03-05 00:56:47','2024-03-05 00:56:50','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(31,'Wide Brim Floppy Hat','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-7.png\"]','YO-104-A0',0,12,0,1,1,3,0,0,2162,NULL,NULL,NULL,17.00,12.00,14.00,672.00,NULL,135976,'2024-03-05 00:56:47','2024-03-05 00:56:50','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(32,'Denim Overall Jumpsuit (Digital)','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-3.png\"]','MH-188-A0',0,12,0,1,0,5,0,0,1580,1106,NULL,NULL,12.00,19.00,12.00,571.00,NULL,178369,'2024-03-05 00:56:47','2024-03-05 00:56:50','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(33,'Embellished Ballet Flats','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-7.png\"]','DN-124-A0',0,10,0,1,1,5,0,0,1927,NULL,NULL,NULL,18.00,19.00,12.00,781.00,NULL,41630,'2024-03-05 00:56:47','2024-03-05 00:56:50','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(34,'Pleated Midi Skirt','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-1.png\"]','SS-142-A0',0,12,0,1,1,4,0,0,1086,NULL,NULL,NULL,13.00,12.00,17.00,631.00,NULL,14043,'2024-03-05 00:56:47','2024-03-05 00:56:50','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(35,'Velour Tracksuit Set','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-1.png\"]','YV-124-A0',0,19,0,1,1,5,0,0,1047,NULL,NULL,NULL,11.00,18.00,12.00,833.00,NULL,12224,'2024-03-05 00:56:47','2024-03-05 00:56:50','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(36,'Geometric Patterned Cardigan (Digital)','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-2.png\"]','GR-168-A0',0,19,0,1,0,4,0,0,1531,1132.94,NULL,NULL,11.00,14.00,11.00,896.00,NULL,65750,'2024-03-05 00:56:47','2024-03-05 00:56:50','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(37,'Buckle Detail Ankle Booties','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-2.png\"]','HP-200-A0',0,10,0,1,1,1,0,0,1042,NULL,NULL,NULL,12.00,14.00,12.00,731.00,NULL,68014,'2024-03-05 00:56:47','2024-03-05 00:56:50','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(38,'Embroidered Bomber Jacket','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-6.png\"]','CS-143-A0',0,13,0,1,0,1,0,0,1876,NULL,NULL,NULL,19.00,12.00,18.00,684.00,NULL,95861,'2024-03-05 00:56:47','2024-03-05 00:56:50','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(39,'Cowl Neck Knit Poncho','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-4.png\"]','FY-154-A0',0,11,0,1,0,5,0,0,1870,NULL,NULL,NULL,11.00,13.00,10.00,847.00,NULL,97143,'2024-03-05 00:56:47','2024-03-05 00:56:50','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(40,'Chunky Knit Infinity Scarf (Digital)','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-7.png\"]','RX-111-A0',0,19,0,1,0,1,0,0,1142,833.66,NULL,NULL,11.00,20.00,20.00,669.00,NULL,146978,'2024-03-05 00:56:47','2024-03-05 00:56:50','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(41,'Retro High-Top Sneakers','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-5.png\"]','2U-150-A0',0,15,0,1,1,5,0,0,2243,NULL,NULL,NULL,14.00,11.00,17.00,706.00,NULL,152322,'2024-03-05 00:56:47','2024-03-05 00:56:51','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(42,'Faux Leather Leggings','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-3.png\"]','0X-110-A0',0,20,0,1,0,5,0,0,1928,NULL,NULL,NULL,12.00,18.00,17.00,582.00,NULL,142929,'2024-03-05 00:56:47','2024-03-05 00:56:51','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(43,'Metallic Pleated Maxi Skirt','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-6.png\"]','6E-102-A0',0,15,0,1,0,5,0,0,538,NULL,NULL,NULL,15.00,16.00,17.00,690.00,NULL,182709,'2024-03-05 00:56:47','2024-03-05 00:56:51','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(44,'Vintage Denim Jacket',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','6C-105-A0',0,19,0,1,0,4,1,0,2259,NULL,NULL,NULL,19.00,12.00,19.00,702.00,NULL,0,'2024-03-05 00:56:47','2024-03-05 00:56:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(45,'Vintage Denim Jacket',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','6C-105-A0-A1',0,19,0,1,0,4,1,0,2259,NULL,NULL,NULL,19.00,12.00,19.00,702.00,NULL,0,'2024-03-05 00:56:47','2024-03-05 00:56:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(46,'Vintage Denim Jacket',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','6C-105-A0-A2',0,19,0,1,0,4,1,0,2259,NULL,NULL,NULL,19.00,12.00,19.00,702.00,NULL,0,'2024-03-05 00:56:47','2024-03-05 00:56:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(47,'Floral Maxi Dress',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','FG-115-A0',0,20,0,1,0,3,1,0,375,NULL,NULL,NULL,12.00,18.00,20.00,597.00,NULL,0,'2024-03-05 00:56:47','2024-03-05 00:56:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(48,'Leather Ankle Boots',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','8S-117-A0',0,11,0,1,0,3,1,0,2359,NULL,NULL,NULL,19.00,11.00,17.00,798.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(49,'Leather Ankle Boots',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','8S-117-A0-A1',0,11,0,1,0,3,1,0,2359,NULL,NULL,NULL,19.00,11.00,17.00,798.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(50,'Leather Ankle Boots',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','8S-117-A0-A2',0,11,0,1,0,3,1,0,2359,NULL,NULL,NULL,19.00,11.00,17.00,798.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(51,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','NM-123-A0',0,17,0,1,0,1,1,0,1614,1194.36,NULL,NULL,13.00,18.00,14.00,879.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(52,'Classic Aviator Sunglasses',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','1H-104-A0',0,18,0,1,0,5,1,0,2420,NULL,NULL,NULL,15.00,11.00,11.00,630.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(53,'Classic Aviator Sunglasses',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','1H-104-A0-A1',0,18,0,1,0,5,1,0,2420,NULL,NULL,NULL,15.00,11.00,11.00,630.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(54,'Tailored Wool Blazer',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','HO-130-A0',0,11,0,1,0,3,1,0,2193,NULL,NULL,NULL,10.00,13.00,10.00,707.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(55,'Tailored Wool Blazer',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','HO-130-A0-A1',0,11,0,1,0,3,1,0,2193,NULL,NULL,NULL,10.00,13.00,10.00,707.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(56,'Tailored Wool Blazer',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','HO-130-A0-A2',0,11,0,1,0,3,1,0,2193,NULL,NULL,NULL,10.00,13.00,10.00,707.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(57,'Tailored Wool Blazer',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','HO-130-A0-A3',0,11,0,1,0,3,1,0,2193,NULL,NULL,NULL,10.00,13.00,10.00,707.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(58,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','W3-102-A0',0,20,0,1,0,2,1,0,950,NULL,NULL,NULL,19.00,17.00,16.00,763.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(59,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','HV-138-A0',0,10,0,1,0,1,1,0,1471,1220.93,NULL,NULL,19.00,17.00,11.00,581.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(60,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','HV-138-A0-A1',0,10,0,1,0,1,1,0,1471,1073.83,NULL,NULL,19.00,17.00,11.00,581.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(61,'High-Waisted Wide Leg Trousers',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','HI-168-A0',0,15,0,1,0,5,1,0,830,NULL,NULL,NULL,16.00,15.00,11.00,656.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(62,'High-Waisted Wide Leg Trousers',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','HI-168-A0-A1',0,15,0,1,0,5,1,0,830,NULL,NULL,NULL,16.00,15.00,11.00,656.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(63,'Embroidered Boho Blouse',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','XL-132-A0',0,18,0,1,0,2,1,0,880,NULL,NULL,NULL,20.00,15.00,11.00,769.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(64,'Embroidered Boho Blouse',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','XL-132-A0-A1',0,18,0,1,0,2,1,0,880,NULL,NULL,NULL,20.00,15.00,11.00,769.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(65,'Embroidered Boho Blouse',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','XL-132-A0-A2',0,18,0,1,0,2,1,0,880,NULL,NULL,NULL,20.00,15.00,11.00,769.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(66,'Embroidered Boho Blouse',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','XL-132-A0-A3',0,18,0,1,0,2,1,0,880,NULL,NULL,NULL,20.00,15.00,11.00,769.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(67,'Embroidered Boho Blouse',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','XL-132-A0-A4',0,18,0,1,0,2,1,0,880,NULL,NULL,NULL,20.00,15.00,11.00,769.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(68,'Statement Chunky Necklace',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','YC-187-A0',0,20,0,1,0,3,1,0,2364,NULL,NULL,NULL,10.00,11.00,11.00,776.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(69,'Statement Chunky Necklace',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','YC-187-A0-A1',0,20,0,1,0,3,1,0,2364,NULL,NULL,NULL,10.00,11.00,11.00,776.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(70,'Statement Chunky Necklace',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','YC-187-A0-A2',0,20,0,1,0,3,1,0,2364,NULL,NULL,NULL,10.00,11.00,11.00,776.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(71,'Chic Fedora Hat (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','JH-172-A0',0,19,0,1,0,4,1,0,359,294.38,NULL,NULL,15.00,18.00,19.00,877.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(72,'Chic Fedora Hat (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','JH-172-A0-A1',0,19,0,1,0,4,1,0,359,280.02,NULL,NULL,15.00,18.00,19.00,877.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(73,'Strappy Block Heel Sandals',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','LX-136-A0',0,19,0,1,0,4,1,0,983,NULL,NULL,NULL,18.00,14.00,10.00,870.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(74,'Velvet Evening Gown',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','MT-175-A0',0,13,0,1,0,5,1,0,2341,NULL,NULL,NULL,13.00,15.00,11.00,506.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(75,'Velvet Evening Gown',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','MT-175-A0-A1',0,13,0,1,0,5,1,0,2341,NULL,NULL,NULL,13.00,15.00,11.00,506.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(76,'Velvet Evening Gown',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','MT-175-A0-A2',0,13,0,1,0,5,1,0,2341,NULL,NULL,NULL,13.00,15.00,11.00,506.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(77,'Velvet Evening Gown',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','MT-175-A0-A3',0,13,0,1,0,5,1,0,2341,NULL,NULL,NULL,13.00,15.00,11.00,506.00,NULL,0,'2024-03-05 00:56:48','2024-03-05 00:56:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(78,'Velvet Evening Gown',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','MT-175-A0-A4',0,13,0,1,0,5,1,0,2341,NULL,NULL,NULL,13.00,15.00,11.00,506.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(79,'Quilted Crossbody Bag',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','LY-196-A0',0,11,0,1,0,2,1,0,1936,NULL,NULL,NULL,10.00,10.00,12.00,598.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(80,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','3D-180-A0',0,16,0,1,0,4,1,0,559,480.74,NULL,NULL,19.00,14.00,10.00,853.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(81,'Lace-Up Combat Boots',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','WL-196-A0',0,18,0,1,0,3,1,0,1558,NULL,NULL,NULL,13.00,12.00,18.00,856.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(82,'Lace-Up Combat Boots',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','WL-196-A0-A1',0,18,0,1,0,3,1,0,1558,NULL,NULL,NULL,13.00,12.00,18.00,856.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(83,'Cotton Striped T-Shirt Dress',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','OY-127-A0',0,16,0,1,0,5,1,0,889,NULL,NULL,NULL,10.00,15.00,19.00,652.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(84,'Printed Palazzo Pants',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','HG-162-A0',0,15,0,1,0,5,1,0,904,NULL,NULL,NULL,15.00,14.00,16.00,659.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(85,'Printed Palazzo Pants',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','HG-162-A0-A1',0,15,0,1,0,5,1,0,904,NULL,NULL,NULL,15.00,14.00,16.00,659.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(86,'Printed Palazzo Pants',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','HG-162-A0-A2',0,15,0,1,0,5,1,0,904,NULL,NULL,NULL,15.00,14.00,16.00,659.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(87,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','83-105-A0',0,13,0,1,0,1,1,0,2429,2113.23,NULL,NULL,17.00,18.00,20.00,824.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(88,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','83-105-A0-A1',0,13,0,1,0,1,1,0,2429,1991.78,NULL,NULL,17.00,18.00,20.00,824.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(89,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','BY-107-A0',0,10,0,1,0,5,1,0,988,NULL,NULL,NULL,16.00,19.00,15.00,876.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(90,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','BY-107-A0-A1',0,10,0,1,0,5,1,0,988,NULL,NULL,NULL,16.00,19.00,15.00,876.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(91,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','DZ-109-A0',0,13,0,1,0,5,1,0,323,NULL,NULL,NULL,20.00,19.00,19.00,759.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(92,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','DZ-109-A0-A1',0,13,0,1,0,5,1,0,323,NULL,NULL,NULL,20.00,19.00,19.00,759.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(93,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','DZ-109-A0-A2',0,13,0,1,0,5,1,0,323,NULL,NULL,NULL,20.00,19.00,19.00,759.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(94,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','DZ-109-A0-A3',0,13,0,1,0,5,1,0,323,NULL,NULL,NULL,20.00,19.00,19.00,759.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(95,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','UO-147-A0',0,17,0,1,0,2,1,0,2066,NULL,NULL,NULL,12.00,11.00,19.00,887.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(96,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','NK-152-A0',0,20,0,1,0,3,1,0,325,292.5,NULL,NULL,17.00,12.00,18.00,643.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(97,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','NK-152-A0-A1',0,20,0,1,0,3,1,0,325,279.5,NULL,NULL,17.00,12.00,18.00,643.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(98,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','HU-159-A0',0,10,0,1,0,5,1,0,1696,NULL,NULL,NULL,18.00,15.00,15.00,794.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(99,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','HU-159-A0-A1',0,10,0,1,0,5,1,0,1696,NULL,NULL,NULL,18.00,15.00,15.00,794.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(100,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','HU-159-A0-A2',0,10,0,1,0,5,1,0,1696,NULL,NULL,NULL,18.00,15.00,15.00,794.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(101,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','LH-198-A0',0,10,0,1,0,2,1,0,1542,NULL,NULL,NULL,17.00,14.00,14.00,588.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(102,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','LH-198-A0-A1',0,10,0,1,0,2,1,0,1542,NULL,NULL,NULL,17.00,14.00,14.00,588.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(103,'Faux Fur Trimmed Coat',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','GD-157-A0',0,14,0,1,0,5,1,0,1274,NULL,NULL,NULL,10.00,18.00,20.00,877.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(104,'Faux Fur Trimmed Coat',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','GD-157-A0-A1',0,14,0,1,0,5,1,0,1274,NULL,NULL,NULL,10.00,18.00,20.00,877.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(105,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','EE-179-A0',0,15,0,1,0,5,1,0,610,469.7,NULL,NULL,17.00,18.00,14.00,643.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(106,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','EE-179-A0-A1',0,15,0,1,0,5,1,0,610,500.2,NULL,NULL,17.00,18.00,14.00,643.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(107,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','EE-179-A0-A2',0,15,0,1,0,5,1,0,610,463.6,NULL,NULL,17.00,18.00,14.00,643.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(108,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','EE-179-A0-A3',0,15,0,1,0,5,1,0,610,475.8,NULL,NULL,17.00,18.00,14.00,643.00,NULL,0,'2024-03-05 00:56:49','2024-03-05 00:56:49','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(109,'Ruffled Wrap Dress',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','9T-114-A0',0,10,0,1,0,5,1,0,2446,NULL,NULL,NULL,13.00,17.00,10.00,899.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(110,'Ruffled Wrap Dress',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','9T-114-A0-A1',0,10,0,1,0,5,1,0,2446,NULL,NULL,NULL,13.00,17.00,10.00,899.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(111,'Beaded Evening Clutch',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','KI-116-A0',0,12,0,1,0,1,1,0,1236,NULL,NULL,NULL,18.00,15.00,13.00,543.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(112,'Beaded Evening Clutch',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','KI-116-A0-A1',0,12,0,1,0,1,1,0,1236,NULL,NULL,NULL,18.00,15.00,13.00,543.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(113,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','YO-104-A0',0,12,0,1,0,3,1,0,2162,NULL,NULL,NULL,17.00,12.00,14.00,672.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(114,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','YO-104-A0-A1',0,12,0,1,0,3,1,0,2162,NULL,NULL,NULL,17.00,12.00,14.00,672.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(115,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','MH-188-A0',0,12,0,1,0,5,1,0,1580,1106,NULL,NULL,12.00,19.00,12.00,571.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(116,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','MH-188-A0-A1',0,12,0,1,0,5,1,0,1580,1169.2,NULL,NULL,12.00,19.00,12.00,571.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(117,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','MH-188-A0-A2',0,12,0,1,0,5,1,0,1580,1406.2,NULL,NULL,12.00,19.00,12.00,571.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(118,'Embellished Ballet Flats',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','DN-124-A0',0,10,0,1,0,5,1,0,1927,NULL,NULL,NULL,18.00,19.00,12.00,781.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(119,'Embellished Ballet Flats',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','DN-124-A0-A1',0,10,0,1,0,5,1,0,1927,NULL,NULL,NULL,18.00,19.00,12.00,781.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(120,'Embellished Ballet Flats',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','DN-124-A0-A2',0,10,0,1,0,5,1,0,1927,NULL,NULL,NULL,18.00,19.00,12.00,781.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(121,'Pleated Midi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','SS-142-A0',0,12,0,1,0,4,1,0,1086,NULL,NULL,NULL,13.00,12.00,17.00,631.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(122,'Pleated Midi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','SS-142-A0-A1',0,12,0,1,0,4,1,0,1086,NULL,NULL,NULL,13.00,12.00,17.00,631.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(123,'Pleated Midi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','SS-142-A0-A2',0,12,0,1,0,4,1,0,1086,NULL,NULL,NULL,13.00,12.00,17.00,631.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(124,'Velour Tracksuit Set',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','YV-124-A0',0,19,0,1,0,5,1,0,1047,NULL,NULL,NULL,11.00,18.00,12.00,833.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(125,'Velour Tracksuit Set',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','YV-124-A0-A1',0,19,0,1,0,5,1,0,1047,NULL,NULL,NULL,11.00,18.00,12.00,833.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(126,'Velour Tracksuit Set',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','YV-124-A0-A2',0,19,0,1,0,5,1,0,1047,NULL,NULL,NULL,11.00,18.00,12.00,833.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(127,'Geometric Patterned Cardigan (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','GR-168-A0',0,19,0,1,0,4,1,0,1531,1132.94,NULL,NULL,11.00,14.00,11.00,896.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(128,'Geometric Patterned Cardigan (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','GR-168-A0-A1',0,19,0,1,0,4,1,0,1531,1255.42,NULL,NULL,11.00,14.00,11.00,896.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(129,'Geometric Patterned Cardigan (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','GR-168-A0-A2',0,19,0,1,0,4,1,0,1531,1270.73,NULL,NULL,11.00,14.00,11.00,896.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(130,'Buckle Detail Ankle Booties',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','HP-200-A0',0,10,0,1,0,1,1,0,1042,NULL,NULL,NULL,12.00,14.00,12.00,731.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(131,'Buckle Detail Ankle Booties',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','HP-200-A0-A1',0,10,0,1,0,1,1,0,1042,NULL,NULL,NULL,12.00,14.00,12.00,731.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(132,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','CS-143-A0',0,13,0,1,0,1,1,0,1876,NULL,NULL,NULL,19.00,12.00,18.00,684.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(133,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','CS-143-A0-A1',0,13,0,1,0,1,1,0,1876,NULL,NULL,NULL,19.00,12.00,18.00,684.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(134,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','FY-154-A0',0,11,0,1,0,5,1,0,1870,NULL,NULL,NULL,11.00,13.00,10.00,847.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(135,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','RX-111-A0',0,19,0,1,0,1,1,0,1142,833.66,NULL,NULL,11.00,20.00,20.00,669.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:50','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(136,'Retro High-Top Sneakers',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','2U-150-A0',0,15,0,1,0,5,1,0,2243,NULL,NULL,NULL,14.00,11.00,17.00,706.00,NULL,0,'2024-03-05 00:56:50','2024-03-05 00:56:51','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(137,'Retro High-Top Sneakers',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','2U-150-A0-A1',0,15,0,1,0,5,1,0,2243,NULL,NULL,NULL,14.00,11.00,17.00,706.00,NULL,0,'2024-03-05 00:56:51','2024-03-05 00:56:51','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(138,'Faux Leather Leggings',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','0X-110-A0',0,20,0,1,0,5,1,0,1928,NULL,NULL,NULL,12.00,18.00,17.00,582.00,NULL,0,'2024-03-05 00:56:51','2024-03-05 00:56:51','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(139,'Faux Leather Leggings',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','0X-110-A0-A1',0,20,0,1,0,5,1,0,1928,NULL,NULL,NULL,12.00,18.00,17.00,582.00,NULL,0,'2024-03-05 00:56:51','2024-03-05 00:56:51','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(140,'Faux Leather Leggings',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','0X-110-A0-A2',0,20,0,1,0,5,1,0,1928,NULL,NULL,NULL,12.00,18.00,17.00,582.00,NULL,0,'2024-03-05 00:56:51','2024-03-05 00:56:51','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(141,'Faux Leather Leggings',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','0X-110-A0-A3',0,20,0,1,0,5,1,0,1928,NULL,NULL,NULL,12.00,18.00,17.00,582.00,NULL,0,'2024-03-05 00:56:51','2024-03-05 00:56:51','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(142,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','6E-102-A0',0,15,0,1,0,5,1,0,538,NULL,NULL,NULL,15.00,16.00,17.00,690.00,NULL,0,'2024-03-05 00:56:51','2024-03-05 00:56:51','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(143,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','6E-102-A0-A1',0,15,0,1,0,5,1,0,538,NULL,NULL,NULL,15.00,16.00,17.00,690.00,NULL,0,'2024-03-05 00:56:51','2024-03-05 00:56:51','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(144,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','6E-102-A0-A2',0,15,0,1,0,5,1,0,538,NULL,NULL,NULL,15.00,16.00,17.00,690.00,NULL,0,'2024-03-05 00:56:51','2024-03-05 00:56:51','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0);
/*!40000 ALTER TABLE `ec_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products_translations`
--

DROP TABLE IF EXISTS `ec_products_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_products_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products_translations`
--

LOCK TABLES `ec_products_translations` WRITE;
/*!40000 ALTER TABLE `ec_products_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_products_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_review_replies`
--

DROP TABLE IF EXISTS `ec_review_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_review_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `review_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_review_replies_review_id_user_id_unique` (`review_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_review_replies`
--

LOCK TABLES `ec_review_replies` WRITE;
/*!40000 ALTER TABLE `ec_review_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_review_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_reviews`
--

DROP TABLE IF EXISTS `ec_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `star` double(8,2) NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_reviews_product_id_customer_id_unique` (`product_id`,`customer_id`),
  KEY `ec_reviews_product_id_customer_id_status_created_at_index` (`product_id`,`customer_id`,`status`,`created_at`),
  KEY `review_relation_index` (`product_id`,`customer_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_reviews`
--

LOCK TABLES `ec_reviews` WRITE;
/*!40000 ALTER TABLE `ec_reviews` DISABLE KEYS */;
INSERT INTO `ec_reviews` VALUES (1,6,29,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(2,7,11,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\"]'),(3,3,15,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(4,9,13,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\"]'),(5,5,35,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\"]'),(6,2,43,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(7,3,17,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(8,9,25,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(9,1,17,1.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\"]'),(10,3,30,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(11,10,40,4.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-16.jpg\"]'),(12,10,25,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\"]'),(13,8,43,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(14,5,39,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(15,6,43,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-18.jpg\"]'),(16,4,21,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\"]'),(17,10,6,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(18,10,14,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(19,10,20,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-19.jpg\"]'),(20,7,5,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\"]'),(21,9,18,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-17.jpg\"]'),(22,10,34,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\"]'),(23,5,6,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(24,10,18,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(25,5,34,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\"]'),(26,5,43,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\"]'),(27,3,4,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\"]'),(28,6,32,2.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(29,2,1,5.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(30,7,9,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-18.jpg\"]'),(31,2,17,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\"]'),(32,5,15,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(33,4,38,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(34,10,4,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\"]'),(35,9,23,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\"]'),(36,6,6,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-20.jpg\"]'),(37,9,38,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(38,8,16,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(40,9,37,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\"]'),(41,9,32,4.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\"]'),(42,5,27,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-12.jpg\"]'),(43,4,6,3.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\"]'),(44,3,9,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\"]'),(45,7,35,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\"]'),(46,2,36,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(47,1,6,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(48,7,16,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(49,8,28,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(50,2,8,3.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-19.jpg\"]'),(51,8,8,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(52,6,39,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(53,1,13,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(54,3,29,3.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\"]'),(55,10,8,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-19.jpg\"]'),(56,5,25,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(57,8,36,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\"]'),(58,10,38,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\"]'),(59,9,11,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\"]'),(60,2,26,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(61,9,21,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(62,3,8,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(63,5,11,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(64,4,26,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(65,1,22,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(66,9,5,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\"]'),(67,6,13,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(68,10,28,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\"]'),(71,4,23,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-12.jpg\"]'),(72,4,22,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(73,9,4,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(74,6,19,1.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\"]'),(75,5,38,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(76,5,37,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\"]'),(77,8,4,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(78,6,5,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\"]'),(79,4,30,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\"]'),(80,3,25,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\"]'),(81,4,17,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(82,1,30,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\"]'),(83,8,10,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(85,10,23,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-19.jpg\"]'),(86,5,14,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\"]'),(87,3,1,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(88,2,38,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\"]'),(89,3,36,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\"]'),(90,5,32,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(91,10,31,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(92,9,39,1.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\"]'),(93,1,32,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-18.jpg\"]'),(94,7,22,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\"]'),(95,8,33,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-19.jpg\"]'),(96,5,8,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\"]'),(97,4,36,5.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-17.jpg\"]'),(99,1,5,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\"]'),(100,8,13,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\"]'),(102,6,37,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\"]'),(103,4,27,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-19.jpg\"]'),(104,2,42,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(106,10,39,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(107,7,37,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(108,7,26,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\"]'),(109,6,33,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\"]'),(110,7,43,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\"]'),(112,5,20,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\"]'),(113,6,1,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(114,9,31,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(116,1,31,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(117,10,11,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(119,8,30,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\"]'),(120,5,30,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(123,7,2,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\"]'),(124,2,7,5.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\"]'),(125,8,23,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(126,4,37,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\"]'),(127,4,40,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(130,2,25,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\"]'),(131,8,42,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\"]'),(132,1,1,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(133,9,1,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(136,4,9,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-19.jpg\"]'),(137,6,10,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(139,8,19,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(140,9,20,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\"]'),(142,6,24,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(143,1,2,5.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\"]'),(144,1,35,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\"]'),(146,2,30,1.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\"]'),(148,10,5,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(149,4,8,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\"]'),(151,7,6,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\"]'),(152,4,41,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\"]'),(153,1,23,4.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-12.jpg\"]'),(154,4,12,4.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(155,7,13,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(156,5,12,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\"]'),(157,2,31,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(159,8,5,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\"]'),(160,7,33,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-16.jpg\"]'),(161,9,28,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(162,4,32,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-14.jpg\"]'),(163,6,7,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\"]'),(168,5,23,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(170,2,4,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(172,5,2,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-20.jpg\"]'),(173,3,5,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-19.jpg\"]'),(174,6,30,3.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-11.jpg\"]'),(176,9,3,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\"]'),(177,8,29,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\"]'),(180,1,14,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\"]'),(183,1,28,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\"]'),(184,4,31,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\"]'),(185,10,13,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(187,10,1,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(188,6,16,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(189,3,28,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-20.jpg\"]'),(191,6,15,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-11.jpg\"]'),(193,4,29,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(194,3,12,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\"]'),(195,7,40,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\"]'),(196,8,15,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(197,9,43,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\"]'),(198,7,31,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\"]'),(199,2,27,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(200,2,33,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\"]'),(201,3,27,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\"]'),(205,10,33,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(206,7,14,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(208,3,14,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(209,10,12,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\"]'),(210,10,26,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\"]'),(211,9,7,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-15.jpg\"]'),(213,7,17,1.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-14.jpg\"]'),(215,4,16,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\"]'),(216,9,10,2.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(217,7,38,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(218,10,17,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-20.jpg\"]'),(219,8,9,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-20.jpg\"]'),(222,4,7,3.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\"]'),(225,7,21,1.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(226,10,24,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(227,5,21,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-20.jpg\"]'),(228,2,32,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(231,4,3,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(232,4,34,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(233,9,19,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(234,8,24,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\"]'),(236,5,3,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-13.jpg\"]'),(238,5,5,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(240,10,43,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-11.jpg\"]'),(241,7,41,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-16.jpg\"]'),(242,7,20,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-14.jpg\"]'),(243,10,32,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\"]'),(244,8,18,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\"]'),(245,2,2,3.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\"]'),(246,1,9,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(247,2,20,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\"]'),(248,10,2,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\"]'),(250,1,29,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\"]'),(251,5,10,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\"]'),(253,1,39,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(254,7,15,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-19.jpg\"]'),(255,1,34,4.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-12.jpg\"]'),(257,10,7,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-20.jpg\"]'),(259,9,40,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\"]'),(263,5,17,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(265,10,22,2.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\"]'),(268,1,40,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\"]'),(269,6,22,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(270,4,1,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\"]'),(272,7,34,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(274,10,37,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(275,3,13,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\"]'),(278,2,41,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(283,1,3,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\"]'),(284,6,28,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-20.jpg\"]'),(286,9,27,4.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\"]'),(288,4,24,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(290,4,20,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-14.jpg\"]'),(294,6,17,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\"]'),(296,10,9,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\"]'),(299,1,15,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\"]'),(301,3,26,1.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(302,1,41,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(306,7,23,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\"]'),(307,1,25,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-12.jpg\"]'),(308,3,11,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]'),(309,6,4,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\"]'),(310,8,31,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-18.jpg\"]'),(312,3,19,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(315,5,19,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-17.jpg\"]'),(316,8,2,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\"]'),(317,3,3,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(321,5,31,4.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-18.jpg\"]'),(322,2,37,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(323,1,21,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\"]'),(327,5,16,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(328,9,29,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\"]'),(329,3,7,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\"]'),(334,2,21,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\"]'),(335,2,18,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(337,8,17,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\"]'),(338,9,9,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(341,4,42,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-13.jpg\"]'),(343,4,14,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(346,3,24,1.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-12.jpg\"]'),(347,9,16,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(350,1,19,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(354,7,19,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(355,8,32,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(359,1,20,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\"]'),(360,3,22,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-14.jpg\"]'),(362,7,42,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(363,5,28,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(366,2,34,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(368,3,42,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\"]'),(369,4,13,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\"]'),(370,9,15,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(371,10,42,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(372,6,12,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\"]'),(373,3,39,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\"]'),(376,2,6,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-13.jpg\"]'),(377,6,23,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\"]'),(380,4,35,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(382,3,43,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\"]'),(384,7,30,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(387,5,33,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\"]'),(388,6,42,4.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(389,9,42,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(390,1,8,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(392,7,8,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\"]'),(394,6,36,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-16.jpg\"]'),(396,5,26,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(397,4,39,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(399,5,9,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(402,2,15,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(408,9,30,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(409,6,3,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\"]'),(415,9,14,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-13.jpg\"]'),(416,1,43,1.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\"]'),(417,10,10,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\"]'),(418,5,1,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\"]'),(419,8,26,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\"]'),(420,1,33,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(423,3,33,1.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(424,5,36,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(425,2,13,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-17.jpg\"]'),(429,9,26,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(433,2,10,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(435,9,6,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(439,7,1,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-18.jpg\"]'),(440,8,11,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]'),(446,1,26,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\"]'),(447,2,9,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\"]'),(448,8,22,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\"]'),(450,6,20,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\"]'),(456,6,18,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\"]'),(460,1,27,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(465,7,3,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\"]'),(466,5,40,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(469,10,36,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\"]'),(477,7,29,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\"]'),(492,8,37,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(494,3,34,1.00,'Best ecommerce CMS online store!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\"]'),(495,4,2,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(497,6,34,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(501,3,20,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(509,8,14,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-20.jpg\"]'),(513,10,35,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(516,5,24,1.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\"]'),(519,1,24,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-16.jpg\"]'),(531,6,26,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-19.jpg\"]'),(532,1,11,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(534,4,10,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\"]'),(541,6,38,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(546,7,32,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\"]'),(549,1,38,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\"]'),(558,9,33,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\"]'),(561,10,19,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(564,2,11,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\"]'),(575,9,17,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\"]'),(579,3,6,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(581,9,41,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(586,6,21,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\"]'),(588,2,12,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-15.jpg\"]'),(592,3,2,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(596,2,35,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(597,2,5,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-20.jpg\"]'),(598,1,7,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(599,2,40,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\"]'),(608,2,23,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\"]'),(609,8,35,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\"]'),(610,3,21,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(616,3,16,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\"]'),(620,1,16,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(621,4,11,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-18.jpg\"]'),(625,8,7,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(626,6,2,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\"]'),(630,7,28,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\"]'),(632,6,9,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(633,2,3,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\"]'),(648,8,38,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-20.jpg\"]'),(650,3,37,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-19.jpg\"]'),(657,1,12,2.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(660,4,33,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\"]'),(677,5,7,3.00,'Clean & perfect source code','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-15.jpg\"]'),(683,7,36,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\"]'),(687,7,7,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-18.jpg\"]'),(701,7,18,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\"]'),(711,6,40,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\"]'),(718,1,10,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\"]'),(719,5,29,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-12.jpg\"]'),(724,10,27,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(742,10,16,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-19.jpg\"]'),(751,8,12,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(757,4,18,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-20.jpg\"]'),(759,6,11,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\"]'),(760,8,27,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-20.jpg\"]'),(781,7,39,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-17.jpg\"]'),(782,7,27,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(786,4,19,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-11.jpg\"]'),(791,9,36,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(796,9,34,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\"]'),(797,3,40,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(798,2,14,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\"]'),(805,5,13,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\"]'),(807,10,30,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-20.jpg\"]'),(829,6,14,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\"]'),(835,2,24,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(855,4,5,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(860,5,22,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\"]'),(880,9,12,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-20.jpg\"]'),(892,2,16,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(893,2,28,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(897,9,8,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\"]'),(909,10,3,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(933,5,41,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-20.jpg\"]'),(938,9,35,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(943,8,40,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(963,8,34,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(969,3,18,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(978,9,22,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]'),(985,1,36,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-2.jpg\"]'),(989,1,4,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(997,7,25,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:57:24','2024-03-05 00:57:24','[\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]');
/*!40000 ALTER TABLE `ec_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipment_histories`
--

DROP TABLE IF EXISTS `ec_shipment_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipment_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `shipment_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipment_histories`
--

LOCK TABLES `ec_shipment_histories` WRITE;
/*!40000 ALTER TABLE `ec_shipment_histories` DISABLE KEYS */;
INSERT INTO `ec_shipment_histories` VALUES (1,'create_from_order','Shipping was created from order %order_id%',0,1,1,'2024-02-20 16:56:52','2024-02-20 16:56:52','Botble\\ACL\\Models\\User'),(2,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,1,1,'2024-03-03 08:56:52','2024-03-05 00:56:52','Botble\\ACL\\Models\\User'),(3,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,1,1,'2024-03-05 00:56:52','2024-03-05 00:56:52','Botble\\ACL\\Models\\User'),(4,'create_from_order','Shipping was created from order %order_id%',0,2,2,'2024-02-17 08:56:52','2024-02-17 08:56:52','Botble\\ACL\\Models\\User'),(5,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,2,2,'2024-03-03 08:56:53','2024-03-05 00:56:53','Botble\\ACL\\Models\\User'),(6,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,2,2,'2024-03-05 00:56:53','2024-03-05 00:56:53','Botble\\ACL\\Models\\User'),(7,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,2,2,'2024-03-05 00:56:53','2024-03-05 00:56:53','Botble\\ACL\\Models\\User'),(8,'create_from_order','Shipping was created from order %order_id%',0,3,3,'2024-03-03 10:56:53','2024-03-03 10:56:53','Botble\\ACL\\Models\\User'),(9,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,3,3,'2024-03-03 10:56:53','2024-03-05 00:56:53','Botble\\ACL\\Models\\User'),(10,'create_from_order','Shipping was created from order %order_id%',0,4,4,'2024-02-22 22:56:53','2024-02-22 22:56:53','Botble\\ACL\\Models\\User'),(11,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,4,4,'2024-03-03 10:56:53','2024-03-05 00:56:53','Botble\\ACL\\Models\\User'),(12,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,4,4,'2024-03-05 00:56:53','2024-03-05 00:56:53','Botble\\ACL\\Models\\User'),(13,'create_from_order','Shipping was created from order %order_id%',0,5,5,'2024-02-18 04:56:53','2024-02-18 04:56:53','Botble\\ACL\\Models\\User'),(14,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,5,5,'2024-03-03 10:56:53','2024-03-05 00:56:53','Botble\\ACL\\Models\\User'),(15,'create_from_order','Shipping was created from order %order_id%',0,6,7,'2024-02-25 00:56:53','2024-02-25 00:56:53','Botble\\ACL\\Models\\User'),(16,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,6,7,'2024-03-03 12:56:53','2024-03-05 00:56:53','Botble\\ACL\\Models\\User'),(17,'create_from_order','Shipping was created from order %order_id%',0,7,8,'2024-03-02 04:56:53','2024-03-02 04:56:53','Botble\\ACL\\Models\\User'),(18,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,7,8,'2024-03-03 14:56:54','2024-03-05 00:56:54','Botble\\ACL\\Models\\User'),(19,'create_from_order','Shipping was created from order %order_id%',0,8,9,'2024-03-03 14:56:54','2024-03-03 14:56:54','Botble\\ACL\\Models\\User'),(20,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,8,9,'2024-03-03 14:56:54','2024-03-05 00:56:54','Botble\\ACL\\Models\\User'),(21,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,8,9,'2024-03-05 00:56:54','2024-03-05 00:56:54','Botble\\ACL\\Models\\User'),(22,'create_from_order','Shipping was created from order %order_id%',0,9,11,'2024-03-03 16:56:54','2024-03-03 16:56:54','Botble\\ACL\\Models\\User'),(23,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,9,11,'2024-03-03 16:56:54','2024-03-05 00:56:54','Botble\\ACL\\Models\\User'),(24,'create_from_order','Shipping was created from order %order_id%',0,10,12,'2024-03-01 00:56:54','2024-03-01 00:56:54','Botble\\ACL\\Models\\User'),(25,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,10,12,'2024-03-03 16:56:54','2024-03-05 00:56:54','Botble\\ACL\\Models\\User'),(26,'create_from_order','Shipping was created from order %order_id%',0,11,13,'2024-03-02 08:56:54','2024-03-02 08:56:54','Botble\\ACL\\Models\\User'),(27,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,11,13,'2024-03-03 16:56:55','2024-03-05 00:56:55','Botble\\ACL\\Models\\User'),(28,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,11,13,'2024-03-05 00:56:55','2024-03-05 00:56:55','Botble\\ACL\\Models\\User'),(29,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,11,13,'2024-03-05 00:56:55','2024-03-05 00:56:55','Botble\\ACL\\Models\\User'),(30,'create_from_order','Shipping was created from order %order_id%',0,12,14,'2024-02-24 16:56:55','2024-02-24 16:56:55','Botble\\ACL\\Models\\User'),(31,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,12,14,'2024-03-03 16:56:55','2024-03-05 00:56:55','Botble\\ACL\\Models\\User'),(32,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,12,14,'2024-03-05 00:56:55','2024-03-05 00:56:55','Botble\\ACL\\Models\\User'),(33,'create_from_order','Shipping was created from order %order_id%',0,13,15,'2024-02-26 12:56:55','2024-02-26 12:56:55','Botble\\ACL\\Models\\User'),(34,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,13,15,'2024-03-03 18:56:55','2024-03-05 00:56:55','Botble\\ACL\\Models\\User'),(35,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,13,15,'2024-03-05 00:56:55','2024-03-05 00:56:55','Botble\\ACL\\Models\\User'),(36,'create_from_order','Shipping was created from order %order_id%',0,14,18,'2024-03-02 16:56:55','2024-03-02 16:56:55','Botble\\ACL\\Models\\User'),(37,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,14,18,'2024-03-03 20:56:55','2024-03-05 00:56:55','Botble\\ACL\\Models\\User'),(38,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,14,18,'2024-03-05 00:56:55','2024-03-05 00:56:55','Botble\\ACL\\Models\\User'),(39,'create_from_order','Shipping was created from order %order_id%',0,15,19,'2024-02-25 20:56:55','2024-02-25 20:56:55','Botble\\ACL\\Models\\User'),(40,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,15,19,'2024-03-03 20:56:56','2024-03-05 00:56:56','Botble\\ACL\\Models\\User'),(41,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,15,19,'2024-03-05 00:56:56','2024-03-05 00:56:56','Botble\\ACL\\Models\\User'),(42,'create_from_order','Shipping was created from order %order_id%',0,16,20,'2024-03-02 16:56:56','2024-03-02 16:56:56','Botble\\ACL\\Models\\User'),(43,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,16,20,'2024-03-03 20:56:56','2024-03-05 00:56:56','Botble\\ACL\\Models\\User'),(44,'create_from_order','Shipping was created from order %order_id%',0,17,21,'2024-02-28 14:56:56','2024-02-28 14:56:56','Botble\\ACL\\Models\\User'),(45,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,17,21,'2024-03-03 22:56:56','2024-03-05 00:56:56','Botble\\ACL\\Models\\User'),(46,'create_from_order','Shipping was created from order %order_id%',0,18,22,'2024-02-29 16:56:56','2024-02-29 16:56:56','Botble\\ACL\\Models\\User'),(47,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,18,22,'2024-03-03 22:56:56','2024-03-05 00:56:56','Botble\\ACL\\Models\\User'),(48,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,22,'2024-03-05 00:56:56','2024-03-05 00:56:56','Botble\\ACL\\Models\\User'),(49,'create_from_order','Shipping was created from order %order_id%',0,19,23,'2024-02-26 10:56:56','2024-02-26 10:56:56','Botble\\ACL\\Models\\User'),(50,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,19,23,'2024-03-03 22:56:56','2024-03-05 00:56:56','Botble\\ACL\\Models\\User'),(51,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,19,23,'2024-03-05 00:56:56','2024-03-05 00:56:56','Botble\\ACL\\Models\\User'),(52,'create_from_order','Shipping was created from order %order_id%',0,20,24,'2024-02-24 00:56:56','2024-02-24 00:56:56','Botble\\ACL\\Models\\User'),(53,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,20,24,'2024-03-04 00:56:57','2024-03-05 00:56:57','Botble\\ACL\\Models\\User'),(54,'create_from_order','Shipping was created from order %order_id%',0,21,25,'2024-02-28 00:56:57','2024-02-28 00:56:57','Botble\\ACL\\Models\\User'),(55,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,21,25,'2024-03-04 00:56:57','2024-03-05 00:56:57','Botble\\ACL\\Models\\User'),(56,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,21,25,'2024-03-05 00:56:57','2024-03-05 00:56:57','Botble\\ACL\\Models\\User'),(57,'create_from_order','Shipping was created from order %order_id%',0,22,26,'2024-02-28 12:56:57','2024-02-28 12:56:57','Botble\\ACL\\Models\\User'),(58,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,22,26,'2024-03-04 02:56:57','2024-03-05 00:56:57','Botble\\ACL\\Models\\User'),(59,'create_from_order','Shipping was created from order %order_id%',0,23,28,'2024-02-26 16:56:57','2024-02-26 16:56:57','Botble\\ACL\\Models\\User'),(60,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,23,28,'2024-03-04 02:56:57','2024-03-05 00:56:57','Botble\\ACL\\Models\\User'),(61,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,23,28,'2024-03-05 00:56:57','2024-03-05 00:56:57','Botble\\ACL\\Models\\User'),(62,'create_from_order','Shipping was created from order %order_id%',0,24,29,'2024-02-29 00:56:57','2024-02-29 00:56:57','Botble\\ACL\\Models\\User'),(63,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,24,29,'2024-03-04 04:56:57','2024-03-05 00:56:57','Botble\\ACL\\Models\\User'),(64,'create_from_order','Shipping was created from order %order_id%',0,25,30,'2024-03-02 12:56:57','2024-03-02 12:56:57','Botble\\ACL\\Models\\User'),(65,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,25,30,'2024-03-04 04:56:58','2024-03-05 00:56:58','Botble\\ACL\\Models\\User'),(66,'create_from_order','Shipping was created from order %order_id%',0,26,31,'2024-02-26 12:56:58','2024-02-26 12:56:58','Botble\\ACL\\Models\\User'),(67,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,26,31,'2024-03-04 06:56:58','2024-03-05 00:56:58','Botble\\ACL\\Models\\User'),(68,'create_from_order','Shipping was created from order %order_id%',0,27,32,'2024-03-02 18:56:58','2024-03-02 18:56:58','Botble\\ACL\\Models\\User'),(69,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,27,32,'2024-03-04 06:56:58','2024-03-05 00:56:58','Botble\\ACL\\Models\\User'),(70,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,27,32,'2024-03-05 00:56:58','2024-03-05 00:56:58','Botble\\ACL\\Models\\User'),(71,'create_from_order','Shipping was created from order %order_id%',0,28,33,'2024-03-04 08:56:58','2024-03-04 08:56:58','Botble\\ACL\\Models\\User'),(72,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,28,33,'2024-03-04 08:56:58','2024-03-05 00:56:58','Botble\\ACL\\Models\\User'),(73,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,28,33,'2024-03-05 00:56:58','2024-03-05 00:56:58','Botble\\ACL\\Models\\User'),(74,'create_from_order','Shipping was created from order %order_id%',0,29,34,'2024-03-03 00:56:58','2024-03-03 00:56:58','Botble\\ACL\\Models\\User'),(75,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,29,34,'2024-03-04 08:56:59','2024-03-05 00:56:59','Botble\\ACL\\Models\\User'),(76,'create_from_order','Shipping was created from order %order_id%',0,30,36,'2024-03-04 08:56:59','2024-03-04 08:56:59','Botble\\ACL\\Models\\User'),(77,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,30,36,'2024-03-04 08:56:59','2024-03-05 00:56:59','Botble\\ACL\\Models\\User'),(78,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,30,36,'2024-03-05 00:56:59','2024-03-05 00:56:59','Botble\\ACL\\Models\\User'),(79,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,30,36,'2024-03-05 00:56:59','2024-03-05 00:56:59','Botble\\ACL\\Models\\User'),(80,'create_from_order','Shipping was created from order %order_id%',0,31,37,'2024-03-01 12:56:59','2024-03-01 12:56:59','Botble\\ACL\\Models\\User'),(81,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,31,37,'2024-03-04 10:56:59','2024-03-05 00:56:59','Botble\\ACL\\Models\\User'),(82,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,31,37,'2024-03-05 00:56:59','2024-03-05 00:56:59','Botble\\ACL\\Models\\User'),(83,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,31,37,'2024-03-05 00:56:59','2024-03-05 00:56:59','Botble\\ACL\\Models\\User'),(84,'create_from_order','Shipping was created from order %order_id%',0,32,38,'2024-03-03 06:56:59','2024-03-03 06:56:59','Botble\\ACL\\Models\\User'),(85,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,32,38,'2024-03-04 10:57:00','2024-03-05 00:57:00','Botble\\ACL\\Models\\User'),(86,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,32,38,'2024-03-05 00:57:00','2024-03-05 00:57:00','Botble\\ACL\\Models\\User'),(87,'create_from_order','Shipping was created from order %order_id%',0,33,39,'2024-02-29 08:57:00','2024-02-29 08:57:00','Botble\\ACL\\Models\\User'),(88,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,33,39,'2024-03-04 10:57:00','2024-03-05 00:57:00','Botble\\ACL\\Models\\User'),(89,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,33,39,'2024-03-05 00:57:00','2024-03-05 00:57:00','Botble\\ACL\\Models\\User'),(90,'create_from_order','Shipping was created from order %order_id%',0,34,40,'2024-03-02 00:57:00','2024-03-02 00:57:00','Botble\\ACL\\Models\\User'),(91,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,34,40,'2024-03-04 12:57:00','2024-03-05 00:57:00','Botble\\ACL\\Models\\User'),(92,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,34,40,'2024-03-05 00:57:00','2024-03-05 00:57:00','Botble\\ACL\\Models\\User'),(93,'create_from_order','Shipping was created from order %order_id%',0,35,41,'2024-03-03 00:57:00','2024-03-03 00:57:00','Botble\\ACL\\Models\\User'),(94,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,35,41,'2024-03-04 12:57:00','2024-03-05 00:57:00','Botble\\ACL\\Models\\User'),(95,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,35,41,'2024-03-05 00:57:00','2024-03-05 00:57:00','Botble\\ACL\\Models\\User'),(96,'create_from_order','Shipping was created from order %order_id%',0,36,42,'2024-03-02 12:57:00','2024-03-02 12:57:00','Botble\\ACL\\Models\\User'),(97,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,36,42,'2024-03-04 12:57:00','2024-03-05 00:57:00','Botble\\ACL\\Models\\User'),(98,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,36,42,'2024-03-05 00:57:00','2024-03-05 00:57:00','Botble\\ACL\\Models\\User'),(99,'create_from_order','Shipping was created from order %order_id%',0,37,43,'2024-03-03 08:57:00','2024-03-03 08:57:00','Botble\\ACL\\Models\\User'),(100,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,37,43,'2024-03-04 14:57:01','2024-03-05 00:57:01','Botble\\ACL\\Models\\User'),(101,'create_from_order','Shipping was created from order %order_id%',0,38,44,'2024-03-02 02:57:01','2024-03-02 02:57:01','Botble\\ACL\\Models\\User'),(102,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,38,44,'2024-03-04 14:57:01','2024-03-05 00:57:01','Botble\\ACL\\Models\\User'),(103,'create_from_order','Shipping was created from order %order_id%',0,39,45,'2024-02-29 20:57:01','2024-02-29 20:57:01','Botble\\ACL\\Models\\User'),(104,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,39,45,'2024-03-04 14:57:01','2024-03-05 00:57:01','Botble\\ACL\\Models\\User'),(105,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,39,45,'2024-03-05 00:57:01','2024-03-05 00:57:01','Botble\\ACL\\Models\\User'),(106,'create_from_order','Shipping was created from order %order_id%',0,40,46,'2024-03-02 16:57:01','2024-03-02 16:57:01','Botble\\ACL\\Models\\User'),(107,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,40,46,'2024-03-04 16:57:01','2024-03-05 00:57:01','Botble\\ACL\\Models\\User'),(108,'create_from_order','Shipping was created from order %order_id%',0,41,47,'2024-03-03 00:57:01','2024-03-03 00:57:01','Botble\\ACL\\Models\\User'),(109,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,41,47,'2024-03-04 16:57:01','2024-03-05 00:57:01','Botble\\ACL\\Models\\User'),(110,'create_from_order','Shipping was created from order %order_id%',0,42,48,'2024-03-04 18:57:01','2024-03-04 18:57:01','Botble\\ACL\\Models\\User'),(111,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,42,48,'2024-03-04 18:57:02','2024-03-05 00:57:02','Botble\\ACL\\Models\\User'),(112,'create_from_order','Shipping was created from order %order_id%',0,43,49,'2024-03-03 18:57:02','2024-03-03 18:57:02','Botble\\ACL\\Models\\User'),(113,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,43,49,'2024-03-04 18:57:02','2024-03-05 00:57:02','Botble\\ACL\\Models\\User'),(114,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,43,49,'2024-03-05 00:57:02','2024-03-05 00:57:02','Botble\\ACL\\Models\\User'),(115,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,43,49,'2024-03-05 00:57:02','2024-03-05 00:57:02','Botble\\ACL\\Models\\User'),(116,'create_from_order','Shipping was created from order %order_id%',0,44,50,'2024-03-04 18:57:02','2024-03-04 18:57:02','Botble\\ACL\\Models\\User'),(117,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,44,50,'2024-03-04 18:57:02','2024-03-05 00:57:02','Botble\\ACL\\Models\\User'),(118,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,44,50,'2024-03-05 00:57:02','2024-03-05 00:57:02','Botble\\ACL\\Models\\User'),(119,'create_from_order','Shipping was created from order %order_id%',0,45,51,'2024-03-04 20:57:02','2024-03-04 20:57:02','Botble\\ACL\\Models\\User'),(120,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,45,51,'2024-03-04 20:57:02','2024-03-05 00:57:02','Botble\\ACL\\Models\\User'),(121,'create_from_order','Shipping was created from order %order_id%',0,46,53,'2024-03-04 14:57:02','2024-03-04 14:57:02','Botble\\ACL\\Models\\User'),(122,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,46,53,'2024-03-04 22:57:03','2024-03-05 00:57:03','Botble\\ACL\\Models\\User'),(123,'create_from_order','Shipping was created from order %order_id%',0,47,54,'2024-03-04 10:57:03','2024-03-04 10:57:03','Botble\\ACL\\Models\\User'),(124,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,47,54,'2024-03-04 22:57:03','2024-03-05 00:57:03','Botble\\ACL\\Models\\User'),(125,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,47,54,'2024-03-05 00:57:03','2024-03-05 00:57:03','Botble\\ACL\\Models\\User');
/*!40000 ALTER TABLE `ec_shipment_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipments`
--

DROP TABLE IF EXISTS `ec_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `shipment_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rate_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cod_amount` decimal(15,2) DEFAULT '0.00',
  `cod_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cross_checking_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `price` decimal(15,2) DEFAULT '0.00',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tracking_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_company_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking_link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estimate_date_shipped` datetime DEFAULT NULL,
  `date_shipped` datetime DEFAULT NULL,
  `label_url` text COLLATE utf8mb4_unicode_ci,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipments`
--

LOCK TABLES `ec_shipments` WRITE;
/*!40000 ALTER TABLE `ec_shipments` DISABLE KEYS */;
INSERT INTO `ec_shipments` VALUES (1,1,NULL,630.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:52','2024-03-05 00:56:52','JJD0018710123','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-07 07:56:52','2024-03-05 07:56:52',NULL,NULL),(2,2,NULL,2541.00,NULL,NULL,'','delivered',5610.00,'completed','pending',0.00,0,'2024-03-05 00:56:53','2024-03-05 00:56:53','JJD0017917999','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:56:53','2024-03-05 07:56:53',NULL,NULL),(3,3,NULL,1012.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:53','2024-03-05 00:56:53','JJD0057525887','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-15 07:56:53',NULL,NULL,NULL),(4,4,NULL,2697.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:53','2024-03-05 00:56:53','JJD0087105769','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-10 07:56:53','2024-03-05 07:56:53',NULL,NULL),(5,5,NULL,1562.00,NULL,NULL,'','approved',3854.00,'pending','pending',0.00,0,'2024-03-05 00:56:53','2024-03-05 00:56:53','JJD0018965435','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:56:53',NULL,NULL,NULL),(6,7,NULL,690.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:53','2024-03-05 00:56:53','JJD0065043828','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-10 07:56:53',NULL,NULL,NULL),(7,8,NULL,1893.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:54','2024-03-05 00:56:54','JJD0032849859','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-07 07:56:54',NULL,NULL,NULL),(8,9,NULL,3374.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:54','2024-03-05 00:56:54','JJD0016249967','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:56:54','2024-03-05 07:56:54',NULL,NULL),(9,11,NULL,769.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:54','2024-03-05 00:56:54','JJD0038689756','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-09 07:56:54',NULL,NULL,NULL),(10,12,NULL,759.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:54','2024-03-05 00:56:54','JJD007262375','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-07 07:56:54',NULL,NULL,NULL),(11,13,NULL,1666.00,NULL,NULL,'','delivered',2094.00,'completed','pending',0.00,0,'2024-03-05 00:56:55','2024-03-05 00:56:55','JJD0039041276','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-15 07:56:55','2024-03-05 07:56:55',NULL,NULL),(12,14,NULL,1164.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:55','2024-03-05 00:56:55','JJD0023681000','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-15 07:56:55','2024-03-05 07:56:55',NULL,NULL),(13,15,NULL,769.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:55','2024-03-05 00:56:55','JJD001946611','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:56:55','2024-03-05 07:56:55',NULL,NULL),(14,18,NULL,656.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:55','2024-03-05 00:56:55','JJD0023307779','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:56:55','2024-03-05 07:56:55',NULL,NULL),(15,19,NULL,2620.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:56','2024-03-05 00:56:56','JJD0053706975','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-07 07:56:56','2024-03-05 07:56:56',NULL,NULL),(16,20,NULL,2070.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:56','2024-03-05 00:56:56','JJD0034791981','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:56:56',NULL,NULL,NULL),(17,21,NULL,2328.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:56','2024-03-05 00:56:56','JJD0091350619','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-11 07:56:56',NULL,NULL,NULL),(18,22,NULL,2530.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:56','2024-03-05 00:56:56','JJD0081707036','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-10 07:56:56','2024-03-05 07:56:56',NULL,NULL),(19,23,NULL,2661.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:56','2024-03-05 00:56:56','JJD0023268260','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:56:56','2024-03-05 07:56:56',NULL,NULL),(20,24,NULL,1414.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:57','2024-03-05 00:56:57','JJD001134722','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-09 07:56:57',NULL,NULL,NULL),(21,25,NULL,1312.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:57','2024-03-05 00:56:57','JJD0017100788','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-10 07:56:57','2024-03-05 07:56:57',NULL,NULL),(22,26,NULL,1312.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:57','2024-03-05 00:56:57','JJD0067947019','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:56:57',NULL,NULL,NULL),(23,28,NULL,2660.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:57','2024-03-05 00:56:57','JJD0053613396','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:56:57','2024-03-05 07:56:57',NULL,NULL),(24,29,NULL,1414.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:57','2024-03-05 00:56:57','JJD0084822510','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-13 07:56:57',NULL,NULL,NULL),(25,30,NULL,506.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:58','2024-03-05 00:56:58','JJD0013574201','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-09 07:56:58',NULL,NULL,NULL),(26,31,NULL,707.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:58','2024-03-05 00:56:58','JJD0040766214','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:56:58',NULL,NULL,NULL),(27,32,NULL,1588.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:58','2024-03-05 00:56:58','JJD0081006277','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:56:58','2024-03-05 07:56:58',NULL,NULL),(28,33,NULL,769.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:58','2024-03-05 00:56:58','JJD006260521','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-09 07:56:58','2024-03-05 07:56:58',NULL,NULL),(29,34,NULL,2628.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:59','2024-03-05 00:56:59','JJD001503816','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:56:59',NULL,NULL,NULL),(30,36,NULL,582.00,NULL,NULL,'','delivered',1928.00,'completed','pending',0.00,0,'2024-03-05 00:56:59','2024-03-05 00:56:59','JJD0058682659','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-12 07:56:59','2024-03-05 07:56:59',NULL,NULL),(31,37,NULL,1312.00,NULL,NULL,'','delivered',1660.00,'completed','pending',0.00,0,'2024-03-05 00:56:59','2024-03-05 00:56:59','JJD0040243749','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-13 07:56:59','2024-03-05 07:56:59',NULL,NULL),(32,38,NULL,4322.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:57:00','2024-03-05 00:57:00','JJD0091021002','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-07 07:57:00','2024-03-05 07:57:00',NULL,NULL),(33,39,NULL,2499.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:57:00','2024-03-05 00:57:00','JJD0073296831','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-12 07:57:00','2024-03-05 07:57:00',NULL,NULL),(34,40,NULL,1675.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:57:00','2024-03-05 00:57:00','JJD002564362','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-13 07:57:00','2024-03-05 07:57:00',NULL,NULL),(35,41,NULL,659.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:57:00','2024-03-05 00:57:00','JJD001752627','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-09 07:57:00','2024-03-05 07:57:00',NULL,NULL),(36,42,NULL,1752.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:57:00','2024-03-05 00:57:00','JJD0047381796','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-11 07:57:00','2024-03-05 07:57:00',NULL,NULL),(37,43,NULL,1538.00,NULL,NULL,'','approved',1760.00,'pending','pending',0.00,0,'2024-03-05 00:57:01','2024-03-05 00:57:01','JJD0018241320','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-12 07:57:01',NULL,NULL,NULL),(38,44,NULL,2499.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:57:01','2024-03-05 00:57:01','JJD0020941704','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-15 07:57:01',NULL,NULL,NULL),(39,45,NULL,2052.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:57:01','2024-03-05 00:57:01','JJD0030414269','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-12 07:57:01','2024-03-05 07:57:01',NULL,NULL),(40,46,NULL,1414.00,NULL,NULL,'','approved',4386.00,'pending','pending',0.00,0,'2024-03-05 00:57:01','2024-03-05 00:57:01','JJD0076848118','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-12 07:57:01',NULL,NULL,NULL),(41,47,NULL,1552.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:57:01','2024-03-05 00:57:01','JJD0048815493','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:57:01',NULL,NULL,NULL),(42,48,NULL,2307.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:57:02','2024-03-05 00:57:02','JJD0030446814','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-13 07:57:02',NULL,NULL,NULL),(43,49,NULL,1086.00,NULL,NULL,'','delivered',2472.00,'completed','pending',0.00,0,'2024-03-05 00:57:02','2024-03-05 00:57:02','JJD0029632925','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:57:02','2024-03-05 07:57:02',NULL,NULL),(44,50,NULL,684.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:57:02','2024-03-05 00:57:02','JJD0042403037','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:57:02','2024-03-05 07:57:02',NULL,NULL),(45,51,NULL,6746.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:57:02','2024-03-05 00:57:02','JJD0021875564','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-13 07:57:02',NULL,NULL,NULL),(46,53,NULL,2953.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:57:03','2024-03-05 00:57:03','JJD0078906140','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:57:03',NULL,NULL,NULL),(47,54,NULL,1562.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:57:03','2024-03-05 00:57:03','JJD0079823589','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:57:03','2024-03-05 07:57:03',NULL,NULL);
/*!40000 ALTER TABLE `ec_shipments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping`
--

DROP TABLE IF EXISTS `ec_shipping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping`
--

LOCK TABLES `ec_shipping` WRITE;
/*!40000 ALTER TABLE `ec_shipping` DISABLE KEYS */;
INSERT INTO `ec_shipping` VALUES (1,'All',NULL,'2024-03-05 00:56:41','2024-03-05 00:56:41');
/*!40000 ALTER TABLE `ec_shipping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rule_items`
--

DROP TABLE IF EXISTS `ec_shipping_rule_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rule_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `shipping_rule_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_price` decimal(15,2) DEFAULT '0.00',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rule_items`
--

LOCK TABLES `ec_shipping_rule_items` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rule_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipping_rule_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rules`
--

DROP TABLE IF EXISTS `ec_shipping_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_id` bigint unsigned NOT NULL,
  `type` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT 'based_on_price',
  `from` decimal(15,2) DEFAULT '0.00',
  `to` decimal(15,2) DEFAULT '0.00',
  `price` decimal(15,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rules`
--

LOCK TABLES `ec_shipping_rules` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rules` DISABLE KEYS */;
INSERT INTO `ec_shipping_rules` VALUES (1,'Free delivery',1,'based_on_price',0.00,NULL,0.00,'2024-03-05 00:56:41','2024-03-05 00:56:41');
/*!40000 ALTER TABLE `ec_shipping_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_store_locators`
--

DROP TABLE IF EXISTS `ec_store_locators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_store_locators` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) DEFAULT '0',
  `is_shipping_location` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_store_locators`
--

LOCK TABLES `ec_store_locators` WRITE;
/*!40000 ALTER TABLE `ec_store_locators` DISABLE KEYS */;
INSERT INTO `ec_store_locators` VALUES (1,'Shofy','sales@botble.com','1800979769','502 New Street','AU','Brighton VIC','Brighton VIC',1,1,'2024-03-05 00:56:42','2024-03-05 00:56:42');
/*!40000 ALTER TABLE `ec_store_locators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_products`
--

DROP TABLE IF EXISTS `ec_tax_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_products` (
  `tax_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tax_id`),
  KEY `ec_tax_products_tax_id_index` (`tax_id`),
  KEY `ec_tax_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_products`
--

LOCK TABLES `ec_tax_products` WRITE;
/*!40000 ALTER TABLE `ec_tax_products` DISABLE KEYS */;
INSERT INTO `ec_tax_products` VALUES (1,6),(1,7),(1,8),(1,9),(1,10),(1,17),(1,18),(1,25),(1,27),(1,28),(1,35),(1,38),(1,42),(2,12),(2,13),(2,15),(2,22),(2,26),(2,31),(2,32),(2,34),(2,39),(2,41),(2,43),(3,1),(3,2),(3,3),(3,4),(3,5),(3,11),(3,14),(3,16),(3,19),(3,20),(3,21),(3,23),(3,24),(3,29),(3,30),(3,33),(3,36),(3,37),(3,40);
/*!40000 ALTER TABLE `ec_tax_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_rules`
--

DROP TABLE IF EXISTS `ec_tax_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_rules`
--

LOCK TABLES `ec_tax_rules` WRITE;
/*!40000 ALTER TABLE `ec_tax_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_tax_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_taxes`
--

DROP TABLE IF EXISTS `ec_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` double(8,6) DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_taxes`
--

LOCK TABLES `ec_taxes` WRITE;
/*!40000 ALTER TABLE `ec_taxes` DISABLE KEYS */;
INSERT INTO `ec_taxes` VALUES (1,'VAT',10.000000,1,'published','2024-03-05 00:56:41','2024-03-05 00:56:41'),(2,'None',0.000000,2,'published','2024-03-05 00:56:41','2024-03-05 00:56:41'),(3,'Import Tax',15.000000,3,'published','2024-03-05 00:56:41','2024-03-05 00:56:41');
/*!40000 ALTER TABLE `ec_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_wish_lists`
--

DROP TABLE IF EXISTS `ec_wish_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_wish_lists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wishlist_relation_index` (`product_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_wish_lists`
--

LOCK TABLES `ec_wish_lists` WRITE;
/*!40000 ALTER TABLE `ec_wish_lists` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_wish_lists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'SHIPPING',0,'published','2024-03-05 00:56:38','2024-03-05 00:56:38',NULL),(2,'PAYMENT',1,'published','2024-03-05 00:56:38','2024-03-05 00:56:38',NULL),(3,'ORDER &amp; RETURNS',2,'published','2024-03-05 00:56:38','2024-03-05 00:56:38',NULL);
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'What Shipping Methods Are Available?','Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.',1,'published','2024-03-05 00:56:38','2024-03-05 00:56:38'),(2,'Do You Ship Internationally?','Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.',1,'published','2024-03-05 00:56:38','2024-03-05 00:56:38'),(3,'How Long Will It Take To Get My Package?','Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.',1,'published','2024-03-05 00:56:38','2024-03-05 00:56:38'),(4,'What Payment Methods Are Accepted?','Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.',2,'published','2024-03-05 00:56:38','2024-03-05 00:56:38'),(5,'Is Buying On-Line Safe?','Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.',2,'published','2024-03-05 00:56:38','2024-03-05 00:56:38'),(6,'How do I place an Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level. Raw denim polaroid paleo farm-to-table, put a bird on it lo-fi tattooed Wes Anderson Pinterest letterpress. Fingerstache McSweeney’s pour-over, letterpress Schlitz photo booth master cleanse bespoke hashtag chillwave gentrify.',3,'published','2024-03-05 00:56:38','2024-03-05 00:56:38'),(7,'How Can I Cancel Or Change My Order?','Plaid letterpress leggings craft beer meh ethical Pinterest. Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth.',3,'published','2024-03-05 00:56:38','2024-03-05 00:56:38'),(8,'Do I need an account to place an order?','Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY. Cray ugh 3 wolf moon fap, fashion axe irony butcher cornhole typewriter chambray VHS banjo street art.',3,'published','2024-03-05 00:56:38','2024-03-05 00:56:38'),(9,'How Do I Track My Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb @Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level.',3,'published','2024-03-05 00:56:38','2024-03-05 00:56:38'),(10,'How Can I Return a Product?','Kale chips Truffaut Williamsburg, hashtag fixie Pinterest raw denim c hambray drinking vinegar Carles street art Bushwick gastropub. Wolf Tumblr paleo church-key. Plaid food truck Echo Park YOLO bitters hella, direct trade Thundercats leggings quinoa before they sold out. You probably haven’t heard of them wayfarers authentic umami drinking vinegar Pinterest Cosby sweater, fingerstache fap High Life.',3,'published','2024-03-05 00:56:38','2024-03-05 00:56:38');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Radiant Reflections','The master was an immense length of neck, which seemed to be sure, she had found her way into a conversation. \'You don\'t know of any one; so, when the White Rabbit, trotting slowly back again, and.',1,0,'beauty/galleries/1.jpg',1,'published','2024-03-05 00:56:51','2024-03-05 00:56:51'),(2,'Glamour Grove','Rome, and Rome--no, THAT\'S all wrong, I\'m certain! I must go back and see that the pebbles were all talking at once, with a pair of white kid gloves, and she had brought herself down to them, they.',1,0,'beauty/galleries/2.jpg',1,'published','2024-03-05 00:56:51','2024-03-05 00:56:51'),(3,'Serene Styles Showcase','Alice: \'allow me to him: She gave me a pair of white kid gloves in one hand, and a long sleep you\'ve had!\' \'Oh, I\'ve had such a nice soft thing to eat or drink under the sea--\' (\'I haven\'t,\' said.',1,0,'beauty/galleries/3.jpg',1,'published','2024-03-05 00:56:51','2024-03-05 00:56:51'),(4,'Allure Alcove','I say,\' the Mock Turtle recovered his voice, and, with tears again as quickly as she could not answer without a grin,\' thought Alice; but she got up, and reduced the answer to it?\' said the.',1,0,'beauty/galleries/4.jpg',1,'published','2024-03-05 00:56:51','2024-03-05 00:56:51'),(5,'Glamour Galleria','King. The White Rabbit was still in existence; \'and now for the Dormouse,\' thought Alice; \'only, as it\'s asleep, I suppose you\'ll be asleep again before it\'s done.\' \'Once upon a neat little house.',1,0,'beauty/galleries/5.jpg',1,'published','2024-03-05 00:56:51','2024-03-05 00:56:51'),(6,'Beauty Boulevard','Alice to herself. \'Shy, they seem to dry me at home! Why, I haven\'t had a large rabbit-hole under the hedge. In another moment down went Alice like the look of things at all, at all!\' \'Do as I tell.',1,0,'beauty/galleries/6.jpg',1,'published','2024-03-05 00:56:51','2024-03-05 00:56:51');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"beauty\\/galleries\\/1.jpg\",\"description\":\"Then it got down off the top of it. Presently the Rabbit in a low voice, to the conclusion that it might end, you know,\' the Hatter hurriedly left the court, she said to herself, \'it would be QUITE.\"},{\"img\":\"beauty\\/galleries\\/3.jpg\",\"description\":\"Hatter, \'or you\'ll be asleep again before it\'s done.\' \'Once upon a low curtain she had read several nice little histories about children who had got its neck nicely straightened out, and was in.\"},{\"img\":\"beauty\\/galleries\\/4.jpg\",\"description\":\"I\'m grown up now,\' she said, by way of expecting nothing but out-of-the-way things to happen, that it was all ridges and furrows; the balls were live hedgehogs, the mallets live flamingoes, and the.\"},{\"img\":\"beauty\\/galleries\\/2.jpg\",\"description\":\"I hate cats and dogs.\' It was the Duchess\'s voice died away, even in the long hall, and close to her, still it was an immense length of neck, which seemed to Alice with one finger, as he spoke.\"},{\"img\":\"beauty\\/galleries\\/5.jpg\",\"description\":\"Duchess; \'I never said I didn\'t!\' interrupted Alice. \'You did,\' said the Cat, as soon as the door of which was the White Rabbit, trotting slowly back to the croquet-ground. The other side of WHAT?.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:56:51','2024-03-05 00:56:51'),(2,'[{\"img\":\"beauty\\/galleries\\/1.jpg\",\"description\":\"Then it got down off the top of it. Presently the Rabbit in a low voice, to the conclusion that it might end, you know,\' the Hatter hurriedly left the court, she said to herself, \'it would be QUITE.\"},{\"img\":\"beauty\\/galleries\\/3.jpg\",\"description\":\"Hatter, \'or you\'ll be asleep again before it\'s done.\' \'Once upon a low curtain she had read several nice little histories about children who had got its neck nicely straightened out, and was in.\"},{\"img\":\"beauty\\/galleries\\/4.jpg\",\"description\":\"I\'m grown up now,\' she said, by way of expecting nothing but out-of-the-way things to happen, that it was all ridges and furrows; the balls were live hedgehogs, the mallets live flamingoes, and the.\"},{\"img\":\"beauty\\/galleries\\/2.jpg\",\"description\":\"I hate cats and dogs.\' It was the Duchess\'s voice died away, even in the long hall, and close to her, still it was an immense length of neck, which seemed to Alice with one finger, as he spoke.\"},{\"img\":\"beauty\\/galleries\\/5.jpg\",\"description\":\"Duchess; \'I never said I didn\'t!\' interrupted Alice. \'You did,\' said the Cat, as soon as the door of which was the White Rabbit, trotting slowly back to the croquet-ground. The other side of WHAT?.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:56:51','2024-03-05 00:56:51'),(3,'[{\"img\":\"beauty\\/galleries\\/1.jpg\",\"description\":\"Then it got down off the top of it. Presently the Rabbit in a low voice, to the conclusion that it might end, you know,\' the Hatter hurriedly left the court, she said to herself, \'it would be QUITE.\"},{\"img\":\"beauty\\/galleries\\/3.jpg\",\"description\":\"Hatter, \'or you\'ll be asleep again before it\'s done.\' \'Once upon a low curtain she had read several nice little histories about children who had got its neck nicely straightened out, and was in.\"},{\"img\":\"beauty\\/galleries\\/4.jpg\",\"description\":\"I\'m grown up now,\' she said, by way of expecting nothing but out-of-the-way things to happen, that it was all ridges and furrows; the balls were live hedgehogs, the mallets live flamingoes, and the.\"},{\"img\":\"beauty\\/galleries\\/2.jpg\",\"description\":\"I hate cats and dogs.\' It was the Duchess\'s voice died away, even in the long hall, and close to her, still it was an immense length of neck, which seemed to Alice with one finger, as he spoke.\"},{\"img\":\"beauty\\/galleries\\/5.jpg\",\"description\":\"Duchess; \'I never said I didn\'t!\' interrupted Alice. \'You did,\' said the Cat, as soon as the door of which was the White Rabbit, trotting slowly back to the croquet-ground. The other side of WHAT?.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:56:51','2024-03-05 00:56:51'),(4,'[{\"img\":\"beauty\\/galleries\\/1.jpg\",\"description\":\"Then it got down off the top of it. Presently the Rabbit in a low voice, to the conclusion that it might end, you know,\' the Hatter hurriedly left the court, she said to herself, \'it would be QUITE.\"},{\"img\":\"beauty\\/galleries\\/3.jpg\",\"description\":\"Hatter, \'or you\'ll be asleep again before it\'s done.\' \'Once upon a low curtain she had read several nice little histories about children who had got its neck nicely straightened out, and was in.\"},{\"img\":\"beauty\\/galleries\\/4.jpg\",\"description\":\"I\'m grown up now,\' she said, by way of expecting nothing but out-of-the-way things to happen, that it was all ridges and furrows; the balls were live hedgehogs, the mallets live flamingoes, and the.\"},{\"img\":\"beauty\\/galleries\\/2.jpg\",\"description\":\"I hate cats and dogs.\' It was the Duchess\'s voice died away, even in the long hall, and close to her, still it was an immense length of neck, which seemed to Alice with one finger, as he spoke.\"},{\"img\":\"beauty\\/galleries\\/5.jpg\",\"description\":\"Duchess; \'I never said I didn\'t!\' interrupted Alice. \'You did,\' said the Cat, as soon as the door of which was the White Rabbit, trotting slowly back to the croquet-ground. The other side of WHAT?.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:56:51','2024-03-05 00:56:51'),(5,'[{\"img\":\"beauty\\/galleries\\/1.jpg\",\"description\":\"Then it got down off the top of it. Presently the Rabbit in a low voice, to the conclusion that it might end, you know,\' the Hatter hurriedly left the court, she said to herself, \'it would be QUITE.\"},{\"img\":\"beauty\\/galleries\\/3.jpg\",\"description\":\"Hatter, \'or you\'ll be asleep again before it\'s done.\' \'Once upon a low curtain she had read several nice little histories about children who had got its neck nicely straightened out, and was in.\"},{\"img\":\"beauty\\/galleries\\/4.jpg\",\"description\":\"I\'m grown up now,\' she said, by way of expecting nothing but out-of-the-way things to happen, that it was all ridges and furrows; the balls were live hedgehogs, the mallets live flamingoes, and the.\"},{\"img\":\"beauty\\/galleries\\/2.jpg\",\"description\":\"I hate cats and dogs.\' It was the Duchess\'s voice died away, even in the long hall, and close to her, still it was an immense length of neck, which seemed to Alice with one finger, as he spoke.\"},{\"img\":\"beauty\\/galleries\\/5.jpg\",\"description\":\"Duchess; \'I never said I didn\'t!\' interrupted Alice. \'You did,\' said the Cat, as soon as the door of which was the White Rabbit, trotting slowly back to the croquet-ground. The other side of WHAT?.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:56:51','2024-03-05 00:56:51'),(6,'[{\"img\":\"beauty\\/galleries\\/1.jpg\",\"description\":\"Then it got down off the top of it. Presently the Rabbit in a low voice, to the conclusion that it might end, you know,\' the Hatter hurriedly left the court, she said to herself, \'it would be QUITE.\"},{\"img\":\"beauty\\/galleries\\/3.jpg\",\"description\":\"Hatter, \'or you\'ll be asleep again before it\'s done.\' \'Once upon a low curtain she had read several nice little histories about children who had got its neck nicely straightened out, and was in.\"},{\"img\":\"beauty\\/galleries\\/4.jpg\",\"description\":\"I\'m grown up now,\' she said, by way of expecting nothing but out-of-the-way things to happen, that it was all ridges and furrows; the balls were live hedgehogs, the mallets live flamingoes, and the.\"},{\"img\":\"beauty\\/galleries\\/2.jpg\",\"description\":\"I hate cats and dogs.\' It was the Duchess\'s voice died away, even in the long hall, and close to her, still it was an immense length of neck, which seemed to Alice with one finger, as he spoke.\"},{\"img\":\"beauty\\/galleries\\/5.jpg\",\"description\":\"Duchess; \'I never said I didn\'t!\' interrupted Alice. \'You did,\' said the Cat, as soon as the door of which was the White Rabbit, trotting slowly back to the croquet-ground. The other side of WHAT?.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:56:51','2024-03-05 00:56:51');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','3aafa7d3808bb1236aa6ecbd99566622',1,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(2,'en_US','51df674ed9750ffdc160a178e9aeb3fc',1,'Botble\\Menu\\Models\\MenuLocation'),(3,'en_US','fc7f0b58776fa94abb2fe3873c47de7e',1,'Botble\\Menu\\Models\\Menu'),(4,'en_US','4dccb1d75907d5e86607a8186bfa3211',2,'Botble\\Menu\\Models\\Menu'),(5,'en_US','361cd222dafdb01e851f13a50efa5411',3,'Botble\\Menu\\Models\\Menu');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'404','404',2,'image/png',15820,'main/general/404.png','[]','2024-03-05 00:56:36','2024-03-05 00:56:36',NULL),(2,0,'about-1','about-1',2,'image/jpeg',9222,'main/general/about-1.jpg','[]','2024-03-05 00:56:36','2024-03-05 00:56:36',NULL),(3,0,'about-2','about-2',2,'image/jpeg',5105,'main/general/about-2.jpg','[]','2024-03-05 00:56:36','2024-03-05 00:56:36',NULL),(4,0,'cta-shape-1','cta-shape-1',2,'image/png',22860,'main/general/cta-shape-1.png','[]','2024-03-05 00:56:36','2024-03-05 00:56:36',NULL),(5,0,'cta-shape-2','cta-shape-2',2,'image/png',16796,'main/general/cta-shape-2.png','[]','2024-03-05 00:56:36','2024-03-05 00:56:36',NULL),(6,0,'cta-thumb-1','cta-thumb-1',2,'image/jpeg',6053,'main/general/cta-thumb-1.jpg','[]','2024-03-05 00:56:36','2024-03-05 00:56:36',NULL),(7,0,'favicon','favicon',2,'image/png',1831,'main/general/favicon.png','[]','2024-03-05 00:56:36','2024-03-05 00:56:36',NULL),(8,0,'footer-pay','footer-pay',2,'image/png',490,'main/general/footer-pay.png','[]','2024-03-05 00:56:36','2024-03-05 00:56:36',NULL),(9,0,'logo-white','logo-white',2,'image/png',3793,'main/general/logo-white.png','[]','2024-03-05 00:56:36','2024-03-05 00:56:36',NULL),(10,0,'logo','logo',2,'image/png',4122,'main/general/logo.png','[]','2024-03-05 00:56:36','2024-03-05 00:56:36',NULL),(11,0,'preloader-icon','preloader-icon',2,'image/png',4182,'main/general/preloader-icon.png','[]','2024-03-05 00:56:37','2024-03-05 00:56:37',NULL),(12,0,'signature','signature',2,'image/png',2117,'main/general/signature.png','[]','2024-03-05 00:56:37','2024-03-05 00:56:37',NULL),(13,0,'slider-offer','slider-offer',2,'image/png',970,'main/general/slider-offer.png','[]','2024-03-05 00:56:37','2024-03-05 00:56:37',NULL),(24,0,'1','1',4,'image/jpeg',4294,'main/customers/1.jpg','[]','2024-03-05 00:56:38','2024-03-05 00:56:38',NULL),(25,0,'10','10',4,'image/jpeg',4294,'main/customers/10.jpg','[]','2024-03-05 00:56:38','2024-03-05 00:56:38',NULL),(26,0,'2','2',4,'image/jpeg',4294,'main/customers/2.jpg','[]','2024-03-05 00:56:38','2024-03-05 00:56:38',NULL),(27,0,'3','3',4,'image/jpeg',4294,'main/customers/3.jpg','[]','2024-03-05 00:56:38','2024-03-05 00:56:38',NULL),(28,0,'4','4',4,'image/jpeg',4294,'main/customers/4.jpg','[]','2024-03-05 00:56:38','2024-03-05 00:56:38',NULL),(29,0,'5','5',4,'image/jpeg',4294,'main/customers/5.jpg','[]','2024-03-05 00:56:38','2024-03-05 00:56:38',NULL),(30,0,'6','6',4,'image/jpeg',4294,'main/customers/6.jpg','[]','2024-03-05 00:56:38','2024-03-05 00:56:38',NULL),(31,0,'7','7',4,'image/jpeg',4294,'main/customers/7.jpg','[]','2024-03-05 00:56:38','2024-03-05 00:56:38',NULL),(32,0,'8','8',4,'image/jpeg',4294,'main/customers/8.jpg','[]','2024-03-05 00:56:38','2024-03-05 00:56:38',NULL),(33,0,'9','9',4,'image/jpeg',4294,'main/customers/9.jpg','[]','2024-03-05 00:56:38','2024-03-05 00:56:38',NULL),(34,0,'blog-big-1','blog-big-1',5,'image/jpeg',13885,'main/blog/blog-big-1.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(35,0,'blog-details-sm-1','blog-details-sm-1',5,'image/jpeg',8166,'main/blog/blog-details-sm-1.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(36,0,'post-1','post-1',5,'image/jpeg',6189,'main/blog/post-1.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(37,0,'post-10','post-10',5,'image/jpeg',5907,'main/blog/post-10.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(38,0,'post-11','post-11',5,'image/jpeg',5907,'main/blog/post-11.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(39,0,'post-12','post-12',5,'image/jpeg',5907,'main/blog/post-12.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(40,0,'post-2','post-2',5,'image/jpeg',6189,'main/blog/post-2.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(41,0,'post-3','post-3',5,'image/jpeg',6189,'main/blog/post-3.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(42,0,'post-4','post-4',5,'image/jpeg',6045,'main/blog/post-4.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(43,0,'post-5','post-5',5,'image/jpeg',6045,'main/blog/post-5.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(44,0,'post-6','post-6',5,'image/jpeg',6045,'main/blog/post-6.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(45,0,'post-7','post-7',5,'image/jpeg',5907,'main/blog/post-7.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(46,0,'post-8','post-8',5,'image/jpeg',5907,'main/blog/post-8.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(47,0,'post-9','post-9',5,'image/jpeg',5907,'main/blog/post-9.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(48,0,'1','1',3,'image/jpeg',4068,'main/users/1.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(49,0,'10','10',3,'image/jpeg',7599,'main/users/10.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(50,0,'2','2',3,'image/jpeg',7599,'main/users/2.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(51,0,'3','3',3,'image/jpeg',6387,'main/users/3.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(52,0,'4','4',3,'image/jpeg',7599,'main/users/4.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(53,0,'5','5',3,'image/jpeg',6387,'main/users/5.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(54,0,'6','6',3,'image/jpeg',7599,'main/users/6.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(55,0,'7','7',3,'image/jpeg',6387,'main/users/7.jpg','[]','2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(56,0,'8','8',3,'image/jpeg',7599,'main/users/8.jpg','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(57,0,'9','9',3,'image/jpeg',6387,'main/users/9.jpg','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(58,0,'1','1',6,'image/png',9133,'main/stores/1.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(59,0,'10','10',6,'image/png',4263,'main/stores/10.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(60,0,'11','11',6,'image/png',4420,'main/stores/11.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(61,0,'12','12',6,'image/png',4908,'main/stores/12.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(62,0,'13','13',6,'image/png',3441,'main/stores/13.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(63,0,'14','14',6,'image/png',4209,'main/stores/14.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(64,0,'15','15',6,'image/png',5113,'main/stores/15.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(65,0,'16','16',6,'image/png',4563,'main/stores/16.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(66,0,'17','17',6,'image/png',4896,'main/stores/17.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(67,0,'2','2',6,'image/png',9008,'main/stores/2.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(68,0,'3','3',6,'image/png',8006,'main/stores/3.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(69,0,'4','4',6,'image/png',8728,'main/stores/4.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(70,0,'5','5',6,'image/png',10689,'main/stores/5.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(71,0,'6','6',6,'image/png',10989,'main/stores/6.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(72,0,'7','7',6,'image/png',3730,'main/stores/7.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(73,0,'8','8',6,'image/png',4030,'main/stores/8.png','[]','2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(74,0,'9','9',6,'image/png',3810,'main/stores/9.png','[]','2024-03-05 00:56:43','2024-03-05 00:56:43',NULL),(75,0,'cover-1','cover-1',6,'image/png',4208,'main/stores/cover-1.png','[]','2024-03-05 00:56:43','2024-03-05 00:56:43',NULL),(76,0,'cover-2','cover-2',6,'image/png',8798,'main/stores/cover-2.png','[]','2024-03-05 00:56:43','2024-03-05 00:56:43',NULL),(77,0,'cover-3','cover-3',6,'image/png',3888,'main/stores/cover-3.png','[]','2024-03-05 00:56:43','2024-03-05 00:56:43',NULL),(78,0,'cover-4','cover-4',6,'image/png',11893,'main/stores/cover-4.png','[]','2024-03-05 00:56:43','2024-03-05 00:56:43',NULL),(79,0,'cover-5','cover-5',6,'image/png',8798,'main/stores/cover-5.png','[]','2024-03-05 00:56:43','2024-03-05 00:56:43',NULL),(80,0,'slider-1','slider-1',8,'image/jpeg',27493,'beauty/sliders/slider-1.jpg','[]','2024-03-05 00:56:45','2024-03-05 00:56:45',NULL),(81,0,'slider-2','slider-2',8,'image/jpeg',27493,'beauty/sliders/slider-2.jpg','[]','2024-03-05 00:56:45','2024-03-05 00:56:45',NULL),(82,0,'slider-3','slider-3',8,'image/jpeg',27493,'beauty/sliders/slider-3.jpg','[]','2024-03-05 00:56:45','2024-03-05 00:56:45',NULL),(83,0,'1','1',9,'image/jpeg',4294,'beauty/product-categories/1.jpg','[]','2024-03-05 00:56:45','2024-03-05 00:56:45',NULL),(84,0,'2','2',9,'image/jpeg',4294,'beauty/product-categories/2.jpg','[]','2024-03-05 00:56:45','2024-03-05 00:56:45',NULL),(85,0,'3','3',9,'image/jpeg',4294,'beauty/product-categories/3.jpg','[]','2024-03-05 00:56:45','2024-03-05 00:56:45',NULL),(86,0,'4','4',9,'image/jpeg',4294,'beauty/product-categories/4.jpg','[]','2024-03-05 00:56:45','2024-03-05 00:56:45',NULL),(87,0,'product-1','product-1',10,'image/png',9803,'beauty/products/product-1.png','[]','2024-03-05 00:56:46','2024-03-05 00:56:46',NULL),(88,0,'product-2','product-2',10,'image/png',9803,'beauty/products/product-2.png','[]','2024-03-05 00:56:46','2024-03-05 00:56:46',NULL),(89,0,'product-3','product-3',10,'image/png',9803,'beauty/products/product-3.png','[]','2024-03-05 00:56:46','2024-03-05 00:56:46',NULL),(90,0,'product-4','product-4',10,'image/png',9803,'beauty/products/product-4.png','[]','2024-03-05 00:56:46','2024-03-05 00:56:46',NULL),(91,0,'product-5','product-5',10,'image/png',9803,'beauty/products/product-5.png','[]','2024-03-05 00:56:46','2024-03-05 00:56:46',NULL),(92,0,'product-6','product-6',10,'image/png',9803,'beauty/products/product-6.png','[]','2024-03-05 00:56:46','2024-03-05 00:56:46',NULL),(93,0,'product-7','product-7',10,'image/png',9803,'beauty/products/product-7.png','[]','2024-03-05 00:56:46','2024-03-05 00:56:46',NULL),(94,0,'product-8','product-8',10,'image/png',9803,'beauty/products/product-8.png','[]','2024-03-05 00:56:46','2024-03-05 00:56:46',NULL),(95,0,'1','1',11,'image/jpeg',4294,'beauty/galleries/1.jpg','[]','2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(96,0,'2','2',11,'image/jpeg',4294,'beauty/galleries/2.jpg','[]','2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(97,0,'3','3',11,'image/jpeg',4294,'beauty/galleries/3.jpg','[]','2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(98,0,'4','4',11,'image/jpeg',4294,'beauty/galleries/4.jpg','[]','2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(99,0,'5','5',11,'image/jpeg',4294,'beauty/galleries/5.jpg','[]','2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(100,0,'6','6',11,'image/jpeg',4294,'beauty/galleries/6.jpg','[]','2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(101,0,'instagram-1','instagram-1',11,'image/jpeg',4294,'beauty/galleries/instagram-1.jpg','[]','2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(102,0,'instagram-2','instagram-2',11,'image/jpeg',4294,'beauty/galleries/instagram-2.jpg','[]','2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(103,0,'instagram-3','instagram-3',11,'image/jpeg',4294,'beauty/galleries/instagram-3.jpg','[]','2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(104,0,'instagram-4','instagram-4',11,'image/jpeg',4294,'beauty/galleries/instagram-4.jpg','[]','2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(105,0,'instagram-5','instagram-5',11,'image/jpeg',4294,'beauty/galleries/instagram-5.jpg','[]','2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(106,0,'instagram-6','instagram-6',11,'image/jpeg',4294,'beauty/galleries/instagram-6.jpg','[]','2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(107,0,'icon-1','icon-1',12,'image/png',4469,'main/contact/icon-1.png','[]','2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(108,0,'icon-2','icon-2',12,'image/png',5977,'main/contact/icon-2.png','[]','2024-03-05 00:56:52','2024-03-05 00:56:52',NULL),(109,0,'icon-3','icon-3',12,'image/png',6082,'main/contact/icon-3.png','[]','2024-03-05 00:56:52','2024-03-05 00:56:52',NULL),(110,0,'line','line',13,'image/png',6152,'main/shapes/line.png','[]','2024-03-05 00:56:52','2024-03-05 00:56:52',NULL),(111,0,'quote','quote',13,'image/png',595,'main/shapes/quote.png','[]','2024-03-05 00:56:52','2024-03-05 00:56:52',NULL);
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2024-03-05 00:56:36','2024-03-05 00:56:36',NULL),(2,0,'general',NULL,'general',1,'2024-03-05 00:56:36','2024-03-05 00:56:36',NULL),(3,0,'users',NULL,'users',1,'2024-03-05 00:56:37','2024-03-05 00:56:37',NULL),(4,0,'customers',NULL,'customers',1,'2024-03-05 00:56:38','2024-03-05 00:56:38',NULL),(5,0,'blog',NULL,'blog',1,'2024-03-05 00:56:41','2024-03-05 00:56:41',NULL),(6,0,'stores',NULL,'stores',1,'2024-03-05 00:56:42','2024-03-05 00:56:42',NULL),(7,0,'beauty',NULL,'beauty',0,'2024-03-05 00:56:45','2024-03-05 00:56:45',NULL),(8,0,'sliders',NULL,'sliders',7,'2024-03-05 00:56:45','2024-03-05 00:56:45',NULL),(9,0,'product-categories',NULL,'product-categories',7,'2024-03-05 00:56:45','2024-03-05 00:56:45',NULL),(10,0,'products',NULL,'products',7,'2024-03-05 00:56:46','2024-03-05 00:56:46',NULL),(11,0,'galleries',NULL,'galleries',7,'2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(12,0,'contact',NULL,'contact',1,'2024-03-05 00:56:51','2024-03-05 00:56:51',NULL),(13,0,'shapes',NULL,'shapes',1,'2024-03-05 00:56:52','2024-03-05 00:56:52',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2024-03-05 00:56:52','2024-03-05 00:56:52');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,1,'Botble\\Page\\Models\\Page','/home',NULL,0,'Home',NULL,'_self',1,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(2,1,1,NULL,NULL,'https://shofy.botble.com',NULL,0,'Electronics',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(3,1,1,NULL,NULL,'https://shofy-fashion.botble.com',NULL,0,'Fashion',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(4,1,1,NULL,NULL,'https://shofy-beauty.botble.com',NULL,0,'Beauty',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(5,1,1,NULL,NULL,'https://shofy-jewelry.botble.com',NULL,0,'Jewelry',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(6,1,1,NULL,NULL,'https://shofy-grocery.botble.com',NULL,0,'Grocery',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(7,1,0,NULL,NULL,NULL,NULL,0,'Shop',NULL,'_self',1,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(8,1,7,2,'Botble\\Page\\Models\\Page','/product-categories',NULL,0,'Shop Categories',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(9,1,7,NULL,NULL,'/products?layout=list',NULL,0,'Shop List',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(10,1,7,NULL,NULL,'/products?layout=grid',NULL,0,'Shop Grid',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(11,1,7,NULL,NULL,'/products/high-waisted-wide-leg-trousers',NULL,0,'Product Detail',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(12,1,7,3,'Botble\\Page\\Models\\Page','/coupons',NULL,0,'Grab Coupons',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(13,1,7,NULL,NULL,'/cart',NULL,0,'Cart',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(14,1,7,NULL,NULL,'/compare',NULL,0,'Compare',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(15,1,7,NULL,NULL,'/wishlist',NULL,0,'Wishlist',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(16,1,7,NULL,NULL,'/orders/tracking',NULL,0,'Track Your Order',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(17,1,0,NULL,NULL,'/stores',NULL,0,'Vendors',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(18,1,0,NULL,NULL,NULL,NULL,0,'Pages',NULL,'_self',1,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(19,1,18,NULL,NULL,'/login',NULL,0,'Login',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(20,1,18,NULL,NULL,'/register',NULL,0,'Register',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(21,1,18,NULL,NULL,'/password/reset',NULL,0,'Forgot Password',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(22,1,18,NULL,NULL,'/404',NULL,0,'404 Error',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(23,1,0,5,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Blog',NULL,'_self',1,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(24,1,23,NULL,NULL,'/blog?layout=grid',NULL,0,'Blog Grid',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(25,1,23,NULL,NULL,'/blog?layout=list',NULL,0,'Blog List',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(26,1,23,NULL,NULL,'/blog/heres-the-first-valentinos-new-makeup-collection',NULL,0,'Blog Detail',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(27,1,0,6,'Botble\\Page\\Models\\Page','/contact',NULL,0,'Contact',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(28,2,0,NULL,NULL,'/orders/tracking',NULL,1,'Track Orders',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(29,2,0,10,'Botble\\Page\\Models\\Page','/shipping',NULL,1,'Shipping',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(30,2,0,NULL,NULL,'/wishlist',NULL,1,'Wishlist',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(31,2,0,NULL,NULL,'/customer/overview',NULL,1,'My Account',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(32,2,0,NULL,NULL,'/customer/orders',NULL,1,'Order History',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(33,2,0,NULL,NULL,'/customer/order-returns',NULL,1,'Returns',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(34,3,0,8,'Botble\\Page\\Models\\Page','/our-story',NULL,2,'Our Story',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(35,3,0,9,'Botble\\Page\\Models\\Page','/careers',NULL,2,'Careers',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(36,3,0,7,'Botble\\Page\\Models\\Page','/cookie-policy',NULL,2,'Privacy Policy',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(37,3,0,NULL,NULL,'/blog',NULL,2,'Latest News',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52'),(38,3,0,6,'Botble\\Page\\Models\\Page','/contact',NULL,2,'Contact Us',NULL,'_self',0,'2024-03-05 00:56:52','2024-03-05 00:56:52');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2024-03-05 00:56:52','2024-03-05 00:56:52'),(2,'My Account','my-account','published','2024-03-05 00:56:52','2024-03-05 00:56:52'),(3,'Information','information','published','2024-03-05 00:56:52','2024-03-05 00:56:52');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'background','[\"main\\/stores\\/cover-2.png\"]',1,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(2,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',1,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(3,'background','[\"main\\/stores\\/cover-2.png\"]',2,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(4,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',2,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(5,'background','[\"main\\/stores\\/cover-3.png\"]',3,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(6,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',3,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(7,'background','[\"main\\/stores\\/cover-1.png\"]',4,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(8,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',4,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(9,'background','[\"main\\/stores\\/cover-2.png\"]',5,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(10,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',5,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(11,'background','[\"main\\/stores\\/cover-4.png\"]',6,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(12,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',6,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(13,'background','[\"main\\/stores\\/cover-2.png\"]',7,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(14,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',7,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(15,'background','[\"main\\/stores\\/cover-1.png\"]',8,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(16,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',8,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:45','2024-03-05 00:56:45'),(17,'button_label','[\"Shop Collection\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-05 00:56:45','2024-03-05 00:56:45'),(18,'button_label','[\"Shop Collection\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-05 00:56:45','2024-03-05 00:56:45'),(19,'button_label','[\"Shop Collection\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-05 00:56:45','2024-03-05 00:56:45'),(20,'faq_ids','[[2,4,5,7,9]]',1,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(21,'faq_ids','[[4,6,7,8,10]]',2,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(22,'faq_ids','[[1,2,5,6,7]]',3,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(23,'faq_ids','[[4,5,7,8,9]]',4,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(24,'faq_ids','[[1,2,3,5,7]]',5,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(25,'faq_ids','[[1,2,5,6,8]]',6,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(26,'faq_ids','[[1,3,6,7,8]]',7,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(27,'faq_ids','[[1,3,4,8,9]]',8,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(28,'faq_ids','[[1,3,5,7,8]]',9,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(29,'faq_ids','[[1,2,5,7,9]]',10,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(30,'faq_ids','[[1,3,5,6,10]]',11,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(31,'faq_ids','[[1,4,6,9,10]]',12,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(32,'faq_ids','[[2,4,7,9,10]]',13,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(33,'faq_ids','[[1,2,3,5,9]]',14,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(34,'faq_ids','[[4,6,7,8,10]]',15,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(35,'faq_ids','[[3,6,7,8,9]]',16,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(36,'faq_ids','[[2,3,5,8,10]]',17,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(37,'faq_ids','[[1,2,4,5,7]]',18,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(38,'faq_ids','[[1,2,3,7,10]]',19,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(39,'faq_ids','[[4,5,6,7,8]]',20,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(40,'faq_ids','[[2,3,6,8,9]]',21,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:46','2024-03-05 00:56:46'),(41,'faq_ids','[[1,2,3,5,7]]',22,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(42,'faq_ids','[[1,2,3,7,10]]',23,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(43,'faq_ids','[[3,7,8,9,10]]',24,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(44,'faq_ids','[[1,3,6,7,10]]',25,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(45,'faq_ids','[[2,3,6,7,9]]',26,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(46,'faq_ids','[[1,3,5,9,10]]',27,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(47,'faq_ids','[[1,3,4,5,8]]',28,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(48,'faq_ids','[[3,4,5,6,8]]',29,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(49,'faq_ids','[[3,6,7,8,9]]',30,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(50,'faq_ids','[[1,4,6,8,10]]',31,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(51,'faq_ids','[[3,4,7,8,10]]',32,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(52,'faq_ids','[[2,3,4,6,7]]',33,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(53,'faq_ids','[[1,4,5,7,8]]',34,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(54,'faq_ids','[[1,4,6,9,10]]',35,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(55,'faq_ids','[[2,5,6,7,10]]',36,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(56,'faq_ids','[[1,2,3,9,10]]',37,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(57,'faq_ids','[[1,2,7,8,9]]',38,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(58,'faq_ids','[[2,3,4,9,10]]',39,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(59,'faq_ids','[[3,4,5,7,10]]',40,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(60,'faq_ids','[[1,4,8,9,10]]',41,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(61,'faq_ids','[[1,4,7,8,9]]',42,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(62,'faq_ids','[[1,4,6,8,10]]',43,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:47','2024-03-05 00:56:47'),(63,'breadcrumb_style','[\"none\"]',1,'Botble\\Page\\Models\\Page','2024-03-05 00:56:52','2024-03-05 00:56:52'),(64,'breadcrumb_style','[\"align-start\"]',2,'Botble\\Page\\Models\\Page','2024-03-05 00:56:52','2024-03-05 00:56:52');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=173 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2013_04_09_032329_create_base_tables',1),(2,'2013_04_09_062329_create_revisions_table',1),(3,'2014_10_12_000000_create_users_table',1),(4,'2014_10_12_100000_create_password_reset_tokens_table',1),(5,'2015_06_18_033822_create_blog_table',1),(6,'2015_06_29_025744_create_audit_history',1),(7,'2016_05_28_112028_create_system_request_logs_table',1),(8,'2016_06_10_230148_create_acl_tables',1),(9,'2016_06_14_230857_create_menus_table',1),(10,'2016_06_17_091537_create_contacts_table',1),(11,'2016_06_28_221418_create_pages_table',1),(12,'2016_10_03_032336_create_languages_table',1),(13,'2016_10_05_074239_create_setting_table',1),(14,'2016_10_07_193005_create_translations_table',1),(15,'2016_10_13_150201_create_galleries_table',1),(16,'2016_11_28_032840_create_dashboard_widget_tables',1),(17,'2016_12_16_084601_create_widgets_table',1),(18,'2017_05_09_070343_create_media_tables',1),(19,'2017_05_18_080441_create_payment_tables',1),(20,'2017_07_11_140018_create_simple_slider_table',1),(21,'2017_10_24_154832_create_newsletter_table',1),(22,'2017_11_03_070450_create_slug_table',1),(23,'2018_07_09_214610_create_testimonial_table',1),(24,'2018_07_09_221238_create_faq_table',1),(25,'2019_01_05_053554_create_jobs_table',1),(26,'2019_08_19_000000_create_failed_jobs_table',1),(27,'2019_11_18_061011_create_country_table',1),(28,'2019_12_14_000001_create_personal_access_tokens_table',1),(29,'2020_03_05_041139_create_ecommerce_tables',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_01_01_044147_ecommerce_create_flash_sale_table',1),(32,'2021_01_17_082713_add_column_is_featured_to_product_collections_table',1),(33,'2021_01_18_024333_add_zip_code_into_table_customer_addresses',1),(34,'2021_02_16_092633_remove_default_value_for_author_type',1),(35,'2021_02_18_073505_update_table_ec_reviews',1),(36,'2021_03_10_024419_add_column_confirmed_at_to_table_ec_customers',1),(37,'2021_03_10_025153_change_column_tax_amount',1),(38,'2021_03_20_033103_add_column_availability_to_table_ec_products',1),(39,'2021_03_27_144913_add_customer_type_into_table_payments',1),(40,'2021_04_28_074008_ecommerce_create_product_label_table',1),(41,'2021_05_24_034720_make_column_currency_nullable',1),(42,'2021_05_31_173037_ecommerce_create_ec_products_translations',1),(43,'2021_07_06_030002_create_marketplace_table',1),(44,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(45,'2021_08_17_105016_remove_column_currency_id_in_some_tables',1),(46,'2021_08_30_142128_add_images_column_to_ec_reviews_table',1),(47,'2021_09_04_150137_add_vendor_verified_at_to_ec_customers_table',1),(48,'2021_10_04_030050_add_column_created_by_to_table_ec_products',1),(49,'2021_10_04_033903_add_column_approved_by_into_table_ec_products',1),(50,'2021_10_05_122616_add_status_column_to_ec_customers_table',1),(51,'2021_10_06_124943_add_transaction_id_column_to_mp_customer_withdrawals_table',1),(52,'2021_10_10_054216_add_columns_to_mp_customer_revenues_table',1),(53,'2021_10_19_020859_update_metadata_field',1),(54,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(55,'2021_11_03_025806_nullable_phone_number_in_ec_customer_addresses',1),(56,'2021_11_23_071403_correct_languages_for_product_variations',1),(57,'2021_11_28_031808_add_product_tags_translations',1),(58,'2021_12_01_031123_add_featured_image_to_ec_products',1),(59,'2021_12_02_035301_add_ads_translations_table',1),(60,'2021_12_03_030600_create_blog_translations',1),(61,'2021_12_03_075608_create_page_translations',1),(62,'2021_12_03_082134_create_faq_translations',1),(63,'2021_12_03_082953_create_gallery_translations',1),(64,'2021_12_03_083642_create_testimonials_translations',1),(65,'2021_12_03_084118_create_location_translations',1),(66,'2021_12_03_094518_migrate_old_location_data',1),(67,'2021_12_06_031304_update_table_mp_customer_revenues',1),(68,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(69,'2022_01_01_033107_update_table_ec_shipments',1),(70,'2022_01_16_085908_improve_plugin_location',1),(71,'2022_02_16_042457_improve_product_attribute_sets',1),(72,'2022_03_22_075758_correct_product_name',1),(73,'2022_04_19_113334_add_index_to_ec_products',1),(74,'2022_04_19_113923_add_index_to_table_posts',1),(75,'2022_04_20_100851_add_index_to_media_table',1),(76,'2022_04_20_101046_add_index_to_menu_table',1),(77,'2022_04_28_144405_remove_unused_table',1),(78,'2022_04_30_034048_create_gallery_meta_translations_table',1),(79,'2022_05_05_115015_create_ec_customer_recently_viewed_products_table',1),(80,'2022_05_18_143720_add_index_to_table_ec_product_categories',1),(81,'2022_06_16_095633_add_index_to_some_tables',1),(82,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(83,'2022_06_30_035148_create_order_referrals_table',1),(84,'2022_07_07_153354_update_charge_id_in_table_payments',1),(85,'2022_07_10_034813_move_lang_folder_to_root',1),(86,'2022_07_24_153815_add_completed_at_to_ec_orders_table',1),(87,'2022_08_04_051940_add_missing_column_expires_at',1),(88,'2022_08_04_052122_delete_location_backup_tables',1),(89,'2022_08_14_032836_create_ec_order_returns_table',1),(90,'2022_08_14_033554_create_ec_order_return_items_table',1),(91,'2022_08_15_040324_add_billing_address',1),(92,'2022_08_30_091114_support_digital_products_table',1),(93,'2022_09_01_000001_create_admin_notifications_tables',1),(94,'2022_09_13_095744_create_options_table',1),(95,'2022_09_13_104347_create_option_value_table',1),(96,'2022_10_05_163518_alter_table_ec_order_product',1),(97,'2022_10_12_041517_create_invoices_table',1),(98,'2022_10_12_142226_update_orders_table',1),(99,'2022_10_13_024916_update_table_order_returns',1),(100,'2022_10_14_024629_drop_column_is_featured',1),(101,'2022_10_19_152916_add_columns_to_mp_stores_table',1),(102,'2022_10_20_062849_create_mp_category_sale_commissions_table',1),(103,'2022_10_21_030830_update_columns_in_ec_shipments_table',1),(104,'2022_10_28_021046_update_columns_in_ec_shipments_table',1),(105,'2022_11_02_071413_add_more_info_for_store',1),(106,'2022_11_02_080444_add_tax_info',1),(107,'2022_11_16_034522_update_type_column_in_ec_shipping_rules_table',1),(108,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(109,'2022_11_19_041643_add_ec_tax_product_table',1),(110,'2022_12_02_093615_update_slug_index_columns',1),(111,'2022_12_12_063830_update_tax_defadult_in_ec_tax_products_table',1),(112,'2022_12_17_041532_fix_address_in_order_invoice',1),(113,'2022_12_26_070329_create_ec_product_views_table',1),(114,'2023_01_04_033051_fix_product_categories',1),(115,'2023_01_09_050400_add_ec_global_options_translations_table',1),(116,'2023_01_10_093754_add_missing_option_value_id',1),(117,'2023_01_17_082713_add_column_barcode_and_cost_per_item_to_product_table',1),(118,'2023_01_26_021854_add_ec_customer_used_coupons_table',1),(119,'2023_01_30_024431_add_alt_to_media_table',1),(120,'2023_02_01_062030_add_store_translations',1),(121,'2023_02_08_015900_update_options_column_in_ec_order_product_table',1),(122,'2023_02_13_032133_update_fee_column_mp_customer_revenues_table',1),(123,'2023_02_16_042611_drop_table_password_resets',1),(124,'2023_02_17_023648_fix_store_prefix',1),(125,'2023_02_27_095752_remove_duplicate_reviews',1),(126,'2023_03_20_115757_add_user_type_column_to_ec_shipment_histories_table',1),(127,'2023_04_17_062645_add_open_in_new_tab',1),(128,'2023_04_21_082427_create_ec_product_categorizables_table',1),(129,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(130,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(131,'2023_05_03_011331_add_missing_column_price_into_invoice_items_table',1),(132,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(133,'2023_05_17_025812_fix_invoice_issue',1),(134,'2023_05_26_073140_move_option_make_phone_field_optional_at_checkout_page_to_mandatory_fields',1),(135,'2023_05_27_144611_fix_exchange_rate_setting',1),(136,'2023_06_22_084331_add_generate_license_code_to_ec_products_table',1),(137,'2023_06_30_042512_create_ec_order_tax_information_table',1),(138,'2023_07_06_011444_create_slug_translations_table',1),(139,'2023_07_14_022724_remove_column_id_from_ec_product_collection_products',1),(140,'2023_07_26_041451_add_more_columns_to_location_table',1),(141,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(142,'2023_08_09_012940_remove_column_status_in_ec_product_attributes',1),(143,'2023_08_11_060908_create_announcements_table',1),(144,'2023_08_15_064505_create_ec_tax_rules_table',1),(145,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(146,'2023_08_21_021819_make_column_address_in_ec_customer_addresses_nullable',1),(147,'2023_08_21_090810_make_page_content_nullable',1),(148,'2023_08_22_094114_drop_unique_for_barcode',1),(149,'2023_08_29_074620_make_column_author_id_nullable',1),(150,'2023_08_29_075308_make_column_user_id_nullable',1),(151,'2023_08_30_031811_add_apply_via_url_column_to_ec_discounts_table',1),(152,'2023_09_07_094312_add_index_to_product_sku_and_translations',1),(153,'2023_09_14_021936_update_index_for_slugs_table',1),(154,'2023_09_14_022423_add_index_for_language_table',1),(155,'2023_09_19_024955_create_discount_product_categories_table',1),(156,'2023_10_17_070728_add_icon_and_icon_image_to_product_categories_table',1),(157,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(158,'2023_11_07_023805_add_tablet_mobile_image',1),(159,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(160,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(161,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(162,'2023_11_22_154643_add_unique_in_table_ec_products_variations',1),(163,'2023_11_27_032313_add_price_columns_to_ec_product_cross_sale_relations_table',1),(164,'2023_12_06_023945_add_display_on_checkout_column_to_ec_discounts_table',1),(165,'2023_12_06_100448_change_random_hash_for_media',1),(166,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(167,'2023_12_12_105220_drop_translations_table',1),(168,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(169,'2023_12_25_040604_ec_create_review_replies_table',1),(170,'2023_12_26_090340_add_private_notes_column_to_ec_customers_table',1),(171,'2024_01_16_070706_fix_translation_tables',1),(172,'2024_01_23_075227_add_proof_file_to_ec_orders_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_category_sale_commissions`
--

DROP TABLE IF EXISTS `mp_category_sale_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_category_sale_commissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_category_id` bigint unsigned NOT NULL,
  `commission_percentage` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mp_category_sale_commissions_product_category_id_unique` (`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_category_sale_commissions`
--

LOCK TABLES `mp_category_sale_commissions` WRITE;
/*!40000 ALTER TABLE `mp_category_sale_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_category_sale_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_revenues`
--

DROP TABLE IF EXISTS `mp_customer_revenues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_revenues` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `sub_amount` decimal(15,2) DEFAULT '0.00',
  `fee` decimal(15,2) DEFAULT '0.00',
  `amount` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_revenues`
--

LOCK TABLES `mp_customer_revenues` WRITE;
/*!40000 ALTER TABLE `mp_customer_revenues` DISABLE KEYS */;
INSERT INTO `mp_customer_revenues` VALUES (1,3,1,2420.00,0.00,2420.00,0.00,'USD',NULL,'2024-03-03 08:57:03','2024-03-03 08:57:03',0,'add-amount'),(2,1,4,7338.00,0.00,7338.00,0.00,'USD',NULL,'2024-03-03 08:57:03','2024-03-03 08:57:03',0,'add-amount'),(3,1,9,6657.00,0.00,6657.00,7338.00,'USD',NULL,'2024-03-04 04:57:04','2024-03-04 04:57:04',0,'add-amount'),(4,2,15,880.00,0.00,880.00,0.00,'USD',NULL,'2024-02-22 00:57:04','2024-02-22 00:57:04',0,'add-amount'),(5,4,18,830.00,0.00,830.00,0.00,'USD',NULL,'2024-02-24 12:57:05','2024-02-24 12:57:05',0,'add-amount'),(6,6,19,3322.00,0.00,3322.00,0.00,'USD',NULL,'2024-02-25 16:57:05','2024-02-25 16:57:05',0,'add-amount'),(7,4,23,6198.00,0.00,6198.00,830.00,'USD',NULL,'2024-02-26 00:57:06','2024-02-26 00:57:06',0,'add-amount'),(8,4,25,1660.00,0.00,1660.00,7028.00,'USD',NULL,'2024-02-29 16:57:06','2024-02-29 16:57:06',0,'add-amount'),(9,6,28,3806.00,0.00,3806.00,3322.00,'USD',NULL,'2024-02-19 12:57:07','2024-02-19 12:57:07',0,'add-amount'),(10,2,33,880.00,0.00,880.00,880.00,'USD',NULL,'2024-02-11 08:57:07','2024-02-11 08:57:07',0,'add-amount'),(11,2,38,7222.00,0.00,7222.00,1760.00,'USD',NULL,'2024-02-08 00:57:08','2024-02-08 00:57:08',0,'add-amount'),(12,1,39,3141.00,0.00,3141.00,13995.00,'USD',NULL,'2024-02-24 00:57:09','2024-02-24 00:57:09',0,'add-amount'),(13,6,41,904.00,0.00,904.00,7128.00,'USD',NULL,'2024-03-01 12:57:09','2024-03-01 12:57:09',0,'add-amount'),(14,8,42,1976.00,0.00,1976.00,0.00,'USD',NULL,'2024-02-12 12:57:10','2024-02-12 12:57:10',0,'add-amount'),(15,7,45,5628.00,0.00,5628.00,0.00,'USD',NULL,'2024-02-18 16:57:10','2024-02-18 16:57:10',0,'add-amount'),(16,7,50,1876.00,0.00,1876.00,5628.00,'USD',NULL,'2024-02-08 12:57:11','2024-02-08 12:57:11',0,'add-amount'),(17,2,54,3854.00,0.00,3854.00,8982.00,'USD',NULL,'2024-01-23 18:57:11','2024-01-23 18:57:11',0,'add-amount');
/*!40000 ALTER TABLE `mp_customer_revenues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_withdrawals`
--

DROP TABLE IF EXISTS `mp_customer_withdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_withdrawals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `fee` decimal(15,2) unsigned DEFAULT '0.00',
  `amount` decimal(15,2) unsigned DEFAULT '0.00',
  `current_balance` decimal(15,2) unsigned DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `images` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `transaction_id` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_withdrawals`
--

LOCK TABLES `mp_customer_withdrawals` WRITE;
/*!40000 ALTER TABLE `mp_customer_withdrawals` DISABLE KEYS */;
INSERT INTO `mp_customer_withdrawals` VALUES (1,1,0.00,1668.00,17136.00,'USD','','{\"name\":\"Prof. Jennyfer Trantow DVM\",\"number\":\"+13348878973\",\"full_name\":\"Ford Williamson\",\"description\":\"Ayana Huel Sr.\"}',NULL,0,'pending',NULL,'2024-03-05 00:57:12','2024-03-05 00:57:12',NULL),(2,1,0.00,4892.00,15468.00,'USD','','{\"name\":\"Prof. Jennyfer Trantow DVM\",\"number\":\"+13348878973\",\"full_name\":\"Ford Williamson\",\"description\":\"Ayana Huel Sr.\"}',NULL,0,'processing',NULL,'2024-03-05 00:57:12','2024-03-05 00:57:12',NULL),(3,1,0.00,2435.00,10576.00,'USD','','{\"name\":\"Prof. Jennyfer Trantow DVM\",\"number\":\"+13348878973\",\"full_name\":\"Ford Williamson\",\"description\":\"Ayana Huel Sr.\"}',NULL,0,'completed',NULL,'2024-03-05 00:57:13','2024-03-05 00:57:13',NULL),(4,2,0.00,1893.00,12836.00,'USD','','{\"name\":\"Hiram Dare\",\"number\":\"+14633961980\",\"full_name\":\"June Trantow\",\"description\":\"Marcel Lemke DDS\"}',NULL,0,'completed',NULL,'2024-03-05 00:57:13','2024-03-05 00:57:13',NULL),(5,2,0.00,853.00,10943.00,'USD','','{\"name\":\"Hiram Dare\",\"number\":\"+14633961980\",\"full_name\":\"June Trantow\",\"description\":\"Marcel Lemke DDS\"}',NULL,0,'pending',NULL,'2024-03-05 00:57:14','2024-03-05 00:57:14',NULL),(6,2,0.00,1908.00,10090.00,'USD','','{\"name\":\"Hiram Dare\",\"number\":\"+14633961980\",\"full_name\":\"June Trantow\",\"description\":\"Marcel Lemke DDS\"}',NULL,0,'completed',NULL,'2024-03-05 00:57:14','2024-03-05 00:57:14',NULL),(7,2,0.00,264.00,8182.00,'USD','','{\"name\":\"Hiram Dare\",\"number\":\"+14633961980\",\"full_name\":\"June Trantow\",\"description\":\"Marcel Lemke DDS\"}',NULL,0,'processing',NULL,'2024-03-05 00:57:15','2024-03-05 00:57:15',NULL),(8,3,0.00,101.00,2420.00,'USD','','{\"name\":\"Greta Ebert\",\"number\":\"+12392619300\",\"full_name\":\"Kade Swift\",\"description\":\"Wyman Haley\"}',NULL,0,'processing',NULL,'2024-03-05 00:57:15','2024-03-05 00:57:15',NULL),(9,3,0.00,301.00,2319.00,'USD','','{\"name\":\"Greta Ebert\",\"number\":\"+12392619300\",\"full_name\":\"Kade Swift\",\"description\":\"Wyman Haley\"}',NULL,0,'completed',NULL,'2024-03-05 00:57:16','2024-03-05 00:57:16',NULL),(10,3,0.00,270.00,2018.00,'USD','','{\"name\":\"Greta Ebert\",\"number\":\"+12392619300\",\"full_name\":\"Kade Swift\",\"description\":\"Wyman Haley\"}',NULL,0,'completed',NULL,'2024-03-05 00:57:16','2024-03-05 00:57:16',NULL),(11,4,0.00,2766.00,8688.00,'USD','','{\"name\":\"Dr. Juliana Auer DVM\",\"number\":\"+18586631327\",\"full_name\":\"Prof. Cali Russel\",\"description\":\"Moriah Ratke\"}',NULL,0,'pending',NULL,'2024-03-05 00:57:17','2024-03-05 00:57:17',NULL),(12,4,0.00,1492.00,5922.00,'USD','','{\"name\":\"Dr. Juliana Auer DVM\",\"number\":\"+18586631327\",\"full_name\":\"Prof. Cali Russel\",\"description\":\"Moriah Ratke\"}',NULL,0,'processing',NULL,'2024-03-05 00:57:17','2024-03-05 00:57:17',NULL),(13,4,0.00,1357.00,4430.00,'USD','','{\"name\":\"Dr. Juliana Auer DVM\",\"number\":\"+18586631327\",\"full_name\":\"Prof. Cali Russel\",\"description\":\"Moriah Ratke\"}',NULL,0,'completed',NULL,'2024-03-05 00:57:18','2024-03-05 00:57:18',NULL),(14,6,0.00,169.00,8032.00,'USD','','{\"name\":\"Hester Wilderman\",\"number\":\"+19495984564\",\"full_name\":\"Kareem Simonis\",\"description\":\"Vella Schneider\"}',NULL,0,'processing',NULL,'2024-03-05 00:57:18','2024-03-05 00:57:18',NULL),(15,6,0.00,2222.00,7863.00,'USD','','{\"name\":\"Hester Wilderman\",\"number\":\"+19495984564\",\"full_name\":\"Kareem Simonis\",\"description\":\"Vella Schneider\"}',NULL,0,'processing',NULL,'2024-03-05 00:57:19','2024-03-05 00:57:19',NULL),(16,6,0.00,1449.00,5641.00,'USD','','{\"name\":\"Hester Wilderman\",\"number\":\"+19495984564\",\"full_name\":\"Kareem Simonis\",\"description\":\"Vella Schneider\"}',NULL,0,'completed',NULL,'2024-03-05 00:57:19','2024-03-05 00:57:19',NULL),(17,6,0.00,606.00,4192.00,'USD','','{\"name\":\"Hester Wilderman\",\"number\":\"+19495984564\",\"full_name\":\"Kareem Simonis\",\"description\":\"Vella Schneider\"}',NULL,0,'completed',NULL,'2024-03-05 00:57:20','2024-03-05 00:57:20',NULL),(18,7,0.00,177.00,7504.00,'USD','','{\"name\":\"Prof. Mack Erdman III\",\"number\":\"+19417430072\",\"full_name\":\"Dr. Juliana Schiller\",\"description\":\"Dr. Jerome Botsford III\"}',NULL,0,'processing',NULL,'2024-03-05 00:57:20','2024-03-05 00:57:20',NULL),(19,7,0.00,311.00,7327.00,'USD','','{\"name\":\"Prof. Mack Erdman III\",\"number\":\"+19417430072\",\"full_name\":\"Dr. Juliana Schiller\",\"description\":\"Dr. Jerome Botsford III\"}',NULL,0,'completed',NULL,'2024-03-05 00:57:20','2024-03-05 00:57:20',NULL),(20,7,0.00,2135.00,7016.00,'USD','','{\"name\":\"Prof. Mack Erdman III\",\"number\":\"+19417430072\",\"full_name\":\"Dr. Juliana Schiller\",\"description\":\"Dr. Jerome Botsford III\"}',NULL,0,'completed',NULL,'2024-03-05 00:57:21','2024-03-05 00:57:21',NULL),(21,8,0.00,558.00,1976.00,'USD','','{\"name\":\"Jeffry Bartoletti DDS\",\"number\":\"+19258239947\",\"full_name\":\"Mr. Porter Altenwerth MD\",\"description\":\"Kyle Bergnaum Sr.\"}',NULL,0,'processing',NULL,'2024-03-05 00:57:21','2024-03-05 00:57:21',NULL),(22,8,0.00,220.00,1418.00,'USD','','{\"name\":\"Jeffry Bartoletti DDS\",\"number\":\"+19258239947\",\"full_name\":\"Mr. Porter Altenwerth MD\",\"description\":\"Kyle Bergnaum Sr.\"}',NULL,0,'processing',NULL,'2024-03-05 00:57:22','2024-03-05 00:57:22',NULL),(23,8,0.00,202.00,1198.00,'USD','','{\"name\":\"Jeffry Bartoletti DDS\",\"number\":\"+19258239947\",\"full_name\":\"Mr. Porter Altenwerth MD\",\"description\":\"Kyle Bergnaum Sr.\"}',NULL,0,'completed',NULL,'2024-03-05 00:57:22','2024-03-05 00:57:22',NULL),(24,8,0.00,171.00,996.00,'USD','','{\"name\":\"Jeffry Bartoletti DDS\",\"number\":\"+19258239947\",\"full_name\":\"Mr. Porter Altenwerth MD\",\"description\":\"Kyle Bergnaum Sr.\"}',NULL,0,'pending',NULL,'2024-03-05 00:57:23','2024-03-05 00:57:23',NULL);
/*!40000 ALTER TABLE `mp_customer_withdrawals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores`
--

DROP TABLE IF EXISTS `mp_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `vendor_verified_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores`
--

LOCK TABLES `mp_stores` WRITE;
/*!40000 ALTER TABLE `mp_stores` DISABLE KEYS */;
INSERT INTO `mp_stores` VALUES (1,'GoPro','garnett.bednar@example.net','+18286351463','20927 Pouros Isle','PH','Mississippi','East Dorcaschester',1,'main/stores/1.png','Voluptatem maiores velit alias dolor enim. Dolores suscipit ex laborum et officia. Tempora qui iure placeat officia. Assumenda ut et aut dolores maxime officiis. Accusantium nulla non quisquam itaque. Et praesentium perferendis aperiam quas ea. Voluptatem voluptatibus qui reprehenderit quisquam.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:45','2024-03-05 00:56:45',NULL,NULL),(2,'Global Office','bbalistreri@example.org','+19847735388','3621 Shanahan Place','MY','South Carolina','Haneport',2,'main/stores/2.png','Quasi quaerat omnis similique voluptatem dolorum accusantium. Eos vitae qui est totam quos fuga commodi. Iste minima non ab reprehenderit maxime. Quod sunt atque harum veniam eum quaerat ut. Optio sed earum aut cumque accusamus ab nihil. Velit natus et ut doloribus.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:45','2024-03-05 00:56:45',NULL,NULL),(3,'Young Shop','yprice@example.net','+17542662662','94372 Myrna Meadows Suite 718','GP','Virginia','Clintchester',3,'main/stores/3.png','Asperiores nihil accusamus adipisci quaerat expedita quia est repellendus. Quia maxime earum fugiat facilis dolores inventore. Eos dolores consequuntur natus tempora. Molestiae voluptatem totam quas et ut asperiores repellat nemo.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:45','2024-03-05 00:56:45',NULL,NULL),(4,'Global Store','mueller.elwin@example.com','+14259786389','84929 Ella Points','NP','Kansas','East Biankaview',4,'main/stores/4.png','Sed ipsam ex doloremque praesentium aut tempora. Vel ut officia eligendi ducimus veritatis quam. Rem beatae quasi at sed non facere. Nemo nostrum qui animi sit. Cum quia laboriosam corrupti esse. Qui earum vero minima eius distinctio. Mollitia eaque suscipit minima aut optio magni. Reiciendis distinctio ea repudiandae et et itaque dolorem. Excepturi quia eos voluptatem aut aut et aut.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:45','2024-03-05 00:56:45',NULL,NULL),(5,'Robert’s Store','benton24@example.org','+18548121116','994 Dach Road','IQ','North Carolina','Port Constanceburgh',5,'main/stores/5.png','Aut dolores nobis excepturi modi. Qui aperiam quia nobis laudantium repudiandae pariatur. Exercitationem numquam ut minima sequi tempore commodi rerum sapiente. Consequatur omnis quia assumenda error totam rerum. Sequi praesentium dolorem aut consequatur sit. Molestias ut ut veritatis tenetur commodi.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:45','2024-03-05 00:56:45',NULL,NULL),(6,'Stouffer','june.ohara@example.org','+16574153369','59974 Nedra Vista Apt. 064','KP','Vermont','Theodoraborough',6,'main/stores/6.png','Ea ratione est explicabo aut consequatur maiores. Id dolor perspiciatis qui et deserunt ea. Distinctio soluta distinctio officia iste vitae itaque voluptates et.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:45','2024-03-05 00:56:45',NULL,NULL),(7,'StarKist','mills.ruthie@example.net','+17208447088','9825 Feeney Turnpike Apt. 178','HK','Ohio','South Theresaside',7,'main/stores/7.png','Et provident labore explicabo sunt dolorem. Quis exercitationem ea sint et aperiam ab. Quae vero dolores quae. Commodi assumenda ratione nostrum architecto ea. Vel rem exercitationem ad eaque facilis est ad. Eos qui vel et possimus officia mollitia quae. Consequatur unde delectus autem. Natus molestiae rem temporibus sint. Minus non neque fugiat recusandae molestiae deserunt.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:45','2024-03-05 00:56:45',NULL,NULL),(8,'Old El Paso','chelsey.gerhold@example.com','+15345057919','6743 Curt View','BF','Ohio','Mathewville',8,'main/stores/8.png','Molestiae dolorem id eum. Reiciendis possimus deserunt voluptates. Reprehenderit atque molestiae occaecati exercitationem ut assumenda porro. Odit reprehenderit eos modi autem. Quidem atque facere voluptas sint adipisci et ipsa. Voluptatem minus sequi impedit nostrum nulla. Maiores sed fugit excepturi similique cum quo.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:45','2024-03-05 00:56:45',NULL,NULL);
/*!40000 ALTER TABLE `mp_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores_translations`
--

DROP TABLE IF EXISTS `mp_stores_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mp_stores_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`mp_stores_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores_translations`
--

LOCK TABLES `mp_stores_translations` WRITE;
/*!40000 ALTER TABLE `mp_stores_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_stores_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_vendor_info`
--

DROP TABLE IF EXISTS `mp_vendor_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_vendor_info` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL DEFAULT '0',
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_fee` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_revenue` decimal(15,2) NOT NULL DEFAULT '0.00',
  `signature` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `payout_payment_method` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT 'bank_transfer',
  `tax_info` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_vendor_info`
--

LOCK TABLES `mp_vendor_info` WRITE;
/*!40000 ALTER TABLE `mp_vendor_info` DISABLE KEYS */;
INSERT INTO `mp_vendor_info` VALUES (1,1,8141.00,0.00,17136.00,'$2y$12$EYD57wgFGNLOfVxNzWdGCe8Y7UqXf3WTTa/uerJTwGXhI0XiQ.Hee','{\"name\":\"Prof. Jennyfer Trantow DVM\",\"number\":\"+13348878973\",\"full_name\":\"Ford Williamson\",\"description\":\"Ayana Huel Sr.\"}','2024-03-05 00:56:43','2024-03-05 00:57:13','bank_transfer',NULL),(2,2,7918.00,0.00,12836.00,'$2y$12$yzLciVSJhYkiqEHNJGYuH.LUbbrfo80qnNXQ9vwstOnEqEDTpMCrC','{\"name\":\"Hiram Dare\",\"number\":\"+14633961980\",\"full_name\":\"June Trantow\",\"description\":\"Marcel Lemke DDS\"}','2024-03-05 00:56:43','2024-03-05 00:57:15','bank_transfer',NULL),(3,3,1748.00,0.00,2420.00,'$2y$12$wfHMTuScd.MwhmhmmRcZzefqDHMa0VQosTkgdAuD2CqoEW7/PLD4u','{\"name\":\"Greta Ebert\",\"number\":\"+12392619300\",\"full_name\":\"Kade Swift\",\"description\":\"Wyman Haley\"}','2024-03-05 00:56:43','2024-03-05 00:57:17','bank_transfer',NULL),(4,4,3073.00,0.00,8688.00,'$2y$12$/Y//uaFY.UjmmQB3wCaKs.u.MFazcfJCjS9W09sxyasRFKm8g1ffe','{\"name\":\"Dr. Juliana Auer DVM\",\"number\":\"+18586631327\",\"full_name\":\"Prof. Cali Russel\",\"description\":\"Moriah Ratke\"}','2024-03-05 00:56:44','2024-03-05 00:57:18','bank_transfer',NULL),(5,5,0.00,0.00,0.00,'$2y$12$Gtxj6qeiIYcDs.mUm9DTxOtU/5DOm9uvS5ARoRFShOrlOFaWbgOuq','{\"name\":\"Dusty Gusikowski\",\"number\":\"+12622295979\",\"full_name\":\"Dr. Gregory Von\",\"description\":\"Aditya Zulauf\"}','2024-03-05 00:56:44','2024-03-05 00:56:44','bank_transfer',NULL),(6,6,3586.00,0.00,8032.00,'$2y$12$Z12TJIAH4GisXhGrjGsmmOBMRBVq63LsGCDID5.d3MfKjSGHpysvO','{\"name\":\"Hester Wilderman\",\"number\":\"+19495984564\",\"full_name\":\"Kareem Simonis\",\"description\":\"Vella Schneider\"}','2024-03-05 00:56:44','2024-03-05 00:57:20','bank_transfer',NULL),(7,7,4881.00,0.00,7504.00,'$2y$12$DoknWvB3s69yMMrX/dzj9eKqchM2NJ6jAOcYE07uLtISkCwvsm7iK','{\"name\":\"Prof. Mack Erdman III\",\"number\":\"+19417430072\",\"full_name\":\"Dr. Juliana Schiller\",\"description\":\"Dr. Jerome Botsford III\"}','2024-03-05 00:56:45','2024-03-05 00:57:21','bank_transfer',NULL),(8,8,825.00,0.00,1976.00,'$2y$12$8c7W31C8kFLKSYX0DGYdbORKVEP.IVTnI4XbgepUw/o2Xsg5EmLQe','{\"name\":\"Jeffry Bartoletti DDS\",\"number\":\"+19258239947\",\"full_name\":\"Mr. Porter Altenwerth MD\",\"description\":\"Kyle Bergnaum Sr.\"}','2024-03-05 00:56:45','2024-03-05 00:57:24','bank_transfer',NULL);
/*!40000 ALTER TABLE `mp_vendor_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Home','[simple-slider style=\"3\" key=\"home-slider\"][/simple-slider][ecommerce-categories style=\"slider\" category_ids=\"1,2,7,17\" background_color=\"#F3F5F7\" title=\"Discover our products\" subtitle=\"Product Collection\" button_label=\"Shop All Products\" button_url=\"/products\"][/ecommerce-categories][ecommerce-products style=\"simple\" by=\"specify\" product_ids=\"2,39,41\"][/ecommerce-products][ecommerce-products style=\"grid\" title=\"Best sellers in beauty\" subtitle=\"Shop by Category\" by=\"category\" category_ids=\"2,3,4\" limit=\"8\" background_color=\"rgb(234, 228, 222)\" button_label=\"Shop All Products\" button_url=\"/products\"][/ecommerce-products][ecommerce-product-groups title=\"Enjoy the best quality\" subtitle=\"Best Seller This Week’s\" limit=\"8\" tabs=\"all,featured,on-sale,trending,top-rated\"][/ecommerce-product-groups][testimonials style=\"2\" title=\"What our Clients say\" subtitle=\"Customers Review\" testimonial_ids=\"1,2,3,4\"][/testimonials][site-features style=\"2\" quantity=\"4\" title_1=\"Free Delivery\" description_1=\"Orders from all item\" icon_1=\"ti ti-truck-delivery\" title_2=\"Return & Refund\" description_2=\"Money back guarantee\" icon_2=\"ti ti-currency-dollar\" title_3=\"Member Discount\" description_3=\"Every order over $140.00\" icon_3=\"ti ti-discount-2\" title_4=\"Support 24/7\" description_4=\"Contact us 24 hours a day\" icon_4=\"ti ti-headset\"][/site-features][gallery style=\"2\" limit=\"6\"][/gallery]',1,NULL,'full-width',NULL,'published','2024-03-05 00:56:52','2024-03-05 00:56:52'),(2,'Product Categories','[ads style=\"2\" key_1=\"UROL9F9ZZVAA\" key_2=\"B30VDBKO7SBF\"][/ads]<p>&nbsp;</p>[ecommerce-categories category_ids=\"11,14,17,18,21,22,23,25,38\" style=\"grid\"][/ecommerce-categories]<p>&nbsp;</p><p>&nbsp;</p>',1,NULL,'full-width',NULL,'published','2024-03-05 00:56:52','2024-03-05 00:56:52'),(3,'Coupons','[ecommerce-coupons coupon_ids=\"1,2,3,4,5,6\"][/ecommerce-coupons]',1,NULL,'full-width',NULL,'published','2024-03-05 00:56:52','2024-03-05 00:56:52'),(4,'Coupons','[ecommerce-coupons coupon_ids=\"1,2,3,4,5,6\"][/ecommerce-coupons]',1,NULL,'full-width',NULL,'published','2024-03-05 00:56:52','2024-03-05 00:56:52'),(5,'Blog',NULL,1,NULL,'full-width',NULL,'published','2024-03-05 00:56:52','2024-03-05 00:56:52'),(6,'Contact','[contact-form show_contact_form=&quot;0,1&quot; title=&quot;Sent A Message&quot; quantity=&quot;2&quot; icon_1=&quot;main/contact/icon-1.png&quot; content_1=&quot;contact@shofy.com &lt;br&gt; &lt;strong&gt;+670 413 90 762&lt;/strong&gt;&quot; icon_2=&quot;main/contact/icon-2.png&quot; content_2=&quot;502 New St, Brighton VIC 3186, Australia&quot; show_social_info=&quot;0,1&quot; social_info_label=&quot;Find on social media&quot; social_info_icon=&quot;main/contact/icon-3.png&quot;][/contact-form][google-map]502 New Street, Brighton VIC, Australia[/google-map]',1,NULL,'full-width',NULL,'published','2024-03-05 00:56:52','2024-03-05 00:56:52'),(7,'Cookie Policy','<h3>EU Cookie Consent</h3><p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p><h4>Essential Data</h4><p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p><p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p><p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>',1,NULL,NULL,NULL,'published','2024-03-05 00:56:52','2024-03-05 00:56:52'),(8,'Our Story','<h4>A passion for handcrafted coffee, brewed with love and community.</h4>\n\n<p>\n    We are a small, family-owned coffee roaster dedicated to bringing the finest, ethically sourced beans to your cup. Our story began in a cozy kitchen, fueled by a shared passion for the rich aroma and invigorating taste of freshly brewed coffee. We dreamt of creating a space where people could connect over a warm cup, share stories, and experience the joy of handcrafted coffee.\n</p>\n\n<h4>From Humble Beginnings to Roasting Success:</h4>\n\n<p>\n    Our journey started with a small coffee roaster nestled in our garage. We spent countless hours experimenting with different roasting profiles, meticulously cupping each batch to achieve the perfect balance of flavor and aroma. Driven by a desire to make a difference, we built relationships with sustainable coffee farms around the world, ensuring fair trade practices and the highest quality beans.\n</p>\n\n<h4>Milestones and More to Come:</h4>\n\n<p>\n    Our dedication to quality and community resonated with coffee lovers, and our small business quickly grew. We opened our first cafe, a warm and inviting space where people could gather, savor our freshly roasted coffee, and connect with friends and neighbors. We\'ve continued to expand, now offering a variety of handcrafted coffee beverages, alongside delicious pastries and light bites.\n</p>\n\n<h4>Values at Our Core:</h4>\n\n<p>\n    At the heart of everything we do lies our commitment to ethical sourcing, sustainable practices, and building meaningful connections. We believe in supporting the communities that cultivate our coffee beans, ensuring fair wages and responsible farming methods. Every cup you enjoy contributes to a positive impact, one sip at a time.\n</p>\n\n<h4>Join us on our journey!</h4>\n\n<p>\n    We invite you to explore our world of coffee, from the rich diversity of our bean origins to the unique flavors crafted through meticulous roasting. Visit our cafe, discover your perfect cup, and become part of our ever-growing coffee community. Let\'s connect over a cup, share stories, and celebrate the simple joy of a well-brewed coffee.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-05 00:56:52','2024-03-05 00:56:52'),(9,'Careers','<h3>Careers: Be Part of Our Brewing Legacy</h3>\n\n<p>\n    At Shofy, we\'re not just brewing coffee, we\'re brewing a legacy. Since our humble beginnings in 2024, we\'ve grown from a small, family-owned roaster to a thriving coffee haven. But our passion for quality, community, and sustainability remains at the core of everything we do.\n</p>\n\n<h4>Why Join Our Team?</h4>\n\n<ul>\n    <li>\n        <p><strong>Become a Coffee Connoisseur</strong>: Immerse yourself in the world of coffee, learning from experienced roasters and baristas about bean origins, roasting techniques, and crafting the perfect cup.</p>\n    </li>\n    <li>\n        <p><strong>Fuel Your Passion</strong>: Contribute to our mission by sourcing ethically, promoting sustainable practices, and fostering positive relationships with coffee-growing communities around the globe.</p>\n    </li>\n    <li>\n        <p><strong>Grow with Us</strong>: We offer comprehensive training programs and opportunities for professional development, helping you refine your skills and advance your career in the coffee industry.</p>\n    </li>\n    <li>\n        <p><strong>Be Part of the Family</strong>: We cultivate a collaborative and supportive work environment where your unique talents and perspectives are valued.</p>\n    </li>\n</ul>\n\n<h4>Current Openings:</h4>\n\n<ul>\n    <li>\n        <p><strong>Coffee Roaster</strong>: Play a vital role in our roasting process, meticulously crafting unique flavor profiles and ensuring the highest quality beans reach our customers.</p>\n    </li>\n    <li>\n        <p><strong>Barista</strong>: Become a coffee ambassador, welcoming guests with a smile, crafting their perfect cup, and sharing your knowledge and passion for coffee.</p>\n    </li>\n    <li>\n        <p><strong>Cafe Manager</strong>: Lead your team in creating a warm and inviting atmosphere, overseeing daily operations, and ensuring exceptional customer service.</p>\n    </li>\n</ul>\n\n<h4>We are always looking for passionate individuals who share our values:</h4>\n\n<ul>\n    <li>\n        <p>A genuine love for coffee and a desire to learn everything there is to know about it.</p>\n    </li>\n    <li>\n        <p>A commitment to ethical sourcing, sustainability, and social responsibility.</p>\n    </li>\n    <li>\n        <p>Excellent communication and interpersonal skills to build rapport with colleagues and customers.</p>\n    </li>\n    <li>\n        <p>A positive attitude, a willingness to learn, and a collaborative spirit.</p>\n    </li>\n</ul>\n\n<p>Ready to join our brewing legacy?</p>\n\n<p>\n    Submit your resume and cover letter, telling us why you\'re a perfect fit for our team. We look forward to meeting passionate individuals who are ready to brew the future with us, one cup at a time.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-05 00:56:52','2024-03-05 00:56:52'),(10,'Shipping','<section>\n    <h2>Shipping Methods</h2>\n    <p>We offer several shipping methods to choose from:</p>\n    <ul>\n        <li>Standard Shipping - 3 to 5 business days</li>\n        <li>Express Shipping - 1 to 2 business days</li>\n        <li>International Shipping - 7 to 14 business days</li>\n    </ul>\n    <p>Please note that shipping times may vary depending on your location and other factors.</p>\n</section>\n\n<section>\n    <h2>Shipping Costs</h2>\n    <p>Shipping costs are calculated based on the weight of your order and the shipping method selected during checkout.</p>\n    <p>You can view the estimated shipping costs in your shopping cart before completing your purchase.</p>\n</section>\n\n<section>\n    <h2>Tracking Your Order</h2>\n    <p>Once your order has been shipped, you will receive a confirmation email with a tracking number.</p>\n    <p>You can use this tracking number to monitor the status of your delivery on our website or through the shipping carrier\'s website.</p>\n</section>\n\n<section>\n    <h2>Shipping Restrictions</h2>\n    <p>Some items may be subject to shipping restrictions due to size, weight, or destination.</p>\n    <p>If your order contains any restricted items, we will notify you during the checkout process.</p>\n</section>\n',1,NULL,NULL,NULL,'published','2024-03-05 00:56:52','2024-03-05 00:56:52');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'USD',0,'KNQ8SZGNKI','razorpay',NULL,2420.00,1,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:52','2024-03-05 00:56:52','Botble\\Ecommerce\\Models\\Customer',NULL),(2,'USD',0,'HRMCWQLY7P','cod',NULL,5610.00,2,'pending','confirm',10,NULL,NULL,'2024-03-05 00:56:52','2024-03-05 00:56:52','Botble\\Ecommerce\\Models\\Customer',NULL),(3,'USD',0,'QLDXFORIP2','sslcommerz',NULL,4682.00,3,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53','Botble\\Ecommerce\\Models\\Customer',NULL),(4,'USD',0,'FCUWJAYNKN','paypal',NULL,7338.00,4,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53','Botble\\Ecommerce\\Models\\Customer',NULL),(5,'USD',0,'PE9FMMFGY1','cod',NULL,3854.00,5,'pending','confirm',10,NULL,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53','Botble\\Ecommerce\\Models\\Customer',NULL),(6,'USD',0,'E6N91PDCIT','cod',NULL,1830.00,6,'pending','confirm',9,NULL,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53','Botble\\Ecommerce\\Models\\Customer',NULL),(7,'USD',0,'J9P8PJBF5N','stripe',NULL,538.00,7,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53','Botble\\Ecommerce\\Models\\Customer',NULL),(8,'USD',0,'IXTOR3VLC8','stripe',NULL,3258.00,8,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:53','2024-03-05 00:56:53','Botble\\Ecommerce\\Models\\Customer',NULL),(9,'USD',0,'XDPYX4V1O0','paypal',NULL,6657.00,9,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54','Botble\\Ecommerce\\Models\\Customer',NULL),(10,'USD',0,'HOHXPGME26','paystack',NULL,3062.00,10,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54','Botble\\Ecommerce\\Models\\Customer',NULL),(11,'USD',0,'IJMMU4OJF9','stripe',NULL,880.00,11,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54','Botble\\Ecommerce\\Models\\Customer',NULL),(12,'USD',0,'K4H6VYI7X6','sslcommerz',NULL,323.00,12,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54','Botble\\Ecommerce\\Models\\Customer',NULL),(13,'USD',0,'9FDB4XYGFJ','cod',NULL,2094.00,13,'pending','confirm',10,NULL,NULL,'2024-03-05 00:56:54','2024-03-05 00:56:54','Botble\\Ecommerce\\Models\\Customer',NULL),(14,'USD',0,'YGTYDBO7JX','bank_transfer',NULL,3856.00,14,'pending','confirm',10,NULL,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55','Botble\\Ecommerce\\Models\\Customer',NULL),(15,'USD',0,'UORNNJABXS','paystack',NULL,880.00,15,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55','Botble\\Ecommerce\\Models\\Customer',NULL),(16,'USD',0,'DTDC5PN8EK','cod',NULL,325.00,16,'pending','confirm',9,NULL,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55','Botble\\Ecommerce\\Models\\Customer',NULL),(17,'USD',0,'YFI2CUKRSP','stripe',NULL,4593.00,17,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55','Botble\\Ecommerce\\Models\\Customer',NULL),(18,'USD',0,'20IMLSEHAW','paypal',NULL,830.00,18,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55','Botble\\Ecommerce\\Models\\Customer',NULL),(19,'USD',0,'DKIXZETYGN','stripe',NULL,3322.00,19,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:55','2024-03-05 00:56:55','Botble\\Ecommerce\\Models\\Customer',NULL),(20,'USD',0,'ANNAGCHOHT','stripe',NULL,1614.00,20,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56','Botble\\Ecommerce\\Models\\Customer',NULL),(21,'USD',0,'TEHQGW5OUE','razorpay',NULL,7092.00,21,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56','Botble\\Ecommerce\\Models\\Customer',NULL),(22,'USD',0,'I1CBFWLVQ1','bank_transfer',NULL,11705.00,22,'pending','confirm',9,NULL,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56','Botble\\Ecommerce\\Models\\Customer',NULL),(23,'USD',0,'WSWDXRPZHG','paystack',NULL,6198.00,23,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56','Botble\\Ecommerce\\Models\\Customer',NULL),(24,'USD',0,'IEZY0GXXUD','stripe',NULL,4386.00,24,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:56','2024-03-05 00:56:56','Botble\\Ecommerce\\Models\\Customer',NULL),(25,'USD',0,'9ZKCLCUIFZ','stripe',NULL,1660.00,25,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57','Botble\\Ecommerce\\Models\\Customer',NULL),(26,'USD',0,'FK4HCZBD6U','bank_transfer',NULL,1660.00,26,'pending','confirm',9,NULL,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57','Botble\\Ecommerce\\Models\\Customer',NULL),(27,'USD',0,'V4JQULT08A','paystack',NULL,1677.00,27,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57','Botble\\Ecommerce\\Models\\Customer',NULL),(28,'USD',0,'XBPVCT57IK','stripe',NULL,3806.00,28,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57','Botble\\Ecommerce\\Models\\Customer',NULL),(29,'USD',0,'DHVFAA7YPL','paystack',NULL,4386.00,29,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57','Botble\\Ecommerce\\Models\\Customer',NULL),(30,'USD',0,'RGZATWCJGN','razorpay',NULL,2341.00,30,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:57','2024-03-05 00:56:57','Botble\\Ecommerce\\Models\\Customer',NULL),(31,'USD',0,'VMKSVCMFUV','razorpay',NULL,2193.00,31,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58','Botble\\Ecommerce\\Models\\Customer',NULL),(32,'USD',0,'TUUZKEZ64Z','bank_transfer',NULL,3392.00,32,'pending','confirm',9,NULL,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58','Botble\\Ecommerce\\Models\\Customer',NULL),(33,'USD',0,'AEFSILIKDF','stripe',NULL,880.00,33,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58','Botble\\Ecommerce\\Models\\Customer',NULL),(34,'USD',0,'70D1M6CRQ4','razorpay',NULL,2964.00,34,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:58','2024-03-05 00:56:58','Botble\\Ecommerce\\Models\\Customer',NULL),(35,'USD',0,'U4TDVO2MOL','paystack',NULL,3062.00,35,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:59','2024-03-05 00:56:59','Botble\\Ecommerce\\Models\\Customer',NULL),(36,'USD',0,'OU1YBHCVPR','cod',NULL,1928.00,36,'pending','confirm',10,NULL,NULL,'2024-03-05 00:56:59','2024-03-05 00:56:59','Botble\\Ecommerce\\Models\\Customer',NULL),(37,'USD',0,'QW1PMOQI3A','cod',NULL,1660.00,37,'pending','confirm',10,NULL,NULL,'2024-03-05 00:56:59','2024-03-05 00:56:59','Botble\\Ecommerce\\Models\\Customer',NULL),(38,'USD',0,'5PKLGQEZDE','sslcommerz',NULL,7222.00,38,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:59','2024-03-05 00:56:59','Botble\\Ecommerce\\Models\\Customer',NULL),(39,'USD',0,'FZSCPWLE8V','sslcommerz',NULL,3141.00,39,'completed','confirm',10,NULL,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00','Botble\\Ecommerce\\Models\\Customer',NULL),(40,'USD',0,'7JWANOEGMT','bank_transfer',NULL,4810.00,40,'pending','confirm',9,NULL,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00','Botble\\Ecommerce\\Models\\Customer',NULL),(41,'USD',0,'C7SSJV2O3E','razorpay',NULL,904.00,41,'completed','confirm',9,NULL,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00','Botble\\Ecommerce\\Models\\Customer',NULL),(42,'USD',0,'MWYCAMLYCT','paypal',NULL,1976.00,42,'completed','confirm',9,NULL,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00','Botble\\Ecommerce\\Models\\Customer',NULL),(43,'USD',0,'XO8FEOEWV1','cod',NULL,1760.00,43,'pending','confirm',10,NULL,NULL,'2024-03-05 00:57:00','2024-03-05 00:57:00','Botble\\Ecommerce\\Models\\Customer',NULL),(44,'USD',0,'LPGIYL3GH1','paystack',NULL,3141.00,44,'completed','confirm',10,NULL,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01','Botble\\Ecommerce\\Models\\Customer',NULL),(45,'USD',0,'P0CNWTCHTD','sslcommerz',NULL,5628.00,45,'completed','confirm',10,NULL,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01','Botble\\Ecommerce\\Models\\Customer',NULL),(46,'USD',0,'3HP7RHDRYO','cod',NULL,4386.00,46,'pending','confirm',9,NULL,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01','Botble\\Ecommerce\\Models\\Customer',NULL),(47,'USD',0,'XVY2IWKENL','paystack',NULL,4728.00,47,'completed','confirm',9,NULL,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01','Botble\\Ecommerce\\Models\\Customer',NULL),(48,'USD',0,'I22QBKQHC8','paystack',NULL,2640.00,48,'completed','confirm',9,NULL,NULL,'2024-03-05 00:57:01','2024-03-05 00:57:01','Botble\\Ecommerce\\Models\\Customer',NULL),(49,'USD',0,'RR0JL9M6AI','cod',NULL,2472.00,49,'pending','confirm',9,NULL,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02','Botble\\Ecommerce\\Models\\Customer',NULL),(50,'USD',0,'MP1MM4AUHJ','paypal',NULL,1876.00,50,'completed','confirm',9,NULL,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02','Botble\\Ecommerce\\Models\\Customer',NULL),(51,'USD',0,'S8Q4TESLWR','razorpay',NULL,8755.00,51,'completed','confirm',9,NULL,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02','Botble\\Ecommerce\\Models\\Customer',NULL),(52,'USD',0,'I7IIGFTZNP','paypal',NULL,4593.00,52,'completed','confirm',9,NULL,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02','Botble\\Ecommerce\\Models\\Customer',NULL),(53,'USD',0,'FVOWXQFTQA','razorpay',NULL,8647.00,53,'completed','confirm',10,NULL,NULL,'2024-03-05 00:57:02','2024-03-05 00:57:02','Botble\\Ecommerce\\Models\\Customer',NULL),(54,'USD',0,'BY0PQTH8FT','paystack',NULL,3854.00,54,'completed','confirm',10,NULL,NULL,'2024-03-05 00:57:03','2024-03-05 00:57:03','Botble\\Ecommerce\\Models\\Customer',NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (6,1),(5,1),(5,2),(6,3),(3,3),(1,4),(4,4),(3,5),(4,5),(6,6),(1,6),(3,7),(5,7),(1,8),(5,8),(3,9),(5,9),(4,10),(6,10),(2,11),(1,12),(4,12),(3,13),(4,13),(6,14),(1,14),(2,15),(4,15),(1,16),(2,16),(6,17),(2,18);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (2,1),(8,1),(6,1),(7,2),(1,2),(8,3),(1,3),(2,3),(2,4),(8,4),(5,4),(7,5),(4,5),(3,6),(6,6),(3,7),(1,7),(6,7),(5,8),(6,8),(1,9),(6,9),(3,9),(2,10),(8,10),(3,10),(3,11),(2,11),(6,11),(8,12),(6,12),(2,13),(3,13),(7,14),(3,14),(5,14),(8,15),(7,15),(4,15),(1,16),(6,16),(1,17),(3,17),(8,17),(3,18),(2,18);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'4 Expert Tips On How To Choose The Right Men’s Wallet','Alice. It looked good-natured, she thought: still it had grown up,\' she said this, she noticed a curious croquet-ground in her hands, and began:-- \'You are old, Father William,\' the young man said.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-3.jpg',262,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(2,'Sexy Clutches: How to Buy &amp; Wear a Designer Clutch Bag','King had said that day. \'No, no!\' said the King. On this the White Rabbit, trotting slowly back to the fifth bend, I think?\' he said in an offended tone, \'was, that the reason so many tea-things are.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-6.jpg',772,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(3,'The Top 2020 Handbag Trends to Know','Alice. \'Nothing WHATEVER?\' persisted the King. \'It began with the bread-knife.\' The March Hare interrupted in a melancholy tone: \'it doesn\'t seem to come once a week: HE taught us Drawling.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-7.jpg',444,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(4,'How to Match the Color of Your Handbag With an Outfit','She was a table set out under a tree a few minutes to see its meaning. \'And just as well say this), \'to go on till you come to the whiting,\' said the Mock Turtle said: \'advance twice, set to work.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-7.jpg',1252,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(5,'How to Care for Leather Bags','Alice in a wondering tone. \'Why, what a Mock Turtle replied; \'and then the puppy began a series of short charges at the stick, and held out its arms and frowning at the other players, and shouting.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-2.jpg',1356,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(6,'We\'re Crushing Hard on Summer\'s 10 Biggest Bag Trends','IT. It\'s HIM.\' \'I don\'t much care where--\' said Alice. \'Why, SHE,\' said the Mock Turtle sighed deeply, and began, in rather a handsome pig, I think.\' And she opened the door opened inwards, and.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-7.jpg',1490,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(7,'Essential Qualities of Highly Successful Music','I think.\' And she thought there was no \'One, two, three, and away,\' but they were nowhere to be a walrus or hippopotamus, but then she heard a little shaking among the distant green leaves. As there.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-7.jpg',640,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(8,'9 Things I Love About Shaving My Head','He sent them word I had not long to doubt, for the White Rabbit, who was reading the list of the cupboards as she could see it trying in a Little Bill It was high time you were me?\' \'Well, perhaps.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-10.jpg',519,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(9,'Why Teamwork Really Makes The Dream Work','Alice, (she had grown to her full size by this time, and was beating her violently with its legs hanging down, but generally, just as she spoke, but no result seemed to listen, the whole thing very.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-5.jpg',340,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(10,'The World Caters to Average People','Queen said severely \'Who is this?\' She said it to the three were all talking together: she made it out to sea. So they got their tails fast in their mouths; and the three gardeners, but she added.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-4.jpg',1778,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(11,'The litigants on the screen are not actors','Gryphon, and the moon, and memory, and muchness--you know you say pig, or fig?\' said the Queen. First came ten soldiers carrying clubs; these were ornamented all over their shoulders, that all the.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-4.jpg',497,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(12,'Hiring the Right Sales Team at the Right Time','And how odd the directions will look! ALICE\'S RIGHT FOOT, ESQ. HEARTHRUG, NEAR THE FENDER, (WITH ALICE\'S LOVE). Oh dear, what nonsense I\'m talking!\' Just then her head to keep herself from being run.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-9.jpg',236,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(13,'Fully Embrace the Return of 90s fashion','All the time it all is! I\'ll try if I only knew the right thing to nurse--and she\'s such a neck as that! No, no! You\'re a serpent; and there\'s no use in waiting by the whole party at once crowded.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-5.jpg',639,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(14,'Exploring the English Countryside','This time Alice waited a little, \'From the Queen. First came ten soldiers carrying clubs; these were ornamented all over their slates; \'but it doesn\'t matter which way she put her hand on the floor.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-6.jpg',2338,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(15,'Here’s the First Valentino’s New Makeup Collection','In another minute the whole thing very absurd, but they were playing the Queen never left off sneezing by this time.) \'You\'re nothing but out-of-the-way things to happen, that it is!\' As she said to.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-6.jpg',146,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(16,'Follow Your own Design process, whatever gets','Gryphon, and the baby was howling so much contradicted in her hand, and Alice joined the procession, wondering very much pleased at having found out that one of the house, and found quite a crowd of.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-8.jpg',110,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(17,'Freelancer Days 2024, What’s new?','Caterpillar took the cauldron of soup off the mushroom, and her eyes immediately met those of a treacle-well--eh, stupid?\' \'But they were getting so used to it as you liked.\' \'Is that the best thing.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-8.jpg',1394,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42'),(18,'Quality Foods Requirments For Every Human Body’s','I\'ll tell you just now what the name \'Alice!\' CHAPTER XII. Alice\'s Evidence \'Here!\' cried Alice, with a yelp of delight, which changed into alarm in another moment, splash! she was dozing off, and.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-6.jpg',2142,NULL,'2024-03-05 00:56:42','2024-03-05 00:56:42');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_logs`
--

DROP TABLE IF EXISTS `request_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status_code` int DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `count` int unsigned NOT NULL DEFAULT '0',
  `user_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_logs`
--

LOCK TABLES `request_logs` WRITE;
/*!40000 ALTER TABLE `request_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.manage.license\":true,\"extensions.index\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.cronjob\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"plugins.captcha\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.settings\":true,\"plugins.ecommerce\":true,\"ecommerce.settings\":true,\"ecommerce.report.index\":true,\"products.index\":true,\"products.create\":true,\"products.edit\":true,\"products.destroy\":true,\"products.duplicate\":true,\"product-categories.index\":true,\"product-categories.create\":true,\"product-categories.edit\":true,\"product-categories.destroy\":true,\"product-tag.index\":true,\"product-tag.create\":true,\"product-tag.edit\":true,\"product-tag.destroy\":true,\"brands.index\":true,\"brands.create\":true,\"brands.edit\":true,\"brands.destroy\":true,\"product-collections.index\":true,\"product-collections.create\":true,\"product-collections.edit\":true,\"product-collections.destroy\":true,\"product-attribute-sets.index\":true,\"product-attribute-sets.create\":true,\"product-attribute-sets.edit\":true,\"product-attribute-sets.destroy\":true,\"product-attributes.index\":true,\"product-attributes.create\":true,\"product-attributes.edit\":true,\"product-attributes.destroy\":true,\"tax.index\":true,\"tax.create\":true,\"tax.edit\":true,\"tax.destroy\":true,\"reviews.index\":true,\"reviews.create\":true,\"reviews.destroy\":true,\"reviews.publish\":true,\"reviews.reply\":true,\"shipping_methods.index\":true,\"ecommerce.shipping-rule-items.index\":true,\"ecommerce.shipping-rule-items.create\":true,\"ecommerce.shipping-rule-items.edit\":true,\"ecommerce.shipping-rule-items.destroy\":true,\"ecommerce.shipping-rule-items.bulk-import\":true,\"ecommerce.shipments.index\":true,\"ecommerce.shipments.create\":true,\"ecommerce.shipments.edit\":true,\"ecommerce.shipments.destroy\":true,\"orders.index\":true,\"orders.create\":true,\"orders.edit\":true,\"orders.destroy\":true,\"discounts.index\":true,\"discounts.create\":true,\"discounts.edit\":true,\"discounts.destroy\":true,\"customers.index\":true,\"customers.create\":true,\"customers.edit\":true,\"customers.destroy\":true,\"flash-sale.index\":true,\"flash-sale.create\":true,\"flash-sale.edit\":true,\"flash-sale.destroy\":true,\"product-label.index\":true,\"product-label.create\":true,\"product-label.edit\":true,\"product-label.destroy\":true,\"ecommerce.import.products.index\":true,\"ecommerce.export.products.index\":true,\"order_returns.index\":true,\"order_returns.edit\":true,\"order_returns.destroy\":true,\"global-option.index\":true,\"global-option.create\":true,\"global-option.edit\":true,\"global-option.destroy\":true,\"ecommerce.invoice.index\":true,\"ecommerce.invoice.edit\":true,\"ecommerce.invoice.destroy\":true,\"ecommerce.invoice-template.index\":true,\"ecommerce.settings.general\":true,\"ecommerce.settings.currencies\":true,\"ecommerce.settings.products\":true,\"ecommerce.settings.product-search\":true,\"ecommerce.settings.digital-products\":true,\"ecommerce.settings.store-locators\":true,\"ecommerce.settings.invoices\":true,\"ecommerce.settings.product-reviews\":true,\"ecommerce.settings.customers\":true,\"ecommerce.settings.shopping\":true,\"ecommerce.settings.taxes\":true,\"ecommerce.settings.shipping\":true,\"ecommerce.settings.tracking\":true,\"ecommerce.settings.standard-and-format\":true,\"ecommerce.settings.checkout\":true,\"ecommerce.settings.return\":true,\"ecommerce.settings.flash-sale\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"location.bulk-import.index\":true,\"location.export.index\":true,\"marketplace.index\":true,\"marketplace.store.index\":true,\"marketplace.store.create\":true,\"marketplace.store.edit\":true,\"marketplace.store.destroy\":true,\"marketplace.store.view\":true,\"marketplace.store.revenue.create\":true,\"marketplace.withdrawal.index\":true,\"marketplace.withdrawal.edit\":true,\"marketplace.withdrawal.destroy\":true,\"marketplace.vendors.index\":true,\"marketplace.unverified-vendors.index\":true,\"marketplace.unverified-vendors.edit\":true,\"marketplace.settings\":true,\"marketplace.reports\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"request-log.index\":true,\"request-log.destroy\":true,\"sale-popup.settings\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true}','Admin users role',1,1,1,'2024-03-05 00:56:37','2024-03-05 00:56:37');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'media_random_hash','76273a6cbe2e48df9311ba289cd34daf',NULL,'2024-03-05 00:56:52'),(2,'api_enabled','0',NULL,'2024-03-05 00:56:52'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"ecommerce\",\"faq\",\"gallery\",\"location\",\"marketplace\",\"newsletter\",\"payment\",\"paypal\",\"paypal-payout\",\"paystack\",\"razorpay\",\"request-log\",\"sale-popup\",\"shippo\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2024-03-05 00:56:52'),(6,'theme','shofy-beauty',NULL,'2024-03-05 00:56:52'),(7,'show_admin_bar','1',NULL,'2024-03-05 00:56:52'),(8,'payment_cod_status','1',NULL,'2024-03-05 00:56:52'),(9,'payment_bank_transfer_status','1',NULL,'2024-03-05 00:56:52'),(10,'admin_favicon','main/general/favicon.png',NULL,'2024-03-05 00:56:52'),(11,'admin_logo','main/general/logo-white.png',NULL,'2024-03-05 00:56:52'),(12,'permalink-botble-blog-models-post','blog',NULL,'2024-03-05 00:56:52'),(13,'permalink-botble-blog-models-category','blog',NULL,'2024-03-05 00:56:52'),(14,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2024-03-05 00:56:52'),(15,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2024-03-05 00:56:52'),(16,'payment_stripe_payment_type','stripe_checkout',NULL,'2024-03-05 00:56:52'),(17,'plugins_ecommerce_customer_new_order_status','0',NULL,'2024-03-05 00:56:52'),(18,'plugins_ecommerce_admin_new_order_status','0',NULL,'2024-03-05 00:56:52'),(19,'ecommerce_is_enabled_support_digital_products','1',NULL,'2024-03-05 00:56:52'),(20,'ecommerce_load_countries_states_cities_from_location_plugin','0',NULL,'2024-03-05 00:56:52'),(21,'language_hide_default','1',NULL,'2024-03-05 00:56:52'),(22,'language_switcher_display','dropdown',NULL,'2024-03-05 00:56:52'),(23,'language_display','all',NULL,'2024-03-05 00:56:52'),(24,'language_hide_languages','[]',NULL,'2024-03-05 00:56:52'),(25,'ecommerce_store_name','Shofy',NULL,'2024-03-05 00:56:52'),(26,'ecommerce_store_phone','1800979769',NULL,'2024-03-05 00:56:52'),(27,'ecommerce_store_address','502 New Street',NULL,'2024-03-05 00:56:52'),(28,'ecommerce_store_state','Brighton VIC',NULL,'2024-03-05 00:56:52'),(29,'ecommerce_store_city','Brighton VIC',NULL,'2024-03-05 00:56:52'),(30,'ecommerce_store_country','AU',NULL,'2024-03-05 00:56:52'),(31,'announcement_max_width','1390',NULL,'2024-03-05 00:56:52'),(32,'announcement_text_color','#010f1c',NULL,'2024-03-05 00:56:52'),(33,'announcement_background_color','transparent',NULL,'2024-03-05 00:56:52'),(34,'announcement_placement','theme',NULL,'2024-03-05 00:56:52'),(35,'announcement_text_alignment','start',NULL,'2024-03-05 00:56:52'),(36,'announcement_dismissible','0',NULL,'2024-03-05 00:56:52'),(37,'simple_slider_using_assets','0',NULL,'2024-03-05 00:56:52'),(38,'theme-shofy-beauty-site_name','Shofy',NULL,NULL),(39,'theme-shofy-beauty-site_title','Shofy - Multipurpose eCommerce Laravel Script',NULL,NULL),(40,'theme-shofy-beauty-seo_description','Shofy is a powerful tool eCommerce Laravel script for creating a professional and visually appealing online store.s',NULL,NULL),(41,'theme-shofy-beauty-copyright','© 2024 All Rights Reserved.',NULL,NULL),(42,'theme-shofy-beauty-primary_font','Jost',NULL,NULL),(43,'theme-shofy-beauty-primary_color','#BD844C',NULL,NULL),(44,'theme-shofy-beauty-favicon','main/general/favicon.png',NULL,NULL),(45,'theme-shofy-beauty-logo','main/general/logo.png',NULL,NULL),(46,'theme-shofy-beauty-logo_light','main/general/logo-white.png',NULL,NULL),(47,'theme-shofy-beauty-header_style','3',NULL,NULL),(48,'theme-shofy-beauty-preloader_icon','main/general/preloader-icon.png',NULL,NULL),(49,'theme-shofy-beauty-address','502 New Street, Brighton VIC, Australia',NULL,NULL),(50,'theme-shofy-beauty-hotline','8 800 332 65-66',NULL,NULL),(51,'theme-shofy-beauty-email','contact@fartmart.co',NULL,NULL),(52,'theme-shofy-beauty-working_time','Mon - Fri: 07AM - 06PM',NULL,NULL),(53,'theme-shofy-beauty-homepage_id','1',NULL,NULL),(54,'theme-shofy-beauty-blog_page_id','5',NULL,NULL),(55,'theme-shofy-beauty-cookie_consent_message','Your experience on this site will be improved by allowing cookies ',NULL,NULL),(56,'theme-shofy-beauty-cookie_consent_learn_more_url','cookie-policy',NULL,NULL),(57,'theme-shofy-beauty-cookie_consent_learn_more_text','Cookie Policy',NULL,NULL),(58,'theme-shofy-beauty-number_of_products_per_page','24',NULL,NULL),(59,'theme-shofy-beauty-number_of_cross_sale_product','6',NULL,NULL),(60,'theme-shofy-beauty-ecommerce_products_page_layout','left_sidebar',NULL,NULL),(61,'theme-shofy-beauty-ecommerce_product_item_style','3',NULL,NULL),(62,'theme-shofy-beauty-logo_in_the_checkout_page','main/general/logo.png',NULL,NULL),(63,'theme-shofy-beauty-logo_in_invoices','main/general/logo.png',NULL,NULL),(64,'theme-shofy-beauty-logo_vendor_dashboard','main/general/logo.png',NULL,NULL),(65,'theme-shofy-beauty-404_page_image','main/general/404.png',NULL,NULL),(66,'theme-shofy-beauty-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"Youtube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'The Clothing Collection','beauty/sliders/slider-1.jpg','/products','New Arrivals 2023',0,'2024-03-05 00:56:45','2024-03-05 00:56:45'),(2,1,'The Summer Collection','beauty/sliders/slider-2.jpg','/products','Best Selling 2023',1,'2024-03-05 00:56:45','2024-03-05 00:56:45'),(3,1,'Amazing New designs','beauty/sliders/slider-3.jpg','/products','Winter Has Arrived',2,'2024-03-05 00:56:45','2024-03-05 00:56:45');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2024-03-05 00:56:45','2024-03-05 00:56:45');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=229 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'foodpound',1,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:56:38','2024-03-05 00:56:38'),(2,'itea-jsc',2,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:56:38','2024-03-05 00:56:38'),(3,'soda-brand',3,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:56:38','2024-03-05 00:56:38'),(4,'shofy',4,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:56:38','2024-03-05 00:56:38'),(5,'soda-brand',5,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:56:38','2024-03-05 00:56:38'),(6,'electronic',1,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:56:41','2024-03-05 00:56:41'),(7,'mobile',2,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:56:41','2024-03-05 00:56:41'),(8,'iphone',3,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:56:41','2024-03-05 00:56:41'),(9,'printer',4,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:56:41','2024-03-05 00:56:41'),(10,'office',5,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:56:41','2024-03-05 00:56:41'),(11,'it',6,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:56:41','2024-03-05 00:56:41'),(12,'crisp-bread-cake',1,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(13,'fashion',2,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(14,'electronic',3,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(15,'commercial',4,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(16,'organic-fruits',5,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(17,'ecological',6,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(18,'general',1,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:42','2024-03-05 00:56:42'),(19,'design',2,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:42','2024-03-05 00:56:42'),(20,'fashion',3,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:42','2024-03-05 00:56:42'),(21,'branding',4,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:42','2024-03-05 00:56:42'),(22,'modern',5,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:42','2024-03-05 00:56:42'),(23,'nature',6,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:42','2024-03-05 00:56:42'),(24,'vintage',7,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:42','2024-03-05 00:56:42'),(25,'sunglasses',8,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:42','2024-03-05 00:56:42'),(26,'4-expert-tips-on-how-to-choose-the-right-mens-wallet',1,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(27,'sexy-clutches-how-to-buy-wear-a-designer-clutch-bag',2,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(28,'the-top-2020-handbag-trends-to-know',3,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(29,'how-to-match-the-color-of-your-handbag-with-an-outfit',4,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(30,'how-to-care-for-leather-bags',5,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(31,'were-crushing-hard-on-summers-10-biggest-bag-trends',6,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(32,'essential-qualities-of-highly-successful-music',7,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(33,'9-things-i-love-about-shaving-my-head',8,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(34,'why-teamwork-really-makes-the-dream-work',9,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(35,'the-world-caters-to-average-people',10,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(36,'the-litigants-on-the-screen-are-not-actors',11,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(37,'hiring-the-right-sales-team-at-the-right-time',12,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(38,'fully-embrace-the-return-of-90s-fashion',13,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(39,'exploring-the-english-countryside',14,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(40,'heres-the-first-valentinos-new-makeup-collection',15,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(41,'follow-your-own-design-process-whatever-gets',16,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(42,'freelancer-days-2024-whats-new',17,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(43,'quality-foods-requirments-for-every-human-bodys',18,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:42','2024-03-05 00:56:42'),(44,'gopro',1,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:45','2024-03-05 00:56:45'),(45,'global-office',2,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:45','2024-03-05 00:56:45'),(46,'young-shop',3,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:45','2024-03-05 00:56:45'),(47,'global-store',4,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:45','2024-03-05 00:56:45'),(48,'roberts-store',5,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:45','2024-03-05 00:56:45'),(49,'stouffer',6,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:45','2024-03-05 00:56:45'),(50,'starkist',7,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:45','2024-03-05 00:56:45'),(51,'old-el-paso',8,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:45','2024-03-05 00:56:45'),(52,'discover-skincare',1,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(53,'clothing',2,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(54,'mens-clothing',3,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(55,'t-shirts',4,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(56,'jeans',5,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(57,'suits',6,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(58,'womens-clothing',7,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(59,'dresses',8,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(60,'blouses',9,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(61,'pants',10,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(62,'accessories',11,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(63,'hats',12,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(64,'scarves',13,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(65,'jewelry',14,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(66,'sportswear',15,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(67,'activewear',16,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(68,'running-shoes',17,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:46','2024-03-05 00:56:46'),(69,'vintage-denim-jacket',1,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(70,'floral-maxi-dress',2,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(71,'leather-ankle-boots',3,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(72,'knit-turtleneck-sweater-digital',4,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:57:24'),(73,'classic-aviator-sunglasses',5,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(74,'tailored-wool-blazer',6,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(75,'bohemian-fringe-handbag',7,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(76,'silk-scarf-with-geometric-print-digital',8,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:57:24'),(77,'high-waisted-wide-leg-trousers',9,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(78,'embroidered-boho-blouse',10,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(79,'statement-chunky-necklace',11,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(80,'chic-fedora-hat-digital',12,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:57:24'),(81,'strappy-block-heel-sandals',13,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(82,'velvet-evening-gown',14,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(83,'quilted-crossbody-bag',15,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(84,'distressed-skinny-jeans-digital',16,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:57:24'),(85,'lace-up-combat-boots',17,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(86,'cotton-striped-t-shirt-dress',18,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(87,'printed-palazzo-pants',19,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(88,'structured-satchel-bag-digital',20,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:57:24'),(89,'off-shoulder-ruffle-top',21,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:46','2024-03-05 00:56:46'),(90,'suede-pointed-toe-pumps',22,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(91,'cropped-cable-knit-sweater',23,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(92,'athleisure-jogger-pants-digital',24,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:57:24'),(93,'leopard-print-midi-skirt',25,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(94,'retro-cat-eye-sunglasses',26,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(95,'faux-fur-trimmed-coat',27,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(96,'boho-fringed-kimono-digital',28,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:57:24'),(97,'ruffled-wrap-dress',29,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(98,'beaded-evening-clutch',30,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(99,'wide-brim-floppy-hat',31,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(100,'denim-overall-jumpsuit-digital',32,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:57:24'),(101,'embellished-ballet-flats',33,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(102,'pleated-midi-skirt',34,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(103,'velour-tracksuit-set',35,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(104,'geometric-patterned-cardigan-digital',36,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:57:24'),(105,'buckle-detail-ankle-booties',37,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(106,'embroidered-bomber-jacket',38,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(107,'cowl-neck-knit-poncho',39,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(108,'chunky-knit-infinity-scarf-digital',40,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:57:24'),(109,'retro-high-top-sneakers',41,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(110,'faux-leather-leggings',42,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(111,'metallic-pleated-maxi-skirt',43,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:47','2024-03-05 00:56:47'),(112,'radiant-reflections',1,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:56:51','2024-03-05 00:56:51'),(113,'glamour-grove',2,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:56:51','2024-03-05 00:56:51'),(114,'serene-styles-showcase',3,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:56:51','2024-03-05 00:56:51'),(115,'allure-alcove',4,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:56:51','2024-03-05 00:56:51'),(116,'glamour-galleria',5,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:56:51','2024-03-05 00:56:51'),(117,'beauty-boulevard',6,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:56:51','2024-03-05 00:56:51'),(118,'home',1,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:52','2024-03-05 00:56:52'),(119,'product-categories',2,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:52','2024-03-05 00:56:52'),(120,'coupons',3,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:52','2024-03-05 00:56:52'),(121,'coupons',4,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:52','2024-03-05 00:56:52'),(122,'blog',5,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:52','2024-03-05 00:56:52'),(123,'contact',6,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:52','2024-03-05 00:56:52'),(124,'cookie-policy',7,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:52','2024-03-05 00:56:52'),(125,'our-story',8,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:52','2024-03-05 00:56:52'),(126,'careers',9,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:52','2024-03-05 00:56:52'),(127,'shipping',10,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:52','2024-03-05 00:56:52'),(128,'vintage-denim-jacket',44,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(129,'vintage-denim-jacket',45,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(130,'vintage-denim-jacket',46,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(131,'floral-maxi-dress',47,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(132,'leather-ankle-boots',48,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(133,'leather-ankle-boots',49,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(134,'leather-ankle-boots',50,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(135,'knit-turtleneck-sweater-digital',51,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(136,'classic-aviator-sunglasses',52,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(137,'classic-aviator-sunglasses',53,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(138,'tailored-wool-blazer',54,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(139,'tailored-wool-blazer',55,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(140,'tailored-wool-blazer',56,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(141,'tailored-wool-blazer',57,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(142,'bohemian-fringe-handbag',58,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(143,'silk-scarf-with-geometric-print-digital',59,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(144,'silk-scarf-with-geometric-print-digital',60,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(145,'high-waisted-wide-leg-trousers',61,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(146,'high-waisted-wide-leg-trousers',62,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(147,'embroidered-boho-blouse',63,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(148,'embroidered-boho-blouse',64,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(149,'embroidered-boho-blouse',65,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(150,'embroidered-boho-blouse',66,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(151,'embroidered-boho-blouse',67,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(152,'statement-chunky-necklace',68,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(153,'statement-chunky-necklace',69,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(154,'statement-chunky-necklace',70,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(155,'chic-fedora-hat-digital',71,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(156,'chic-fedora-hat-digital',72,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(157,'strappy-block-heel-sandals',73,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(158,'velvet-evening-gown',74,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(159,'velvet-evening-gown',75,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(160,'velvet-evening-gown',76,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(161,'velvet-evening-gown',77,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(162,'velvet-evening-gown',78,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(163,'quilted-crossbody-bag',79,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(164,'distressed-skinny-jeans-digital',80,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(165,'lace-up-combat-boots',81,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(166,'lace-up-combat-boots',82,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(167,'cotton-striped-t-shirt-dress',83,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(168,'printed-palazzo-pants',84,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(169,'printed-palazzo-pants',85,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(170,'printed-palazzo-pants',86,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(171,'structured-satchel-bag-digital',87,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(172,'structured-satchel-bag-digital',88,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(173,'off-shoulder-ruffle-top',89,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(174,'off-shoulder-ruffle-top',90,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(175,'suede-pointed-toe-pumps',91,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(176,'suede-pointed-toe-pumps',92,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(177,'suede-pointed-toe-pumps',93,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(178,'suede-pointed-toe-pumps',94,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(179,'cropped-cable-knit-sweater',95,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(180,'athleisure-jogger-pants-digital',96,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(181,'athleisure-jogger-pants-digital',97,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(182,'leopard-print-midi-skirt',98,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(183,'leopard-print-midi-skirt',99,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(184,'leopard-print-midi-skirt',100,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(185,'retro-cat-eye-sunglasses',101,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(186,'retro-cat-eye-sunglasses',102,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(187,'faux-fur-trimmed-coat',103,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(188,'faux-fur-trimmed-coat',104,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(189,'boho-fringed-kimono-digital',105,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(190,'boho-fringed-kimono-digital',106,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(191,'boho-fringed-kimono-digital',107,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(192,'boho-fringed-kimono-digital',108,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(193,'ruffled-wrap-dress',109,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(194,'ruffled-wrap-dress',110,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(195,'beaded-evening-clutch',111,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(196,'beaded-evening-clutch',112,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(197,'wide-brim-floppy-hat',113,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(198,'wide-brim-floppy-hat',114,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(199,'denim-overall-jumpsuit-digital',115,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(200,'denim-overall-jumpsuit-digital',116,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(201,'denim-overall-jumpsuit-digital',117,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(202,'embellished-ballet-flats',118,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(203,'embellished-ballet-flats',119,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(204,'embellished-ballet-flats',120,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(205,'pleated-midi-skirt',121,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(206,'pleated-midi-skirt',122,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(207,'pleated-midi-skirt',123,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(208,'velour-tracksuit-set',124,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(209,'velour-tracksuit-set',125,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(210,'velour-tracksuit-set',126,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(211,'geometric-patterned-cardigan-digital',127,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(212,'geometric-patterned-cardigan-digital',128,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(213,'geometric-patterned-cardigan-digital',129,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(214,'buckle-detail-ankle-booties',130,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(215,'buckle-detail-ankle-booties',131,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(216,'embroidered-bomber-jacket',132,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(217,'embroidered-bomber-jacket',133,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(218,'cowl-neck-knit-poncho',134,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(219,'chunky-knit-infinity-scarf-digital',135,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(220,'retro-high-top-sneakers',136,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(221,'retro-high-top-sneakers',137,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(222,'faux-leather-leggings',138,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(223,'faux-leather-leggings',139,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(224,'faux-leather-leggings',140,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(225,'faux-leather-leggings',141,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(226,'metallic-pleated-maxi-skirt',142,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(227,'metallic-pleated-maxi-skirt',143,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24'),(228,'metallic-pleated-maxi-skirt',144,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:57:24','2024-03-05 00:57:24');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'General',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:42','2024-03-05 00:56:42'),(2,'Design',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:42','2024-03-05 00:56:42'),(3,'Fashion',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:42','2024-03-05 00:56:42'),(4,'Branding',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:42','2024-03-05 00:56:42'),(5,'Modern',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:42','2024-03-05 00:56:42'),(6,'Nature',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:42','2024-03-05 00:56:42'),(7,'Vintage',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:42','2024-03-05 00:56:42'),(8,'Sunglasses',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:42','2024-03-05 00:56:42');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'James Dopli','Thanks for all your efforts and teamwork over the last several months!  Thank you so much','main/users/10.jpg','Developer','published','2024-03-05 00:56:45','2024-03-05 00:56:45'),(2,'Theodore Handle','How you use the city or town name is up to you. All results may be freely used in any work.','main/users/4.jpg','CO Founder','published','2024-03-05 00:56:45','2024-03-05 00:56:45'),(3,'Shahnewaz Sakil','Very happy with our choice to take our daughter to Brave care. The entire team was great! Thank you!','main/users/8.jpg','UI/UX Designer','published','2024-03-05 00:56:45','2024-03-05 00:56:45'),(4,'Albert Flores','Wedding day savior! 5 stars. Their bridal collection is a game-changer. Made me feel like a star.','main/users/2.jpg','Bank of America','published','2024-03-05 00:56:45','2024-03-05 00:56:45');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'viola99@sanford.com',NULL,'$2y$12$D0nt2kHeaWktmfHTOTz/a.vDl9qoT7ZIaCVHNXCzb3I37avFlXn3S',NULL,'2024-03-05 00:56:37','2024-03-05 00:56:37','Mattie','Considine','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SiteInfoWidget','footer_primary_sidebar','shofy-beauty',0,'{\"id\":\"SiteInfoWidget\",\"logo\":\"main\\/general\\/logo.png\",\"about\":\"Shofy is a powerful tool eCommerce Laravel script for creating a professional and visually appealing online store.\",\"show_social_links\":true}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(2,'CustomMenuWidget','footer_primary_sidebar','shofy-beauty',1,'{\"id\":\"CustomMenuWidget\",\"name\":\"My Account\",\"menu_id\":\"my-account\"}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(3,'CustomMenuWidget','footer_primary_sidebar','shofy-beauty',2,'{\"id\":\"CustomMenuWidget\",\"name\":\"Information\",\"menu_id\":\"information\"}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(4,'SiteContactWidget','footer_primary_sidebar','shofy-beauty',4,'{\"id\":\"SiteContactWidget\",\"name\":\"Talk To Us\",\"phone_label\":\"Got Questions? Call us\",\"phone\":\"+670 413 90 762\",\"email\":\"shofy@support.com\",\"address\":\"79 Sleepy Hollow St. Jamaica, New York 1432\"}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(5,'NewsletterWidget','footer_top_sidebar','shofy-beauty',1,'{\"id\":\"NewsletterWidget\",\"title\":\"Subscribe our Newsletter\",\"subtitle\":\"Sale 20% off all store\"}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(6,'SiteCopyrightWidget','footer_bottom_sidebar','shofy-beauty',1,'{\"id\":\"SiteCopyrightWidget\",\"content\":\"\\u00a9 %y% All rights Reserved.\"}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(7,'SiteAcceptedPaymentsWidget','footer_bottom_sidebar','shofy-beauty',2,'{\"id\":\"SiteAcceptedPaymentsWidget\",\"name\":\"Accepted Payments\",\"image\":\"main\\/general\\/footer-pay.png\",\"url\":\"#\"}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(8,'BlogSearchWidget','blog_sidebar','shofy-beauty',1,'{\"id\":\"BlogSearchWidget\"}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(9,'BlogAboutMeWidget','blog_sidebar','shofy-beauty',2,'{\"id\":\"BlogAboutMeWidget\",\"name\":\"About Me\",\"author_url\":\"\\/blog\",\"author_avatar\":\"main\\/users\\/9.jpg\",\"author_name\":\"Ravi O\'Leigh\",\"author_role\":\"Photographer & Blogger\",\"author_description\":\"Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient\",\"author_signature\":\"main\\/general\\/signature.png\"}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(10,'BlogPostsWidget','blog_sidebar','shofy-beauty',3,'{\"id\":\"BlogPostsWidget\",\"name\":\"Latest Posts\",\"limit\":3}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(11,'BlogCategoriesWidget','blog_sidebar','shofy-beauty',4,'{\"id\":\"BlogCategoriesWidget\",\"name\":\"Categories\",\"number_display\":6}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(12,'BlogTagsWidget','blog_sidebar','shofy-beauty',5,'{\"id\":\"BlogTagsWidget\",\"name\":\"Popular Tags\",\"number_display\":6}','2024-03-05 00:56:52','2024-03-05 00:56:52'),(13,'ProductDetailInfoWidget','product_details_sidebar','shofy-beauty',1,'{\"id\":\"ProductDetailInfoWidget\",\"messages\":[[{\"key\":\"message\",\"value\":\"30 days easy returns\"}],[{\"key\":\"message\",\"value\":\"Order yours before 2.30pm for same day dispatch\"}]],\"description\":\"Guaranteed safe & secure checkout\",\"image\":\"main\\/general\\/footer-pay.png\"}','2024-03-05 00:56:52','2024-03-05 00:56:52');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-03-05 14:57:25
